/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.idcard.mapper;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.idcard.mapper.IdCardBiobankMapper;
import org.molgenis.data.idcard.model.IdCardBiobank;
import org.molgenis.data.idcard.model.IdCardOrganization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IdCardBiobankMapperImpl
implements IdCardBiobankMapper {
    private static final Logger LOG = LoggerFactory.getLogger(IdCardBiobankMapperImpl.class);
    private final DataService dataService;

    @Autowired
    public IdCardBiobankMapperImpl(DataService dataService) {
        this.dataService = Objects.requireNonNull(dataService);
    }

    @Override
    public IdCardBiobank toIdCardBiobank(JsonReader jsonReader) throws IOException {
        IdCardBiobank idCardBiobank = new IdCardBiobank(this.dataService);
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
        jsonReader.beginObject();
        block64: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "Collections": {
                    jsonReader.skipValue();
                    continue block64;
                }
                case "OrganizationID": {
                    idCardBiobank.set("OrganizationID", jsonReader.nextInt());
                    continue block64;
                }
                case "type": {
                    idCardBiobank.set("type", jsonReader.nextString());
                    continue block64;
                }
                case "also listed in": {
                    ArrayList<String> alsoListedInValues = new ArrayList<String>();
                    jsonReader.beginArray();
                    while (jsonReader.hasNext()) {
                        alsoListedInValues.add(jsonReader.nextString());
                    }
                    jsonReader.endArray();
                    idCardBiobank.set("also_listed_in", alsoListedInValues.stream().collect(Collectors.joining(",")));
                    continue block64;
                }
                case "url": {
                    ArrayList<String> urlValues = new ArrayList<String>();
                    jsonReader.beginArray();
                    while (jsonReader.hasNext()) {
                        urlValues.add(jsonReader.nextString());
                    }
                    jsonReader.endArray();
                    idCardBiobank.set("url", urlValues.stream().collect(Collectors.joining(",")));
                    continue block64;
                }
                case "main contact": {
                    jsonReader.beginObject();
                    block67: while (jsonReader.hasNext()) {
                        String mainContactName;
                        switch (mainContactName = jsonReader.nextName()) {
                            case "title": {
                                idCardBiobank.set("title", jsonReader.nextString());
                                continue block67;
                            }
                            case "first name": {
                                idCardBiobank.set("first_name", jsonReader.nextString());
                                continue block67;
                            }
                            case "email": {
                                idCardBiobank.set("email", jsonReader.nextString());
                                continue block67;
                            }
                            case "last name": {
                                idCardBiobank.set("last_name", jsonReader.nextString());
                                continue block67;
                            }
                            case "phone": {
                                idCardBiobank.set("phone", jsonReader.nextString());
                                continue block67;
                            }
                        }
                        LOG.warn("unknown property [{}] in object [main contact]", (Object)mainContactName);
                        jsonReader.skipValue();
                    }
                    jsonReader.endObject();
                    continue block64;
                }
                case "last activities": {
                    try {
                        idCardBiobank.set("last_activities", dateTimeFormat.parse(jsonReader.nextString()));
                        continue block64;
                    }
                    catch (ParseException e) {
                        throw new IOException(e);
                    }
                }
                case "date of inclusion": {
                    try {
                        idCardBiobank.set("date_of_inclusion", dateTimeFormat.parse(jsonReader.nextString()));
                        continue block64;
                    }
                    catch (ParseException e) {
                        throw new IOException(e);
                    }
                }
                case "address": {
                    jsonReader.beginObject();
                    block68: while (jsonReader.hasNext()) {
                        switch (jsonReader.nextName()) {
                            case "street2": {
                                idCardBiobank.set("street2", jsonReader.nextString());
                                continue block68;
                            }
                            case "name of host institution": {
                                idCardBiobank.set("name_of_host_institution", jsonReader.nextString());
                                continue block68;
                            }
                            case "zip": {
                                idCardBiobank.set("zip", jsonReader.nextString());
                                continue block68;
                            }
                            case "street1": {
                                idCardBiobank.set("street1", jsonReader.nextString());
                                continue block68;
                            }
                            case "country": {
                                idCardBiobank.set("country", jsonReader.nextString());
                                continue block68;
                            }
                            case "city": {
                                idCardBiobank.set("city", jsonReader.nextString());
                                continue block68;
                            }
                        }
                        jsonReader.skipValue();
                    }
                    jsonReader.endObject();
                    continue block64;
                }
                case "name": {
                    idCardBiobank.set("name", jsonReader.nextString());
                    continue block64;
                }
                case "ID": {
                    idCardBiobank.set("ID", jsonReader.nextString());
                    continue block64;
                }
                case "type of host institution": {
                    idCardBiobank.set("type_of_host_institution", jsonReader.nextString());
                    continue block64;
                }
                case "target population": {
                    idCardBiobank.set("target_population", jsonReader.nextString());
                    continue block64;
                }
            }
            LOG.warn("unknown property [{}] in root object", (Object)name);
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return idCardBiobank;
    }

    @Override
    public Iterable<Entity> toIdCardBiobanks(JsonReader jsonReader) throws IOException {
        ArrayList<Entity> idCardBiobanks = new ArrayList<Entity>();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            idCardBiobanks.add((Entity)this.toIdCardBiobank(jsonReader));
        }
        jsonReader.endArray();
        return idCardBiobanks;
    }

    @Override
    public IdCardOrganization toIdCardOrganization(JsonReader jsonReader) throws IOException {
        IdCardOrganization idCardOrganization = new IdCardOrganization();
        jsonReader.beginObject();
        block14: while (jsonReader.hasNext()) {
            String name;
            switch (name = jsonReader.nextName()) {
                case "Collections": {
                    jsonReader.skipValue();
                    continue block14;
                }
                case "name": {
                    idCardOrganization.setName(jsonReader.nextString());
                    continue block14;
                }
                case "ID": {
                    idCardOrganization.setId(jsonReader.nextString());
                    continue block14;
                }
                case "OrganizationID": {
                    idCardOrganization.setOrganizationId(jsonReader.nextString());
                    continue block14;
                }
                case "type": {
                    idCardOrganization.setType(jsonReader.nextString());
                    continue block14;
                }
            }
            LOG.warn("unknown property [{}] in root object", (Object)name);
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return idCardOrganization;
    }

    @Override
    public Iterable<IdCardOrganization> toIdCardOrganizations(JsonReader jsonReader) throws IOException {
        ArrayList<IdCardOrganization> idCardOrganizations = new ArrayList<IdCardOrganization>();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            idCardOrganizations.add(this.toIdCardOrganization(jsonReader));
        }
        jsonReader.endArray();
        return idCardOrganizations;
    }
}

