/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.jpa;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataConverter;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Fetch;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.Sort;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.support.AbstractRepository;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.support.QueryResolver;
import org.molgenis.generators.GeneratorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;

public class JpaRepository
extends AbstractRepository {
    private static final Logger LOG = LoggerFactory.getLogger(JpaRepository.class);
    public static final String BASE_URL = "jpa://";
    private final EntityMetaData entityMetaData;
    private final QueryResolver queryResolver;
    @PersistenceContext
    private EntityManager entityManager;

    public JpaRepository(EntityMetaData entityMetaData, QueryResolver queryResolver) {
        this.entityMetaData = entityMetaData;
        this.queryResolver = queryResolver;
    }

    public JpaRepository(EntityManager entityManager, EntityMetaData entityMetaData, QueryResolver queryResolver) {
        this(entityMetaData, queryResolver);
        this.entityManager = entityManager;
    }

    public EntityMetaData getEntityMetaData() {
        return this.entityMetaData;
    }

    protected Class<? extends Entity> getEntityClass() {
        return this.entityMetaData.getEntityClass();
    }

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Transactional
    public void add(Entity entity) {
        Entity jpaEntity = this.getTypedEntity(entity);
        if (LOG.isDebugEnabled()) {
            LOG.debug("persisting " + entity.getClass().getSimpleName() + " " + entity);
        }
        this.getEntityManager().persist((Object)jpaEntity);
        if (LOG.isDebugEnabled()) {
            LOG.debug("persisted " + entity.getClass().getSimpleName() + " [" + jpaEntity.getIdValue() + "]");
        }
        entity.set(this.getEntityMetaData().getIdAttribute().getName(), jpaEntity.getIdValue());
    }

    @Transactional
    public Integer add(Iterable<? extends Entity> entities) {
        Integer count = 0;
        for (Entity entity : entities) {
            this.add(entity);
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        return count;
    }

    @Transactional(readOnly=true)
    public Iterator<Entity> iterator() {
        return this.findAll((Query)new QueryImpl()).iterator();
    }

    @Transactional(readOnly=true)
    public long count() {
        return this.count((Query)new QueryImpl());
    }

    @Transactional(readOnly=true)
    public long count(Query q) {
        this.queryResolver.resolveRefIdentifiers(q.getRules(), this.getEntityMetaData());
        EntityManager em = this.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        Root from = cq.from(this.getEntityClass());
        cq.select((Selection)cb.countDistinct((Expression)from));
        this.createWhere(q, from, cq, cb);
        TypedQuery tq = em.createQuery(cq);
        if (LOG.isDebugEnabled()) {
            LOG.debug("execute count query " + q);
        }
        return (Long)tq.getSingleResult();
    }

    @Transactional(readOnly=true)
    public Entity findOne(Object id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching JPA [{}] data by id [{}]", (Object)this.getEntityClass().getSimpleName(), id);
        }
        return (Entity)this.getEntityManager().find(this.getEntityClass(), this.getEntityMetaData().getIdAttribute().getDataType().convert(id));
    }

    @Transactional(readOnly=true)
    public Entity findOne(Object id, Fetch fetch) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching JPA [{}] data by id [{}]", (Object)this.getEntityClass().getSimpleName(), id);
        }
        return (Entity)this.getEntityManager().find(this.getEntityClass(), this.getEntityMetaData().getIdAttribute().getDataType().convert(id));
    }

    @Transactional(readOnly=true)
    public Iterable<Entity> findAll(Query q) {
        this.queryResolver.resolveRefIdentifiers(q.getRules(), this.getEntityMetaData());
        EntityManager em = this.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(this.getEntityClass());
        Root from = cq.from(this.getEntityClass());
        cq.select((Selection)from).distinct(true);
        this.createWhere(q, from, cq, cb);
        TypedQuery tq = em.createQuery(cq);
        if (q.getPageSize() > 0) {
            tq.setMaxResults(q.getPageSize());
        }
        if (q.getOffset() > 0) {
            tq.setFirstResult(q.getOffset());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching JPA [{}] data for query [{}]", (Object)this.getEntityClass().getSimpleName(), (Object)q);
        }
        return tq.getResultList();
    }

    @Transactional(readOnly=true)
    public Entity findOne(Query q) {
        Iterable<Entity> result = this.findAll(q);
        Iterator<Entity> it = result.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    @Transactional
    public void update(Entity entity) {
        EntityManager em = this.getEntityManager();
        if (LOG.isDebugEnabled()) {
            LOG.debug("merging" + this.getEntityClass().getSimpleName() + " [" + entity.getIdValue() + "]");
        }
        em.merge((Object)this.getTypedEntity(entity));
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushing entity manager");
        }
        em.flush();
    }

    @Transactional
    public void update(Iterable<? extends Entity> entities) {
        EntityManager em = this.getEntityManager();
        int batchSize = 500;
        int batchCount = 0;
        for (Entity entity : entities) {
            Entity entity2 = this.getTypedEntity(entity);
            if (LOG.isDebugEnabled()) {
                LOG.debug("merging" + this.getEntityClass().getSimpleName() + " [" + entity.getIdValue() + "]");
            }
            em.merge((Object)entity2);
            if (++batchCount != batchSize) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("flushing entity manager");
            }
            em.flush();
            if (LOG.isDebugEnabled()) {
                LOG.debug("clearing entity manager");
            }
            em.clear();
            batchCount = 0;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushing entity manager");
        }
        em.flush();
    }

    @Transactional
    public void deleteById(Object id) {
        Entity entity;
        if (LOG.isDebugEnabled()) {
            LOG.debug("removing " + this.getEntityClass().getSimpleName() + " [" + id + "]");
        }
        if ((entity = this.findOne(this.getEntityMetaData().getIdAttribute().getDataType().convert(id))) == null) {
            throw new UnknownEntityException("Unknown entity [" + this.getEntityMetaData().getName() + "] with id [" + id + "]");
        }
        this.delete(entity);
    }

    @Transactional
    public void delete(Entity entity) {
        EntityManager em = this.getEntityManager();
        if (LOG.isDebugEnabled()) {
            LOG.debug("removing " + this.getEntityClass().getSimpleName() + " [" + entity.getIdValue() + "]");
        }
        em.remove((Object)this.findOne(entity.getIdValue()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushing entity manager");
        }
        em.flush();
    }

    @Transactional
    public void delete(Iterable<? extends Entity> entities) {
        EntityManager em = this.getEntityManager();
        for (Entity entity : entities) {
            em.remove((Object)this.findOne(entity.getIdValue()));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("removing " + this.getEntityClass().getSimpleName() + " [" + entity.getIdValue() + "]");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushing entity manager");
        }
        em.flush();
    }

    @Transactional
    public void deleteAll() {
        this.delete((Iterable<? extends Entity>)((Object)this));
    }

    private void createWhere(Query q, Root<?> from, CriteriaQuery<?> cq, CriteriaBuilder cb) {
        List<Order> orders;
        List<Predicate> where = this.createPredicates(from, cb, q.getRules());
        if (!where.isEmpty()) {
            cq.where((Expression)cb.and(where.toArray(new Predicate[where.size()])));
        }
        if (!(orders = this.createOrder(from, cb, q.getSort())).isEmpty()) {
            cq.orderBy(orders);
        }
    }

    private List<Predicate> createPredicates(Root<?> from, CriteriaBuilder cb, List<QueryRule> originalRules) {
        ArrayList rules = Lists.newArrayList(originalRules);
        ArrayList<Predicate> andPredicates = new ArrayList<Predicate>();
        ArrayList<Predicate> orPredicates = new ArrayList<Predicate>();
        ListIterator it = rules.listIterator();
        block19: while (it.hasNext()) {
            QueryRule r = (QueryRule)it.next();
            switch (r.getOperator()) {
                case AND: {
                    continue block19;
                }
                case NESTED: {
                    Predicate predicate;
                    List nestedRules = r.getNestedRules();
                    if (nestedRules == null || nestedRules.isEmpty()) continue block19;
                    List<Predicate> subPredicates = this.createPredicates(from, cb, nestedRules);
                    if (subPredicates.size() == 1) {
                        predicate = subPredicates.get(0);
                    } else {
                        Predicate[] subPredicatesArr = subPredicates.toArray(new Predicate[0]);
                        QueryRule.Operator andOrOperator = ((QueryRule)nestedRules.get(1)).getOperator();
                        switch (andOrOperator) {
                            case AND: {
                                predicate = cb.and(subPredicatesArr);
                                break;
                            }
                            case OR: {
                                predicate = cb.or(subPredicatesArr);
                                break;
                            }
                            default: {
                                throw new MolgenisDataException("Expected AND or OR operator in query rule [" + r + "] instead of " + andOrOperator);
                            }
                        }
                    }
                    andPredicates.add(predicate);
                    continue block19;
                }
                case OR: {
                    orPredicates.add(cb.and(andPredicates.toArray(new Predicate[andPredicates.size()])));
                    andPredicates.clear();
                    continue block19;
                }
                case EQUALS: {
                    andPredicates.add(cb.equal((Expression)from.get(r.getJpaAttribute()), r.getValue()));
                    continue block19;
                }
                case IN: {
                    AttributeMetaData meta = this.getEntityMetaData().getAttribute(r.getField());
                    MolgenisFieldTypes.FieldTypeEnum enumType = meta.getDataType().getEnumType();
                    CriteriaBuilder.In in = enumType == MolgenisFieldTypes.FieldTypeEnum.MREF || enumType == MolgenisFieldTypes.FieldTypeEnum.CATEGORICAL_MREF || enumType == MolgenisFieldTypes.FieldTypeEnum.CATEGORICAL ? cb.in((Expression)from.join(r.getJpaAttribute(), JoinType.LEFT)) : cb.in((Expression)from.get(r.getJpaAttribute()));
                    for (Object o : (Iterable)r.getValue()) {
                        in.value(o);
                    }
                    andPredicates.add((Predicate)in);
                    continue block19;
                }
                case LIKE: {
                    String like = "%" + r.getValue() + "%";
                    String f = r.getJpaAttribute();
                    andPredicates.add(cb.like((Expression)from.get(f), like));
                    continue block19;
                }
                case SEARCH: {
                    andPredicates.addAll(this.createPredicates(from, cb, this.createSearchQueryRules(r.getValue())));
                    it.remove();
                    continue block19;
                }
            }
            Path field = from.get(r.getJpaAttribute());
            Object value = r.getValue();
            Comparable<Integer> cValue = null;
            if (field.getJavaType() == Integer.class) {
                cValue = DataConverter.toInt((Object)value);
            } else if (field.getJavaType() == Long.class) {
                cValue = DataConverter.toLong((Object)value);
            } else if (field.getJavaType() == java.util.Date.class) {
                cValue = DataConverter.toDate((Object)value);
            } else {
                throw new MolgenisDataException("cannot solve query rule:  " + r);
            }
            switch (r.getOperator()) {
                case GREATER: {
                    andPredicates.add(cb.greaterThan((Expression)field, (Comparable)cValue));
                    continue block19;
                }
                case LESS: {
                    andPredicates.add(cb.lessThan((Expression)field, (Comparable)cValue));
                    continue block19;
                }
                case GREATER_EQUAL: {
                    andPredicates.add(cb.greaterThanOrEqualTo((Expression)field, (Comparable)cValue));
                    continue block19;
                }
                case LESS_EQUAL: {
                    andPredicates.add(cb.lessThanOrEqualTo((Expression)field, (Comparable)cValue));
                    continue block19;
                }
            }
            throw new RuntimeException("canno solve query rule:  " + r);
        }
        if (orPredicates.size() > 0) {
            if (andPredicates.size() > 0) {
                orPredicates.add(cb.and(andPredicates.toArray(new Predicate[0])));
            }
            ArrayList<Predicate> result = new ArrayList<Predicate>();
            result.add(cb.or(orPredicates.toArray(new Predicate[0])));
            return result;
        }
        if (andPredicates.size() > 0) {
            return andPredicates;
        }
        return new ArrayList<Predicate>();
    }

    private List<Order> createOrder(Root<?> from, CriteriaBuilder cb, Sort sort) {
        ArrayList<Order> orders = new ArrayList<Order>();
        if (sort != null) {
            for (Sort.Order sortOrder : sort) {
                if (sortOrder.getDirection() == Sort.Direction.ASC) {
                    orders.add(cb.asc((Expression)from.get(GeneratorHelper.firstToLower((String)sortOrder.getAttr()))));
                    continue;
                }
                orders.add(cb.desc((Expression)from.get(GeneratorHelper.firstToLower((String)sortOrder.getAttr()))));
            }
        }
        return orders;
    }

    public void close() throws IOException {
    }

    @Transactional
    public void deleteById(Iterable<Object> ids) {
        for (Object id : ids) {
            this.deleteById(id);
        }
    }

    @Transactional(readOnly=true)
    public void flush() {
        LOG.debug("flushing entity manager");
        this.getEntityManager().flush();
    }

    public void clearCache() {
        LOG.debug("clearing entity manager");
        this.getEntityManager().clear();
    }

    private Entity getTypedEntity(Entity entity) {
        if (this.getEntityClass().isAssignableFrom(entity.getClass())) {
            return entity;
        }
        Entity jpaEntity = (Entity)BeanUtils.instantiateClass(this.getEntityClass());
        jpaEntity.set(entity);
        return jpaEntity;
    }

    private List<QueryRule> createSearchQueryRules(Object searchValue) {
        ArrayList searchRules = Lists.newArrayList();
        for (AttributeMetaData attr : this.getEntityMetaData().getAtomicAttributes()) {
            QueryRule rule = null;
            switch (attr.getDataType().getEnumType()) {
                case ENUM: 
                case STRING: 
                case TEXT: 
                case HTML: 
                case HYPERLINK: 
                case EMAIL: {
                    rule = new QueryRule(attr.getName(), QueryRule.Operator.LIKE, searchValue);
                    break;
                }
                case BOOL: {
                    if (!DataConverter.canConvert((Object)searchValue, Boolean.class)) break;
                    rule = new QueryRule(attr.getName(), QueryRule.Operator.EQUALS, (Object)DataConverter.toBoolean((Object)searchValue));
                    break;
                }
                case DATE: {
                    if (!DataConverter.canConvert((Object)searchValue, Date.class)) break;
                    rule = new QueryRule(attr.getName(), QueryRule.Operator.EQUALS, (Object)DataConverter.toDate((Object)searchValue));
                    break;
                }
                case DATE_TIME: {
                    if (!DataConverter.canConvert((Object)searchValue, java.util.Date.class)) break;
                    rule = new QueryRule(attr.getName(), QueryRule.Operator.EQUALS, (Object)DataConverter.toUtilDate((Object)searchValue));
                    break;
                }
                case DECIMAL: {
                    if (!DataConverter.canConvert((Object)searchValue, Double.class)) break;
                    rule = new QueryRule(attr.getName(), QueryRule.Operator.EQUALS, (Object)DataConverter.toDouble((Object)searchValue));
                    break;
                }
                case INT: {
                    if (!DataConverter.canConvert((Object)searchValue, Integer.class)) break;
                    rule = new QueryRule(attr.getName(), QueryRule.Operator.EQUALS, (Object)DataConverter.toInt((Object)searchValue));
                    break;
                }
                case LONG: {
                    if (!DataConverter.canConvert((Object)searchValue, Long.class)) break;
                    rule = new QueryRule(attr.getName(), QueryRule.Operator.EQUALS, (Object)DataConverter.toLong((Object)searchValue));
                    break;
                }
                case CATEGORICAL: 
                case CATEGORICAL_MREF: 
                case MREF: 
                case XREF: {
                    ArrayList nested = Lists.newArrayList();
                    for (AttributeMetaData refAttr : attr.getRefEntity().getAtomicAttributes()) {
                        MolgenisFieldTypes.FieldTypeEnum fieldType;
                        if (!refAttr.isLabelAttribute() && !refAttr.isLookupAttribute() || (fieldType = refAttr.getDataType().getEnumType()) != MolgenisFieldTypes.FieldTypeEnum.STRING && fieldType != MolgenisFieldTypes.FieldTypeEnum.ENUM && fieldType != MolgenisFieldTypes.FieldTypeEnum.TEXT && fieldType != MolgenisFieldTypes.FieldTypeEnum.HTML && fieldType != MolgenisFieldTypes.FieldTypeEnum.HYPERLINK && fieldType != MolgenisFieldTypes.FieldTypeEnum.EMAIL) continue;
                        Query q = new QueryImpl().like(refAttr.getName(), searchValue.toString());
                        EntityManager em = this.getEntityManager();
                        CriteriaBuilder cb = em.getCriteriaBuilder();
                        CriteriaQuery cq = cb.createQuery(attr.getRefEntity().getEntityClass());
                        Root from = cq.from(attr.getRefEntity().getEntityClass());
                        cq.select((Selection)from);
                        this.createWhere(q, from, cq, cb);
                        TypedQuery tq = em.createQuery(cq);
                        List refEntities = tq.getResultList();
                        if (refEntities.isEmpty()) continue;
                        if (!nested.isEmpty()) {
                            nested.add(QueryRule.OR);
                        }
                        nested.add(new QueryRule(attr.getName(), QueryRule.Operator.IN, (Object)refEntities));
                    }
                    if (nested.isEmpty()) break;
                    rule = new QueryRule(QueryRule.Operator.NESTED, (Object)nested);
                    break;
                }
            }
            if (rule == null) continue;
            if (!searchRules.isEmpty()) {
                searchRules.add(new QueryRule(QueryRule.Operator.OR));
            }
            searchRules.add(rule);
        }
        return searchRules;
    }

    public Set<RepositoryCapability> getCapabilities() {
        return Sets.newHashSet((Object[])new RepositoryCapability[]{RepositoryCapability.WRITABLE});
    }
}

