/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.jpa.importer;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.molgenis.data.DatabaseAction;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.importer.ImportService;
import org.molgenis.data.jpa.importer.EntitiesImporter;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.data.support.GenericImporterExtensions;
import org.molgenis.framework.db.EntitiesValidationReport;
import org.molgenis.framework.db.EntitiesValidator;
import org.molgenis.framework.db.EntityImportReport;
import org.molgenis.util.FileExtensionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class JpaImportService
implements ImportService {
    private final EntitiesValidator entitiesValidator;
    private final EntitiesImporter entitiesImporter;
    private final RepositoryCollection targetCollection;

    @Autowired
    public JpaImportService(EntitiesValidator entitiesValidator, EntitiesImporter entitiesImporter, @Qualifier(value="JpaRepositoryCollection") RepositoryCollection repositoryCollection) {
        this.entitiesValidator = Objects.requireNonNull(entitiesValidator);
        this.entitiesImporter = Objects.requireNonNull(entitiesImporter);
        this.targetCollection = Objects.requireNonNull(repositoryCollection);
    }

    public EntitiesValidationReport validateImport(File file, RepositoryCollection source) {
        try {
            return this.entitiesValidator.validate(file);
        }
        catch (IOException e) {
            throw new MolgenisDataException((Throwable)e);
        }
    }

    public EntityImportReport doImport(RepositoryCollection source, DatabaseAction databaseAction, String defaultPackage) {
        try {
            return this.entitiesImporter.importEntities(source, databaseAction);
        }
        catch (IOException e) {
            throw new MolgenisDataException((Throwable)e);
        }
    }

    public boolean canImport(File file, RepositoryCollection source) {
        String fileNameExtension = FileExtensionUtils.findExtensionFromPossibilities((String)file.getName(), (Set)GenericImporterExtensions.getJPA());
        if (!source.getEntityNames().iterator().hasNext()) {
            return false;
        }
        if (null != fileNameExtension) {
            for (String entityName : source.getEntityNames()) {
                if (this.targetCollection.hasRepository(entityName)) continue;
                return false;
            }
        }
        return true;
    }

    public List<DatabaseAction> getSupportedDatabaseActions() {
        return Lists.newArrayList((Object[])DatabaseAction.values());
    }

    public boolean getMustChangeEntityName() {
        return false;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public Set<String> getSupportedFileExtensions() {
        return GenericImporterExtensions.getJPA();
    }

    public LinkedHashMap<String, Boolean> integrationTestMetaData(MetaDataService metaDataService, RepositoryCollection repositoryCollection, String defaultPackage) {
        return metaDataService.integrationTestMetaData(repositoryCollection);
    }
}

