/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.jpa;

import org.apache.log4j.Logger;
import org.molgenis.data.DataService;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.RepositoryDecoratorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class JpaRepositoryRegistrator
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private static final Logger LOG = Logger.getLogger(JpaRepositoryRegistrator.class);
    private final DataService dataService;
    private final RepositoryCollection repositoryCollection;
    private final RepositoryDecoratorFactory repositoryDecoratorFactory;

    @Autowired
    public JpaRepositoryRegistrator(DataService dataService, @Qualifier(value="JpaRepositoryCollection") RepositoryCollection repositoryCollection, RepositoryDecoratorFactory repositoryDecoratorFactory) {
        if (dataService == null) {
            throw new IllegalArgumentException("DataService is null");
        }
        if (repositoryCollection == null) {
            throw new IllegalArgumentException("JpaRepositoryCollection is missing");
        }
        this.dataService = dataService;
        this.repositoryCollection = repositoryCollection;
        this.repositoryDecoratorFactory = repositoryDecoratorFactory;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        LOG.info((Object)"Registering JPA repositories ...");
        for (String name : this.repositoryCollection.getEntityNames()) {
            LOG.debug((Object)("Registering JPA repository [" + name + "]"));
            Repository repository = this.repositoryCollection.getRepositoryByEntityName(name);
            this.dataService.addRepository(this.repositoryDecoratorFactory.createDecoratedRepository(repository));
        }
        LOG.info((Object)"Registered JPA repositories");
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

