/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.jpa;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataConverter;
import org.molgenis.data.DatabaseAction;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.support.AbstractAggregateableCrudRepository;
import org.molgenis.data.support.ConvertingIterable;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.support.QueryResolver;
import org.molgenis.data.validation.EntityValidator;
import org.molgenis.generators.GeneratorHelper;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;

public class JpaRepository
extends AbstractAggregateableCrudRepository {
    public static final String BASE_URL = "jpa://";
    private final EntityMetaData entityMetaData;
    private final QueryResolver queryResolver;
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    @PersistenceContext
    private EntityManager entityManager;

    public JpaRepository(EntityMetaData entityMetaData, EntityValidator entityValidator, QueryResolver queryResolver) {
        super(BASE_URL + entityMetaData.getEntityClass().getName(), entityValidator);
        this.entityMetaData = entityMetaData;
        this.queryResolver = queryResolver;
    }

    public JpaRepository(EntityManager entityManager, EntityMetaData entityMetaData, EntityValidator entityValidator, QueryResolver queryResolver) {
        this(entityMetaData, entityValidator, queryResolver);
        this.entityManager = entityManager;
    }

    public EntityMetaData getEntityMetaData() {
        return this.entityMetaData;
    }

    protected Class<? extends Entity> getEntityClass() {
        return this.entityMetaData.getEntityClass();
    }

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    protected void addInternal(Entity entity) {
        Entity jpaEntity = this.getTypedEntity(entity);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("persisting " + entity.getClass().getSimpleName() + " " + entity));
        }
        this.getEntityManager().persist((Object)jpaEntity);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("persisted " + entity.getClass().getSimpleName() + " [" + jpaEntity.getIdValue() + "]"));
        }
        entity.set(this.getEntityMetaData().getIdAttribute().getName(), jpaEntity.getIdValue());
    }

    protected Integer addInternal(Iterable<? extends Entity> entities) {
        Integer count = 0;
        for (Entity entity : entities) {
            this.addInternal(entity);
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        return count;
    }

    @Transactional(readOnly=true)
    public Iterator<Entity> iterator() {
        return this.findAll((Query)new QueryImpl()).iterator();
    }

    @Transactional(readOnly=true)
    public long count() {
        return this.count((Query)new QueryImpl());
    }

    @Transactional(readOnly=true)
    public long count(Query q) {
        this.queryResolver.resolveRefIdentifiers(q.getRules(), this.getEntityMetaData());
        EntityManager em = this.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        Root from = cq.from(this.getEntityClass());
        cq.select((Selection)cb.countDistinct((Expression)from));
        this.createWhere(q, from, cq, cb);
        TypedQuery tq = em.createQuery(cq);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("execute count query " + q));
        }
        return (Long)tq.getSingleResult();
    }

    @Transactional(readOnly=true)
    public Entity findOne(Object id) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("finding by key" + this.getEntityClass().getSimpleName() + " [" + id + "]"));
        }
        return (Entity)this.getEntityManager().find(this.getEntityClass(), this.getEntityMetaData().getIdAttribute().getDataType().convert(id));
    }

    @Transactional(readOnly=true)
    public Iterable<Entity> findAll(Iterable<Object> ids) {
        String idAttrName = this.getEntityMetaData().getIdAttribute().getName();
        EntityManager em = this.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(this.getEntityClass());
        Root from = cq.from(this.getEntityClass());
        cq.select((Selection)from).where((Expression)from.get(idAttrName).in((Collection)Lists.newArrayList(ids)));
        TypedQuery tq = em.createQuery(cq);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("finding by key " + this.getEntityClass().getSimpleName() + " [" + StringUtils.join(ids, (char)',') + "]"));
        }
        return tq.getResultList();
    }

    @Transactional(readOnly=true)
    public Iterable<Entity> findAll(Query q) {
        this.queryResolver.resolveRefIdentifiers(q.getRules(), this.getEntityMetaData());
        EntityManager em = this.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(this.getEntityClass());
        Root from = cq.from(this.getEntityClass());
        cq.select((Selection)from).distinct(true);
        this.createWhere(q, from, cq, cb);
        TypedQuery tq = em.createQuery(cq);
        if (q.getPageSize() > 0) {
            tq.setMaxResults(q.getPageSize());
        }
        if (q.getOffset() > 0) {
            tq.setFirstResult(q.getOffset());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("finding " + this.getEntityClass().getSimpleName() + " " + q));
        }
        return tq.getResultList();
    }

    @Transactional(readOnly=true)
    public Entity findOne(Query q) {
        Iterable<Entity> result = this.findAll(q);
        Iterator<Entity> it = result.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    protected void updateInternal(Entity entity) {
        EntityManager em = this.getEntityManager();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("merging" + this.getEntityClass().getSimpleName() + " [" + entity.getIdValue() + "]"));
        }
        em.merge((Object)this.getTypedEntity(entity));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"flushing entity manager");
        }
        em.flush();
    }

    protected void updateInternal(Iterable<? extends Entity> entities) {
        EntityManager em = this.getEntityManager();
        int batchSize = 500;
        int batchCount = 0;
        for (Entity entity : entities) {
            Entity entity2 = this.getTypedEntity(entity);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("merging" + this.getEntityClass().getSimpleName() + " [" + entity.getIdValue() + "]"));
            }
            em.merge((Object)entity2);
            if (++batchCount != batchSize) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"flushing entity manager");
            }
            em.flush();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"clearing entity manager");
            }
            em.clear();
            batchCount = 0;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"flushing entity manager");
        }
        em.flush();
    }

    protected void updateInternal(List<? extends Entity> entities, DatabaseAction dbAction, String ... keyNames) {
        if (keyNames.length == 0) {
            throw new MolgenisDataException("At least one key must be provided, e.g. 'name'");
        }
        if (entities.size() == 0) {
            return;
        }
        String entityName = this.getEntityClass().getSimpleName();
        LinkedHashMap<String, Entity> entityIndex = new LinkedHashMap<String, Entity>();
        ArrayList keyIndex = new ArrayList();
        boolean keysMissing = false;
        for (Entity entity : entities) {
            StringBuilder combinedKeyBuilder = new StringBuilder();
            LinkedHashMap<String, Object> keyValues = new LinkedHashMap<String, Object>();
            boolean bl = true;
            for (String key : keyNames) {
                combinedKeyBuilder.append(';');
                if (entity.get(key) == null) continue;
                combinedKeyBuilder.append(entity.get(key));
                bl = false;
                keyValues.put(key, entity.get(key));
            }
            if (bl) {
                keysMissing = true;
            }
            if (!keysMissing) {
                keyIndex.add(keyValues);
                entityIndex.put(combinedKeyBuilder.toString(), entity);
                continue;
            }
            if ((dbAction.equals((Object)DatabaseAction.ADD) || dbAction.equals((Object)DatabaseAction.ADD_IGNORE_EXISTING) || dbAction.equals((Object)DatabaseAction.ADD_UPDATE_EXISTING)) && keyNames.length == 1 && keyNames[0].equals(this.getEntityMetaData().getIdAttribute().getName())) continue;
            throw new MolgenisDataException("keys are missing: " + this.getEntityClass().getSimpleName() + "." + Arrays.asList(keyNames));
        }
        List<? extends Entity> newEntities = entities;
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        if (!keysMissing && keyIndex.size() > 0) {
            newEntities = new ArrayList<Entity>();
            QueryImpl q = new QueryImpl();
            if (keyNames.length == 1) {
                ArrayList values = new ArrayList();
                for (Map map : keyIndex) {
                    values.add(map.get(keyNames[0]));
                }
                q.in(keyNames[0], values);
            } else {
                for (Map map : keyIndex) {
                    for (int i = 0; i < keyNames.length; ++i) {
                        if (i > 0) {
                            q.or();
                        }
                        q.eq(keyNames[i], map.get(keyNames[i]));
                    }
                }
            }
            Iterable<Entity> selectForUpdate = this.findAll((Query)q);
            for (Entity entity : selectForUpdate) {
                StringBuilder combinedKeyBuilder = new StringBuilder();
                for (String key : keyNames) {
                    combinedKeyBuilder.append(';').append(entity.get(key));
                }
                entityIndex.remove(combinedKeyBuilder.toString());
                arrayList.add(entity);
            }
            newEntities = new ArrayList(entityIndex.values());
        }
        if (arrayList.size() > 0 && (dbAction == DatabaseAction.ADD_UPDATE_EXISTING || dbAction == DatabaseAction.UPDATE || dbAction == DatabaseAction.UPDATE_IGNORE_MISSING)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("existingEntities[0] before: " + ((Entity)arrayList.get(0)).toString()));
            }
            this.matchByNameAndUpdateFields(arrayList, entities);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("existingEntities[0] after: " + ((Entity)arrayList.get(0)).toString()));
            }
        }
        switch (dbAction) {
            case ADD: {
                if (arrayList.size() == 0) {
                    this.addInternal(newEntities);
                    break;
                }
                throw new MolgenisDataException("Tried to add existing " + entityName + " elements as new insert: " + Arrays.asList(keyNames) + "=" + arrayList.subList(0, Math.min(5, arrayList.size())) + (arrayList.size() > 5 ? " and " + (arrayList.size() - 5) + "more" : "" + arrayList));
            }
            case ADD_IGNORE_EXISTING: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("updateByName(List<" + entityName + "," + dbAction + ">) will skip " + arrayList.size() + " existing entities"));
                }
                this.addInternal(newEntities);
                break;
            }
            case ADD_UPDATE_EXISTING: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("updateByName(List<" + entityName + "," + dbAction + ">)  will try to update " + arrayList.size() + " existing entities and add " + newEntities.size() + " new entities"));
                }
                this.addInternal(newEntities);
                this.update(arrayList);
                break;
            }
            case UPDATE: {
                if (newEntities.size() == 0) {
                    this.updateInternal(arrayList);
                    break;
                }
                throw new MolgenisDataException("Tried to update non-existing " + entityName + "elements " + Arrays.asList(keyNames) + "=" + entityIndex.values());
            }
            case UPDATE_IGNORE_MISSING: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("updateByName(List<" + entityName + "," + dbAction + ">) will try to update " + arrayList.size() + " existing entities and skip " + newEntities.size() + " new entities"));
                }
                this.updateInternal(arrayList);
                break;
            }
            case REMOVE: {
                if (newEntities.size() == 0) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("updateByName(List<" + entityName + "," + dbAction + ">) will try to remove " + arrayList.size() + " existing entities"));
                    }
                    this.delete(arrayList);
                    break;
                }
                throw new MolgenisDataException("Tried to remove non-existing " + entityName + " elements " + Arrays.asList(keyNames) + "=" + entityIndex.values());
            }
            case REMOVE_IGNORE_MISSING: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("updateByName(List<" + entityName + "," + dbAction + ">) will try to remove " + arrayList.size() + " existing entities and skip " + newEntities.size() + " new entities"));
                }
                this.delete(arrayList);
                break;
            }
            default: {
                throw new MolgenisDataException("updateByName failed because of unknown dbAction " + dbAction);
            }
        }
    }

    private void matchByNameAndUpdateFields(List<? extends Entity> existingEntities, List<? extends Entity> entities) {
        for (Entity entity : existingEntities) {
            for (Entity entity2 : entities) {
                boolean match = false;
                if (entity.getLabelAttributeNames().size() > 0) {
                    match = true;
                }
                for (String labelField : entity.getLabelAttributeNames()) {
                    Object x2;
                    Object x1 = entity.get(labelField);
                    if (x1.equals(x2 = entity2.get(labelField))) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                try {
                    MapEntity mapEntity = new MapEntity();
                    for (String field : entity.getAttributeNames()) {
                        mapEntity.set(field, entity2.get(field));
                    }
                    entity.set((Entity)mapEntity, false);
                }
                catch (Exception ex) {
                    throw new MolgenisDataException((Throwable)ex);
                }
            }
        }
    }

    @Transactional
    public void deleteById(Object id) {
        Entity entity;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("removing " + this.getEntityClass().getSimpleName() + " [" + id + "]"));
        }
        if ((entity = this.findOne(this.getEntityMetaData().getIdAttribute().getDataType().convert(id))) == null) {
            throw new UnknownEntityException("Unknown entity [" + this.getEntityMetaData().getName() + "] with id [" + id + "]");
        }
        this.delete(entity);
    }

    @Transactional
    public void delete(Entity entity) {
        EntityManager em = this.getEntityManager();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("removing " + this.getEntityClass().getSimpleName() + " [" + entity.getIdValue() + "]"));
        }
        em.remove((Object)this.getTypedEntity(entity));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"flushing entity manager");
        }
        em.flush();
    }

    @Transactional
    public void delete(Iterable<? extends Entity> entities) {
        EntityManager em = this.getEntityManager();
        for (Entity entity : entities) {
            em.remove((Object)this.getTypedEntity(entity));
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("removing " + this.getEntityClass().getSimpleName() + " [" + entity.getIdValue() + "]"));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"flushing entity manager");
        }
        em.flush();
    }

    @Transactional
    public void deleteAll() {
        this.delete((Iterable<? extends Entity>)((Object)this));
    }

    private void createWhere(Query q, Root<?> from, CriteriaQuery<?> cq, CriteriaBuilder cb) {
        List<Order> orders;
        List<Predicate> where = this.createPredicates(from, cb, q.getRules());
        if (!where.isEmpty()) {
            cq.where((Expression)cb.and(where.toArray(new Predicate[where.size()])));
        }
        if (!(orders = this.createOrder(from, cb, q.getSort())).isEmpty()) {
            cq.orderBy(orders);
        }
    }

    private List<Predicate> createPredicates(Root<?> from, CriteriaBuilder cb, List<QueryRule> originalRules) {
        ArrayList rules = Lists.newArrayList(originalRules);
        ArrayList<Predicate> andPredicates = new ArrayList<Predicate>();
        ArrayList<Predicate> orPredicates = new ArrayList<Predicate>();
        ListIterator it = rules.listIterator();
        block19: while (it.hasNext()) {
            QueryRule r = (QueryRule)it.next();
            AttributeMetaData meta = this.getEntityMetaData().getAttribute(r.getField());
            switch (r.getOperator()) {
                case AND: {
                    continue block19;
                }
                case NESTED: {
                    Predicate predicate;
                    List nestedRules = r.getNestedRules();
                    if (nestedRules == null || nestedRules.isEmpty()) continue block19;
                    List<Predicate> subPredicates = this.createPredicates(from, cb, nestedRules);
                    if (subPredicates.size() == 1) {
                        predicate = subPredicates.get(0);
                    } else {
                        Predicate[] subPredicatesArr = subPredicates.toArray(new Predicate[0]);
                        QueryRule.Operator andOrOperator = ((QueryRule)nestedRules.get(1)).getOperator();
                        switch (andOrOperator) {
                            case AND: {
                                predicate = cb.and(subPredicatesArr);
                                break;
                            }
                            case OR: {
                                predicate = cb.or(subPredicatesArr);
                                break;
                            }
                            default: {
                                throw new MolgenisDataException("Expected AND or OR operator in query rule [" + r + "] instead of " + andOrOperator);
                            }
                        }
                    }
                    andPredicates.add(predicate);
                    continue block19;
                }
                case OR: {
                    orPredicates.add(cb.and(andPredicates.toArray(new Predicate[andPredicates.size()])));
                    andPredicates.clear();
                    continue block19;
                }
                case EQUALS: {
                    if (meta.getDataType().getEnumType() == MolgenisFieldTypes.FieldTypeEnum.DATE_TIME && r.getValue() instanceof Date) {
                        andPredicates.add(cb.equal(cb.function("Date", java.util.Date.class, new Expression[]{from.get(r.getJpaAttribute())}), r.getValue()));
                        continue block19;
                    }
                    andPredicates.add(cb.equal((Expression)from.get(r.getJpaAttribute()), r.getValue()));
                    continue block19;
                }
                case IN: {
                    CriteriaBuilder.In in = meta.getDataType().getEnumType() == MolgenisFieldTypes.FieldTypeEnum.MREF || meta.getDataType().getEnumType() == MolgenisFieldTypes.FieldTypeEnum.CATEGORICAL ? cb.in((Expression)from.join(r.getJpaAttribute(), JoinType.LEFT)) : cb.in((Expression)from.get(r.getJpaAttribute()));
                    for (Object o : (Iterable)r.getValue()) {
                        in.value(o);
                    }
                    andPredicates.add((Predicate)in);
                    continue block19;
                }
                case LIKE: {
                    String like = "%" + r.getValue() + "%";
                    String f = r.getJpaAttribute();
                    andPredicates.add(cb.like((Expression)from.get(f), like));
                    continue block19;
                }
                case SEARCH: {
                    andPredicates.addAll(this.createPredicates(from, cb, this.createSearchQueryRules(r.getValue())));
                    it.remove();
                    continue block19;
                }
            }
            Path field = from.get(r.getJpaAttribute());
            Object value = r.getValue();
            Comparable<Integer> cValue = null;
            if (field.getJavaType() == Integer.class) {
                cValue = DataConverter.toInt((Object)value);
            } else if (field.getJavaType() == Long.class) {
                cValue = DataConverter.toLong((Object)value);
            } else if (field.getJavaType() == java.util.Date.class) {
                cValue = DataConverter.toDate((Object)value);
            } else {
                throw new MolgenisDataException("cannot solve query rule:  " + r);
            }
            switch (r.getOperator()) {
                case GREATER: {
                    andPredicates.add(cb.greaterThan((Expression)field, (Comparable)cValue));
                    continue block19;
                }
                case LESS: {
                    andPredicates.add(cb.lessThan((Expression)field, (Comparable)cValue));
                    continue block19;
                }
                case GREATER_EQUAL: {
                    andPredicates.add(cb.greaterThanOrEqualTo((Expression)field, (Comparable)cValue));
                    continue block19;
                }
                case LESS_EQUAL: {
                    andPredicates.add(cb.lessThanOrEqualTo((Expression)field, (Comparable)cValue));
                    continue block19;
                }
            }
            throw new RuntimeException("canno solve query rule:  " + r);
        }
        if (orPredicates.size() > 0) {
            if (andPredicates.size() > 0) {
                orPredicates.add(cb.and(andPredicates.toArray(new Predicate[0])));
            }
            ArrayList<Predicate> result = new ArrayList<Predicate>();
            result.add(cb.or(orPredicates.toArray(new Predicate[0])));
            return result;
        }
        if (andPredicates.size() > 0) {
            return andPredicates;
        }
        return new ArrayList<Predicate>();
    }

    private List<Order> createOrder(Root<?> from, CriteriaBuilder cb, Sort sort) {
        ArrayList<Order> orders = new ArrayList<Order>();
        if (sort != null) {
            for (Sort.Order sortOrder : sort) {
                if (sortOrder.isAscending()) {
                    orders.add(cb.asc((Expression)from.get(GeneratorHelper.firstToLower((String)sortOrder.getProperty()))));
                    continue;
                }
                orders.add(cb.desc((Expression)from.get(GeneratorHelper.firstToLower((String)sortOrder.getProperty()))));
            }
        }
        return orders;
    }

    public void close() throws IOException {
    }

    @Transactional
    public void deleteById(Iterable<Object> ids) {
        for (Object id : ids) {
            this.deleteById(id);
        }
    }

    @Transactional(readOnly=true)
    public void flush() {
        this.logger.debug((Object)"flushing entity manager");
        this.getEntityManager().flush();
    }

    public void clearCache() {
        this.logger.debug((Object)"clearing entity manager");
        this.getEntityManager().clear();
    }

    private Entity getTypedEntity(Entity entity) {
        if (this.getEntityClass().isAssignableFrom(entity.getClass())) {
            return entity;
        }
        Entity jpaEntity = (Entity)BeanUtils.instantiateClass(this.getEntityClass());
        jpaEntity.set(entity);
        return jpaEntity;
    }

    @Transactional(readOnly=true)
    public <E extends Entity> Iterable<E> findAll(Iterable<Object> ids, Class<E> clazz) {
        return new ConvertingIterable(clazz, this.findAll(ids));
    }

    @Transactional(readOnly=true)
    public <E extends Entity> E findOne(Object id, Class<E> clazz) {
        Entity entity = this.findOne(id);
        if (entity == null) {
            return null;
        }
        if (clazz.isAssignableFrom(entity.getClass())) {
            return (E)entity;
        }
        Entity e = (Entity)BeanUtils.instantiate(clazz);
        e.set(entity);
        return (E)e;
    }

    @Transactional(readOnly=true)
    public <E extends Entity> E findOne(Query q, Class<E> clazz) {
        Entity entity = this.findOne(q);
        if (entity == null) {
            return null;
        }
        if (clazz.isAssignableFrom(entity.getClass())) {
            return (E)entity;
        }
        Entity e = (Entity)BeanUtils.instantiate(clazz);
        e.set(entity);
        return (E)e;
    }

    protected void addAggregateValuesAndLabels(AttributeMetaData attr, List<Object> values, Set<String> labels) {
        if (attr.getDataType().getEnumType() == MolgenisFieldTypes.FieldTypeEnum.BOOL) {
            values.add(Boolean.TRUE);
            values.add(Boolean.FALSE);
            labels.add(attr.getName() + ": true");
            labels.add(attr.getName() + ": false");
        } else if (attr.getRefEntity() != null) {
            EntityMetaData refEntityMeta = attr.getRefEntity();
            String refEntityLblAttr = refEntityMeta.getLabelAttribute().getName();
            for (Entity entity : this.findAll(refEntityMeta.getEntityClass())) {
                labels.add(entity.getString(refEntityLblAttr));
                values.add(entity.get(refEntityLblAttr));
            }
        } else {
            for (Object value : this.getDistinctValues(attr)) {
                String valueStr = DataConverter.toString(value);
                labels.add(valueStr);
                values.add(valueStr);
            }
        }
    }

    private List<?> getDistinctValues(AttributeMetaData attr) {
        EntityManager em = this.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createTupleQuery();
        String attrName = attr.getName().substring(0, 1).toLowerCase() + attr.getName().substring(1);
        Root root = cq.from(this.getEntityClass());
        cq.distinct(true).multiselect(new Selection[]{root.get(attrName)});
        TypedQuery tq = em.createQuery(cq);
        List tuples = tq.getResultList();
        ArrayList result = Lists.newArrayList();
        for (Tuple tuple : tuples) {
            result.add(tuple.get(0));
        }
        return result;
    }

    private List<? extends Entity> findAll(Class<? extends Entity> entityClass) {
        EntityManager em = this.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(entityClass);
        TypedQuery tq = em.createQuery(cq.select((Selection)cq.from(entityClass)));
        return tq.getResultList();
    }

    private List<QueryRule> createSearchQueryRules(Object searchValue) {
        ArrayList searchRules = Lists.newArrayList();
        for (AttributeMetaData attr : this.getEntityMetaData().getAtomicAttributes()) {
            QueryRule rule = null;
            switch (attr.getDataType().getEnumType()) {
                case ENUM: 
                case STRING: 
                case TEXT: 
                case HTML: 
                case HYPERLINK: 
                case EMAIL: {
                    rule = new QueryRule(attr.getName(), QueryRule.Operator.LIKE, searchValue);
                    break;
                }
                case BOOL: {
                    if (!DataConverter.canConvert((Object)searchValue, Boolean.class)) break;
                    rule = new QueryRule(attr.getName(), QueryRule.Operator.EQUALS, (Object)DataConverter.toBoolean((Object)searchValue));
                    break;
                }
                case DATE: {
                    if (!DataConverter.canConvert((Object)searchValue, Date.class)) break;
                    rule = new QueryRule(attr.getName(), QueryRule.Operator.EQUALS, (Object)DataConverter.toDate((Object)searchValue));
                    break;
                }
                case DATE_TIME: {
                    if (searchValue instanceof String && ((String)searchValue).matches("\\d{4}-\\d{2}-\\d{2}") && DataConverter.canConvert((Object)searchValue, Date.class)) {
                        rule = new QueryRule(attr.getName(), QueryRule.Operator.EQUALS, (Object)DataConverter.toDate((Object)searchValue));
                        break;
                    }
                    if (!DataConverter.canConvert((Object)searchValue, java.util.Date.class)) break;
                    rule = new QueryRule(attr.getName(), QueryRule.Operator.EQUALS, (Object)DataConverter.toUtilDate((Object)searchValue));
                    break;
                }
                case DECIMAL: {
                    if (!DataConverter.canConvert((Object)searchValue, Double.class)) break;
                    rule = new QueryRule(attr.getName(), QueryRule.Operator.EQUALS, (Object)DataConverter.toDouble((Object)searchValue));
                    break;
                }
                case INT: {
                    if (!DataConverter.canConvert((Object)searchValue, Integer.class)) break;
                    rule = new QueryRule(attr.getName(), QueryRule.Operator.EQUALS, (Object)DataConverter.toInt((Object)searchValue));
                    break;
                }
                case LONG: {
                    if (!DataConverter.canConvert((Object)searchValue, Long.class)) break;
                    rule = new QueryRule(attr.getName(), QueryRule.Operator.EQUALS, (Object)DataConverter.toLong((Object)searchValue));
                    break;
                }
                case CATEGORICAL: 
                case MREF: 
                case XREF: {
                    ArrayList nested = Lists.newArrayList();
                    for (AttributeMetaData refAttr : attr.getRefEntity().getAtomicAttributes()) {
                        MolgenisFieldTypes.FieldTypeEnum fieldType;
                        if (!refAttr.isLabelAttribute() && !refAttr.isLookupAttribute() || (fieldType = refAttr.getDataType().getEnumType()) != MolgenisFieldTypes.FieldTypeEnum.STRING && fieldType != MolgenisFieldTypes.FieldTypeEnum.ENUM && fieldType != MolgenisFieldTypes.FieldTypeEnum.TEXT && fieldType != MolgenisFieldTypes.FieldTypeEnum.HTML && fieldType != MolgenisFieldTypes.FieldTypeEnum.HYPERLINK && fieldType != MolgenisFieldTypes.FieldTypeEnum.EMAIL) continue;
                        Query q = new QueryImpl().like(refAttr.getName(), searchValue);
                        EntityManager em = this.getEntityManager();
                        CriteriaBuilder cb = em.getCriteriaBuilder();
                        CriteriaQuery cq = cb.createQuery(attr.getRefEntity().getEntityClass());
                        Root from = cq.from(attr.getRefEntity().getEntityClass());
                        cq.select((Selection)from);
                        this.createWhere(q, from, cq, cb);
                        TypedQuery tq = em.createQuery(cq);
                        List refEntities = tq.getResultList();
                        if (refEntities.isEmpty()) continue;
                        if (!nested.isEmpty()) {
                            nested.add(QueryRule.OR);
                        }
                        nested.add(new QueryRule(attr.getName(), QueryRule.Operator.IN, (Object)refEntities));
                    }
                    if (nested.isEmpty()) break;
                    rule = new QueryRule(QueryRule.Operator.NESTED, (Object)nested);
                    break;
                }
            }
            if (rule == null) continue;
            if (!searchRules.isEmpty()) {
                searchRules.add(new QueryRule(QueryRule.Operator.OR));
            }
            searchRules.add(rule);
        }
        return searchRules;
    }
}

