/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.jpa.importer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.CrudRepository;
import org.molgenis.data.DataService;
import org.molgenis.data.DatabaseAction;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.validation.ConstraintViolation;
import org.molgenis.data.validation.MolgenisValidationException;
import org.molgenis.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class EntityImportService {
    private static final long MAX_CACHE_ITEMS = 100000L;
    private static int BATCH_SIZE = 1000;
    private DataService dataService;
    private LoadingCache<CacheKey, Iterable<Entity>> refLoadingCache = CacheBuilder.newBuilder().maximumSize(100000L).softValues().build((CacheLoader)new CacheLoader<CacheKey, Iterable<Entity>>(){

        public Iterable<Entity> load(CacheKey key) throws Exception {
            Iterable result = EntityImportService.this.dataService.findAll(key.getEnityName(), new QueryImpl().in(key.getAttrName(), key.getKeyValues()));
            return result;
        }
    });

    @Autowired
    public void setDataService(DataService dataService) {
        this.dataService = dataService;
    }

    @Transactional
    public int importEntity(String entityName, Repository source, DatabaseAction dbAction) {
        boolean resolved;
        Repository repo = this.dataService.getRepositoryByEntityName(entityName);
        if (!(repo instanceof CrudRepository)) {
            throw new MolgenisDataException(repo.getName() + " is not a CrudRepository");
        }
        CrudRepository jpaRepository = (CrudRepository)repo;
        ArrayList entitiesToImport = Lists.newArrayList();
        for (Entity entity : source) {
            entitiesToImport.add(new MapEntity(entity));
        }
        EntityMetaData entityMetaData = repo.getEntityMetaData();
        String updateKey = entityMetaData.getLabelAttribute().getName();
        ArrayList batch = Lists.newArrayListWithCapacity((int)BATCH_SIZE);
        ArrayList unresolved = Lists.newArrayList();
        HashSet labelAttributeValues = Sets.newHashSetWithExpectedSize((int)BATCH_SIZE);
        long rownr = 0L;
        for (Entity entityToImport : entitiesToImport) {
            ++rownr;
            if (EntityUtils.isEmpty((Entity)entityToImport)) break;
            Object key = entityToImport.get(updateKey);
            if (key == null) {
                ConstraintViolation violation = new ConstraintViolation("Missing key", null, entityToImport, entityMetaData.getLabelAttribute(), entityMetaData, rownr);
                throw new MolgenisValidationException((Set)Sets.newHashSet((Object[])new ConstraintViolation[]{violation}));
            }
            if (labelAttributeValues.contains(key)) {
                ConstraintViolation violation = new ConstraintViolation("Duplicate key '" + key + "'", key, entityToImport, entityMetaData.getLabelAttribute(), entityMetaData, rownr);
                throw new MolgenisValidationException((Set)Sets.newHashSet((Object[])new ConstraintViolation[]{violation}));
            }
            labelAttributeValues.add(key);
            resolved = true;
            for (AttributeMetaData attr : entityMetaData.getAttributes()) {
                if (attr.getDataType().getEnumType() != MolgenisFieldTypes.FieldTypeEnum.MREF && attr.getDataType().getEnumType() != MolgenisFieldTypes.FieldTypeEnum.XREF && attr.getDataType().getEnumType() != MolgenisFieldTypes.FieldTypeEnum.CATEGORICAL) continue;
                boolean attrResolved = this.resolveEntityRef(entityName, entityToImport, attr);
                boolean bl = resolved = resolved && attrResolved;
                if (attrResolved || attr.getRefEntity().getName().equalsIgnoreCase(entityName)) continue;
                throw new MolgenisValidationException((Set)Sets.newHashSet((Object[])new ConstraintViolation[]{this.createViolation(attr, entityMetaData, entityToImport, rownr)}));
            }
            if (resolved) {
                batch.add(entityToImport);
            } else {
                unresolved.add(entityToImport);
            }
            if (batch.size() != BATCH_SIZE) continue;
            this.update(jpaRepository, batch, dbAction, updateKey);
            jpaRepository.flush();
            batch.clear();
        }
        if (!batch.isEmpty()) {
            this.update(jpaRepository, batch, dbAction, updateKey);
            jpaRepository.flush();
            batch.clear();
        }
        if (!unresolved.isEmpty()) {
            int iterations = 0;
            while (!unresolved.isEmpty() && ++iterations < 100) {
                ListIterator it = unresolved.listIterator();
                while (it.hasNext()) {
                    Entity entityToImport = (Entity)it.next();
                    resolved = true;
                    for (AttributeMetaData attr : entityMetaData.getAttributes()) {
                        if (attr.getDataType().getEnumType() != MolgenisFieldTypes.FieldTypeEnum.MREF && attr.getDataType().getEnumType() != MolgenisFieldTypes.FieldTypeEnum.XREF && attr.getDataType().getEnumType() != MolgenisFieldTypes.FieldTypeEnum.CATEGORICAL || !attr.getRefEntity().getName().equalsIgnoreCase(entityName)) continue;
                        resolved = resolved && this.resolveEntityRef(entityName, entityToImport, attr);
                    }
                    if (!resolved) continue;
                    it.remove();
                    batch.add(entityToImport);
                    this.update(jpaRepository, batch, dbAction, updateKey);
                    jpaRepository.flush();
                    batch.clear();
                }
            }
        }
        if (!unresolved.isEmpty()) {
            LinkedHashSet violations = Sets.newLinkedHashSetWithExpectedSize((int)unresolved.size());
            for (Entity entity : unresolved) {
                for (AttributeMetaData attr : entityMetaData.getAttributes()) {
                    if (attr.getDataType().getEnumType() != MolgenisFieldTypes.FieldTypeEnum.MREF && attr.getDataType().getEnumType() != MolgenisFieldTypes.FieldTypeEnum.XREF && attr.getDataType().getEnumType() != MolgenisFieldTypes.FieldTypeEnum.CATEGORICAL || !attr.getRefEntity().getName().equalsIgnoreCase(entityName) || this.resolveEntityRef(entityName, entity, attr)) continue;
                    long rowNr = this.getRowNr(entity, entitiesToImport, entityMetaData.getLabelAttribute().getName());
                    violations.add(this.createViolation(attr, entityMetaData, entity, rowNr));
                }
            }
            throw new MolgenisValidationException((Set)violations);
        }
        if (!batch.isEmpty()) {
            this.update(jpaRepository, batch, dbAction, updateKey);
            jpaRepository.flush();
        }
        return entitiesToImport.size();
    }

    public void update(CrudRepository repo, List<? extends Entity> entities, DatabaseAction dbAction, String ... keyNames) {
        if (keyNames.length == 0) {
            throw new MolgenisDataException("At least one key must be provided, e.g. 'name'");
        }
        if (entities.size() == 0) {
            return;
        }
        String entityName = repo.getEntityMetaData().getEntityClass().getSimpleName();
        LinkedHashMap<String, Entity> entityIndex = new LinkedHashMap<String, Entity>();
        ArrayList keyIndex = new ArrayList();
        boolean keysMissing = false;
        for (Entity entity : entities) {
            StringBuilder combinedKeyBuilder = new StringBuilder();
            LinkedHashMap<String, Object> keyValues = new LinkedHashMap<String, Object>();
            boolean bl = true;
            for (String key : keyNames) {
                combinedKeyBuilder.append(';');
                if (entity.get(key) == null) continue;
                combinedKeyBuilder.append(entity.get(key));
                bl = false;
                keyValues.put(key, entity.get(key));
            }
            if (bl) {
                keysMissing = true;
            }
            if (!keysMissing) {
                keyIndex.add(keyValues);
                entityIndex.put(combinedKeyBuilder.toString(), entity);
                continue;
            }
            if ((dbAction.equals((Object)DatabaseAction.ADD) || dbAction.equals((Object)DatabaseAction.ADD_UPDATE_EXISTING)) && keyNames.length == 1 && keyNames[0].equals(repo.getEntityMetaData().getIdAttribute().getName())) continue;
            throw new MolgenisDataException("keys are missing: " + repo.getEntityMetaData().getEntityClass().getSimpleName() + "." + Arrays.asList(keyNames));
        }
        List<? extends Entity> newEntities = entities;
        ArrayList<MapEntity> arrayList = new ArrayList<MapEntity>();
        if (!keysMissing && keyIndex.size() > 0) {
            newEntities = new ArrayList<Entity>();
            QueryImpl q = new QueryImpl();
            if (keyNames.length == 1) {
                ArrayList values = new ArrayList();
                for (Map map : keyIndex) {
                    values.add(map.get(keyNames[0]));
                }
                q.in(keyNames[0], (Iterable)values);
            } else {
                for (Map map : keyIndex) {
                    for (int i = 0; i < keyNames.length; ++i) {
                        if (i > 0) {
                            q.or();
                        }
                        q.eq(keyNames[i], map.get(keyNames[i]));
                    }
                }
            }
            Iterable selectForUpdate = repo.findAll((Query)q);
            for (Entity entity : selectForUpdate) {
                StringBuilder combinedKeyBuilder = new StringBuilder();
                for (String key : keyNames) {
                    combinedKeyBuilder.append(';').append(entity.get(key));
                }
                entityIndex.remove(combinedKeyBuilder.toString());
                MapEntity e = new MapEntity(repo.getEntityMetaData().getIdAttribute().getName());
                e.set(entity);
                arrayList.add(e);
            }
            newEntities = new ArrayList(entityIndex.values());
        }
        if (arrayList.size() > 0 && (dbAction == DatabaseAction.ADD_UPDATE_EXISTING || dbAction == DatabaseAction.UPDATE)) {
            this.matchByNameAndUpdateFields(repo.getEntityMetaData(), arrayList, entities);
        }
        switch (dbAction) {
            case ADD: {
                if (arrayList.size() == 0) {
                    repo.add(newEntities);
                    break;
                }
                throw new MolgenisDataException("Tried to add existing " + entityName + " elements as new insert: " + Arrays.asList(keyNames) + "=" + arrayList.subList(0, Math.min(5, arrayList.size())) + (arrayList.size() > 5 ? " and " + (arrayList.size() - 5) + "more" : "" + arrayList));
            }
            case ADD_UPDATE_EXISTING: {
                repo.add(newEntities);
                repo.update(arrayList);
                break;
            }
            case UPDATE: {
                if (newEntities.size() == 0) {
                    repo.update(arrayList);
                    break;
                }
                throw new MolgenisDataException("Tried to update non-existing " + entityName + "elements " + Arrays.asList(keyNames) + "=" + entityIndex.values());
            }
            default: {
                throw new MolgenisDataException("updateByName failed because of unknown dbAction " + dbAction);
            }
        }
    }

    private void matchByNameAndUpdateFields(EntityMetaData emd, List<? extends Entity> existingEntities, List<? extends Entity> entities) {
        if (emd.getLabelAttribute() != null) {
            for (Entity entity : existingEntities) {
                for (Entity entity2 : entities) {
                    Object x2;
                    Object x1 = entity.get(emd.getLabelAttribute().getName());
                    if (!x1.equals(x2 = entity2.get(emd.getLabelAttribute().getName()))) continue;
                    try {
                        MapEntity mapEntity = new MapEntity();
                        for (String field : entity.getAttributeNames()) {
                            mapEntity.set(field, entity2.get(field));
                        }
                        entity.set((Entity)mapEntity, false);
                    }
                    catch (Exception ex) {
                        throw new MolgenisDataException((Throwable)ex);
                    }
                }
            }
        }
    }

    private long getRowNr(Entity entityToFind, Iterable<Entity> entities, String keyAttr) {
        Object key = entityToFind.get(keyAttr);
        if (key == null) {
            return 0L;
        }
        long rownr = 0L;
        for (Entity entity : entities) {
            ++rownr;
            if (!key.equals(entity.get(keyAttr))) continue;
            return rownr;
        }
        return 0L;
    }

    private boolean resolveEntityRef(String entityName, Entity entityToBeImported, AttributeMetaData attr) {
        final ArrayList keyValues = Lists.newArrayList();
        final String foreignAttr = attr.getRefEntity().getLabelAttribute().getName();
        String key = attr.getName() + "_" + foreignAttr;
        if (attr.getDataType().getEnumType() == MolgenisFieldTypes.FieldTypeEnum.MREF) {
            List keys = entityToBeImported.getList(key);
            if (keys != null) {
                keyValues.addAll(keys);
            }
        } else {
            Object keyValue = entityToBeImported.get(key);
            if (keyValue != null) {
                keyValues.add(keyValue);
            }
        }
        if (keyValues.isEmpty()) {
            return true;
        }
        CacheKey cacheKey = new CacheKey(attr.getRefEntity().getName(), foreignAttr, keyValues);
        ArrayList foundRefEntityList = null;
        try {
            foundRefEntityList = Lists.newArrayList((Iterable)((Iterable)this.refLoadingCache.get((Object)cacheKey)));
            if (foundRefEntityList.isEmpty()) {
                this.refLoadingCache.invalidate((Object)cacheKey);
            }
            Collections.sort(foundRefEntityList, new Comparator<Entity>(){

                @Override
                public int compare(Entity o1, Entity o2) {
                    Object value1 = o1.get(foreignAttr);
                    Object value2 = o2.get(foreignAttr);
                    Integer index1 = keyValues.indexOf(value1);
                    Integer index2 = keyValues.indexOf(value2);
                    return index1.compareTo(index2);
                }
            });
        }
        catch (ExecutionException e) {
            throw new MolgenisDataException((Throwable)e);
        }
        if (!foundRefEntityList.isEmpty()) {
            if (attr.getDataType().getEnumType() == MolgenisFieldTypes.FieldTypeEnum.MREF) {
                List entityRefs = (List)entityToBeImported.get(attr.getName());
                if (entityRefs == null) {
                    entityRefs = Lists.newArrayList();
                    entityToBeImported.set(attr.getName(), (Object)entityRefs);
                }
                entityRefs.addAll(foundRefEntityList);
                for (Entity entityRef : entityRefs) {
                    keyValues.remove(entityRef.getString(foreignAttr));
                }
                entityToBeImported.set(key, (Object)keyValues);
            } else {
                entityToBeImported.set(attr.getName(), foundRefEntityList.get(0));
                keyValues.remove(0);
                entityToBeImported.set(key, null);
            }
        }
        return keyValues.isEmpty();
    }

    private ConstraintViolation createViolation(AttributeMetaData attr, EntityMetaData entityMetaData, Entity entity, long rownr) {
        String foreignAttr = attr.getRefEntity().getLabelAttribute().getName();
        String key = attr.getName() + "_" + foreignAttr;
        Object value = entity.get(key);
        String message = String.format("Could not resolve attribute '%s' with value '%s' of entity '%s'. This is a reference to entity '%s'.This happens when the key is missing in the referencing entity or when there are duplicate keys.", attr.getName(), value, entityMetaData.getName(), attr.getRefEntity().getName());
        return new ConstraintViolation(message, value, entity, attr, entityMetaData, rownr);
    }

    private class CacheKey {
        private final String enityName;
        private final String attrName;
        private final List<Object> keyValues;

        public CacheKey(String enityName, String attrName, List<Object> keyValues) {
            this.enityName = enityName;
            this.attrName = attrName;
            this.keyValues = keyValues;
        }

        public String getEnityName() {
            return this.enityName;
        }

        public String getAttrName() {
            return this.attrName;
        }

        public List<Object> getKeyValues() {
            return this.keyValues;
        }

        public int hashCode() {
            int prime = 31;
            int hashCode = 1;
            hashCode = 31 * hashCode + this.getOuterType().hashCode();
            hashCode = 31 * hashCode + (this.attrName == null ? 0 : this.attrName.hashCode());
            hashCode = 31 * hashCode + (this.enityName == null ? 0 : this.enityName.hashCode());
            hashCode = 31 * hashCode + (this.keyValues == null ? 0 : this.keyValues.hashCode());
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.attrName == null ? other.attrName != null : !this.attrName.equals(other.attrName)) {
                return false;
            }
            if (this.enityName == null ? other.enityName != null : !this.enityName.equals(other.enityName)) {
                return false;
            }
            return !(this.keyValues == null ? other.keyValues != null : !this.keyValues.equals(other.keyValues));
        }

        private EntityImportService getOuterType() {
            return EntityImportService.this;
        }
    }
}

