/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.jpa.importer;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.molgenis.data.DatabaseAction;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.importer.ImportService;
import org.molgenis.data.jpa.importer.EntitiesImporter;
import org.molgenis.framework.db.EntitiesValidationReport;
import org.molgenis.framework.db.EntitiesValidator;
import org.molgenis.framework.db.EntityImportReport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class JpaImportService
implements ImportService {
    private static final List<String> SUPPORTED_FILE_EXTENSIONS = Arrays.asList("xls", "xlsx", "csv", "zip");
    private final EntitiesValidator entitiesValidator;
    private final EntitiesImporter entitiesImporter;
    private final RepositoryCollection targetCollection;

    @Autowired
    public JpaImportService(EntitiesValidator entitiesValidator, EntitiesImporter entitiesImporter, @Qualifier(value="JpaRepositoryCollection") RepositoryCollection repositoryCollection) {
        this.entitiesValidator = entitiesValidator;
        this.entitiesImporter = entitiesImporter;
        this.targetCollection = repositoryCollection;
    }

    public EntitiesValidationReport validateImport(File file, RepositoryCollection source) {
        try {
            return this.entitiesValidator.validate(file);
        }
        catch (IOException e) {
            throw new MolgenisDataException((Throwable)e);
        }
    }

    public EntityImportReport doImport(RepositoryCollection source, DatabaseAction databaseAction) {
        try {
            return this.entitiesImporter.importEntities(source, databaseAction);
        }
        catch (IOException e) {
            throw new MolgenisDataException((Throwable)e);
        }
    }

    public boolean canImport(File file, RepositoryCollection source) {
        String fileNameExtension = StringUtils.getFilenameExtension((String)file.getName());
        if (SUPPORTED_FILE_EXTENSIONS.contains(fileNameExtension.toLowerCase())) {
            for (String entityName : source.getEntityNames()) {
                if (this.targetCollection.getRepositoryByEntityName(entityName) == null) continue;
                return true;
            }
        }
        return false;
    }

    public List<DatabaseAction> getSupportedDatabaseActions() {
        return Lists.newArrayList((Object[])DatabaseAction.values());
    }

    public boolean getMustChangeEntityName() {
        return false;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

