/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.jpa.standalone;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.metamodel.EntityType;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryDecoratorFactory;
import org.molgenis.data.jpa.JpaRepository;
import org.molgenis.data.support.DataServiceImpl;
import org.molgenis.data.support.NonDecoratingRepositoryDecoratorFactory;
import org.molgenis.data.support.QueryResolver;
import org.molgenis.data.validation.DefaultEntityValidator;
import org.molgenis.data.validation.EntityAttributesValidator;
import org.molgenis.data.validation.EntityValidator;
import org.springframework.beans.BeanUtils;

public class JpaStandaloneDataService
extends DataServiceImpl {
    private final EntityManager entityManager;

    public JpaStandaloneDataService(String dbUrl, String dbUsername, String dbPassword) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        super((RepositoryDecoratorFactory)new NonDecoratingRepositoryDecoratorFactory());
        HashMap props = Maps.newHashMap();
        props.put("javax.persistence.jdbc.driver", "com.mysql.jdbc.Driver");
        props.put("javax.persistence.jdbc.url", dbUrl);
        props.put("javax.persistence.jdbc.user", dbUsername);
        props.put("javax.persistence.jdbc.password", dbPassword);
        this.entityManager = Persistence.createEntityManagerFactory((String)"molgenis", (Map)props).createEntityManager();
        for (EntityType entityType : this.entityManager.getMetamodel().getEntities()) {
            this.addRepository((Repository)this.createJpaRepository(entityType));
        }
    }

    private JpaRepository createJpaRepository(EntityType<?> entityType) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        String repoClassName = entityType.getJavaType().getName() + "Repository";
        Class<?> repoClass = Class.forName(repoClassName);
        Constructor<?> constructor = repoClass.getConstructor(EntityManager.class, EntityValidator.class, QueryResolver.class);
        return (JpaRepository)((Object)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{this.entityManager, new DefaultEntityValidator((DataService)this, new EntityAttributesValidator()), new QueryResolver((DataService)this)}));
    }

    public void add(final String entityName, final Entity entity) {
        this.doInTransaction(new TransactionCallback<Object>(){

            @Override
            public Object execute() {
                JpaStandaloneDataService.super.add(entityName, entity);
                return null;
            }
        });
    }

    public void add(final String entityName, final Iterable<? extends Entity> entities) {
        this.doInTransaction(new TransactionCallback<Object>(){

            @Override
            public Object execute() {
                JpaStandaloneDataService.super.add(entityName, entities);
                return null;
            }
        });
    }

    public void update(final String entityName, final Entity entity) {
        this.doInTransaction(new TransactionCallback<Object>(){

            @Override
            public Object execute() {
                JpaStandaloneDataService.super.update(entityName, entity);
                return null;
            }
        });
    }

    public void update(final String entityName, final Iterable<? extends Entity> entities) {
        this.doInTransaction(new TransactionCallback<Object>(){

            @Override
            public Object execute() {
                JpaStandaloneDataService.super.update(entityName, entities);
                return null;
            }
        });
    }

    public void delete(final String entityName, final Entity entity) {
        this.doInTransaction(new TransactionCallback<Object>(){

            @Override
            public Object execute() {
                JpaStandaloneDataService.super.delete(entityName, entity);
                return null;
            }
        });
    }

    public void delete(final String entityName, final Iterable<? extends Entity> entities) {
        this.doInTransaction(new TransactionCallback<Object>(){

            @Override
            public Object execute() {
                JpaStandaloneDataService.super.delete(entityName, entities);
                return null;
            }
        });
    }

    public void delete(final String entityName, final Object id) {
        this.doInTransaction(new TransactionCallback<Object>(){

            @Override
            public Object execute() {
                JpaStandaloneDataService.super.delete(entityName, id);
                return null;
            }
        });
    }

    private <T> T doInTransaction(TransactionCallback<T> callback) {
        try {
            this.entityManager.getTransaction().begin();
            T result = callback.execute();
            this.entityManager.getTransaction().commit();
            return result;
        }
        catch (RuntimeException e) {
            this.entityManager.getTransaction().rollback();
            throw e;
        }
    }

    private static interface TransactionCallback<T> {
        public T execute();
    }
}

