/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.semanticsearch.config;

import org.molgenis.data.DataService;
import org.molgenis.data.IdGenerator;
import org.molgenis.data.Repository;
import org.molgenis.data.elasticsearch.factory.EmbeddedElasticSearchServiceFactory;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.data.semantic.LabeledResource;
import org.molgenis.data.semanticsearch.explain.service.ElasticSearchExplainService;
import org.molgenis.data.semanticsearch.explain.service.ElasticSearchExplainServiceImpl;
import org.molgenis.data.semanticsearch.explain.service.ExplainServiceHelper;
import org.molgenis.data.semanticsearch.repository.TagRepository;
import org.molgenis.data.semanticsearch.service.OntologyTagService;
import org.molgenis.data.semanticsearch.service.SemanticSearchService;
import org.molgenis.data.semanticsearch.service.TagService;
import org.molgenis.data.semanticsearch.service.impl.OntologyTagServiceImpl;
import org.molgenis.data.semanticsearch.service.impl.SemanticSearchServiceHelper;
import org.molgenis.data.semanticsearch.service.impl.SemanticSearchServiceImpl;
import org.molgenis.data.semanticsearch.service.impl.UntypedTagService;
import org.molgenis.ontology.core.service.OntologyService;
import org.molgenis.ontology.ic.TermFrequencyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SemanticSearchConfig {
    @Autowired
    DataService dataService;
    @Autowired
    MetaDataService metaDataService;
    @Autowired
    OntologyService ontologyService;
    @Autowired
    IdGenerator idGenerator;
    @Autowired
    TermFrequencyService termFrequencyService;
    @Autowired
    EmbeddedElasticSearchServiceFactory embeddedElasticSearchServiceFactory;

    @Bean
    public SemanticSearchServiceHelper semanticSearchServiceHelper() {
        return new SemanticSearchServiceHelper(this.dataService, this.ontologyService, this.termFrequencyService);
    }

    @Bean
    public OntologyTagService ontologyTagService() {
        return new OntologyTagServiceImpl(this.dataService, this.ontologyService, this.tagRepository(), this.idGenerator);
    }

    @Bean
    public SemanticSearchService semanticSearchService() {
        return new SemanticSearchServiceImpl(this.dataService, this.ontologyService, this.metaDataService, this.semanticSearchServiceHelper(), this.elasticSearchExplainService());
    }

    @Bean
    public TagService<LabeledResource, LabeledResource> tagService() {
        return new UntypedTagService(this.dataService, this.tagRepository());
    }

    @Bean
    public ExplainServiceHelper explainServiceHelper() {
        return new ExplainServiceHelper();
    }

    @Bean
    TagRepository tagRepository() {
        Repository repo = this.dataService.getRepository("tags");
        return new TagRepository(repo, this.idGenerator);
    }

    @Bean
    ElasticSearchExplainService elasticSearchExplainService() {
        return new ElasticSearchExplainServiceImpl(this.embeddedElasticSearchServiceFactory.getClient(), this.explainServiceHelper());
    }
}

