/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.semanticsearch.explain.bean;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.semanticsearch.explain.bean.AutoValue_ExplainedAttributeMetaData;
import org.molgenis.data.semanticsearch.explain.bean.ExplainedQueryString;
import org.molgenis.gson.AutoGson;

@AutoGson(autoValueClass=AutoValue_ExplainedAttributeMetaData.class)
public abstract class ExplainedAttributeMetaData {
    public static ExplainedAttributeMetaData create(AttributeMetaData attributeMetaData) {
        return new AutoValue_ExplainedAttributeMetaData(ExplainedAttributeMetaData.attributeToMap(attributeMetaData), Collections.emptySet(), false);
    }

    public static ExplainedAttributeMetaData create(AttributeMetaData attributeMetaData, Iterable<ExplainedQueryString> explainedQueryStrings, boolean highQuality) {
        return new AutoValue_ExplainedAttributeMetaData(ExplainedAttributeMetaData.attributeToMap(attributeMetaData), Sets.newHashSet(explainedQueryStrings), highQuality);
    }

    public abstract Map<String, Object> getAttributeMetaData();

    public abstract Set<ExplainedQueryString> getExplainedQueryStrings();

    public abstract boolean isHighQuality();

    private static Map<String, Object> attributeToMap(AttributeMetaData attributeMetaData) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", attributeMetaData.getName());
        map.put("label", attributeMetaData.getLabel());
        map.put("description", attributeMetaData.getDescription());
        map.put("dataType", attributeMetaData.getDataType().toString());
        map.put("nillable", attributeMetaData.isNillable());
        map.put("unique", attributeMetaData.isUnique());
        if (attributeMetaData.getRefEntity() != null) {
            map.put("refEntity", attributeMetaData.getRefEntity().getName());
        }
        return map;
    }
}

