/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.semanticsearch.explain.service;

import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.action.explain.ExplainRequestBuilder;
import org.elasticsearch.action.explain.ExplainResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Query;
import org.molgenis.data.elasticsearch.request.QueryGenerator;
import org.molgenis.data.elasticsearch.util.MapperTypeSanitizer;
import org.molgenis.data.semanticsearch.explain.bean.ExplainedQueryString;
import org.molgenis.data.semanticsearch.explain.service.ElasticSearchExplainService;
import org.molgenis.data.semanticsearch.explain.service.ExplainServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ElasticSearchExplainServiceImpl
implements ElasticSearchExplainService {
    private static final String DEFAULT_INDEX_NAME = "molgenis";
    private final ExplainServiceHelper explainServiceHelper;
    private final Client client;
    private final QueryGenerator queryGenerator = new QueryGenerator();
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchExplainServiceImpl.class);

    @Autowired
    public ElasticSearchExplainServiceImpl(Client client, ExplainServiceHelper explainServiceHelper) {
        this.explainServiceHelper = explainServiceHelper;
        this.client = client;
    }

    @Override
    public Explanation explain(Query q, EntityMetaData entityMetaData, String documentId) {
        String type = MapperTypeSanitizer.sanitizeMapperType((String)entityMetaData.getName());
        ExplainRequestBuilder explainRequestBuilder = new ExplainRequestBuilder(this.client, DEFAULT_INDEX_NAME, type, documentId);
        QueryBuilder queryBuilder = this.queryGenerator.createQueryBuilder(q.getRules(), entityMetaData);
        explainRequestBuilder.setQuery(queryBuilder);
        ExplainResponse explainResponse = (ExplainResponse)explainRequestBuilder.get();
        if (explainResponse.hasExplanation()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(explainResponse.getExplanation().toString());
            }
            return explainResponse.getExplanation();
        }
        return null;
    }

    @Override
    public Set<ExplainedQueryString> findQueriesFromExplanation(Map<String, String> originalQueryInMap, Explanation explanation) {
        LinkedHashSet<ExplainedQueryString> matchedQueryStrings = new LinkedHashSet<ExplainedQueryString>();
        Set<String> matchedQueryTerms = this.explainServiceHelper.findMatchedWords(explanation);
        for (String matchedQueryTerm : matchedQueryTerms) {
            Map<String, Double> matchedQueryRule = this.explainServiceHelper.findMatchQueries(matchedQueryTerm, originalQueryInMap);
            if (matchedQueryRule.size() <= 0) continue;
            Map.Entry<String, Double> entry = matchedQueryRule.entrySet().stream().max(new Comparator<Map.Entry<String, Double>>(){

                @Override
                public int compare(Map.Entry<String, Double> o1, Map.Entry<String, Double> o2) {
                    return Double.compare(o1.getValue(), o2.getValue());
                }
            }).get();
            matchedQueryStrings.add(ExplainedQueryString.create(matchedQueryTerm, entry.getKey(), originalQueryInMap.get(entry.getKey()), entry.getValue()));
        }
        return matchedQueryStrings;
    }
}

