/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.semanticsearch.explain.service;

import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.common.collect.Lists;
import org.molgenis.data.MolgenisDataAccessException;
import org.molgenis.data.semanticsearch.string.NGramDistanceAlgorithm;

public class ExplainServiceHelper {
    public static final Pattern REGEXR_PATTERN = Pattern.compile("^weight\\(\\w*:(\\w*)(.*|)\\s.*");
    private final Splitter termSplitter = Splitter.onPattern((String)"[^\\p{IsAlphabetic}]+");

    public Set<String> findMatchedWords(Explanation explanation) {
        HashSet<String> words = new HashSet<String>();
        String description = explanation.getDescription();
        if (description.startsWith(Options.SUM_OF.toString()) || description.startsWith(Options.PRODUCT_OF.toString())) {
            if (Lists.newArrayList((Object[])explanation.getDetails()).stream().allMatch(this::reachLastLevel)) {
                words.add(this.extractMatchedWords(explanation.getDetails()));
            } else {
                for (Explanation subExplanation : explanation.getDetails()) {
                    words.addAll(this.findMatchedWords(subExplanation));
                }
            }
        } else if (description.startsWith(Options.MAX_OF.toString())) {
            Explanation maxExplanation = Lists.newArrayList((Object[])explanation.getDetails()).stream().max(new Comparator<Explanation>(){

                @Override
                public int compare(Explanation explanation1, Explanation explanation2) {
                    return Float.compare(explanation1.getValue(), explanation2.getValue());
                }
            }).get();
            words.addAll(this.findMatchedWords(maxExplanation));
        } else if (description.startsWith(Options.WEIGHT.toString())) {
            words.add(this.getMatchedWord(description));
        }
        return words;
    }

    public String extractMatchedWords(Explanation[] explanations) {
        List collect = Lists.newArrayList((Object[])explanations).stream().map(explanation -> this.getMatchedWord(explanation.getDescription())).collect(Collectors.toList());
        return StringUtils.join(collect, (char)' ');
    }

    public boolean reachLastLevel(Explanation explanation) {
        return explanation.getDescription().startsWith(Options.WEIGHT.toString());
    }

    public Map<String, Double> findMatchQueries(String matchedWordsString, Map<String, String> collectExpandedQueryMap) {
        HashMap<String, Double> qualifiedQueries = new HashMap<String, Double>();
        Set<String> matchedWords = this.splitIntoTerms(matchedWordsString);
        for (Map.Entry<String, String> entry : collectExpandedQueryMap.entrySet()) {
            Set<String> wordsInQuery = this.splitIntoTerms(entry.getKey());
            if (!wordsInQuery.containsAll(matchedWords)) continue;
            qualifiedQueries.put(entry.getKey(), NGramDistanceAlgorithm.stringMatching(matchedWordsString, entry.getKey()));
        }
        return qualifiedQueries;
    }

    public String removeBoostFromQuery(String description) {
        return description.replaceAll("\\^\\d*\\.{0,1}\\d+", "");
    }

    public String getMatchedWord(String description) {
        Matcher matcher = REGEXR_PATTERN.matcher(description);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new MolgenisDataAccessException("Failed to find matched word in : " + description);
    }

    Set<String> splitIntoTerms(String description) {
        return FluentIterable.from((Iterable)this.termSplitter.split((CharSequence)description)).transform(String::toLowerCase).filter(w -> !StringUtils.isEmpty((CharSequence)w)).toSet();
    }

    public static enum Options {
        PRODUCT_OF("product of:"),
        MAX_OF("max of:"),
        SUM_OF("sum of:"),
        WEIGHT("weight");

        private String label;

        private Options(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

