/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.semanticsearch.repository;

import org.molgenis.data.Entity;
import org.molgenis.data.IdGenerator;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.meta.TagMetaData;
import org.molgenis.data.semantic.Relation;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.QueryImpl;

public class TagRepository {
    public static final TagMetaData META_DATA = TagMetaData.INSTANCE;
    private final IdGenerator idGenerator;
    private final Repository repository;

    public TagRepository(Repository repository, IdGenerator idGenerator) {
        this.repository = repository;
        this.idGenerator = idGenerator;
    }

    public Entity getTagEntity(String objectIRI, String label, Relation relation, String codeSystemIRI) {
        Query q = new QueryImpl().eq("objectIRI", (Object)objectIRI).and().eq("relationIRI", (Object)relation.getIRI()).and().eq("codeSystem", (Object)codeSystemIRI);
        Entity result = this.repository.findOne(q);
        if (result == null) {
            MapEntity mapEntity = new MapEntity("tags");
            mapEntity.set("identifier", (Object)this.idGenerator.generateId());
            mapEntity.set("objectIRI", (Object)objectIRI);
            mapEntity.set("label", (Object)label);
            mapEntity.set("relationIRI", (Object)relation.getIRI());
            mapEntity.set("relationLabel", (Object)relation.getLabel());
            mapEntity.set("codeSystem", (Object)codeSystemIRI);
            this.repository.add((Entity)mapEntity);
            result = mapEntity;
        }
        return result;
    }
}

