/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.semanticsearch.service.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.IdGenerator;
import org.molgenis.data.Package;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.semantic.LabeledResource;
import org.molgenis.data.semantic.Relation;
import org.molgenis.data.semantic.Tag;
import org.molgenis.data.semantic.TagImpl;
import org.molgenis.data.semanticsearch.repository.TagRepository;
import org.molgenis.data.semanticsearch.semantic.OntologyTag;
import org.molgenis.data.semanticsearch.service.OntologyTagService;
import org.molgenis.data.support.DefaultEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.ontology.core.model.Ontology;
import org.molgenis.ontology.core.model.OntologyTerm;
import org.molgenis.ontology.core.service.OntologyService;
import org.molgenis.security.core.runas.RunAsSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyTagServiceImpl
implements OntologyTagService {
    private final DataService dataService;
    private final TagRepository tagRepository;
    private final OntologyService ontologyService;
    private final IdGenerator idGenerator;
    private static final Logger LOG = LoggerFactory.getLogger(OntologyTagServiceImpl.class);

    public OntologyTagServiceImpl(DataService dataService, OntologyService ontologyService, TagRepository tagRepository, IdGenerator idGenerator) {
        this.dataService = dataService;
        this.tagRepository = tagRepository;
        this.ontologyService = ontologyService;
        this.idGenerator = idGenerator;
    }

    @Override
    public void removeAttributeTag(String entity, String attribute, String relationIRI, String ontologyTermIRI) {
        Entity attributeEntity = this.findAttributeEntity(entity, attribute);
        Iterable tags = attributeEntity.getEntities("tags");
        Iterable newTags = Iterables.filter((Iterable)tags, e -> !this.isSameTag(relationIRI, ontologyTermIRI, (Entity)e));
        attributeEntity.set("tags", (Object)newTags);
        this.dataService.update("attributes", attributeEntity);
        this.updateEntityMetaDataEntityWithNewAttributeEntity(entity, attribute, attributeEntity);
    }

    @Override
    public void removeAttributeTag(EntityMetaData entityMetaData, Tag<AttributeMetaData, OntologyTerm, Ontology> removeTag) {
        AttributeMetaData attributeMetaData = (AttributeMetaData)removeTag.getSubject();
        Entity attributeEntity = this.findAttributeEntity(entityMetaData.getName(), attributeMetaData.getName());
        ArrayList<Entity> tags = new ArrayList<Entity>();
        for (Entity tagEntity : attributeEntity.getEntities("tags")) {
            TagImpl<AttributeMetaData, OntologyTerm, Ontology> tag = this.asTag(attributeMetaData, tagEntity);
            if (removeTag.equals(tag)) continue;
            tags.add(tagEntity);
        }
        attributeEntity.set("tags", tags);
        this.dataService.update("attributes", attributeEntity);
    }

    @Override
    @RunAsSystem
    public Multimap<Relation, OntologyTerm> getTagsForAttribute(EntityMetaData entityMetaData, AttributeMetaData attributeMetaData) {
        LinkedHashMultimap tags = LinkedHashMultimap.create();
        Entity entity = this.findAttributeEntity(entityMetaData.getName(), attributeMetaData.getName());
        if (entity == null) {
            LOG.warn("Cannot find attribute {}.{}", (Object)entityMetaData.getName(), (Object)attributeMetaData.getName());
            return tags;
        }
        for (Entity tagEntity : entity.getEntities("tags")) {
            TagImpl<AttributeMetaData, OntologyTerm, Ontology> tag = this.asTag(attributeMetaData, tagEntity);
            tags.put((Object)tag.getRelation(), tag.getObject());
        }
        return tags;
    }

    @Override
    public Iterable<Tag<Package, OntologyTerm, Ontology>> getTagsForPackage(Package p) {
        Entity packageEntity = this.dataService.findOne("packages", new QueryImpl().eq("fullName", (Object)p.getName()));
        if (packageEntity == null) {
            throw new UnknownEntityException("Unknown package [" + p.getName() + "]");
        }
        ArrayList tags = Lists.newArrayList();
        for (Entity tagEntity : packageEntity.getEntities("tags")) {
            tags.add(this.asTag(p, tagEntity));
        }
        return tags;
    }

    @Override
    public void addAttributeTag(EntityMetaData entityMetaData, Tag<AttributeMetaData, OntologyTerm, Ontology> tag) {
        Entity entity = this.findAttributeEntity(entityMetaData.getName(), ((AttributeMetaData)tag.getSubject()).getName());
        ArrayList<Entity> tags = new ArrayList<Entity>();
        for (Entity tagEntity : entity.getEntities("tags")) {
            tags.add(tagEntity);
        }
        tags.add(this.getTagEntity(tag));
        entity.set("tags", tags);
        this.dataService.update("attributes", entity);
    }

    @Override
    public OntologyTag addAttributeTag(String entity, String attribute, String relationIRI, List<String> ontologyTermIRIs) {
        boolean added = false;
        Entity attributeEntity = this.findAttributeEntity(entity, attribute);
        DefaultEntity tagEntity = new DefaultEntity((EntityMetaData)TagRepository.META_DATA, this.dataService);
        Stream<OntologyTerm> terms = ontologyTermIRIs.stream().map(arg_0 -> ((OntologyService)this.ontologyService).getOntologyTerm(arg_0));
        OntologyTerm combinedOntologyTerm = OntologyTerm.and((OntologyTerm[])((OntologyTerm[])terms.toArray(OntologyTerm[]::new)));
        Relation relation = Relation.forIRI((String)relationIRI);
        tagEntity.set("identifier", (Object)this.idGenerator.generateId());
        tagEntity.set("codeSystem", null);
        tagEntity.set("relationIRI", (Object)relation.getIRI());
        tagEntity.set("relationLabel", (Object)relation.getLabel());
        tagEntity.set("label", (Object)combinedOntologyTerm.getLabel());
        tagEntity.set("objectIRI", (Object)combinedOntologyTerm.getIRI());
        this.dataService.add("tags", (Entity)tagEntity);
        HashMap tags = Maps.newHashMap();
        for (Entity tag : attributeEntity.getEntities("tags")) {
            tags.put(tag.get("objectIRI").toString(), tag);
        }
        if (!tags.containsKey(tagEntity.get("objectIRI").toString())) {
            tags.put(tagEntity.get("objectIRI").toString(), tagEntity);
            added = true;
        }
        attributeEntity.set("tags", tags.values());
        this.dataService.update("attributes", attributeEntity);
        this.updateEntityMetaDataEntityWithNewAttributeEntity(entity, attribute, attributeEntity);
        return added ? OntologyTag.create(combinedOntologyTerm, relation) : null;
    }

    public Entity getTagEntity(Tag<?, OntologyTerm, Ontology> tag) {
        return this.tagRepository.getTagEntity(((OntologyTerm)tag.getObject()).getIRI(), ((OntologyTerm)tag.getObject()).getLabel(), tag.getRelation(), ((Ontology)tag.getCodeSystem()).getIRI());
    }

    @Override
    public void removeAllTagsFromEntity(String entityName) {
        EntityMetaData entityMetadata = this.dataService.getEntityMetaData(entityName);
        Iterable attributeMetaDatas = entityMetadata.getAtomicAttributes();
        for (AttributeMetaData attributeMetaData : attributeMetaDatas) {
            Entity attributeEntity = this.findAttributeEntity(entityName, attributeMetaData.getName());
            attributeEntity.set("tags", Collections.emptyList());
            this.dataService.update("attributes", attributeEntity);
            this.updateEntityMetaDataEntityWithNewAttributeEntity(entityName, attributeMetaData.getName(), attributeEntity);
        }
    }

    @Override
    public Map<String, OntologyTag> tagAttributesInEntity(String entity, Map<AttributeMetaData, OntologyTerm> tags) {
        LinkedHashMap<String, OntologyTag> result = new LinkedHashMap<String, OntologyTag>();
        for (Map.Entry<AttributeMetaData, OntologyTerm> tag : tags.entrySet()) {
            OntologyTerm ontologyTerm = tag.getValue();
            OntologyTag ontologyTag = this.addAttributeTag(entity, tag.getKey().getName(), Relation.isAssociatedWith.getIRI(), Collections.singletonList(ontologyTerm.getIRI()));
            result.put(tag.getKey().getName(), ontologyTag);
        }
        return result;
    }

    @Override
    public void addEntityTag(Tag<EntityMetaData, OntologyTerm, Ontology> tag) {
    }

    @Override
    public void removeEntityTag(Tag<EntityMetaData, OntologyTerm, Ontology> tag) {
    }

    @Override
    public Iterable<Tag<EntityMetaData, LabeledResource, LabeledResource>> getTagsForEntity(EntityMetaData entityMetaData) {
        return null;
    }

    private void updateEntityMetaDataEntityWithNewAttributeEntity(String entity, String attribute, Entity attributeEntity) {
        Entity entityEntity = this.dataService.findOne("entities", (Object)entity);
        Iterable attributes = entityEntity.getEntities("attributes");
        entityEntity.set("attributes", (Object)Iterables.transform((Iterable)attributes, att -> att.getString("name").equals(attribute) ? attributeEntity : att));
        this.dataService.update("entities", entityEntity);
    }

    private boolean isSameTag(String relationIRI, String ontologyTermIRI, Entity e) {
        return ontologyTermIRI.equals(e.getString("objectIRI")) && relationIRI.equals(e.getString("relationIRI"));
    }

    @RunAsSystem
    public Entity findAttributeEntity(String entityName, String attributeName) {
        Entity entityMetaDataEntity = this.dataService.findOne("entities", (Object)entityName);
        Optional<Entity> result = StreamSupport.stream(entityMetaDataEntity.getEntities("attributes").spliterator(), false).filter(att -> attributeName.equals(att.getString("name"))).findFirst();
        if (!result.isPresent() && entityMetaDataEntity.get("extends") != null) {
            return this.findAttributeEntity(entityMetaDataEntity.getEntity("extends").getString("fullName"), attributeName);
        }
        return result.isPresent() ? result.get() : null;
    }

    private <SubjectType> TagImpl<SubjectType, OntologyTerm, Ontology> asTag(SubjectType subjectType, Entity tagEntity) {
        String identifier = tagEntity.getString("identifier");
        Relation relation = OntologyTagServiceImpl.asRelation(tagEntity);
        Ontology ontology = this.asOntology(tagEntity);
        OntologyTerm ontologyTerm = this.asOntologyTerm(tagEntity);
        if (relation == null || ontologyTerm == null) {
            return null;
        }
        return new TagImpl(identifier, subjectType, relation, (Object)ontologyTerm, (Object)ontology);
    }

    private static Relation asRelation(Entity tagEntity) {
        String relationIRI = tagEntity.getString("relationIRI");
        if (relationIRI == null) {
            return null;
        }
        return Relation.forIRI((String)relationIRI);
    }

    private OntologyTerm asOntologyTerm(Entity tagEntity) {
        String objectIRI = tagEntity.getString("objectIRI");
        if (objectIRI == null) {
            return null;
        }
        return this.ontologyService.getOntologyTerm(objectIRI);
    }

    private Ontology asOntology(Entity tagEntity) {
        String codeSystemIRI = tagEntity.getString("codeSystem");
        if (codeSystemIRI == null) {
            return null;
        }
        return this.ontologyService.getOntology(codeSystemIRI);
    }
}

