/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.semanticsearch.service.impl;

import autovalue.shaded.com.google.common.common.collect.Sets;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.common.base.Joiner;
import org.elasticsearch.common.collect.Lists;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.MolgenisDataAccessException;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.data.semanticsearch.explain.bean.ExplainedAttributeMetaData;
import org.molgenis.data.semanticsearch.explain.bean.ExplainedQueryString;
import org.molgenis.data.semanticsearch.explain.service.ElasticSearchExplainService;
import org.molgenis.data.semanticsearch.semantic.Hit;
import org.molgenis.data.semanticsearch.service.SemanticSearchService;
import org.molgenis.data.semanticsearch.service.impl.SemanticSearchServiceHelper;
import org.molgenis.data.semanticsearch.string.NGramDistanceAlgorithm;
import org.molgenis.data.semanticsearch.string.Stemmer;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.ontology.core.model.Ontology;
import org.molgenis.ontology.core.model.OntologyTerm;
import org.molgenis.ontology.core.service.OntologyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SemanticSearchServiceImpl
implements SemanticSearchService {
    private static final Logger LOG = LoggerFactory.getLogger(SemanticSearchServiceImpl.class);
    private final DataService dataService;
    private final OntologyService ontologyService;
    private final MetaDataService metaDataService;
    private final SemanticSearchServiceHelper semanticSearchServiceHelper;
    private final ElasticSearchExplainService elasticSearchExplainService;
    public static final int MAX_NUM_TAGS = 100;
    private static final float CUTOFF = 0.4f;
    private Splitter termSplitter = Splitter.onPattern((String)"[^\\p{IsAlphabetic}]+");
    private Joiner termJoiner = Joiner.on((char)' ');
    private static final String UNIT_ONTOLOGY_IRI = "http://purl.obolibrary.org/obo/uo.owl";
    private static final int MAX_NUMBER_EXPLAINED_ATTRIBUTES = 10;

    @Autowired
    public SemanticSearchServiceImpl(DataService dataService, OntologyService ontologyService, MetaDataService metaDataService, SemanticSearchServiceHelper semanticSearchServiceHelper, ElasticSearchExplainService elasticSearchExplainService) {
        this.dataService = Objects.requireNonNull(dataService);
        this.ontologyService = Objects.requireNonNull(ontologyService);
        this.metaDataService = Objects.requireNonNull(metaDataService);
        this.semanticSearchServiceHelper = Objects.requireNonNull(semanticSearchServiceHelper);
        this.elasticSearchExplainService = Objects.requireNonNull(elasticSearchExplainService);
    }

    @Override
    public Map<AttributeMetaData, ExplainedAttributeMetaData> findAttributes(EntityMetaData sourceEntityMetaData, Set<String> queryTerms, Collection<OntologyTerm> ontologyTerms) {
        List<String> attributeIdentifiers = this.semanticSearchServiceHelper.getAttributeIdentifiers(sourceEntityMetaData);
        QueryRule disMaxQueryRule = this.semanticSearchServiceHelper.createDisMaxQueryRuleForAttribute(queryTerms, ontologyTerms);
        ArrayList finalQueryRules = Lists.newArrayList((Object[])new QueryRule[]{new QueryRule("identifier", QueryRule.Operator.IN, attributeIdentifiers)});
        if (disMaxQueryRule.getNestedRules().size() > 0) {
            finalQueryRules.addAll(Arrays.asList(new QueryRule(QueryRule.Operator.AND), disMaxQueryRule));
        }
        Stream attributeMetaDataEntities = this.dataService.findAll("attributes", (Query)new QueryImpl((List)finalQueryRules));
        Map<String, String> collectExpanedQueryMap = this.semanticSearchServiceHelper.collectExpandedQueryMap(queryTerms, ontologyTerms);
        LinkedHashMap<AttributeMetaData, ExplainedAttributeMetaData> explainedAttributes = new LinkedHashMap<AttributeMetaData, ExplainedAttributeMetaData>();
        AtomicInteger count = new AtomicInteger(0);
        attributeMetaDataEntities.forEach(attributeEntity -> {
            AttributeMetaData attribute = sourceEntityMetaData.getAttribute(attributeEntity.getString("name"));
            if (count.get() < 10) {
                Set<ExplainedQueryString> explanations = this.convertAttributeEntityToExplainedAttribute((Entity)attributeEntity, sourceEntityMetaData, collectExpanedQueryMap, finalQueryRules);
                boolean singleMatchHighQuality = this.isSingleMatchHighQuality(queryTerms, Sets.newHashSet(collectExpanedQueryMap.values()), explanations);
                explainedAttributes.put(attribute, ExplainedAttributeMetaData.create(attribute, explanations, singleMatchHighQuality));
            } else {
                explainedAttributes.put(attribute, ExplainedAttributeMetaData.create(attribute));
            }
            count.incrementAndGet();
        });
        return explainedAttributes;
    }

    boolean isSingleMatchHighQuality(Collection<String> queryTerms, Collection<String> ontologyTermQueries, Iterable<ExplainedQueryString> explanations) {
        HashMap<String, Double> matchedTags = new HashMap<String, Double>();
        for (ExplainedQueryString explanation : explanations) {
            matchedTags.put(explanation.getTagName().toLowerCase(), explanation.getScore());
        }
        ontologyTermQueries.removeAll(queryTerms);
        if (queryTerms.size() > 0 && queryTerms.stream().anyMatch(token -> this.isGoodMatch((Map<String, Double>)matchedTags, (String)token))) {
            return true;
        }
        return ontologyTermQueries.size() > 0 && ontologyTermQueries.stream().allMatch(token -> this.isGoodMatch((Map<String, Double>)matchedTags, (String)token));
    }

    boolean isGoodMatch(Map<String, Double> matchedTags, String label) {
        return matchedTags.containsKey(label = label.toLowerCase()) && matchedTags.get(label).intValue() == 100 || Sets.newHashSet((Object[])label.split(" ")).stream().allMatch(word -> matchedTags.containsKey(word) && ((Double)matchedTags.get(word)).intValue() == 100);
    }

    @Override
    public Map<AttributeMetaData, ExplainedAttributeMetaData> decisionTreeToFindRelevantAttributes(EntityMetaData sourceEntityMetaData, AttributeMetaData targetAttribute, Collection<OntologyTerm> ontologyTermsFromTags, Set<String> searchTerms) {
        Set<String> queryTerms = this.createLexicalSearchQueryTerms(targetAttribute, searchTerms);
        List ontologyTerms = ontologyTermsFromTags;
        if (null != searchTerms && !searchTerms.isEmpty()) {
            Set escapedSearchTerms = searchTerms.stream().filter(StringUtils::isNotBlank).map(QueryParserBase::escape).collect(Collectors.toSet());
            ontologyTerms = this.ontologyService.findExcatOntologyTerms(this.ontologyService.getAllOntologiesIds(), escapedSearchTerms, 100);
        } else if (null == ontologyTerms || ontologyTerms.size() == 0) {
            Hit<OntologyTerm> ontologyTermHit;
            List allOntologiesIds = this.ontologyService.getAllOntologiesIds();
            Ontology unitOntology = this.ontologyService.getOntology(UNIT_ONTOLOGY_IRI);
            if (unitOntology != null) {
                allOntologiesIds.remove(unitOntology.getId());
            }
            ontologyTerms = (ontologyTermHit = this.findTags(targetAttribute, (List<String>)allOntologiesIds)) != null ? Arrays.asList(ontologyTermHit.getResult()) : Collections.emptyList();
        }
        return this.findAttributes(sourceEntityMetaData, queryTerms, ontologyTerms);
    }

    public Set<String> createLexicalSearchQueryTerms(AttributeMetaData targetAttribute, Set<String> searchTerms) {
        HashSet<String> queryTerms = new HashSet<String>();
        if (searchTerms != null && !searchTerms.isEmpty()) {
            queryTerms.addAll(searchTerms);
        }
        if (queryTerms.size() == 0) {
            if (StringUtils.isNotBlank((CharSequence)targetAttribute.getLabel())) {
                queryTerms.add(targetAttribute.getLabel());
            }
            if (StringUtils.isNotBlank((CharSequence)targetAttribute.getDescription())) {
                queryTerms.add(targetAttribute.getDescription());
            }
        }
        return queryTerms;
    }

    public Set<ExplainedQueryString> convertAttributeEntityToExplainedAttribute(Entity attributeEntity, EntityMetaData sourceEntityMetaData, Map<String, String> collectExpanedQueryMap, List<QueryRule> finalQueryRules) {
        String attributeId = attributeEntity.getString("identifier");
        String attributeName = attributeEntity.getString("name");
        AttributeMetaData attribute = sourceEntityMetaData.getAttribute(attributeName);
        if (attribute == null) {
            throw new MolgenisDataAccessException("The attributeMetaData : " + attributeName + " does not exsit in EntityMetaData : " + sourceEntityMetaData.getName());
        }
        Explanation explanation = this.elasticSearchExplainService.explain((Query)new QueryImpl(finalQueryRules), this.dataService.getEntityMetaData("attributes"), attributeId);
        Set<ExplainedQueryString> detectedQueryStrings = this.elasticSearchExplainService.findQueriesFromExplanation(collectExpanedQueryMap, explanation);
        return detectedQueryStrings;
    }

    @Override
    public Map<AttributeMetaData, Hit<OntologyTerm>> findTags(String entity, List<String> ontologyIds) {
        LinkedHashMap<AttributeMetaData, Hit<OntologyTerm>> result = new LinkedHashMap<AttributeMetaData, Hit<OntologyTerm>>();
        EntityMetaData emd = this.metaDataService.getEntityMetaData(entity);
        for (AttributeMetaData amd : emd.getAtomicAttributes()) {
            Hit<OntologyTerm> tag = this.findTags(amd, ontologyIds);
            if (tag == null) continue;
            result.put(amd, tag);
        }
        return result;
    }

    @Override
    public Hit<OntologyTerm> findTags(AttributeMetaData attribute, List<String> ontologyIds) {
        String description = attribute.getDescription() == null ? attribute.getLabel() : attribute.getDescription();
        Set<String> searchTerms = this.splitIntoTerms(description);
        Stemmer stemmer = new Stemmer();
        if (LOG.isDebugEnabled()) {
            LOG.debug("findOntologyTerms({},{},{})", new Object[]{ontologyIds, searchTerms, 100});
        }
        List candidates = this.ontologyService.findOntologyTerms(ontologyIds, searchTerms, 100);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Candidates: {}", (Object)candidates);
        }
        List hits = candidates.stream().filter(ontologyTerm -> this.filterOntologyTerm(this.splitIntoTerms(Stemmer.stemAndJoin(searchTerms)), (OntologyTerm)ontologyTerm, stemmer)).map(ontolgoyTerm -> Hit.create(ontolgoyTerm, this.bestMatchingSynonym((OntologyTerm)ontolgoyTerm, searchTerms).getScore())).sorted((Comparator<Hit>)Ordering.natural().reverse()).collect(Collectors.toList());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Hits: {}", hits);
        }
        Hit<OntologyTerm> result = null;
        String bestMatchingSynonym = null;
        for (Hit hit : hits) {
            String bestMatchingSynonymForHit = this.bestMatchingSynonym((OntologyTerm)hit.getResult(), searchTerms).getResult();
            if (result == null) {
                result = hit;
                bestMatchingSynonym = bestMatchingSynonymForHit;
            } else {
                Sets.SetView jointTerms = Sets.union(this.splitIntoTerms(bestMatchingSynonym), this.splitIntoTerms(bestMatchingSynonymForHit));
                String joinedSynonyms = this.termJoiner.join((Iterable)jointTerms);
                Hit<OntologyTerm> joinedHit = Hit.create(OntologyTerm.and((OntologyTerm[])new OntologyTerm[]{(OntologyTerm)result.getResult(), (OntologyTerm)hit.getResult()}), this.distanceFrom(joinedSynonyms, searchTerms, stemmer));
                if (joinedHit.compareTo(result) > 0) {
                    result = joinedHit;
                    bestMatchingSynonym = bestMatchingSynonym + " " + bestMatchingSynonymForHit;
                }
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("result: {}", (Object)result);
        }
        if (result != null && result.getScore() >= 0.4f) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Tag {} with {}", (Object)attribute, (Object)result);
            }
            return result;
        }
        return null;
    }

    private boolean filterOntologyTerm(Set<String> keywordsFromAttribute, OntologyTerm ontologyTerm, Stemmer stemmer) {
        Set<String> ontologyTermSynonyms = this.semanticSearchServiceHelper.getOtLabelAndSynonyms(ontologyTerm);
        for (String synonym : ontologyTermSynonyms) {
            Set<String> splitIntoTerms = this.splitIntoTerms(Stemmer.stemAndJoin(this.splitIntoTerms(synonym)));
            if (splitIntoTerms.size() == 0 || !keywordsFromAttribute.containsAll(splitIntoTerms)) continue;
            return true;
        }
        return false;
    }

    public Hit<String> bestMatchingSynonym(OntologyTerm ontologyTerm, Set<String> searchTerms) {
        Stemmer stemmer = new Stemmer();
        Optional<Hit> bestSynonym = ontologyTerm.getSynonyms().stream().map(synonym -> Hit.create(synonym, this.distanceFrom((String)synonym, searchTerms, stemmer))).max(Comparator.naturalOrder());
        return bestSynonym.get();
    }

    float distanceFrom(String synonym, Set<String> searchTerms, Stemmer stemmer) {
        String s1 = Stemmer.stemAndJoin(this.splitIntoTerms(synonym));
        String s2 = Stemmer.stemAndJoin(searchTerms);
        float distance = (float)NGramDistanceAlgorithm.stringMatching(s1, s2) / 100.0f;
        LOG.debug("Similarity between: {} and {} is {}", new Object[]{s1, s2, Float.valueOf(distance)});
        return distance;
    }

    private Set<String> splitIntoTerms(String description) {
        return FluentIterable.from((Iterable)this.termSplitter.split((CharSequence)description)).transform(String::toLowerCase).filter(w -> !NGramDistanceAlgorithm.STOPWORDSLIST.contains(w)).filter(StringUtils::isNotEmpty).toSet();
    }
}

