/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.semantic;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Package;
import org.molgenis.data.Query;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.semantic.LabeledResource;
import org.molgenis.data.semantic.Relation;
import org.molgenis.data.semantic.Tag;
import org.molgenis.data.semantic.TagImpl;
import org.molgenis.data.semantic.TagRepository;
import org.molgenis.data.semantic.TagService;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.ontology.Ontology;
import org.molgenis.ontology.OntologyService;
import org.molgenis.ontology.OntologyTerm;

public class OntologyTagService
implements TagService<OntologyTerm, Ontology> {
    private final DataService dataService;
    private final TagRepository tagRepository;
    private final OntologyService ontologyService;

    public OntologyTagService(DataService dataService, OntologyService ontologyService, TagRepository tagRepository) {
        this.dataService = dataService;
        this.tagRepository = tagRepository;
        this.ontologyService = ontologyService;
    }

    private Entity findAttributeEntity(String entityName, String attributeName) {
        Query q = new QueryImpl().eq("entity", (Object)entityName).and().eq("name", (Object)attributeName);
        Entity entity = this.dataService.findOne("attributes", q);
        return entity;
    }

    @Override
    public void removeAttributeTag(EntityMetaData entityMetaData, Tag<AttributeMetaData, OntologyTerm, Ontology> removeTag) {
        AttributeMetaData attributeMetaData = (AttributeMetaData)removeTag.getSubject();
        Entity attributeEntity = this.findAttributeEntity(entityMetaData.getName(), attributeMetaData.getName());
        ArrayList<Entity> tags = new ArrayList<Entity>();
        for (Entity tagEntity : attributeEntity.getEntities("tags")) {
            TagImpl<AttributeMetaData, OntologyTerm, Ontology> tag = this.asTag(attributeMetaData, tagEntity);
            if (removeTag.equals(tag)) continue;
            tags.add(tagEntity);
        }
        attributeEntity.set("tags", tags);
        this.dataService.update("attributes", attributeEntity);
    }

    @Override
    public Iterable<Tag<AttributeMetaData, OntologyTerm, Ontology>> getTagsForAttribute(EntityMetaData entityMetaData, AttributeMetaData attributeMetaData) {
        Entity entity = this.findAttributeEntity(entityMetaData.getName(), attributeMetaData.getName());
        ArrayList<Tag<AttributeMetaData, OntologyTerm, Ontology>> tags = new ArrayList<Tag<AttributeMetaData, OntologyTerm, Ontology>>();
        for (Entity tagEntity : entity.getEntities("tags")) {
            tags.add((Tag<AttributeMetaData, OntologyTerm, Ontology>)this.asTag(attributeMetaData, tagEntity));
        }
        return tags;
    }

    @Override
    public Iterable<Tag<Package, OntologyTerm, Ontology>> getTagsForPackage(Package p) {
        Entity packageEntity = this.dataService.findOne("packages", new QueryImpl().eq("fullName", (Object)p.getName()));
        if (packageEntity == null) {
            throw new UnknownEntityException("Unknown package [" + p.getName() + "]");
        }
        ArrayList tags = Lists.newArrayList();
        for (Entity tagEntity : packageEntity.getEntities("tags")) {
            tags.add(this.asTag(p, tagEntity));
        }
        return tags;
    }

    private <SubjectType> TagImpl<SubjectType, OntologyTerm, Ontology> asTag(SubjectType subjectType, Entity tagEntity) {
        String identifier = tagEntity.getString("identifier");
        Relation relation = Relation.forIRI((String)tagEntity.getString("relationIRI"));
        Ontology ontology = this.ontologyService.getOntology(tagEntity.getString("codeSystem"));
        OntologyTerm ontologyTerm = this.ontologyService.getOntologyTerm(tagEntity.getString("objectIRI"), ontology.getIri());
        return new TagImpl(identifier, subjectType, relation, (Object)ontologyTerm, (Object)ontology);
    }

    @Override
    public void addAttributeTag(EntityMetaData entityMetaData, Tag<AttributeMetaData, OntologyTerm, Ontology> tag) {
        Entity entity = this.findAttributeEntity(entityMetaData.getName(), ((AttributeMetaData)tag.getSubject()).getName());
        ArrayList<Entity> tags = new ArrayList<Entity>();
        for (Entity tagEntity : entity.getEntities("tags")) {
            tags.add(tagEntity);
        }
        tags.add(this.getTagEntity(tag));
        entity.set("tags", tags);
        this.dataService.update("attributes", entity);
    }

    public Entity getTagEntity(Tag<?, OntologyTerm, Ontology> tag) {
        return this.tagRepository.getTagEntity(((OntologyTerm)tag.getObject()).getIRI(), ((OntologyTerm)tag.getObject()).getLabel(), tag.getRelation(), ((Ontology)tag.getCodeSystem()).getIri());
    }

    @Override
    public void addEntityTag(Tag<EntityMetaData, OntologyTerm, Ontology> tag) {
    }

    @Override
    public void removeEntityTag(Tag<EntityMetaData, OntologyTerm, Ontology> tag) {
    }

    @Override
    public Iterable<Tag<EntityMetaData, LabeledResource, LabeledResource>> getTagsForEntity(EntityMetaData entityMetaData) {
        return null;
    }
}

