/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.semantic;

import org.molgenis.data.CrudRepository;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.meta.TagMetaData;
import org.molgenis.data.semantic.Relation;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.QueryImpl;
import org.springframework.util.IdGenerator;

public class TagRepository {
    public static final TagMetaData META_DATA = new TagMetaData();
    private IdGenerator idGenerator;
    private CrudRepository repository;

    public TagRepository(CrudRepository repository, IdGenerator idGenerator) {
        this.repository = repository;
        this.idGenerator = idGenerator;
    }

    public Entity getTagEntity(String objectIRI, String label, Relation relation, String codeSystemIRI) {
        Query q = new QueryImpl().eq("objectIRI", (Object)objectIRI).and().eq("relationIRI", (Object)relation.getIRI()).and().eq("codeSystem", (Object)codeSystemIRI);
        Entity result = this.repository.findOne(q);
        if (result == null) {
            MapEntity mapEntity = new MapEntity("tags");
            mapEntity.set("identifier", (Object)this.idGenerator.generateId().toString());
            mapEntity.set("objectIRI", (Object)objectIRI);
            mapEntity.set("label", (Object)label);
            mapEntity.set("relationIRI", (Object)relation.getIRI());
            mapEntity.set("relationLabel", (Object)relation.getLabel());
            mapEntity.set("codeSystem", (Object)codeSystemIRI);
            this.repository.add((Entity)mapEntity);
            result = mapEntity;
        }
        return result;
    }
}

