/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.semantic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Package;
import org.molgenis.data.Query;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.semantic.LabeledResource;
import org.molgenis.data.semantic.Tag;
import org.molgenis.data.semantic.TagImpl;
import org.molgenis.data.semantic.TagRepository;
import org.molgenis.data.semantic.TagService;
import org.molgenis.data.support.QueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UntypedTagService
implements TagService<LabeledResource, LabeledResource> {
    private static final Logger LOG = LoggerFactory.getLogger(UntypedTagService.class);
    private final DataService dataService;
    private final TagRepository tagRepository;

    public UntypedTagService(DataService dataService, TagRepository tagRepository) {
        this.dataService = dataService;
        this.tagRepository = tagRepository;
    }

    private Entity findAttributeEntity(EntityMetaData entityMetaData, String attributeName) {
        Query q = new QueryImpl().eq("entity", (Object)entityMetaData.getName()).and().eq("name", (Object)attributeName);
        Entity entity = this.dataService.findOne("attributes", q);
        return entity;
    }

    private Entity findEntity(EntityMetaData emd) {
        return this.dataService.findOne("entities", (Object)emd.getName());
    }

    @Override
    public void removeAttributeTag(EntityMetaData entityMetaData, Tag<AttributeMetaData, LabeledResource, LabeledResource> removeTag) {
        AttributeMetaData attributeMetaData = (AttributeMetaData)removeTag.getSubject();
        Entity attributeEntity = this.findAttributeEntity(entityMetaData, attributeMetaData.getName());
        ArrayList<Entity> tags = new ArrayList<Entity>();
        for (Entity tagEntity : attributeEntity.getEntities("tags")) {
            TagImpl tag = TagImpl.asTag((Object)attributeMetaData, (Entity)tagEntity);
            if (removeTag.equals((Object)tag)) continue;
            tags.add(tagEntity);
        }
        attributeEntity.set("tags", tags);
        this.dataService.update("attributes", attributeEntity);
    }

    @Override
    public Iterable<Tag<AttributeMetaData, LabeledResource, LabeledResource>> getTagsForAttribute(EntityMetaData entityMetaData, AttributeMetaData attributeMetaData) {
        Entity entity = this.findAttributeEntity(entityMetaData, attributeMetaData.getName());
        if (entity == null) {
            return Collections.emptyList();
        }
        ArrayList<Tag<AttributeMetaData, LabeledResource, LabeledResource>> tags = new ArrayList<Tag<AttributeMetaData, LabeledResource, LabeledResource>>();
        for (Entity tagEntity : entity.getEntities("tags")) {
            tags.add((Tag<AttributeMetaData, LabeledResource, LabeledResource>)TagImpl.asTag((Object)attributeMetaData, (Entity)tagEntity));
        }
        return tags;
    }

    @Override
    public Iterable<Tag<EntityMetaData, LabeledResource, LabeledResource>> getTagsForEntity(EntityMetaData entityMetaData) {
        Entity entity = this.findEntity(entityMetaData);
        if (entity == null) {
            throw new UnknownEntityException("No known entity with name " + entityMetaData.getName() + ".");
        }
        ArrayList<Tag<EntityMetaData, LabeledResource, LabeledResource>> tags = new ArrayList<Tag<EntityMetaData, LabeledResource, LabeledResource>>();
        for (Entity tagEntity : entity.getEntities("tags")) {
            tags.add((Tag<EntityMetaData, LabeledResource, LabeledResource>)TagImpl.asTag((Object)entityMetaData, (Entity)tagEntity));
        }
        return tags;
    }

    @Override
    public void addAttributeTag(EntityMetaData entityMetaData, Tag<AttributeMetaData, LabeledResource, LabeledResource> tag) {
        Entity entity = this.findAttributeEntity(entityMetaData, ((AttributeMetaData)tag.getSubject()).getName());
        ArrayList<Entity> tags = new ArrayList<Entity>();
        for (Entity tagEntity : entity.getEntities("tags")) {
            tags.add(tagEntity);
        }
        tags.add(this.getTagEntity(tag));
        entity.set("tags", tags);
        this.dataService.update("attributes", entity);
    }

    @Override
    public void addEntityTag(Tag<EntityMetaData, LabeledResource, LabeledResource> tag) {
        Entity entity = this.findEntity((EntityMetaData)tag.getSubject());
        if (entity == null) {
            throw new UnknownEntityException("Unknown entity [" + ((EntityMetaData)tag.getSubject()).getName() + "]");
        }
        ImmutableList existingTags = ImmutableList.copyOf(this.getTagsForEntity((EntityMetaData)tag.getSubject()));
        if (existingTags.contains(tag)) {
            LOG.debug("Tag already present");
            return;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(entity.getEntities("tags"));
        builder.add((Object)this.getTagEntity(tag));
        entity.set("tags", (Object)builder.build());
        this.dataService.update("entities", entity);
    }

    public Entity getTagEntity(Tag<?, LabeledResource, LabeledResource> tag) {
        return this.tagRepository.getTagEntity(((LabeledResource)tag.getObject()).getIri(), ((LabeledResource)tag.getObject()).getLabel(), tag.getRelation(), ((LabeledResource)tag.getCodeSystem()).getIri());
    }

    @Override
    public Iterable<Tag<Package, LabeledResource, LabeledResource>> getTagsForPackage(Package p) {
        Entity packageEntity = this.dataService.findOne("packages", new QueryImpl().eq("fullName", (Object)p.getName()));
        if (packageEntity == null) {
            throw new UnknownEntityException("Unknown package [" + p.getName() + "]");
        }
        ArrayList tags = Lists.newArrayList();
        for (Entity tagEntity : packageEntity.getEntities("tags")) {
            tags.add(TagImpl.asTag((Object)p, (Entity)tagEntity));
        }
        return tags;
    }

    @Override
    public void removeEntityTag(Tag<EntityMetaData, LabeledResource, LabeledResource> tag) {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

