/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.utils;

import com.google.common.io.BaseEncoding;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.collect.Iterables;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.MolgenisInvalidFormatException;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.data.vcf.datastructures.Sample;
import org.molgenis.data.vcf.datastructures.Trio;
import org.molgenis.vcf.meta.VcfMetaInfo;

public class VcfUtils {
    public static final String TAB = "\t";

    public static String createId(Entity vcfEntity) {
        MessageDigest messageDigest;
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(StringUtils.strip((String)vcfEntity.get("#CHROM").toString()));
        strBuilder.append("_");
        strBuilder.append(StringUtils.strip((String)vcfEntity.get("POS").toString()));
        strBuilder.append("_");
        strBuilder.append(StringUtils.strip((String)vcfEntity.get("REF").toString()));
        strBuilder.append("_");
        strBuilder.append(StringUtils.strip((String)vcfEntity.get("ALT").toString()));
        String idStr = strBuilder.toString();
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] md5Hash = messageDigest.digest(idStr.getBytes(Charset.forName("UTF-8")));
        String id = BaseEncoding.base64Url().omitPadding().encode(md5Hash);
        return id;
    }

    public static String convertToVCF(Entity vcfEntity) throws MolgenisDataException {
        return VcfUtils.convertToVCF(vcfEntity, Collections.emptyList());
    }

    public static String convertToVCF(Entity vcfEntity, List<String> attributesToInclude) throws MolgenisDataException {
        Iterable sampleEntities;
        StringBuilder vcfRecord = new StringBuilder();
        List<String> vcfAttributes = Arrays.asList("#CHROM", "POS", "ID", "REF", "ALT", "QUAL", "FILTER");
        for (String vcfAttribute : vcfAttributes) {
            vcfRecord.append((vcfEntity.getString(vcfAttribute) != null && !vcfEntity.getString(vcfAttribute).equals("") ? vcfEntity.getString(vcfAttribute) : ".") + TAB);
        }
        ArrayList<String> infoFieldsSeen = new ArrayList<String>();
        boolean hasInfoFields = false;
        for (AttributeMetaData attributeMetaData : vcfEntity.getEntityMetaData().getAttribute("INFO").getAttributeParts()) {
            if (!attributesToInclude.isEmpty() && !attributesToInclude.contains(attributeMetaData.getName())) continue;
            infoFieldsSeen.add(attributeMetaData.getName());
            if (vcfEntity.getString(attributeMetaData.getName()) == null) continue;
            if (attributeMetaData.getDataType().getEnumType().equals((Object)MolgenisFieldTypes.FieldTypeEnum.BOOL)) {
                if (!vcfEntity.getBoolean(attributeMetaData.getName()).booleanValue()) continue;
                vcfRecord.append(attributeMetaData.getName() + ";");
                hasInfoFields = true;
                continue;
            }
            vcfRecord.append(attributeMetaData.getName() + "=" + vcfEntity.getString(attributeMetaData.getName()) + ";");
            hasInfoFields = true;
        }
        if (!hasInfoFields) {
            vcfRecord.append(".");
        }
        if ((sampleEntities = vcfEntity.getEntities("SAMPLES_ENTITIES")) != null && !Iterables.isEmpty((Iterable)sampleEntities)) {
            vcfRecord.append(TAB);
            boolean firstSample = true;
            for (Entity sample : sampleEntities) {
                StringBuilder formatColumn = new StringBuilder();
                StringBuilder sampleColumn = new StringBuilder();
                for (String sampleAttribute : sample.getAttributeNames()) {
                    if (!sampleAttribute.equals("GT")) continue;
                    if (firstSample) {
                        formatColumn.append(sampleAttribute);
                        formatColumn.append(":");
                    }
                    if (sample.getString(sampleAttribute) != null) {
                        sampleColumn.append(sample.getString(sampleAttribute));
                        sampleColumn.append(":");
                        continue;
                    }
                    sampleColumn.append(".:");
                }
                for (String sampleAttribute : sample.getAttributeNames()) {
                    if (sampleAttribute.equals("GT") || sampleAttribute.equals("ID") || sampleAttribute.equals("NAME")) continue;
                    if (sample.getString(sampleAttribute) != null) {
                        sampleColumn.append(sample.getString(sampleAttribute));
                        sampleColumn.append(":");
                    } else {
                        sampleColumn.append(".:");
                    }
                    if (!firstSample) continue;
                    formatColumn.append(sampleAttribute);
                    formatColumn.append(":");
                }
                if (firstSample && formatColumn.length() > 0) {
                    formatColumn.deleteCharAt(formatColumn.length() - 1);
                    vcfRecord.append(formatColumn.toString() + TAB);
                    firstSample = false;
                } else if (firstSample) {
                    throw new MolgenisDataException("Weird situation: we are at sample 1 and want to print FORMAT info but there seems to be none?");
                }
                sampleColumn.deleteCharAt(sampleColumn.length() - 1);
                vcfRecord.append(sampleColumn.toString() + TAB);
            }
            vcfRecord.deleteCharAt(vcfRecord.length() - 1);
        }
        return vcfRecord.toString();
    }

    public static boolean checkPreviouslyAnnotatedAndAddMetadata(File inputVcfFile, PrintWriter outputVCFWriter, List<AttributeMetaData> infoFields) throws FileNotFoundException, MolgenisInvalidFormatException {
        return VcfUtils.checkPreviouslyAnnotatedAndAddMetadata(inputVcfFile, outputVCFWriter, infoFields, Collections.emptyList());
    }

    public static boolean checkPreviouslyAnnotatedAndAddMetadata(File inputVcfFile, PrintWriter outputVCFWriter, List<AttributeMetaData> infoFields, List<String> attributesToInclude) throws MolgenisInvalidFormatException, FileNotFoundException {
        String checkAnnotatedBeforeValue = attributesToInclude.isEmpty() ? (infoFields.isEmpty() ? null : infoFields.get(0).getName()) : attributesToInclude.get(0);
        boolean annotatedBefore = false;
        System.out.println("Detecting VCF column header...");
        Scanner inputVcfFileScanner = new Scanner(inputVcfFile, "UTF-8");
        String line = inputVcfFileScanner.nextLine();
        if (line.startsWith("##")) {
            while (inputVcfFileScanner.hasNextLine()) {
                if (checkAnnotatedBeforeValue != null && line.contains("##INFO=<ID=" + checkAnnotatedBeforeValue) && !annotatedBefore) {
                    System.out.println("\nThis file has already been annotated with '" + checkAnnotatedBeforeValue + "' data before it seems. Skipping any further annotation of variants that already contain this field.");
                    annotatedBefore = true;
                }
                outputVCFWriter.println(line);
                line = inputVcfFileScanner.nextLine();
                if (!line.startsWith("##")) break;
                System.out.print(".");
            }
            System.out.println("\nHeader line found:\n" + line);
            if (!line.startsWith("#CHROM")) {
                outputVCFWriter.close();
                inputVcfFileScanner.close();
                throw new MolgenisInvalidFormatException("Header does not start with #CHROM, are you sure it is a VCF file?");
            }
            if (!annotatedBefore) {
                for (AttributeMetaData infoAttributeMetaData : VcfUtils.getAtomicAttributesFromList(infoFields)) {
                    if (!attributesToInclude.isEmpty() && !attributesToInclude.contains(infoAttributeMetaData.getName())) continue;
                    outputVCFWriter.println(VcfUtils.attributeMetaDataToInfoField(infoAttributeMetaData));
                }
            }
        } else {
            outputVCFWriter.close();
            inputVcfFileScanner.close();
            throw new MolgenisInvalidFormatException("Did not find ## on the first line, are you sure it is a VCF file?");
        }
        outputVCFWriter.println(line);
        inputVcfFileScanner.close();
        return annotatedBefore;
    }

    public static List<AttributeMetaData> getAtomicAttributesFromList(Iterable<AttributeMetaData> outputAttrs) {
        ArrayList<AttributeMetaData> result = new ArrayList<AttributeMetaData>();
        for (AttributeMetaData attributeMetaData : outputAttrs) {
            if (attributeMetaData.getDataType().getEnumType().equals((Object)MolgenisFieldTypes.FieldTypeEnum.COMPOUND)) {
                result.addAll(VcfUtils.getAtomicAttributesFromList(attributeMetaData.getAttributeParts()));
                continue;
            }
            result.add(attributeMetaData);
        }
        return result;
    }

    private static String attributeMetaDataToInfoField(AttributeMetaData infoAttributeMetaData) {
        StringBuilder sb = new StringBuilder();
        sb.append("##INFO=<ID=");
        sb.append(infoAttributeMetaData.getName());
        sb.append(",Number=.");
        sb.append(",Type=");
        sb.append(VcfUtils.toVcfDataType(infoAttributeMetaData.getDataType().getEnumType()));
        sb.append(",Description=\"");
        if (StringUtils.isBlank((CharSequence)infoAttributeMetaData.getDescription())) {
            ((DefaultAttributeMetaData)infoAttributeMetaData).setDescription("Description not provided");
        }
        sb.append(infoAttributeMetaData.getDescription().replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", " "));
        sb.append("\">");
        return sb.toString();
    }

    private static String toVcfDataType(MolgenisFieldTypes.FieldTypeEnum dataType) {
        switch (dataType) {
            case BOOL: {
                return VcfMetaInfo.Type.FLAG.toString();
            }
            case LONG: 
            case DECIMAL: {
                return VcfMetaInfo.Type.FLOAT.toString();
            }
            case INT: {
                return VcfMetaInfo.Type.INTEGER.toString();
            }
            case EMAIL: 
            case ENUM: 
            case HTML: 
            case HYPERLINK: 
            case STRING: 
            case TEXT: 
            case DATE: 
            case DATE_TIME: 
            case CATEGORICAL: 
            case XREF: 
            case CATEGORICAL_MREF: 
            case MREF: {
                return VcfMetaInfo.Type.STRING.toString();
            }
            case COMPOUND: 
            case FILE: 
            case IMAGE: {
                throw new RuntimeException("invalid vcf data type " + dataType);
            }
        }
        throw new RuntimeException("unsupported vcf data type " + dataType);
    }

    public static HashMap<String, Trio> getPedigree(File inputVcfFile) throws FileNotFoundException {
        HashMap<String, Trio> result = new HashMap<String, Trio>();
        Scanner inputVcfFileScanner = new Scanner(inputVcfFile, "UTF-8");
        String line = inputVcfFileScanner.nextLine();
        if (line.startsWith("##")) {
            while (inputVcfFileScanner.hasNextLine()) {
                if (line.startsWith("##PEDIGREE")) {
                    String[] lineSplit;
                    System.out.println("Pedigree data line: " + line);
                    String childID = null;
                    String motherID = null;
                    String fatherID = null;
                    String lineStripped = line.replace("##PEDIGREE=<", "").replace(">", "");
                    for (String element : lineSplit = lineStripped.split(",", -1)) {
                        if (element.startsWith("Child")) {
                            childID = element.replace("Child=", "");
                            continue;
                        }
                        if (element.startsWith("Mother")) {
                            motherID = element.replace("Mother=", "");
                            continue;
                        }
                        if (element.startsWith("Father")) {
                            fatherID = element.replace("Father=", "");
                            continue;
                        }
                        inputVcfFileScanner.close();
                        throw new MolgenisDataException("Expected Child, Mother or Father, but found: " + element + " in line " + line);
                    }
                    if (childID != null && motherID != null && fatherID != null) {
                        result.put(childID, new Trio(new Sample(childID), new Sample(motherID), new Sample(fatherID)));
                    } else {
                        inputVcfFileScanner.close();
                        throw new MolgenisDataException("Missing Child, Mother or Father ID in line " + line);
                    }
                }
                if ((line = inputVcfFileScanner.nextLine()).startsWith("##")) continue;
            }
        }
        inputVcfFileScanner.close();
        return result;
    }
}

