/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.utils;

import com.google.common.io.BaseEncoding;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.MolgenisInvalidFormatException;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.data.vcf.datastructures.Sample;
import org.molgenis.data.vcf.datastructures.Trio;
import org.molgenis.vcf.meta.VcfMetaInfo;

public class VcfUtils {
    private static List<String> VCF_ATTRIBUTE_NAMES = Arrays.asList("#CHROM", "POS", "ID", "REF", "ALT", "QUAL", "FILTER");

    public static String createId(Entity vcfEntity) {
        MessageDigest messageDigest;
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(StringUtils.strip((String)vcfEntity.get("#CHROM").toString()));
        strBuilder.append("_");
        strBuilder.append(StringUtils.strip((String)vcfEntity.get("POS").toString()));
        strBuilder.append("_");
        strBuilder.append(StringUtils.strip((String)vcfEntity.get("REF").toString()));
        strBuilder.append("_");
        strBuilder.append(StringUtils.strip((String)vcfEntity.get("ALT").toString()));
        String idStr = strBuilder.toString();
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] md5Hash = messageDigest.digest(idStr.getBytes(Charset.forName("UTF-8")));
        String id = BaseEncoding.base64Url().omitPadding().encode(md5Hash);
        return id;
    }

    public static void writeToVcf(Entity vcfEntity, BufferedWriter writer) throws MolgenisDataException, IOException {
        VcfUtils.writeToVcf(vcfEntity, Collections.emptyList(), writer);
    }

    public static void writeToVcf(Entity vcfEntity, List<String> attributesToInclude, BufferedWriter writer) throws MolgenisDataException, IOException {
        Iterable iterable;
        for (String string : VCF_ATTRIBUTE_NAMES) {
            String value = vcfEntity.getString(string);
            if (value != null && !value.isEmpty()) {
                writer.write(value);
            } else {
                writer.write(46);
            }
            writer.write(9);
        }
        boolean hasInfoFields = false;
        for (AttributeMetaData attributeMetaData : vcfEntity.getEntityMetaData().getAttribute("INFO").getAttributeParts()) {
            String infoAttrName = attributeMetaData.getName();
            if (!attributesToInclude.isEmpty() && !attributesToInclude.contains(infoAttrName)) continue;
            if (attributeMetaData.getDataType().getEnumType() == MolgenisFieldTypes.FieldTypeEnum.BOOL) {
                Boolean infoAttrBoolValue = vcfEntity.getBoolean(infoAttrName);
                if (infoAttrBoolValue == null || !infoAttrBoolValue.booleanValue()) continue;
                writer.append(infoAttrName);
                writer.append(';');
                hasInfoFields = true;
                continue;
            }
            String infoAttrStringValue = vcfEntity.getString(infoAttrName);
            if (infoAttrStringValue == null) continue;
            writer.append(infoAttrName);
            writer.append('=');
            writer.append(infoAttrStringValue);
            writer.append(';');
            hasInfoFields = true;
        }
        if (!hasInfoFields) {
            writer.append('.');
        }
        if ((iterable = vcfEntity.getEntities("SAMPLES_ENTITIES")) != null) {
            boolean firstSample = true;
            Iterator it = iterable.iterator();
            while (it.hasNext()) {
                if (firstSample) {
                    writer.append('\t');
                }
                Entity sample = (Entity)it.next();
                StringBuilder formatColumn = new StringBuilder();
                StringBuilder sampleColumn = new StringBuilder();
                if (sample.getEntityMetaData().getAttribute("GT") != null) {
                    String sampleAttrValue;
                    if (firstSample) {
                        formatColumn.append("GT");
                        formatColumn.append(':');
                    }
                    if ((sampleAttrValue = sample.getString("GT")) != null) {
                        sampleColumn.append(sampleAttrValue);
                        sampleColumn.append(':');
                    } else {
                        sampleColumn.append(".:");
                    }
                }
                for (AttributeMetaData sampleAttr : sample.getEntityMetaData().getAttributes()) {
                    String sampleAttribute = sampleAttr.getName();
                    if (sampleAttribute.equals("GT") || sampleAttribute.equals("ID") || sampleAttribute.equals("NAME")) continue;
                    String sampleAttrValue = sample.getString(sampleAttribute);
                    if (sampleAttrValue != null) {
                        sampleColumn.append(sampleAttrValue);
                        sampleColumn.append(':');
                    } else {
                        sampleColumn.append(".:");
                    }
                    if (!firstSample) continue;
                    formatColumn.append(sampleAttribute);
                    formatColumn.append(':');
                }
                if (firstSample && formatColumn.length() > 0) {
                    formatColumn.deleteCharAt(formatColumn.length() - 1);
                    writer.write(formatColumn.toString());
                    writer.write(9);
                    firstSample = false;
                } else if (firstSample) {
                    throw new MolgenisDataException("Weird situation: we are at sample 1 and want to print FORMAT info but there seems to be none?");
                }
                sampleColumn.deleteCharAt(sampleColumn.length() - 1);
                writer.write(sampleColumn.toString());
                if (!it.hasNext()) continue;
                writer.write(9);
            }
        }
    }

    public static boolean checkPreviouslyAnnotatedAndAddMetadata(File inputVcfFile, BufferedWriter outputVCFWriter, List<AttributeMetaData> infoFields) throws MolgenisInvalidFormatException, IOException {
        return VcfUtils.checkPreviouslyAnnotatedAndAddMetadata(inputVcfFile, outputVCFWriter, infoFields, Collections.emptyList());
    }

    public static boolean checkPreviouslyAnnotatedAndAddMetadata(File inputVcfFile, BufferedWriter outputVCFWriter, List<AttributeMetaData> infoFields, List<String> attributesToInclude) throws MolgenisInvalidFormatException, IOException {
        String checkAnnotatedBeforeValue = attributesToInclude.isEmpty() ? (infoFields.isEmpty() ? null : infoFields.get(0).getName()) : attributesToInclude.get(0);
        boolean annotatedBefore = false;
        System.out.println("Detecting VCF column header...");
        Scanner inputVcfFileScanner = new Scanner(inputVcfFile, "UTF-8");
        String line = inputVcfFileScanner.nextLine();
        if (line.startsWith("##")) {
            while (inputVcfFileScanner.hasNextLine()) {
                if (checkAnnotatedBeforeValue != null && line.contains("##INFO=<ID=" + checkAnnotatedBeforeValue) && !annotatedBefore) {
                    System.out.println("\nThis file has already been annotated with '" + checkAnnotatedBeforeValue + "' data before it seems. Skipping any further annotation of variants that already contain this field.");
                    annotatedBefore = true;
                }
                outputVCFWriter.write(line);
                outputVCFWriter.newLine();
                line = inputVcfFileScanner.nextLine();
                if (!line.startsWith("##")) break;
                System.out.print(".");
            }
            System.out.println("\nHeader line found:\n" + line);
            if (!line.startsWith("#CHROM")) {
                outputVCFWriter.close();
                inputVcfFileScanner.close();
                throw new MolgenisInvalidFormatException("Header does not start with #CHROM, are you sure it is a VCF file?");
            }
            if (!annotatedBefore) {
                for (AttributeMetaData infoAttributeMetaData : VcfUtils.getAtomicAttributesFromList(infoFields)) {
                    if (!attributesToInclude.isEmpty() && !attributesToInclude.contains(infoAttributeMetaData.getName())) continue;
                    outputVCFWriter.write(VcfUtils.attributeMetaDataToInfoField(infoAttributeMetaData));
                    outputVCFWriter.newLine();
                }
            }
        } else {
            outputVCFWriter.close();
            inputVcfFileScanner.close();
            throw new MolgenisInvalidFormatException("Did not find ## on the first line, are you sure it is a VCF file?");
        }
        outputVCFWriter.write(line);
        outputVCFWriter.newLine();
        inputVcfFileScanner.close();
        return annotatedBefore;
    }

    public static List<AttributeMetaData> getAtomicAttributesFromList(Iterable<AttributeMetaData> outputAttrs) {
        ArrayList<AttributeMetaData> result = new ArrayList<AttributeMetaData>();
        for (AttributeMetaData attributeMetaData : outputAttrs) {
            if (attributeMetaData.getDataType().getEnumType().equals((Object)MolgenisFieldTypes.FieldTypeEnum.COMPOUND)) {
                result.addAll(VcfUtils.getAtomicAttributesFromList(attributeMetaData.getAttributeParts()));
                continue;
            }
            result.add(attributeMetaData);
        }
        return result;
    }

    private static String attributeMetaDataToInfoField(AttributeMetaData infoAttributeMetaData) {
        StringBuilder sb = new StringBuilder();
        sb.append("##INFO=<ID=");
        sb.append(infoAttributeMetaData.getName());
        sb.append(",Number=.");
        sb.append(",Type=");
        sb.append(VcfUtils.toVcfDataType(infoAttributeMetaData.getDataType().getEnumType()));
        sb.append(",Description=\"");
        if (StringUtils.isBlank((CharSequence)infoAttributeMetaData.getDescription())) {
            ((DefaultAttributeMetaData)infoAttributeMetaData).setDescription("Description not provided");
        }
        sb.append(infoAttributeMetaData.getDescription().replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", " "));
        sb.append("\">");
        return sb.toString();
    }

    private static String toVcfDataType(MolgenisFieldTypes.FieldTypeEnum dataType) {
        switch (dataType) {
            case BOOL: {
                return VcfMetaInfo.Type.FLAG.toString();
            }
            case LONG: 
            case DECIMAL: {
                return VcfMetaInfo.Type.FLOAT.toString();
            }
            case INT: {
                return VcfMetaInfo.Type.INTEGER.toString();
            }
            case EMAIL: 
            case ENUM: 
            case HTML: 
            case HYPERLINK: 
            case STRING: 
            case TEXT: 
            case DATE: 
            case DATE_TIME: 
            case CATEGORICAL: 
            case XREF: 
            case CATEGORICAL_MREF: 
            case MREF: {
                return VcfMetaInfo.Type.STRING.toString();
            }
            case COMPOUND: 
            case FILE: 
            case IMAGE: {
                throw new RuntimeException("invalid vcf data type " + dataType);
            }
        }
        throw new RuntimeException("unsupported vcf data type " + dataType);
    }

    public static HashMap<String, Trio> getPedigree(File inputVcfFile) throws FileNotFoundException {
        HashMap<String, Trio> result = new HashMap<String, Trio>();
        Scanner inputVcfFileScanner = new Scanner(inputVcfFile, "UTF-8");
        String line = inputVcfFileScanner.nextLine();
        if (line.startsWith("##")) {
            while (inputVcfFileScanner.hasNextLine()) {
                if (line.startsWith("##PEDIGREE")) {
                    String[] lineSplit;
                    System.out.println("Pedigree data line: " + line);
                    String childID = null;
                    String motherID = null;
                    String fatherID = null;
                    String lineStripped = line.replace("##PEDIGREE=<", "").replace(">", "");
                    for (String element : lineSplit = lineStripped.split(",", -1)) {
                        if (element.startsWith("Child")) {
                            childID = element.replace("Child=", "");
                            continue;
                        }
                        if (element.startsWith("Mother")) {
                            motherID = element.replace("Mother=", "");
                            continue;
                        }
                        if (element.startsWith("Father")) {
                            fatherID = element.replace("Father=", "");
                            continue;
                        }
                        inputVcfFileScanner.close();
                        throw new MolgenisDataException("Expected Child, Mother or Father, but found: " + element + " in line " + line);
                    }
                    if (childID != null && motherID != null && fatherID != null) {
                        result.put(childID, new Trio(new Sample(childID), new Sample(motherID), new Sample(fatherID)));
                    } else {
                        inputVcfFileScanner.close();
                        throw new MolgenisDataException("Missing Child, Mother or Father ID in line " + line);
                    }
                }
                if ((line = inputVcfFileScanner.nextLine()).startsWith("##")) continue;
            }
        }
        inputVcfFileScanner.close();
        return result;
    }
}

