/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.support.AbstractRepository;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.data.support.DefaultEntityMetaData;
import org.molgenis.data.support.MapEntity;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.vcf.VcfInfo;
import org.molgenis.vcf.VcfReader;
import org.molgenis.vcf.VcfRecord;
import org.molgenis.vcf.VcfSample;
import org.molgenis.vcf.meta.VcfMeta;
import org.molgenis.vcf.meta.VcfMetaFormat;
import org.molgenis.vcf.meta.VcfMetaInfo;

public class VcfRepository
extends AbstractRepository {
    private static final Logger logger = Logger.getLogger(VcfRepository.class);
    public static final String BASE_URL = "vcf://";
    public static final String CHROM = "#CHROM";
    public static final String ALT = "ALT";
    public static final String POS = "POS";
    public static final String REF = "REF";
    public static final String FILTER = "FILTER";
    public static final String QUAL = "QUAL";
    public static final String ID = "ID";
    public static final String INFO = "INFO";
    public static final String SAMPLES = "SAMPLES";
    public static final String NAME = "NAME";
    private final File file;
    private final String entityName;
    private DefaultEntityMetaData entityMetaData;
    private List<VcfReader> vcfReaderRegistry;
    private DefaultEntityMetaData sampleEntityMetaData;
    private boolean hasFormatMetaData;

    public VcfRepository(File file, String entityName) throws IOException {
        super(BASE_URL + file.getName());
        this.file = file;
        this.entityName = entityName;
    }

    public Iterator<Entity> iterator() {
        VcfReader vcfReader;
        try {
            vcfReader = this.createVcfReader();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final VcfReader finalVcfReader = vcfReader;
        return new Iterator<Entity>(){
            Iterator<VcfRecord> vcfRecordIterator;
            {
                this.vcfRecordIterator = finalVcfReader.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.vcfRecordIterator.hasNext();
            }

            @Override
            public Entity next() {
                MapEntity entity = new MapEntity();
                try {
                    VcfRecord vcfRecord = this.vcfRecordIterator.next();
                    entity.set(VcfRepository.CHROM, (Object)vcfRecord.getChromosome());
                    entity.set(VcfRepository.ALT, (Object)StringUtils.join((Iterable)Lists.transform((List)vcfRecord.getAlternateAlleles(), (Function)new Function<Allele, String>(){

                        public String apply(Allele allele) {
                            return allele.toString();
                        }
                    }), (char)','));
                    entity.set(VcfRepository.POS, (Object)vcfRecord.getPosition());
                    entity.set(VcfRepository.REF, (Object)vcfRecord.getReferenceAllele().toString());
                    entity.set(VcfRepository.FILTER, (Object)vcfRecord.getFilterStatus());
                    entity.set(VcfRepository.QUAL, (Object)vcfRecord.getQuality());
                    StringBuilder id = new StringBuilder();
                    id.append(StringUtils.strip((String)entity.get(VcfRepository.CHROM).toString()));
                    id.append("_");
                    id.append(StringUtils.strip((String)entity.get(VcfRepository.POS).toString()));
                    id.append("_");
                    id.append(StringUtils.strip((String)entity.get(VcfRepository.REF).toString()));
                    id.append("_");
                    id.append(StringUtils.strip((String)entity.get(VcfRepository.ALT).toString()));
                    entity.set(VcfRepository.ID, (Object)id.toString());
                    for (VcfInfo vcfInfo : vcfRecord.getInformation()) {
                        Object val = vcfInfo.getVal();
                        if (val instanceof List) {
                            val = StringUtils.join((Iterable)((List)val), (char)',');
                        }
                        entity.set(vcfInfo.getKey(), val);
                    }
                    if (VcfRepository.this.hasFormatMetaData) {
                        ArrayList<MapEntity> samples = new ArrayList<MapEntity>();
                        Iterator sampleIterator = vcfRecord.getSamples().iterator();
                        if (vcfRecord.getNrSamples() > 0) {
                            Iterator sampleNameIterator = finalVcfReader.getVcfMeta().getSampleNames().iterator();
                            while (sampleIterator.hasNext()) {
                                String[] format = vcfRecord.getFormat();
                                VcfSample sample = (VcfSample)sampleIterator.next();
                                MapEntity sampleEntity = new MapEntity((EntityMetaData)VcfRepository.this.sampleEntityMetaData);
                                for (int i = 0; i < format.length; ++i) {
                                    sampleEntity.set(format[i], (Object)sample.getData(i));
                                }
                                sampleEntity.set(VcfRepository.ID, (Object)UUID.randomUUID());
                                sampleEntity.set(VcfRepository.NAME, (Object)(entity.get(VcfRepository.POS) + "_" + entity.get(VcfRepository.ALT) + "_" + (String)sampleNameIterator.next()));
                                samples.add(sampleEntity);
                            }
                        }
                        entity.set(VcfRepository.SAMPLES, samples);
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Unable to load VCF metadata. " + e.getStackTrace()));
                }
                return entity;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityMetaData getEntityMetaData() {
        if (this.entityMetaData == null) {
            this.entityMetaData = new DefaultEntityMetaData(this.entityName);
            try {
                VcfMeta vcfMeta;
                try (VcfReader vcfReader = this.createVcfReader();){
                    vcfMeta = vcfReader.getVcfMeta();
                    Iterable formatMetaData = vcfReader.getVcfMeta().getFormatMeta();
                    this.createSampleEntityMetaData(formatMetaData);
                }
                this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(CHROM, MolgenisFieldTypes.FieldTypeEnum.STRING));
                this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(ALT, MolgenisFieldTypes.FieldTypeEnum.STRING));
                this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(POS, MolgenisFieldTypes.FieldTypeEnum.LONG));
                this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(REF, MolgenisFieldTypes.FieldTypeEnum.STRING));
                this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(FILTER, MolgenisFieldTypes.FieldTypeEnum.STRING));
                this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(QUAL, MolgenisFieldTypes.FieldTypeEnum.STRING));
                DefaultAttributeMetaData idAttributeMetaData = new DefaultAttributeMetaData(ID, MolgenisFieldTypes.FieldTypeEnum.STRING);
                idAttributeMetaData.setIdAttribute(true);
                this.entityMetaData.addAttributeMetaData((AttributeMetaData)idAttributeMetaData);
                DefaultAttributeMetaData infoMetaData = new DefaultAttributeMetaData(INFO, MolgenisFieldTypes.FieldTypeEnum.COMPOUND);
                ArrayList<DefaultAttributeMetaData> metadataInfoField = new ArrayList<DefaultAttributeMetaData>();
                for (VcfMetaInfo info : vcfMeta.getInfoMeta()) {
                    DefaultAttributeMetaData attributeMetaData = new DefaultAttributeMetaData(info.getId(), this.vcfReaderFormatToMolgenisType(info));
                    attributeMetaData.setDescription(info.getDescription());
                    metadataInfoField.add(attributeMetaData);
                }
                infoMetaData.setAttributesMetaData(metadataInfoField);
                this.entityMetaData.addAttributeMetaData((AttributeMetaData)infoMetaData);
                if (this.hasFormatMetaData) {
                    DefaultAttributeMetaData samplesAttributeMeta = new DefaultAttributeMetaData(SAMPLES, MolgenisFieldTypes.FieldTypeEnum.MREF);
                    samplesAttributeMeta.setRefEntity((EntityMetaData)this.sampleEntityMetaData);
                    this.entityMetaData.addAttributeMetaData((AttributeMetaData)samplesAttributeMeta);
                }
                this.entityMetaData.setIdAttribute(ID);
                this.entityMetaData.setLabelAttribute(ID);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.entityMetaData;
    }

    void createSampleEntityMetaData(Iterable<VcfMetaFormat> formatMetaData) {
        this.hasFormatMetaData = formatMetaData.iterator().hasNext();
        if (this.hasFormatMetaData) {
            this.sampleEntityMetaData = new DefaultEntityMetaData(this.entityName + "_Sample");
            DefaultAttributeMetaData idAttributeMetaData = new DefaultAttributeMetaData(ID, MolgenisFieldTypes.FieldTypeEnum.STRING);
            idAttributeMetaData.setIdAttribute(true);
            idAttributeMetaData.setVisible(false);
            this.sampleEntityMetaData.addAttributeMetaData((AttributeMetaData)idAttributeMetaData);
            DefaultAttributeMetaData nameAttributeMetaData = new DefaultAttributeMetaData(NAME, MolgenisFieldTypes.FieldTypeEnum.STRING);
            nameAttributeMetaData.setLabelAttribute(true);
            this.sampleEntityMetaData.addAttributeMetaData((AttributeMetaData)nameAttributeMetaData);
            for (VcfMetaFormat meta : formatMetaData) {
                DefaultAttributeMetaData attributeMetaData = new DefaultAttributeMetaData(meta.getId(), this.vcfFieldTypeToMolgenisFieldType(meta));
                this.sampleEntityMetaData.addAttributeMetaData((AttributeMetaData)attributeMetaData);
            }
        }
    }

    private MolgenisFieldTypes.FieldTypeEnum vcfReaderFormatToMolgenisType(VcfMetaInfo vcfMetaInfo) {
        boolean isListValue;
        String number = vcfMetaInfo.getNumber();
        try {
            isListValue = number.equals("A") || number.equals("R") || number.equals("G") || number.equals(".") || Integer.valueOf(number) > 1;
        }
        catch (NumberFormatException ex) {
            throw new GenotypeDataException("Error parsing length of vcf info field. " + number + " is not a valid int or expected preset (A, R, G, .)", (Throwable)ex);
        }
        switch (vcfMetaInfo.getType()) {
            case CHARACTER: {
                if (isListValue) {
                    return MolgenisFieldTypes.FieldTypeEnum.STRING;
                }
                return MolgenisFieldTypes.FieldTypeEnum.STRING;
            }
            case FLAG: {
                return MolgenisFieldTypes.FieldTypeEnum.BOOL;
            }
            case FLOAT: {
                if (isListValue) {
                    return MolgenisFieldTypes.FieldTypeEnum.STRING;
                }
                return MolgenisFieldTypes.FieldTypeEnum.DECIMAL;
            }
            case INTEGER: {
                if (isListValue) {
                    return MolgenisFieldTypes.FieldTypeEnum.STRING;
                }
                return MolgenisFieldTypes.FieldTypeEnum.INT;
            }
            case STRING: {
                if (isListValue) {
                    return MolgenisFieldTypes.FieldTypeEnum.STRING;
                }
                return MolgenisFieldTypes.FieldTypeEnum.STRING;
            }
        }
        throw new MolgenisDataException("unknown vcf info type [" + vcfMetaInfo.getType() + "]");
    }

    private MolgenisFieldTypes.FieldTypeEnum vcfFieldTypeToMolgenisFieldType(VcfMetaFormat format) {
        boolean isListValue;
        String number = format.getNumber();
        try {
            isListValue = number.equals("A") || number.equals("R") || number.equals("G") || number.equals(".") || Integer.valueOf(number) > 1;
        }
        catch (NumberFormatException ex) {
            throw new GenotypeDataException("Error parsing length of vcf info field. " + number + " is not a valid int or expected preset (A, R, G, .)", (Throwable)ex);
        }
        switch (format.getType()) {
            case CHARACTER: {
                if (isListValue) {
                    return MolgenisFieldTypes.FieldTypeEnum.STRING;
                }
                return MolgenisFieldTypes.FieldTypeEnum.STRING;
            }
            case FLOAT: {
                if (isListValue) {
                    return MolgenisFieldTypes.FieldTypeEnum.STRING;
                }
                return MolgenisFieldTypes.FieldTypeEnum.DECIMAL;
            }
            case INTEGER: {
                if (isListValue) {
                    return MolgenisFieldTypes.FieldTypeEnum.STRING;
                }
                return MolgenisFieldTypes.FieldTypeEnum.INT;
            }
            case STRING: {
                if (isListValue) {
                    return MolgenisFieldTypes.FieldTypeEnum.STRING;
                }
                return MolgenisFieldTypes.FieldTypeEnum.STRING;
            }
        }
        throw new MolgenisDataException("unknown vcf field type [" + format.getType() + "]");
    }

    private VcfReader createVcfReader() throws IOException {
        VcfReader reader = new VcfReader((Reader)new InputStreamReader((InputStream)new FileInputStream(this.file), Charset.forName("UTF-8")));
        if (this.vcfReaderRegistry == null) {
            this.vcfReaderRegistry = new ArrayList<VcfReader>();
        }
        this.vcfReaderRegistry.add(reader);
        return reader;
    }

    public void close() throws IOException {
        if (this.vcfReaderRegistry != null) {
            for (VcfReader vcfReader : this.vcfReaderRegistry) {
                try {
                    vcfReader.close();
                }
                catch (IOException e) {
                    logger.warn((Object)e);
                }
            }
        }
    }
}

