/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Repository;
import org.molgenis.data.processor.CellProcessor;
import org.molgenis.data.support.FileRepositoryCollection;
import org.molgenis.data.vcf.VcfRepository;

public class VcfRepositoryCollection
extends FileRepositoryCollection {
    private static final String EXTENSION_VCF = "vcf";
    private static final String EXTENSION_VCF_GZ = "vcf.gz";
    static final Set<String> EXTENSIONS = ImmutableSet.of((Object)"vcf", (Object)"vcf.gz");
    private final File file;
    private final String entityName;

    public VcfRepositoryCollection(File file) throws IOException {
        super(EXTENSIONS, new CellProcessor[0]);
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        this.file = file;
        String name = file.getName();
        if (name.endsWith(EXTENSION_VCF)) {
            this.entityName = name.substring(0, name.lastIndexOf(".vcf"));
        } else if (name.endsWith(EXTENSION_VCF_GZ)) {
            this.entityName = name.substring(0, name.lastIndexOf(".vcf.gz"));
        } else {
            throw new IllegalArgumentException("Not a VCF file [" + file.getName() + "]");
        }
    }

    public Iterable<String> getEntityNames() {
        return Collections.singleton(this.entityName);
    }

    public Repository getRepositoryByEntityName(String name) {
        if (!this.entityName.equals(name)) {
            throw new MolgenisDataException("Unknown entity name [" + name + "]");
        }
        try {
            return new VcfRepository(this.file, name);
        }
        catch (IOException e) {
            throw new MolgenisDataException((Throwable)e);
        }
    }
}

