/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.vcf.VcfReaderFactory;
import org.molgenis.vcf.VcfReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcfReaderFactoryImpl
implements VcfReaderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(VcfReaderFactoryImpl.class);
    private File file;
    private List<VcfReader> vcfReaderRegistry = Lists.newArrayList();

    public VcfReaderFactoryImpl(File file) {
        this.file = Objects.requireNonNull(file);
        Preconditions.checkArgument((boolean)file.exists());
    }

    public VcfReader get() {
        try {
            InputStream inputStream = new FileInputStream(this.file);
            if (this.file.getName().endsWith(".gz")) {
                inputStream = new GZIPInputStream(inputStream);
            } else if (this.file.getName().endsWith(".zip")) {
                ZipFile zipFile = new ZipFile(this.file.getPath());
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                ZipEntry entry = e.nextElement();
                inputStream = zipFile.getInputStream(entry);
            }
            VcfReader reader = new VcfReader((Reader)new InputStreamReader(inputStream, Charset.forName("UTF-8")));
            this.vcfReaderRegistry.add(reader);
            return reader;
        }
        catch (IOException e) {
            throw new MolgenisDataException("Failed to create VCF Reader for file" + this.file.getAbsolutePath(), (Throwable)e);
        }
    }

    protected void tryCloseVcfReader(VcfReader reader) {
        try {
            LOG.debug("Close VcfReader.");
            reader.close();
        }
        catch (Exception ex) {
            LOG.info("Failed to close VcfReader.", (Throwable)ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.vcfReaderRegistry.forEach(this::tryCloseVcfReader);
    }
}

