/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.support.AbstractRepository;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.data.vcf.VcfReaderFactory;
import org.molgenis.data.vcf.VcfReaderFactoryImpl;
import org.molgenis.data.vcf.format.VcfToEntity;
import org.molgenis.vcf.VcfReader;
import org.molgenis.vcf.meta.VcfMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcfRepository
extends AbstractRepository {
    private static final Logger LOG = LoggerFactory.getLogger(VcfRepository.class);
    public static final String DEFAULT_ATTRIBUTE_DESCRIPTION = "Description not provided";
    public static final String CHROM = "#CHROM";
    public static final String ALT = "ALT";
    public static final String POS = "POS";
    public static final String REF = "REF";
    public static final String FILTER = "FILTER";
    public static final String QUAL = "QUAL";
    public static final String ID = "ID";
    public static final String INTERNAL_ID = "INTERNAL_ID";
    public static final String INFO = "INFO";
    public static final String FORMAT_GT = "GT";
    public static final String SAMPLES = "SAMPLES_ENTITIES";
    public static final String NAME = "NAME";
    public static final String ORIGINAL_NAME = "ORIGINAL_NAME";
    public static final String PREFIX = "##";
    public static final AttributeMetaData CHROM_META = new DefaultAttributeMetaData("#CHROM", MolgenisFieldTypes.FieldTypeEnum.STRING).setAggregateable(true).setNillable(false).setDescription("The chromosome on which the variant is observed");
    public static final AttributeMetaData ALT_META = new DefaultAttributeMetaData("ALT", MolgenisFieldTypes.FieldTypeEnum.TEXT).setAggregateable(true).setNillable(false).setDescription("The alternative allele observed");
    public static final AttributeMetaData POS_META = new DefaultAttributeMetaData("POS", MolgenisFieldTypes.FieldTypeEnum.LONG).setAggregateable(true).setNillable(false).setDescription("The position on the chromosome which the variant is observed");
    public static final AttributeMetaData REF_META = new DefaultAttributeMetaData("REF", MolgenisFieldTypes.FieldTypeEnum.TEXT).setAggregateable(true).setNillable(false).setDescription("The reference allele");
    public static final AttributeMetaData FILTER_META = new DefaultAttributeMetaData("FILTER", MolgenisFieldTypes.FieldTypeEnum.STRING).setAggregateable(true).setNillable(true).setDescription("Description not provided");
    public static final AttributeMetaData QUAL_META = new DefaultAttributeMetaData("QUAL", MolgenisFieldTypes.FieldTypeEnum.STRING).setAggregateable(true).setNillable(true).setDescription("Description not provided");
    public static final AttributeMetaData ID_META = new DefaultAttributeMetaData("ID", MolgenisFieldTypes.FieldTypeEnum.STRING).setNillable(true).setDescription("Description not provided");
    public static final AttributeMetaData INFO_META = new DefaultAttributeMetaData("INFO", MolgenisFieldTypes.FieldTypeEnum.COMPOUND).setNillable(true);
    private final String entityName;
    protected Supplier<VcfToEntity> vcfToEntitySupplier;
    private VcfReaderFactory vcfReaderFactory;

    public VcfRepository(File file, String entityName) throws IOException {
        this(new VcfReaderFactoryImpl(file), entityName);
    }

    protected VcfRepository(VcfReaderFactory vcfReaderFactory, String entityName) {
        this.entityName = Objects.requireNonNull(entityName);
        this.vcfReaderFactory = vcfReaderFactory;
        this.vcfToEntitySupplier = Suppliers.memoize(this::parseVcfMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VcfToEntity parseVcfMeta() {
        VcfReader reader = (VcfReader)this.vcfReaderFactory.get();
        try {
            VcfMeta vcfMeta = reader.getVcfMeta();
            VcfToEntity vcfToEntity = new VcfToEntity(this.entityName, vcfMeta);
            return vcfToEntity;
        }
        catch (Exception e) {
            LOG.error("Failed to read VCF Metadata from file", (Throwable)e);
            VcfToEntity vcfToEntity = null;
            return vcfToEntity;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOG.info("Failed to close VcfReader", (Throwable)e);
            }
        }
    }

    public Iterator<Entity> iterator() {
        UnmodifiableIterator vcfRecordIterator = Iterators.unmodifiableIterator((Iterator)((VcfReader)this.vcfReaderFactory.get()).iterator());
        VcfToEntity vcfToEntity = (VcfToEntity)this.vcfToEntitySupplier.get();
        return Iterators.transform((Iterator)vcfRecordIterator, vcfToEntity::toEntity);
    }

    public EntityMetaData getEntityMetaData() {
        return ((VcfToEntity)this.vcfToEntitySupplier.get()).getEntityMetaData();
    }

    public void close() throws IOException {
        this.vcfReaderFactory.close();
    }

    public Set<RepositoryCapability> getCapabilities() {
        return Collections.emptySet();
    }

    public long count() {
        return Iterables.size((Iterable)((Object)this));
    }
}

