/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.format;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.base.Preconditions;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.meta.MetaValidationUtils;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.data.support.DefaultEntityMetaData;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.vcf.VcfRepository;
import org.molgenis.data.vcf.utils.VcfUtils;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.vcf.VcfInfo;
import org.molgenis.vcf.VcfRecord;
import org.molgenis.vcf.VcfSample;
import org.molgenis.vcf.meta.VcfMeta;
import org.molgenis.vcf.meta.VcfMetaFormat;
import org.molgenis.vcf.meta.VcfMetaInfo;

public class VcfToEntity {
    private final EntityMetaData entityMetaData;
    private final EntityMetaData sampleEntityMetaData;
    private final VcfMeta vcfMeta;

    public VcfToEntity(String entityName, VcfMeta vcfMeta) {
        this.vcfMeta = (VcfMeta)Preconditions.checkNotNull((Object)vcfMeta);
        this.sampleEntityMetaData = this.createSampleEntityMetaData((String)Preconditions.checkNotNull((Object)entityName), (Iterable)Preconditions.checkNotNull((Object)vcfMeta.getFormatMeta()));
        this.entityMetaData = this.createEntityMetaData(entityName, vcfMeta);
    }

    private EntityMetaData createSampleEntityMetaData(String entityName, Iterable<VcfMetaFormat> formatMetaData) {
        DefaultEntityMetaData result = null;
        if (formatMetaData.iterator().hasNext()) {
            result = new DefaultEntityMetaData(entityName + "_Sample");
            DefaultAttributeMetaData idAttributeMetaData = new DefaultAttributeMetaData("ID", MolgenisFieldTypes.FieldTypeEnum.STRING).setAggregateable(true);
            idAttributeMetaData.setVisible(false);
            result.addAttributeMetaData((AttributeMetaData)idAttributeMetaData, new EntityMetaData.AttributeRole[]{EntityMetaData.AttributeRole.ROLE_ID});
            DefaultAttributeMetaData nameAttributeMetaData = new DefaultAttributeMetaData("NAME", MolgenisFieldTypes.FieldTypeEnum.TEXT).setAggregateable(true);
            result.addAttributeMetaData((AttributeMetaData)nameAttributeMetaData, new EntityMetaData.AttributeRole[]{EntityMetaData.AttributeRole.ROLE_LABEL, EntityMetaData.AttributeRole.ROLE_LOOKUP});
            for (VcfMetaFormat meta : formatMetaData) {
                String name = meta.getId();
                if (MetaValidationUtils.KEYWORDS.contains(name) || MetaValidationUtils.KEYWORDS.contains(name.toUpperCase())) {
                    name = name + "_";
                }
                DefaultAttributeMetaData attributeMetaData = new DefaultAttributeMetaData(name.replaceAll("[-.*$&%^()#!@?]", "_"), VcfToEntity.vcfFieldTypeToMolgenisFieldType(meta)).setAggregateable(true).setLabel(meta.getId());
                result.addAttributeMetaData((AttributeMetaData)attributeMetaData, new EntityMetaData.AttributeRole[0]);
            }
        }
        return result;
    }

    private EntityMetaData createEntityMetaData(String entityName, VcfMeta vcfMeta) {
        DefaultEntityMetaData entityMetaData = new DefaultEntityMetaData(entityName);
        entityMetaData.addAttributeMetaData(VcfRepository.CHROM_META, new EntityMetaData.AttributeRole[0]);
        entityMetaData.addAttributeMetaData(VcfRepository.ALT_META, new EntityMetaData.AttributeRole[0]);
        entityMetaData.addAttributeMetaData(VcfRepository.POS_META, new EntityMetaData.AttributeRole[0]);
        entityMetaData.addAttributeMetaData(VcfRepository.REF_META, new EntityMetaData.AttributeRole[0]);
        entityMetaData.addAttributeMetaData(VcfRepository.FILTER_META, new EntityMetaData.AttributeRole[0]);
        entityMetaData.addAttributeMetaData(VcfRepository.QUAL_META, new EntityMetaData.AttributeRole[0]);
        entityMetaData.addAttributeMetaData(VcfRepository.ID_META, new EntityMetaData.AttributeRole[0]);
        DefaultAttributeMetaData idAttributeMetaData = new DefaultAttributeMetaData("INTERNAL_ID", MolgenisFieldTypes.FieldTypeEnum.STRING);
        idAttributeMetaData.setVisible(false);
        entityMetaData.addAttributeMetaData((AttributeMetaData)idAttributeMetaData, new EntityMetaData.AttributeRole[]{EntityMetaData.AttributeRole.ROLE_ID});
        DefaultAttributeMetaData infoMetaData = new DefaultAttributeMetaData("INFO", MolgenisFieldTypes.FieldTypeEnum.COMPOUND).setNillable(true);
        ArrayList<AttributeMetaData> metadataInfoField = new ArrayList<AttributeMetaData>();
        for (VcfMetaInfo info : vcfMeta.getInfoMeta()) {
            AttributeMetaData attributeMetaData2;
            String postFix = "";
            for (AttributeMetaData attributeMetaData2 : entityMetaData.getAtomicAttributes()) {
                if (!attributeMetaData2.getName().equals(info.getId())) continue;
                postFix = "_" + entityName;
            }
            String name = info.getId();
            if (MetaValidationUtils.KEYWORDS.contains(name) || MetaValidationUtils.KEYWORDS.contains(name.toUpperCase())) {
                name = name + "_";
            }
            attributeMetaData2 = new DefaultAttributeMetaData(name + postFix, VcfToEntity.vcfReaderFormatToMolgenisType(info)).setAggregateable(true);
            attributeMetaData2.setDescription(StringUtils.isBlank((CharSequence)info.getDescription()) ? "Description not provided" : info.getDescription());
            metadataInfoField.add(attributeMetaData2);
        }
        infoMetaData.setAttributesMetaData(metadataInfoField);
        entityMetaData.addAttributeMetaData((AttributeMetaData)infoMetaData, new EntityMetaData.AttributeRole[0]);
        if (this.sampleEntityMetaData != null) {
            DefaultAttributeMetaData samplesAttributeMeta = new DefaultAttributeMetaData("SAMPLES_ENTITIES", MolgenisFieldTypes.FieldTypeEnum.MREF).setRefEntity(this.sampleEntityMetaData).setLabel("SAMPLES");
            entityMetaData.addAttributeMetaData((AttributeMetaData)samplesAttributeMeta, new EntityMetaData.AttributeRole[0]);
        }
        return entityMetaData;
    }

    private static MolgenisFieldTypes.FieldTypeEnum vcfReaderFormatToMolgenisType(VcfMetaInfo vcfMetaInfo) {
        boolean isListValue;
        String number = vcfMetaInfo.getNumber();
        try {
            isListValue = number.equals("A") || number.equals("R") || number.equals("G") || number.equals(".") || Integer.parseInt(number) > 1;
        }
        catch (NumberFormatException ex) {
            throw new GenotypeDataException("Error parsing length of vcf info field. " + number + " is not a valid int or expected preset (A, R, G, .)", (Throwable)ex);
        }
        switch (vcfMetaInfo.getType()) {
            case CHARACTER: {
                if (isListValue) {
                    return MolgenisFieldTypes.FieldTypeEnum.STRING;
                }
                return MolgenisFieldTypes.FieldTypeEnum.STRING;
            }
            case FLAG: {
                return MolgenisFieldTypes.FieldTypeEnum.BOOL;
            }
            case FLOAT: {
                if (isListValue) {
                    return MolgenisFieldTypes.FieldTypeEnum.STRING;
                }
                return MolgenisFieldTypes.FieldTypeEnum.DECIMAL;
            }
            case INTEGER: {
                if (isListValue) {
                    return MolgenisFieldTypes.FieldTypeEnum.STRING;
                }
                return MolgenisFieldTypes.FieldTypeEnum.INT;
            }
            case STRING: {
                if (isListValue) {
                    return MolgenisFieldTypes.FieldTypeEnum.TEXT;
                }
                return MolgenisFieldTypes.FieldTypeEnum.TEXT;
            }
        }
        throw new MolgenisDataException("unknown vcf info type [" + vcfMetaInfo.getType() + "]");
    }

    private static MolgenisFieldTypes.FieldTypeEnum vcfFieldTypeToMolgenisFieldType(VcfMetaFormat format) {
        boolean isListValue;
        String number = format.getNumber();
        try {
            isListValue = number.equals("A") || number.equals("R") || number.equals("G") || number.equals(".") || Integer.parseInt(number) > 1;
        }
        catch (NumberFormatException ex) {
            throw new GenotypeDataException("Error parsing length of vcf info field. " + number + " is not a valid int or expected preset (A, R, G, .)", (Throwable)ex);
        }
        switch (format.getType()) {
            case CHARACTER: {
                if (isListValue) {
                    return MolgenisFieldTypes.FieldTypeEnum.STRING;
                }
                return MolgenisFieldTypes.FieldTypeEnum.STRING;
            }
            case FLOAT: {
                if (isListValue) {
                    return MolgenisFieldTypes.FieldTypeEnum.STRING;
                }
                return MolgenisFieldTypes.FieldTypeEnum.DECIMAL;
            }
            case INTEGER: {
                if (isListValue) {
                    return MolgenisFieldTypes.FieldTypeEnum.STRING;
                }
                return MolgenisFieldTypes.FieldTypeEnum.INT;
            }
            case STRING: {
                if (isListValue) {
                    return MolgenisFieldTypes.FieldTypeEnum.STRING;
                }
                return MolgenisFieldTypes.FieldTypeEnum.STRING;
            }
        }
        throw new MolgenisDataException("unknown vcf field type [" + format.getType() + "]");
    }

    public Entity toEntity(String[] tokens) {
        return this.toEntity(new VcfRecord(this.vcfMeta, tokens));
    }

    public Entity toEntity(VcfRecord vcfRecord) {
        MapEntity entity = new MapEntity(this.entityMetaData);
        entity.set("#CHROM", (Object)vcfRecord.getChromosome());
        entity.set("ALT", (Object)StringUtils.join((Iterable)Lists.transform((List)vcfRecord.getAlternateAlleles(), Allele::toString), (char)','));
        entity.set("POS", (Object)vcfRecord.getPosition());
        entity.set("REF", (Object)vcfRecord.getReferenceAllele().toString());
        entity.set("FILTER", (Object)vcfRecord.getFilterStatus());
        entity.set("QUAL", (Object)vcfRecord.getQuality());
        entity.set("ID", (Object)StringUtils.join((Iterable)vcfRecord.getIdentifiers(), (char)','));
        String id = VcfUtils.createId((Entity)entity);
        entity.set("INTERNAL_ID", (Object)id);
        this.writeInfoFieldsToEntity(vcfRecord, (Entity)entity);
        if (this.sampleEntityMetaData != null) {
            List<Entity> samples = this.createSampleEntities(vcfRecord, entity.get("POS") + "_" + entity.get("ALT"), id);
            entity.set("SAMPLES_ENTITIES", samples);
        }
        return entity;
    }

    protected List<Entity> createSampleEntities(VcfRecord vcfRecord, String entityPosAlt, String entityId) {
        ArrayList<Entity> samples = new ArrayList<Entity>();
        Iterator sampleIterator = vcfRecord.getSamples().iterator();
        if (vcfRecord.getNrSamples() > 0) {
            Iterator sampleNameIterator = this.vcfMeta.getSampleNames().iterator();
            int j = 0;
            while (sampleIterator.hasNext()) {
                String[] format = vcfRecord.getFormat();
                VcfSample sample = (VcfSample)sampleIterator.next();
                MapEntity sampleEntity = new MapEntity(this.sampleEntityMetaData);
                for (int i = 0; i < format.length; ++i) {
                    sampleEntity.set(format[i], (Object)sample.getData(i));
                }
                sampleEntity.set("ID", (Object)(entityId + j));
                String original_name = (String)sampleNameIterator.next();
                sampleEntity.set("NAME", (Object)(entityPosAlt + "_" + original_name));
                sampleEntity.set("ORIGINAL_NAME", (Object)original_name);
                samples.add((Entity)sampleEntity);
                ++j;
            }
        }
        return samples;
    }

    protected void writeInfoFieldsToEntity(VcfRecord vcfRecord, Entity entity) {
        ArrayList<String> names;
        String postFix;
        for (VcfMetaInfo info : this.vcfMeta.getInfoMeta()) {
            postFix = "";
            names = new ArrayList<String>();
            for (AttributeMetaData attributeMetaData : this.entityMetaData.getAttributes()) {
                if (!attributeMetaData.getName().equals(info.getId())) continue;
                names.add(attributeMetaData.getName());
            }
            if (names.contains(info.getId())) {
                postFix = "_" + entity.getEntityMetaData().getName();
            }
            if (!info.getType().equals((Object)VcfMetaInfo.Type.FLAG)) continue;
            entity.set(info.getId() + postFix, (Object)false);
        }
        for (VcfInfo vcfInfo : vcfRecord.getInformation()) {
            postFix = "";
            names = new ArrayList();
            for (AttributeMetaData attributeMetaData : this.entityMetaData.getAttributes()) {
                if (!attributeMetaData.getName().equals(vcfInfo.getKey())) continue;
                names.add(attributeMetaData.getName());
            }
            if (vcfInfo.getKey().equals(".")) continue;
            Object val = vcfInfo.getVal();
            if (val instanceof List) {
                val = StringUtils.join((Iterable)((List)val), (char)',');
            }
            if (val instanceof Float && Float.isNaN(((Float)val).floatValue())) {
                val = null;
            }
            if (val == null) {
                if (names.contains(vcfInfo.getKey())) {
                    postFix = "_" + entity.getEntityMetaData().getName();
                }
                if (!(vcfInfo.getKey() + postFix).equals(".") && this.entityMetaData.getAttribute(vcfInfo.getKey() + postFix) != null && this.entityMetaData.getAttribute(vcfInfo.getKey() + postFix).getDataType().getEnumType().equals((Object)MolgenisFieldTypes.FieldTypeEnum.BOOL)) {
                    val = true;
                }
            }
            if (val == null) continue;
            entity.set(vcfInfo.getKey() + postFix, val);
        }
    }

    public EntityMetaData getEntityMetaData() {
        return this.entityMetaData;
    }
}

