/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.importer;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.DatabaseAction;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.importer.EntitiesValidationReportImpl;
import org.molgenis.data.importer.ImportService;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.data.support.DefaultEntityMetaData;
import org.molgenis.data.support.GenericImporterExtensions;
import org.molgenis.framework.db.EntitiesValidationReport;
import org.molgenis.framework.db.EntityImportReport;
import org.molgenis.security.permission.PermissionSystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class VcfImporterService
implements ImportService {
    private static final Logger LOG = LoggerFactory.getLogger(VcfImporterService.class);
    private static final int BATCH_SIZE = 10000;
    private static final String BACKEND = "ElasticSearch";
    private final DataService dataService;
    private final PermissionSystemService permissionSystemService;

    @Autowired
    public VcfImporterService(DataService dataService, PermissionSystemService permissionSystemService) {
        this.dataService = Objects.requireNonNull(dataService);
        this.permissionSystemService = Objects.requireNonNull(permissionSystemService);
    }

    public EntityImportReport doImport(RepositoryCollection source, DatabaseAction databaseAction, String defaultPackage) {
        EntityImportReport report;
        block18: {
            if (databaseAction != DatabaseAction.ADD) {
                throw new IllegalArgumentException("Only ADD is supported");
            }
            ArrayList addedEntities = Lists.newArrayList();
            try {
                Iterator it = source.getEntityNames().iterator();
                if (it.hasNext()) {
                    try (Repository repo = source.getRepository((String)it.next());){
                        report = this.importVcf(repo, addedEntities);
                        break block18;
                    }
                }
                report = new EntityImportReport();
            }
            catch (Exception e) {
                LOG.error("Exception importing vcf", (Throwable)e);
                try {
                    this.dataService.getMeta().delete((List)addedEntities);
                }
                catch (Exception e1) {
                    LOG.error("Exception rollback changes", (Throwable)e1);
                }
                throw new MolgenisDataException((Throwable)e);
            }
        }
        return report;
    }

    public EntitiesValidationReport validateImport(File file, RepositoryCollection source) {
        EntitiesValidationReportImpl report = new EntitiesValidationReportImpl();
        Iterator it = source.getEntityNames().iterator();
        if (it.hasNext()) {
            String entityName = (String)it.next();
            EntityMetaData emd = source.getRepository(entityName).getEntityMetaData();
            boolean entityExists = this.dataService.hasRepository(entityName);
            report.getSheetsImportable().put(entityName, !entityExists);
            ArrayList availableAttributeNames = Lists.newArrayList();
            for (AttributeMetaData attr : emd.getAtomicAttributes()) {
                availableAttributeNames.add(attr.getName());
            }
            report.getFieldsImportable().put(entityName, availableAttributeNames);
            AttributeMetaData sampleAttribute = emd.getAttribute("SAMPLES_ENTITIES");
            if (sampleAttribute != null) {
                String sampleEntityName = sampleAttribute.getRefEntity().getName();
                boolean sampleEntityExists = this.dataService.hasRepository(sampleEntityName);
                report.getSheetsImportable().put(sampleEntityName, !sampleEntityExists);
                ArrayList availableSampleAttributeNames = Lists.newArrayList();
                for (AttributeMetaData attr : sampleAttribute.getRefEntity().getAtomicAttributes()) {
                    availableSampleAttributeNames.add(attr.getName());
                }
                report.getFieldsImportable().put(sampleEntityName, availableSampleAttributeNames);
            }
        }
        return report;
    }

    public boolean canImport(File file, RepositoryCollection source) {
        for (String extension : GenericImporterExtensions.getVCF()) {
            if (!file.getName().toLowerCase().endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private EntityImportReport importVcf(Repository inRepository, List<EntityMetaData> addedEntities) throws IOException {
        EntityImportReport report = new EntityImportReport();
        Repository sampleRepository = null;
        String entityName = inRepository.getName();
        if (this.dataService.hasRepository(entityName)) {
            throw new MolgenisDataException("Can't overwrite existing " + entityName);
        }
        DefaultEntityMetaData entityMetaData = new DefaultEntityMetaData(inRepository.getEntityMetaData());
        entityMetaData.setBackend(BACKEND);
        AttributeMetaData sampleAttribute = entityMetaData.getAttribute("SAMPLES_ENTITIES");
        if (sampleAttribute != null) {
            DefaultEntityMetaData samplesEntityMetaData = new DefaultEntityMetaData(sampleAttribute.getRefEntity());
            samplesEntityMetaData.setBackend(BACKEND);
            sampleRepository = this.dataService.getMeta().addEntityMeta((EntityMetaData)samplesEntityMetaData);
            this.permissionSystemService.giveUserEntityPermissions(SecurityContextHolder.getContext(), Collections.singletonList(samplesEntityMetaData.getName()));
            addedEntities.add(sampleAttribute.getRefEntity());
        }
        Iterator inIterator = inRepository.iterator();
        int sampleEntityCount = 0;
        ArrayList sampleEntities = new ArrayList();
        try (Repository outRepository = this.dataService.getMeta().addEntityMeta((EntityMetaData)entityMetaData);){
            this.permissionSystemService.giveUserEntityPermissions(SecurityContextHolder.getContext(), Collections.singletonList(entityMetaData.getName()));
            addedEntities.add((EntityMetaData)entityMetaData);
            if (sampleRepository != null) {
                while (inIterator.hasNext()) {
                    Entity entity2 = (Entity)inIterator.next();
                    Iterable samples = entity2.getEntities("SAMPLES_ENTITIES");
                    if (samples == null) continue;
                    Iterator sampleIterator = samples.iterator();
                    while (sampleIterator.hasNext()) {
                        sampleEntities.add(sampleIterator.next());
                        if (sampleEntities.size() != 10000) continue;
                        sampleRepository.add(sampleEntities.stream());
                        sampleEntityCount += sampleEntities.size();
                        sampleEntities.clear();
                    }
                }
                if (!sampleEntities.isEmpty()) {
                    sampleRepository.add(sampleEntities.stream());
                    sampleEntityCount += sampleEntities.size();
                }
                sampleRepository.flush();
                report.addNewEntity(sampleRepository.getName());
                if (sampleEntityCount > 0) {
                    report.addEntityCount(sampleRepository.getName(), sampleEntityCount);
                }
            }
            AtomicInteger vcfEntityCount = new AtomicInteger();
            outRepository.add(inRepository.stream().filter(entity -> {
                vcfEntityCount.incrementAndGet();
                return true;
            }));
            if (vcfEntityCount.get() > 0) {
                report.addEntityCount(entityName, vcfEntityCount.get());
            }
        }
        report.addNewEntity(entityName);
        return report;
    }

    public int getOrder() {
        return 10;
    }

    public List<DatabaseAction> getSupportedDatabaseActions() {
        return Lists.newArrayList((Object[])new DatabaseAction[]{DatabaseAction.ADD});
    }

    public boolean getMustChangeEntityName() {
        return true;
    }

    public Set<String> getSupportedFileExtensions() {
        return GenericImporterExtensions.getVCF();
    }

    public LinkedHashMap<String, Boolean> integrationTestMetaData(MetaDataService metaDataService, RepositoryCollection repositoryCollection, String defaultPackage) {
        return metaDataService.integrationTestMetaData(repositoryCollection);
    }
}

