/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.utils;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.io.BaseEncoding;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.data.support.DefaultEntityMetaData;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.vcf.VcfRepository;
import org.molgenis.data.vcf.datastructures.Sample;
import org.molgenis.data.vcf.datastructures.Trio;
import org.molgenis.vcf.meta.VcfMetaInfo;

public class VcfUtils {
    public static String createId(Entity vcfEntity) {
        MessageDigest messageDigest;
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(org.apache.commons.lang3.StringUtils.strip((String)vcfEntity.get("#CHROM").toString()));
        strBuilder.append("_");
        strBuilder.append(org.apache.commons.lang3.StringUtils.strip((String)vcfEntity.get("POS").toString()));
        strBuilder.append("_");
        strBuilder.append(org.apache.commons.lang3.StringUtils.strip((String)vcfEntity.get("REF").toString()));
        strBuilder.append("_");
        strBuilder.append(org.apache.commons.lang3.StringUtils.strip((String)vcfEntity.get("ALT").toString()));
        String idStr = strBuilder.toString();
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] md5Hash = messageDigest.digest(idStr.getBytes(Charset.forName("UTF-8")));
        String id = BaseEncoding.base64Url().omitPadding().encode(md5Hash);
        return id;
    }

    public static String getIdFromInfoField(String line) {
        int idStartIndex = line.indexOf("ID=") + 3;
        int idEndIndex = line.indexOf(44);
        return line.substring(idStartIndex, idEndIndex);
    }

    public static List<AttributeMetaData> getAtomicAttributesFromList(Iterable<AttributeMetaData> outputAttrs) {
        ArrayList<AttributeMetaData> result = new ArrayList<AttributeMetaData>();
        for (AttributeMetaData attributeMetaData : outputAttrs) {
            if (attributeMetaData.getDataType().getEnumType().equals((Object)MolgenisFieldTypes.FieldTypeEnum.COMPOUND)) {
                result.addAll(VcfUtils.getAtomicAttributesFromList(attributeMetaData.getAttributeParts()));
                continue;
            }
            result.add(attributeMetaData);
        }
        return result;
    }

    public static Map<String, AttributeMetaData> getAttributesMapFromList(Iterable<AttributeMetaData> outputAttrs) {
        LinkedHashMap<String, AttributeMetaData> attributeMap = new LinkedHashMap<String, AttributeMetaData>();
        List<AttributeMetaData> attributes = VcfUtils.getAtomicAttributesFromList(outputAttrs);
        for (AttributeMetaData attributeMetaData : attributes) {
            attributeMap.put(attributeMetaData.getName(), attributeMetaData);
        }
        return attributeMap;
    }

    public static String toVcfDataType(MolgenisFieldTypes.FieldTypeEnum dataType) {
        switch (dataType) {
            case BOOL: {
                return VcfMetaInfo.Type.FLAG.toString();
            }
            case LONG: 
            case DECIMAL: {
                return VcfMetaInfo.Type.FLOAT.toString();
            }
            case INT: {
                return VcfMetaInfo.Type.INTEGER.toString();
            }
            case EMAIL: 
            case ENUM: 
            case HTML: 
            case HYPERLINK: 
            case STRING: 
            case TEXT: 
            case DATE: 
            case DATE_TIME: 
            case CATEGORICAL: 
            case XREF: 
            case CATEGORICAL_MREF: 
            case MREF: {
                return VcfMetaInfo.Type.STRING.toString();
            }
        }
        throw new RuntimeException("unsupported vcf data type " + dataType);
    }

    public static Iterator<Entity> reverseXrefMrefRelation(final Iterator<Entity> annotatedRecords) {
        return new Iterator<Entity>(){
            PeekingIterator<Entity> effects;
            DefaultEntityMetaData resultEMD;
            EntityMetaData effectsEMD;
            {
                this.effects = Iterators.peekingIterator((Iterator)annotatedRecords);
            }

            private void createResultEntityMetaData(Entity effect, EntityMetaData variantEMD) {
                if (this.resultEMD == null || this.effectsEMD == null) {
                    this.effectsEMD = effect.getEntityMetaData();
                    this.resultEMD = new DefaultEntityMetaData(variantEMD);
                    this.resultEMD.addAttribute("EFFECT", new EntityMetaData.AttributeRole[0]).setDataType(MolgenisFieldTypes.MREF).setRefEntity(this.effectsEMD);
                }
            }

            @Override
            public boolean hasNext() {
                return this.effects.hasNext();
            }

            private Entity createEntityStructure(Entity variant, List<Entity> effectsForVariant) {
                this.createResultEntityMetaData(effectsForVariant.get(0), variant.getEntityMetaData());
                MapEntity newVariant = new MapEntity(variant, (EntityMetaData)this.resultEMD);
                if (effectsForVariant.size() > 1) {
                    newVariant.set("EFFECT", effectsForVariant);
                } else {
                    Entity entity = effectsForVariant.get(0);
                    boolean isEmpty = true;
                    for (AttributeMetaData attr : this.effectsEMD.getAtomicAttributes()) {
                        if (attr.getName().equals(this.effectsEMD.getIdAttribute().getName()) || attr.getName().equals("VARIANT") || entity.get(attr.getName()) == null) continue;
                        isEmpty = false;
                        break;
                    }
                    if (!isEmpty) {
                        newVariant.set("EFFECT", effectsForVariant);
                    }
                }
                return newVariant;
            }

            @Override
            public Entity next() {
                Entity variant = null;
                ArrayList effectsForVariant = autovalue.shaded.com.google.common.common.collect.Lists.newArrayList();
                while (this.effects.hasNext()) {
                    String peekedId = ((Entity)this.effects.peek()).getEntity("VARIANT").getIdValue().toString();
                    if (variant == null || variant.getIdValue().toString().equals(peekedId)) {
                        Entity effect = (Entity)this.effects.next();
                        variant = effect.getEntity("VARIANT");
                        effectsForVariant.add(effect);
                        continue;
                    }
                    return this.createEntityStructure(variant, effectsForVariant);
                }
                return this.createEntityStructure(variant, effectsForVariant);
            }
        };
    }

    public static List<Entity> createEntityStructureForVcf(EntityMetaData entityMetaData, String attributeName, Stream<Entity> inputStream) {
        return VcfUtils.createEntityStructureForVcf(entityMetaData, attributeName, inputStream, Collections.emptyList());
    }

    public static List<Entity> createEntityStructureForVcf(EntityMetaData entityMetaData, String attributeName, Stream<Entity> inputStream, List<AttributeMetaData> annotatorAttributes) {
        AttributeMetaData attributeToParse = entityMetaData.getAttribute(attributeName);
        String description = attributeToParse.getDescription();
        if (description.indexOf(58) == -1) {
            throw new RuntimeException("Unable to create entitystructure, missing semicolon in description of [" + attributeName + "]");
        }
        String[] step1 = description.split(":");
        String entityName = StringUtils.deleteWhitespace((String)step1[0]);
        String value = step1[1].replaceAll("^\\s'|'$", "");
        Map<Integer, AttributeMetaData> metadataMap = VcfUtils.parseDescription(value, annotatorAttributes);
        DefaultEntityMetaData xrefMetaData = VcfUtils.getXrefEntityMetaData(metadataMap, entityName);
        ArrayList<Entity> results = new ArrayList<Entity>();
        for (Entity inputEntity : inputStream.collect(Collectors.toList())) {
            DefaultEntityMetaData newEntityMetadata = VcfUtils.removeRefFieldFromInfoMetadata(attributeToParse, inputEntity);
            MapEntity originalEntity = new MapEntity(inputEntity, (EntityMetaData)newEntityMetadata);
            results.addAll(VcfUtils.parseValue((EntityMetaData)xrefMetaData, metadataMap, inputEntity.getString(attributeToParse.getName()), (Entity)originalEntity));
        }
        return results;
    }

    private static DefaultEntityMetaData getXrefEntityMetaData(Map<Integer, AttributeMetaData> metadataMap, String entityName) {
        DefaultEntityMetaData xrefMetaData = new DefaultEntityMetaData(entityName);
        xrefMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData("identifier").setAuto(true).setVisible(false), new EntityMetaData.AttributeRole[]{EntityMetaData.AttributeRole.ROLE_ID});
        xrefMetaData.addAllAttributeMetaData((Iterable)Lists.newArrayList(metadataMap.values()));
        xrefMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData("Variant", MolgenisFieldTypes.FieldTypeEnum.MREF), new EntityMetaData.AttributeRole[0]);
        return xrefMetaData;
    }

    private static DefaultEntityMetaData removeRefFieldFromInfoMetadata(AttributeMetaData attributeToParse, Entity inputEntity) {
        DefaultEntityMetaData newMeta = (DefaultEntityMetaData)inputEntity.getEntityMetaData();
        DefaultAttributeMetaData newInfoMetadata = (DefaultAttributeMetaData)newMeta.getAttribute("INFO");
        newInfoMetadata.setAttributesMetaData((Iterable)StreamSupport.stream(newMeta.getAttribute("INFO").getAttributeParts().spliterator(), false).filter(attr -> !attr.getName().equals(attributeToParse.getName())).collect(Collectors.toList()));
        newMeta.removeAttributeMetaData(VcfRepository.INFO_META);
        newMeta.addAttributeMetaData((AttributeMetaData)newInfoMetadata, new EntityMetaData.AttributeRole[0]);
        return newMeta;
    }

    private static Map<Integer, AttributeMetaData> parseDescription(String description, List<AttributeMetaData> annotatorAttributes) {
        String value = description.replaceAll("^\\s'|'$", "");
        String[] attributeStrings = value.split("\\|");
        HashMap<Integer, AttributeMetaData> attributeMap = new HashMap<Integer, AttributeMetaData>();
        Map<String, AttributeMetaData> annotatorAttributeMap = VcfUtils.getAttributesMapFromList(annotatorAttributes);
        for (int i = 0; i < attributeStrings.length; ++i) {
            String attribute = attributeStrings[i];
            MolgenisFieldTypes.FieldTypeEnum type = annotatorAttributeMap.containsKey(attribute) ? annotatorAttributeMap.get(attribute).getDataType().getEnumType() : MolgenisFieldTypes.FieldTypeEnum.STRING;
            DefaultAttributeMetaData attr = new DefaultAttributeMetaData(StringUtils.deleteWhitespace((String)attribute), type).setLabel(attribute);
            attributeMap.put(i, (AttributeMetaData)attr);
        }
        return attributeMap;
    }

    private static List<Entity> parseValue(EntityMetaData metadata, Map<Integer, AttributeMetaData> attributesMap, String value, Entity originalEntity) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        String[] valuesPerEntity = value.split(",");
        Integer i = 0;
        while (i < valuesPerEntity.length) {
            String[] values = valuesPerEntity[i].split("\\|");
            MapEntity singleResult = new MapEntity(metadata);
            Integer j = 0;
            while (j < values.length) {
                String attributeName = attributesMap.get(j).getName().replaceAll("^'|'$", "");
                String attributeValue = values[j];
                singleResult.set(attributeName, (Object)attributeValue);
                singleResult.set("Variant", (Object)originalEntity);
                Integer n = j;
                Integer n2 = j = Integer.valueOf(j + 1);
            }
            result.add((Entity)singleResult);
            Integer n = i;
            Integer n3 = i = Integer.valueOf(i + 1);
        }
        return result;
    }

    public static HashMap<String, Trio> getPedigree(Scanner inputVcfFileScanner) throws FileNotFoundException {
        String line;
        HashMap<String, Trio> result = new HashMap<String, Trio>();
        while (inputVcfFileScanner.hasNextLine() && (line = inputVcfFileScanner.nextLine()).startsWith("##")) {
            String[] lineSplit;
            if (!line.startsWith("##PEDIGREE")) continue;
            System.out.println("Pedigree data line: " + line);
            String childID = null;
            String motherID = null;
            String fatherID = null;
            String lineStripped = line.replace("##PEDIGREE=<", "").replace(">", "");
            for (String element : lineSplit = lineStripped.split(",", -1)) {
                if (element.startsWith("Child")) {
                    childID = element.replace("Child=", "");
                    continue;
                }
                if (element.startsWith("Mother")) {
                    motherID = element.replace("Mother=", "");
                    continue;
                }
                if (element.startsWith("Father")) {
                    fatherID = element.replace("Father=", "");
                    continue;
                }
                throw new MolgenisDataException("Expected Child, Mother or Father, but found: " + element + " in line " + line);
            }
            if (childID != null && motherID != null && fatherID != null) {
                result.put(childID, new Trio(new Sample(childID), new Sample(motherID), new Sample(fatherID)));
                continue;
            }
            throw new MolgenisDataException("Missing Child, Mother or Father ID in line " + line);
        }
        return result;
    }
}

