/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.utils;

import autovalue.shaded.com.google.common.common.collect.Lists;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.MolgenisInvalidFormatException;
import org.molgenis.data.vcf.utils.VcfUtils;

public class VcfWriterUtils {
    public static final String VARIANT = "VARIANT";
    public static final String EFFECT = "EFFECT";
    public static final char ANNOTATION_FIELD_SEPARATOR = ';';
    public static final String SPACE_PIPE_SEPERATOR = " | ";
    private static final LinkedList<String> VCF_ATTRIBUTE_NAMES = new LinkedList<String>(Arrays.asList("#CHROM", "POS", "ID", "REF", "ALT", "QUAL", "FILTER"));
    private static final char PIPE_SEPARATOR = '|';

    public static void writeVcfHeader(File inputVcfFile, BufferedWriter outputVCFWriter, List<AttributeMetaData> addedAttributes) throws MolgenisInvalidFormatException, IOException {
        VcfWriterUtils.writeVcfHeader(inputVcfFile, outputVCFWriter, addedAttributes, Collections.emptyList());
    }

    public static void writeVcfHeader(File inputVcfFile, BufferedWriter outputVCFWriter, List<AttributeMetaData> addedAttributes, List<String> attributesToInclude) throws MolgenisInvalidFormatException, IOException {
        System.out.println("Detecting VCF column header...");
        Scanner inputVcfFileScanner = new Scanner(inputVcfFile, "UTF-8");
        String line = inputVcfFileScanner.nextLine();
        LinkedHashMap<String, String> infoHeaderLinesMap = new LinkedHashMap<String, String>();
        if (!line.startsWith("##")) {
            outputVCFWriter.close();
            inputVcfFileScanner.close();
            throw new MolgenisInvalidFormatException("Did not find ## on the first line, are you sure it is a VCF file?");
        }
        line = VcfWriterUtils.processHeaders(outputVCFWriter, inputVcfFileScanner, line, infoHeaderLinesMap);
        System.out.println("\nHeader line found:\n" + line);
        VcfWriterUtils.checkColumnHeaders(outputVCFWriter, inputVcfFileScanner, line);
        VcfWriterUtils.writeInfoHeaders(outputVCFWriter, addedAttributes, attributesToInclude, infoHeaderLinesMap);
        VcfWriterUtils.writeColumnHeaders(outputVCFWriter, line);
        inputVcfFileScanner.close();
    }

    public static void writeToVcf(Entity vcfEntity, List<AttributeMetaData> addedAttributes, List<String> attributesToInclude, BufferedWriter writer) throws MolgenisDataException, IOException {
        VcfWriterUtils.addStandardFieldsToVcf(vcfEntity, writer);
        VcfWriterUtils.writeInfoData(vcfEntity, writer, addedAttributes, attributesToInclude);
        Iterable sampleEntities = vcfEntity.getEntities("SAMPLES_ENTITIES");
        if (sampleEntities != null) {
            VcfWriterUtils.addSampleEntitiesToVcf(sampleEntities, writer);
        }
    }

    private static String processHeaders(BufferedWriter outputVCFWriter, Scanner inputVcfFileScanner, String line, Map<String, String> infoHeaderLinesMap) throws IOException {
        while (inputVcfFileScanner.hasNextLine()) {
            if (line.startsWith("##INFO")) {
                infoHeaderLinesMap.put(VcfUtils.getIdFromInfoField(line), line);
            } else {
                if (!line.startsWith("##")) break;
                outputVCFWriter.write(line);
                outputVCFWriter.newLine();
            }
            line = inputVcfFileScanner.nextLine();
            System.out.print(".");
        }
        return line;
    }

    private static void checkColumnHeaders(BufferedWriter outputVCFWriter, Scanner inputVcfFileScanner, String line) throws IOException, MolgenisInvalidFormatException {
        if (!line.startsWith("#CHROM")) {
            outputVCFWriter.close();
            inputVcfFileScanner.close();
            throw new MolgenisInvalidFormatException("Header does not start with #CHROM, are you sure it is a VCF file?");
        }
    }

    private static void writeColumnHeaders(BufferedWriter outputVCFWriter, String line) throws IOException {
        outputVCFWriter.write(line);
        outputVCFWriter.newLine();
    }

    private static void writeInfoHeaders(BufferedWriter outputVCFWriter, List<AttributeMetaData> annotatorAttributes, List<String> attributesToInclude, Map<String, String> infoHeaderLinesMap) throws IOException {
        Map<String, AttributeMetaData> annotatorAttributesMap = VcfUtils.getAttributesMapFromList(annotatorAttributes);
        VcfWriterUtils.writeExistingInfoHeaders(outputVCFWriter, infoHeaderLinesMap, annotatorAttributesMap);
        VcfWriterUtils.writeAddedInfoHeaders(outputVCFWriter, attributesToInclude, annotatorAttributesMap, infoHeaderLinesMap);
    }

    private static void writeAddedInfoHeaders(BufferedWriter outputVCFWriter, List<String> attributesToInclude, Map<String, AttributeMetaData> annotatorAttributes, Map<String, String> infoHeaderLinesMap) throws IOException {
        for (AttributeMetaData annotatorInfoAttr : annotatorAttributes.values()) {
            if (!attributesToInclude.isEmpty() && !attributesToInclude.contains(annotatorInfoAttr.getName()) && !annotatorInfoAttr.getDataType().equals((Object)MolgenisFieldTypes.XREF) && !annotatorInfoAttr.getDataType().equals((Object)MolgenisFieldTypes.MREF)) continue;
            outputVCFWriter.write(VcfWriterUtils.createInfoStringFromAttribute(annotatorAttributes.get(annotatorInfoAttr.getName()), attributesToInclude, infoHeaderLinesMap.get(annotatorInfoAttr.getName())));
            outputVCFWriter.newLine();
        }
    }

    private static String createInfoStringFromAttribute(AttributeMetaData infoAttributeMetaData, List<String> attributesToInclude, String currentInfoField) {
        String attributeName = infoAttributeMetaData.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("##INFO=<ID=");
        sb.append(attributeName);
        sb.append(",Number=.");
        sb.append(",Type=");
        sb.append(VcfUtils.toVcfDataType(infoAttributeMetaData.getDataType().getEnumType()));
        sb.append(",Description=\"");
        if (StringUtils.isBlank((CharSequence)infoAttributeMetaData.getDescription())) {
            if ((infoAttributeMetaData.getDataType().equals((Object)MolgenisFieldTypes.MREF) || infoAttributeMetaData.getDataType().equals((Object)MolgenisFieldTypes.XREF)) && !attributeName.equals("SAMPLES_ENTITIES")) {
                String currentAttributesString = currentInfoField != null ? currentInfoField.substring(currentInfoField.indexOf("'") + 1, currentInfoField.lastIndexOf("'")) : "";
                VcfWriterUtils.writeRefAttributePartsToInfoDescription(infoAttributeMetaData, attributesToInclude, attributeName, sb, currentAttributesString);
            } else {
                sb.append("Description not provided");
            }
        } else {
            sb.append(infoAttributeMetaData.getDescription().replace("\"", "\\\"").replace("\n", " "));
        }
        sb.append("\">");
        return sb.toString();
    }

    private static void writeRefAttributePartsToInfoDescription(AttributeMetaData infoAttributeMetaData, List<String> attributesToInclude, String attributeName, StringBuilder sb, String existingAttributes) {
        Iterable atomicAttributes = infoAttributeMetaData.getRefEntity().getAtomicAttributes();
        sb.append(attributeName);
        sb.append(" annotations: '");
        if (!existingAttributes.isEmpty()) {
            sb.append(existingAttributes);
            sb.append(SPACE_PIPE_SEPERATOR);
        }
        sb.append(VcfWriterUtils.refAttributesToString(atomicAttributes, attributesToInclude).replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", " "));
        sb.append("'");
    }

    private static String refAttributesToString(final Iterable<AttributeMetaData> atomicAttributes, final List<String> attributesToInclude) {
        Iterable attributes = Iterables.filter(atomicAttributes, (Predicate)new Predicate<AttributeMetaData>(){

            public boolean apply(AttributeMetaData attributeMetaData) {
                return attributeMetaData.isVisible() && VcfWriterUtils.isOutputAttribute(attributeMetaData, Lists.newArrayList((Iterable)atomicAttributes), attributesToInclude);
            }
        });
        return Joiner.on((String)SPACE_PIPE_SEPERATOR).join(Iterables.transform((Iterable)attributes, AttributeMetaData::getName));
    }

    private static void writeExistingInfoHeaders(BufferedWriter outputVCFWriter, Map<String, String> infoHeaderLinesMap, Map<String, AttributeMetaData> annotatorAttributes) throws IOException {
        for (String infoHeaderFieldKey : infoHeaderLinesMap.keySet()) {
            if (annotatorAttributes.containsKey(infoHeaderFieldKey)) continue;
            outputVCFWriter.write(infoHeaderLinesMap.get(infoHeaderFieldKey));
            outputVCFWriter.newLine();
        }
    }

    private static void addStandardFieldsToVcf(Entity vcfEntity, BufferedWriter writer) throws IOException {
        for (String attribute : VCF_ATTRIBUTE_NAMES) {
            String value = vcfEntity.getString(attribute);
            if (value != null && !value.isEmpty()) {
                writer.write(value);
            } else {
                writer.write(46);
            }
            writer.write(9);
        }
    }

    private static void writeInfoData(Entity vcfEntity, BufferedWriter writer, List<AttributeMetaData> annotatorAttributes, List<String> attributesToInclude) throws IOException {
        boolean hasInfoFields = false;
        for (AttributeMetaData attributeMetaData : vcfEntity.getEntityMetaData().getAttribute("INFO").getAttributeParts()) {
            if (!VcfWriterUtils.isOutputAttribute(attributeMetaData, annotatorAttributes, attributesToInclude)) continue;
            hasInfoFields = VcfWriterUtils.writeSingleInfoField(vcfEntity, writer, hasInfoFields, attributeMetaData);
        }
        String refEntityAttributesInfoFields = VcfWriterUtils.parseRefAttributesToDataString(vcfEntity, annotatorAttributes, attributesToInclude);
        if (!Strings.isNullOrEmpty((String)refEntityAttributesInfoFields)) {
            writer.append(refEntityAttributesInfoFields);
            hasInfoFields = true;
        }
        if (!hasInfoFields) {
            writer.append('.');
        }
    }

    private static String parseRefAttributesToDataString(Entity vcfEntity, List<AttributeMetaData> annotatorAttributes, List<String> attributesToInclude) {
        Iterable attributes = vcfEntity.getEntityMetaData().getAttributes();
        StringBuilder refEntityInfoFields = new StringBuilder();
        for (AttributeMetaData attribute : attributes) {
            String attributeName = attribute.getName();
            if (!attribute.getDataType().equals((Object)MolgenisFieldTypes.MREF) && !attribute.getDataType().equals((Object)MolgenisFieldTypes.XREF) || attributeName.equals("SAMPLES_ENTITIES") || vcfEntity.get(attributeName) == null || !VcfWriterUtils.isOutputAttribute(attribute, annotatorAttributes, attributesToInclude)) continue;
            VcfWriterUtils.parseRefFieldsToInfoField(vcfEntity.getEntities(attributeName), attribute, refEntityInfoFields, annotatorAttributes, attributesToInclude);
        }
        return refEntityInfoFields.toString();
    }

    private static boolean writeSingleInfoField(Entity vcfEntity, BufferedWriter writer, boolean hasInfoFields, AttributeMetaData attributeMetaData) throws IOException {
        String infoAttrName = attributeMetaData.getName();
        if (attributeMetaData.getDataType().getEnumType() == MolgenisFieldTypes.FieldTypeEnum.BOOL) {
            Boolean infoAttrBoolValue = vcfEntity.getBoolean(infoAttrName);
            if (infoAttrBoolValue != null && infoAttrBoolValue.booleanValue()) {
                writer.append(infoAttrName);
                writer.append(';');
                hasInfoFields = true;
            }
        } else {
            String infoAttrStringValue = vcfEntity.getString(infoAttrName);
            if (infoAttrStringValue != null) {
                writer.append(infoAttrName);
                writer.append('=');
                writer.append(infoAttrStringValue);
                writer.append(';');
                hasInfoFields = true;
            }
        }
        return hasInfoFields;
    }

    private static void parseRefFieldsToInfoField(Iterable<Entity> refEntities, AttributeMetaData attribute, StringBuilder refEntityInfoFields, List<AttributeMetaData> annotatorAttributes, List<String> attributesToInclude) {
        boolean secondValuePresent = false;
        for (Entity refEntity : refEntities) {
            Iterable refAttributes = refEntity.getEntityMetaData().getAttributes();
            if (!secondValuePresent) {
                refEntityInfoFields.append(attribute.getName());
                refEntityInfoFields.append("=");
                VcfWriterUtils.addEntityValuesToRefEntityInfoField(refEntityInfoFields, refEntity, refAttributes, annotatorAttributes, attributesToInclude);
            } else {
                refEntityInfoFields.append(",");
                VcfWriterUtils.addEntityValuesToRefEntityInfoField(refEntityInfoFields, refEntity, refAttributes, annotatorAttributes, attributesToInclude);
            }
            secondValuePresent = true;
        }
        refEntityInfoFields.append(';');
    }

    private static void addEntityValuesToRefEntityInfoField(StringBuilder refEntityInfoFields, Entity refEntity, Iterable<AttributeMetaData> refAttributes, List<AttributeMetaData> annotatorAttributes, List<String> attributesToInclude) {
        boolean previousValuePresent = false;
        for (AttributeMetaData refAttribute : refAttributes) {
            if (!refAttribute.isVisible() || refAttribute.getDataType() == MolgenisFieldTypes.XREF || refAttribute.getDataType().equals((Object)MolgenisFieldTypes.MREF) || !VcfWriterUtils.isOutputAttribute(refAttribute, annotatorAttributes, attributesToInclude)) continue;
            if (previousValuePresent) {
                refEntityInfoFields.append('|');
            }
            String value = refEntity.getString(refAttribute.getName()) == null ? "" : refEntity.getString(refAttribute.getName());
            refEntityInfoFields.append(value);
            previousValuePresent = true;
        }
    }

    private static void addSampleEntitiesToVcf(Iterable<Entity> sampleEntities, BufferedWriter writer) throws IOException {
        boolean first = true;
        for (Entity sample : sampleEntities) {
            writer.append('\t');
            if (first) {
                VcfWriterUtils.writeFormatString(writer, sample);
            }
            VcfWriterUtils.writeSampleData(writer, sample);
            first = false;
        }
    }

    private static void writeSampleData(BufferedWriter writer, Entity sample) throws IOException {
        StringBuilder sampleColumn = new StringBuilder();
        if (sample.getEntityMetaData().getAttribute("GT") != null) {
            String sampleAttrValue = sample.getString("GT");
            if (sampleAttrValue != null) {
                sampleColumn.append(sampleAttrValue);
            } else {
                sampleColumn.append(".");
            }
        }
        EntityMetaData entityMetadata = sample.getEntityMetaData();
        for (AttributeMetaData sampleAttribute : entityMetadata.getAttributes()) {
            String sampleAttrValue;
            String sampleAttributeName = sampleAttribute.getName();
            if (sampleAttributeName.equals("GT") || sampleAttribute.equals(entityMetadata.getIdAttribute()) || sampleAttribute.equals(entityMetadata.getLabelAttribute())) continue;
            if (sampleColumn.length() != 0) {
                sampleColumn.append(":");
            }
            if ((sampleAttrValue = sample.getString(sampleAttributeName)) != null) {
                sampleColumn.append(sampleAttrValue);
                continue;
            }
            sampleColumn.append(".");
        }
        writer.write(sampleColumn.toString());
    }

    private static void writeFormatString(BufferedWriter writer, Entity sample) throws IOException {
        StringBuilder formatColumn = new StringBuilder();
        if (sample.getEntityMetaData().getAttribute("GT") != null) {
            formatColumn.append("GT");
        }
        EntityMetaData entityMetadata = sample.getEntityMetaData();
        for (AttributeMetaData sampleAttribute : entityMetadata.getAttributes()) {
            String sampleAttributeName = sampleAttribute.getName();
            if (sampleAttributeName.equals("GT") || sampleAttribute.equals(entityMetadata.getIdAttribute()) || sampleAttribute.equals(entityMetadata.getLabelAttribute())) continue;
            if (formatColumn.length() != 0) {
                formatColumn.append(':');
            }
            formatColumn.append(sampleAttributeName);
        }
        if (formatColumn.length() <= 0) {
            throw new MolgenisDataException("Missing FORMAT information while trying to print first sample");
        }
        formatColumn.append('\t');
        writer.write(formatColumn.toString());
    }

    private static boolean isOutputAttribute(AttributeMetaData attribute, List<AttributeMetaData> addedAttributes, List<String> attributesToInclude) {
        ArrayList<AttributeMetaData> expandedAddedAttributes = new ArrayList<AttributeMetaData>();
        for (AttributeMetaData annotatorAttr : addedAttributes) {
            if (annotatorAttr.getDataType().equals((Object)MolgenisFieldTypes.XREF) || annotatorAttr.getDataType().equals((Object)MolgenisFieldTypes.MREF)) {
                expandedAddedAttributes.addAll(Lists.newArrayList((Iterable)annotatorAttr.getRefEntity().getAtomicAttributes()));
                continue;
            }
            expandedAddedAttributes.add(annotatorAttr);
        }
        List annotatorAttributeNames = expandedAddedAttributes.stream().map(AttributeMetaData::getName).collect(Collectors.toList());
        if (!annotatorAttributeNames.contains(attribute.getName())) {
            return true;
        }
        return attributesToInclude.contains(attribute.getName()) || attributesToInclude.isEmpty();
    }
}

