/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.importer;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.DatabaseAction;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.FileRepositoryCollectionFactory;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.RepositoryDecoratorFactory;
import org.molgenis.data.elasticsearch.ElasticsearchRepository;
import org.molgenis.data.elasticsearch.SearchService;
import org.molgenis.data.importer.EntitiesValidationReportImpl;
import org.molgenis.data.importer.ImportService;
import org.molgenis.data.support.FileRepositoryCollection;
import org.molgenis.framework.db.EntitiesValidationReport;
import org.molgenis.framework.db.EntityImportReport;
import org.molgenis.security.permission.PermissionSystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class VcfImporterService
implements ImportService {
    private static final List<String> SUPPORTED_FILE_EXTENSIONS = Arrays.asList("vcf", "vcf.gz");
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private final FileRepositoryCollectionFactory fileRepositoryCollectionFactory;
    private final DataService dataService;
    private final SearchService searchService;
    private final RepositoryDecoratorFactory repositoryDecoratorFactory;
    private final PermissionSystemService permissionSystemService;

    @Autowired
    public VcfImporterService(FileRepositoryCollectionFactory fileRepositoryCollectionFactory, DataService dataService, SearchService searchService, RepositoryDecoratorFactory repositoryDecoratorFactory, PermissionSystemService permissionSystemService) {
        if (fileRepositoryCollectionFactory == null) {
            throw new IllegalArgumentException("fileRepositoryCollectionFactory is null");
        }
        if (dataService == null) {
            throw new IllegalArgumentException("dataservice is null");
        }
        if (searchService == null) {
            throw new IllegalArgumentException("seachservice is null");
        }
        if (repositoryDecoratorFactory == null) {
            throw new IllegalArgumentException("repositoryDecoratorFactory is null");
        }
        if (permissionSystemService == null) {
            throw new IllegalArgumentException("permissionSystemService is null");
        }
        this.fileRepositoryCollectionFactory = fileRepositoryCollectionFactory;
        this.dataService = dataService;
        this.searchService = searchService;
        this.repositoryDecoratorFactory = repositoryDecoratorFactory;
        this.permissionSystemService = permissionSystemService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityImportReport doImport(RepositoryCollection source, DatabaseAction databaseAction) {
        EntityImportReport report;
        block9: {
            if (databaseAction != DatabaseAction.ADD) {
                throw new IllegalArgumentException("Only ADD is supported");
            }
            ArrayList addedEntities = Lists.newArrayList();
            try {
                Iterator it = source.getEntityNames().iterator();
                if (it.hasNext()) {
                    Repository repo = source.getRepositoryByEntityName((String)it.next());
                    try {
                        report = this.importVcf(repo, 1000, addedEntities);
                        List entityNames = addedEntities.stream().map(emd -> emd.getName()).collect(Collectors.toList());
                        this.permissionSystemService.giveUserEntityAndMenuPermissions(SecurityContextHolder.getContext(), entityNames);
                        break block9;
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)repo);
                    }
                }
                report = new EntityImportReport();
            }
            catch (Exception e) {
                for (EntityMetaData emd2 : addedEntities) {
                    if (this.dataService.hasRepository(emd2.getName())) {
                        this.dataService.removeRepository(emd2.getName());
                    }
                    if (!this.searchService.hasMapping(emd2)) continue;
                    this.searchService.delete(emd2.getName());
                }
                throw new MolgenisDataException((Throwable)e);
            }
        }
        return report;
    }

    public EntitiesValidationReport validateImport(File file, RepositoryCollection source) {
        EntitiesValidationReportImpl report = new EntitiesValidationReportImpl();
        Iterator it = source.getEntityNames().iterator();
        if (it.hasNext()) {
            String entityName = (String)it.next();
            EntityMetaData emd = source.getRepositoryByEntityName(entityName).getEntityMetaData();
            boolean entityExists = this.dataService.hasRepository(entityName);
            report.getSheetsImportable().put(entityName, !entityExists);
            ArrayList availableAttributeNames = Lists.newArrayList();
            for (AttributeMetaData attr : emd.getAtomicAttributes()) {
                availableAttributeNames.add(attr.getName());
            }
            report.getFieldsImportable().put(entityName, availableAttributeNames);
            AttributeMetaData sampleAttribute = emd.getAttribute("SAMPLES");
            if (sampleAttribute != null) {
                boolean sampleEntityExists = this.dataService.hasRepository(entityName);
                String sampleEntityName = sampleAttribute.getRefEntity().getName();
                report.getSheetsImportable().put(sampleEntityName, !sampleEntityExists);
                ArrayList availableSampleAttributeNames = Lists.newArrayList();
                for (AttributeMetaData attr : sampleAttribute.getRefEntity().getAtomicAttributes()) {
                    availableSampleAttributeNames.add(attr.getName());
                }
                report.getFieldsImportable().put(sampleEntityName, availableSampleAttributeNames);
            }
        }
        return report;
    }

    public boolean canImport(File file, RepositoryCollection source) {
        for (String extension : SUPPORTED_FILE_EXTENSIONS) {
            if (!file.getName().toLowerCase().endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importVcf(File vcfFile) throws IOException {
        FileRepositoryCollection repositoryCollection = this.fileRepositoryCollectionFactory.createFileRepositoryCollection(vcfFile);
        Iterator it = repositoryCollection.getEntityNames().iterator();
        if (it.hasNext()) {
            Repository repo = repositoryCollection.getRepositoryByEntityName((String)it.next());
            try {
                this.importVcf(repo, 1000, Lists.newArrayList());
            }
            finally {
                IOUtils.closeQuietly((Closeable)repo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityImportReport importVcf(Repository inRepository, int batchSize, List<EntityMetaData> addedEntities) throws IOException {
        EntityImportReport report = new EntityImportReport();
        ElasticsearchRepository sampleRepository = null;
        String entityName = inRepository.getName();
        if (this.dataService.hasRepository(entityName)) {
            throw new MolgenisDataException("Can't overwrite existing " + entityName);
        }
        EntityMetaData entityMetaData = inRepository.getEntityMetaData();
        ElasticsearchRepository outRepository = new ElasticsearchRepository(entityMetaData, this.searchService);
        this.searchService.createMappings(entityMetaData, true, true, true, true);
        addedEntities.add(entityMetaData);
        AttributeMetaData sampleAttribute = entityMetaData.getAttribute("SAMPLES");
        if (sampleAttribute != null) {
            sampleRepository = new ElasticsearchRepository(sampleAttribute.getRefEntity(), this.searchService);
            this.searchService.createMappings(sampleAttribute.getRefEntity(), true, true, true, true);
            addedEntities.add(sampleAttribute.getRefEntity());
        }
        Iterator inIterator = inRepository.iterator();
        int vcfEntityCount = 0;
        int sampleEntityCount = 0;
        try {
            ArrayList sampleEntities = new ArrayList();
            while (inIterator.hasNext()) {
                Iterable samples;
                Entity entity = (Entity)inIterator.next();
                ++vcfEntityCount;
                if (sampleRepository == null || (samples = entity.getEntities("SAMPLES")) == null) continue;
                Iterator sampleIterator = samples.iterator();
                while (sampleIterator.hasNext()) {
                    sampleEntities.add(sampleIterator.next());
                    if (sampleEntities.size() != batchSize) continue;
                    sampleRepository.add(sampleEntities);
                    sampleEntityCount += sampleEntities.size();
                    sampleEntities.clear();
                }
            }
            outRepository.add((Iterable)inRepository);
            if (sampleRepository != null) {
                sampleRepository.add(sampleEntities);
                sampleEntityCount += sampleEntities.size();
            }
        }
        finally {
            outRepository.close();
        }
        this.dataService.addRepository(this.repositoryDecoratorFactory.createDecoratedRepository((Repository)outRepository));
        report.addNewEntity(entityName);
        if (sampleRepository != null) {
            this.dataService.addRepository((Repository)sampleRepository);
            report.addNewEntity(sampleRepository.getName());
            if (sampleEntityCount > 0) {
                report.addEntityCount(sampleRepository.getName(), sampleEntityCount);
            }
        }
        if (vcfEntityCount > 0) {
            report.addEntityCount(entityName, vcfEntityCount);
        }
        return report;
    }

    public int getOrder() {
        return 10;
    }

    public List<DatabaseAction> getSupportedDatabaseActions() {
        return Lists.newArrayList((Object[])new DatabaseAction[]{DatabaseAction.ADD});
    }

    public boolean getMustChangeEntityName() {
        return true;
    }
}

