/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.utils;

import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.molgenis.data.AbstractMolgenisSpringTest;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.MolgenisInvalidFormatException;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.support.DynamicEntity;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.molgenis.data.vcf.utils.VcfWriterUtils;
import org.molgenis.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.ContextConfiguration;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@ContextConfiguration(classes={Config.class})
public class VcfWriterUtilsIT
extends AbstractMolgenisSpringTest {
    @Autowired
    EntityTypeFactory entityTypeFactory;
    @Autowired
    AttributeFactory attributeFactory;
    @Autowired
    VcfAttributes vcfAttributes;
    private static final Logger LOG = LoggerFactory.getLogger(VcfWriterUtilsIT.class);
    public static final String ID = "ID";
    public static final String PUTATIVE_IMPACT = "Putative_impact";
    public static final String TYPE = "TYPE";
    public static final String VARIANT = "VARIANT";
    public static final String EFFECT = "EFFECT";
    public static final String GENES = "GENES";
    public static final String GTC = "GTC";
    public static final String AN = "AN";
    public static final String AC = "AC";
    private static Attribute INFO_ATTR;
    private static Attribute GTC_ATTR;
    private static Attribute AC_ATTR;
    private static Attribute AN_ATTR;
    private static Attribute PUTATIVE_IMPACT_ATTR;
    private static Attribute EFFECT_ATTR;
    private static Attribute GENES_ATTR;
    private EntityType annotatedEntityType;
    public EntityType metaDataCanAnnotate;
    public EntityType metaDataCantAnnotate;
    public EntityType geneMeta;
    EntityType effectMeta;
    EntityType vcfMeta;
    EntityType sampleEntityType;
    public Attribute attributeChrom;
    public Attribute attributePos;
    public Attribute attributeRef;
    public Attribute attributeAlt;
    public Attribute attributeCantAnnotateChrom;
    public Entity entity;
    public Entity entity1;
    public Entity entity2;
    public Entity entity3;
    public Entity entity4;
    public ArrayList<Entity> entities;

    @BeforeMethod
    public void beforeMethod() throws IOException {
        this.annotatedEntityType = (EntityType)this.entityTypeFactory.create((Object)"test");
        this.metaDataCanAnnotate = (EntityType)this.entityTypeFactory.create((Object)"test");
        this.metaDataCantAnnotate = (EntityType)this.entityTypeFactory.create((Object)"test");
        this.geneMeta = (EntityType)this.entityTypeFactory.create((Object)GENES);
        this.effectMeta = (EntityType)this.entityTypeFactory.create((Object)EFFECT);
        this.vcfMeta = (EntityType)this.entityTypeFactory.create((Object)"vcfMeta");
        this.sampleEntityType = (EntityType)this.entityTypeFactory.create((Object)"vcfSampleEntity");
        this.attributeChrom = this.attributeFactory.create().setName("#CHROM").setDataType(AttributeType.STRING).setIdAttribute(Boolean.valueOf(true));
        this.attributePos = this.attributeFactory.create().setName("POS").setDataType(AttributeType.INT);
        this.attributeRef = this.attributeFactory.create().setName("REF").setDataType(AttributeType.STRING);
        this.attributeAlt = this.attributeFactory.create().setName("ALT").setDataType(AttributeType.STRING);
        this.attributeCantAnnotateChrom = this.attributeFactory.create().setName("#CHROM").setDataType(AttributeType.LONG).setIdAttribute(Boolean.valueOf(true));
        this.metaDataCanAnnotate.addAttribute(this.attributePos, new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(this.attributeChrom, new EntityType.AttributeRole[0]);
        this.metaDataCantAnnotate.addAttribute(this.attributeCantAnnotateChrom, new EntityType.AttributeRole[0]);
        this.metaDataCantAnnotate.addAttribute(this.attributePos, new EntityType.AttributeRole[0]);
        this.metaDataCantAnnotate.addAttribute(this.attributeRef, new EntityType.AttributeRole[0]);
        this.metaDataCantAnnotate.addAttribute(this.attributeAlt, new EntityType.AttributeRole[0]);
        this.entity = new DynamicEntity(this.metaDataCanAnnotate);
        this.entity1 = new DynamicEntity(this.metaDataCanAnnotate);
        this.entity2 = new DynamicEntity(this.metaDataCanAnnotate);
        this.entity3 = new DynamicEntity(this.metaDataCanAnnotate);
        this.entity4 = new DynamicEntity(this.metaDataCanAnnotate);
        this.metaDataCanAnnotate.addAttribute(this.attributeFactory.create().setName(ID).setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(this.attributeRef, new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(this.attributeAlt, new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(this.attributeFactory.create().setName("QUAL").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(this.attributeFactory.create().setName("FILTER").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        INFO_ATTR = this.attributeFactory.create().setName("INFO").setDataType(AttributeType.COMPOUND);
        AC_ATTR = this.attributeFactory.create().setName(AC).setDataType(AttributeType.STRING).setParent(INFO_ATTR);
        AN_ATTR = this.attributeFactory.create().setName(AN).setDataType(AttributeType.STRING).setParent(INFO_ATTR);
        GTC_ATTR = this.attributeFactory.create().setName(GTC).setDataType(AttributeType.STRING).setParent(INFO_ATTR);
        this.metaDataCanAnnotate.addAttribute(INFO_ATTR, new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(AC_ATTR, new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(AN_ATTR, new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(GTC_ATTR, new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(this.attributeChrom, new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(this.attributePos, new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(this.attributeFactory.create().setName(ID).setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(this.attributeRef, new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(this.attributeAlt, new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(this.attributeFactory.create().setName("QUAL").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(this.attributeFactory.create().setName("FILTER").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]).setDescription("Test that description is not: 'Description not provided'");
        Attribute annoAttr = this.attributeFactory.create().setName("ANNO").setDataType(AttributeType.STRING).setParent(INFO_ATTR);
        this.annotatedEntityType.addAttribute(INFO_ATTR, new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(AC_ATTR, new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(AN_ATTR, new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(GTC_ATTR, new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(annoAttr, new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(annoAttr, new EntityType.AttributeRole[0]);
        this.entity1.set("#CHROM", (Object)"1");
        this.entity1.set("POS", (Object)10050000);
        this.entity1.set(ID, (Object)"test21");
        this.entity1.set("REF", (Object)"G");
        this.entity1.set("ALT", (Object)"A");
        this.entity1.set("QUAL", (Object)".");
        this.entity1.set("FILTER", (Object)"PASS");
        this.entity1.set(AC, (Object)"21");
        this.entity1.set(AN, (Object)"22");
        this.entity1.set(GTC, (Object)"0,1,10");
        this.entity2.set("#CHROM", (Object)"1");
        this.entity2.set("POS", (Object)10050001);
        this.entity2.set(ID, (Object)"test22");
        this.entity2.set("REF", (Object)"G");
        this.entity2.set("ALT", (Object)"A");
        this.entity2.set("QUAL", (Object)".");
        this.entity2.set("FILTER", (Object)"PASS");
        this.entity3.set("#CHROM", (Object)"1");
        this.entity3.set("POS", (Object)10050002);
        this.entity3.set(ID, (Object)"test23");
        this.entity3.set("REF", (Object)"G");
        this.entity3.set("ALT", (Object)"A");
        this.entity3.set("QUAL", (Object)".");
        this.entity3.set("FILTER", (Object)"PASS");
        this.entities = new ArrayList();
        this.entities.add(this.entity1);
        this.entities.add(this.entity2);
        this.entities.add(this.entity3);
        Attribute geneId = this.attributeFactory.create().setName("id").setDataType(AttributeType.STRING).setDescription("Random generated ID").setVisible(false).setIdAttribute(Boolean.valueOf(true));
        this.geneMeta.addAttribute(geneId, new EntityType.AttributeRole[0]);
        this.geneMeta.addAttribute(this.attributeFactory.create().setName("Gene").setDataType(AttributeType.STRING).setDescription("HGNC symbol"), new EntityType.AttributeRole[0]);
        Attribute id = this.attributeFactory.create().setName("id").setDataType(AttributeType.STRING).setDescription("effect identifier").setVisible(false).setIdAttribute(Boolean.valueOf(true));
        this.effectMeta.addAttribute(id, new EntityType.AttributeRole[0]);
        this.effectMeta.addAttribute(this.attributeFactory.create().setName("ALT").setDataType(AttributeType.STRING).setDescription("Alternative allele"), new EntityType.AttributeRole[0]);
        this.effectMeta.addAttribute(this.attributeFactory.create().setName("ALT_GENE").setDataType(AttributeType.STRING).setDescription("Alternative allele and gene"), new EntityType.AttributeRole[0]);
        this.effectMeta.addAttribute(this.attributeFactory.create().setName("GENE").setDataType(AttributeType.STRING).setDescription("Gene identifier (HGNC symbol)"), new EntityType.AttributeRole[0]);
        this.effectMeta.addAttribute(this.attributeFactory.create().setName(PUTATIVE_IMPACT).setDataType(AttributeType.STRING).setDescription("Level of effect on the gene"), new EntityType.AttributeRole[0]);
        this.effectMeta.addAttribute(this.attributeFactory.create().setName(TYPE).setDataType(AttributeType.STRING).setDescription("Type of mutation"), new EntityType.AttributeRole[0]);
        PUTATIVE_IMPACT_ATTR = this.attributeFactory.create().setName(PUTATIVE_IMPACT).setDataType(AttributeType.STRING);
        EFFECT_ATTR = this.attributeFactory.create().setName(EFFECT).setDataType(AttributeType.MREF).setRefEntity(this.effectMeta);
        GENES_ATTR = this.attributeFactory.create().setName(GENES).setDataType(AttributeType.MREF).setRefEntity(this.geneMeta);
        String formatDpAttrName = "DP";
        String formatEcAttrName = "EC";
        String formatGtAttrName = "GT";
        String sampleIdAttrName = "NAME";
        Attribute sampleId = this.attributeFactory.create().setName(sampleIdAttrName).setIdAttribute(Boolean.valueOf(true));
        this.sampleEntityType.addAttribute(sampleId, new EntityType.AttributeRole[0]);
        this.sampleEntityType.addAttribute(this.attributeFactory.create().setName(formatDpAttrName), new EntityType.AttributeRole[0]);
        this.sampleEntityType.addAttribute(this.attributeFactory.create().setName(formatEcAttrName), new EntityType.AttributeRole[0]);
        this.sampleEntityType.addAttribute(this.attributeFactory.create().setName(formatGtAttrName), new EntityType.AttributeRole[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void convertToVcfInfoGtFirst() throws MolgenisDataException, IOException {
        String formatDpAttrName = "DP";
        String formatEcAttrName = "EC";
        String formatGtAttrName = "GT";
        String idAttrName = "idAttr";
        String sampleIdAttrName = "NAME";
        EntityType sampleEntityType = (EntityType)this.entityTypeFactory.create((Object)"vcfSampleEntity");
        Attribute sampleId = this.attributeFactory.create().setName(sampleIdAttrName).setIdAttribute(Boolean.valueOf(true));
        sampleEntityType.addAttribute(sampleId, new EntityType.AttributeRole[0]);
        sampleEntityType.addAttribute(this.attributeFactory.create().setName(formatDpAttrName), new EntityType.AttributeRole[0]);
        sampleEntityType.addAttribute(this.attributeFactory.create().setName(formatEcAttrName), new EntityType.AttributeRole[0]);
        sampleEntityType.addAttribute(this.attributeFactory.create().setName(formatGtAttrName), new EntityType.AttributeRole[0]);
        EntityType entityType = (EntityType)this.entityTypeFactory.create((Object)"vcfEntity");
        Attribute id = this.attributeFactory.create().setName(idAttrName).setIdAttribute(Boolean.valueOf(true));
        entityType.addAttribute(id, new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.vcfAttributes.getChromAttribute(), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.vcfAttributes.getPosAttribute(), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.vcfAttributes.getIdAttribute(), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.vcfAttributes.getRefAttribute(), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.vcfAttributes.getAltAttribute(), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.vcfAttributes.getQualAttribute(), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.vcfAttributes.getFilterAttribute(), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.attributeFactory.create().setName("INFO").setDataType(AttributeType.COMPOUND), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.attributeFactory.create().setName("SAMPLES_ENTITIES").setDataType(AttributeType.MREF).setRefEntity(sampleEntityType), new EntityType.AttributeRole[0]);
        DynamicEntity sampleEntity = new DynamicEntity(sampleEntityType);
        sampleEntity.set(sampleIdAttrName, (Object)"0");
        sampleEntity.set(formatDpAttrName, (Object)"5");
        sampleEntity.set(formatEcAttrName, (Object)"5");
        sampleEntity.set(formatGtAttrName, (Object)"1/1");
        DynamicEntity vcfEntity = new DynamicEntity(entityType);
        vcfEntity.set(idAttrName, (Object)"0");
        vcfEntity.set("#CHROM", (Object)"1");
        vcfEntity.set("POS", (Object)565286);
        vcfEntity.set(ID, (Object)"rs1578391");
        vcfEntity.set("REF", (Object)"C");
        vcfEntity.set("ALT", (Object)"T");
        vcfEntity.set("QUAL", null);
        vcfEntity.set("FILTER", (Object)"flt");
        vcfEntity.set("INFO", null);
        vcfEntity.set("SAMPLES_ENTITIES", (Object)Lists.newArrayList((Object[])new Entity[]{sampleEntity}));
        StringWriter strWriter = new StringWriter();
        try (BufferedWriter writer = new BufferedWriter(strWriter);){
            VcfWriterUtils.writeToVcf((Entity)vcfEntity, (List)Lists.newArrayList(), (List)Lists.newArrayList(), (BufferedWriter)writer);
        }
        Assert.assertEquals((String)strWriter.toString(), (String)"1\t565286\trs1578391\tC\tT\t.\tflt\tidAttr=0\tGT:DP:EC\t1/1:5:5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void vcfWriterRoundtripTest() throws IOException, MolgenisInvalidFormatException {
        File outputVCFFile = File.createTempFile("output", ".vcf");
        try {
            BufferedWriter outputVCFWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputVCFFile), StandardCharsets.UTF_8));
            File inputVcfFile = new File(ResourceUtils.getFile(((Object)((Object)this)).getClass(), (String)"/testWriter.vcf").getPath());
            VcfWriterUtils.writeVcfHeader((File)inputVcfFile, (BufferedWriter)outputVCFWriter, Collections.emptyList());
            for (Entity entity : this.entities) {
                VcfWriterUtils.writeToVcf((Entity)entity, new ArrayList(), new ArrayList(), (BufferedWriter)outputVCFWriter);
                outputVCFWriter.newLine();
            }
            outputVCFWriter.close();
            Assert.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)inputVcfFile, (File)outputVCFFile, (String)"UTF8"));
            boolean outputVCFFileIsDeleted = outputVCFFile.delete();
            LOG.info("Result test file named: " + outputVCFFile.getName() + " is " + (outputVCFFileIsDeleted ? "" : "not ") + "deleted");
        }
        catch (Throwable throwable) {
            boolean outputVCFFileIsDeleted = outputVCFFile.delete();
            LOG.info("Result test file named: " + outputVCFFile.getName() + " is " + (outputVCFFileIsDeleted ? "" : "not ") + "deleted");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void vcfWriterAnnotateTest() throws IOException, MolgenisInvalidFormatException {
        this.entity1.set("ANNO", (Object)"TEST_test21");
        this.entity2.set("ANNO", (Object)"TEST_test22");
        File outputVCFFile = File.createTempFile("output", ".vcf");
        try {
            BufferedWriter outputVCFWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputVCFFile), StandardCharsets.UTF_8));
            File inputVcfFile = new File(ResourceUtils.getFile(((Object)((Object)this)).getClass(), (String)"/testWriter.vcf").getPath());
            File resultVCFWriter = new File(ResourceUtils.getFile(((Object)((Object)this)).getClass(), (String)"/result_vcfWriter.vcf").getPath());
            VcfWriterUtils.writeVcfHeader((File)inputVcfFile, (BufferedWriter)outputVCFWriter, (List)Lists.newArrayList(Collections.singletonList(this.attributeFactory.create().setName("ANNO"))));
            for (Entity entity : this.entities) {
                DynamicEntity mapEntity = new DynamicEntity(this.annotatedEntityType);
                mapEntity.set(entity);
                VcfWriterUtils.writeToVcf((Entity)mapEntity, new ArrayList(), new ArrayList(), (BufferedWriter)outputVCFWriter);
                outputVCFWriter.newLine();
            }
            outputVCFWriter.close();
            Assert.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)resultVCFWriter, (File)outputVCFFile, (String)"UTF8"));
            boolean outputVCFFileIsDeleted = outputVCFFile.delete();
            LOG.info("Result test file named: " + outputVCFFile.getName() + " is " + (outputVCFFileIsDeleted ? "" : "not ") + "deleted");
        }
        catch (Throwable throwable) {
            boolean outputVCFFileIsDeleted = outputVCFFile.delete();
            LOG.info("Result test file named: " + outputVCFFile.getName() + " is " + (outputVCFFileIsDeleted ? "" : "not ") + "deleted");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void vcfWriteMrefTest() throws IOException, MolgenisInvalidFormatException {
        File actualOutputFile = File.createTempFile("output", ".vcf");
        Attribute attr = this.attributeFactory.create().setName("#CHROM").setDataType(AttributeType.STRING).setIdAttribute(Boolean.valueOf(true));
        this.vcfMeta.addAttribute(attr, new EntityType.AttributeRole[0]);
        this.vcfMeta.addAttribute(this.attributeFactory.create().setName("POS").setDataType(AttributeType.INT), new EntityType.AttributeRole[0]);
        this.vcfMeta.addAttribute(this.attributeFactory.create().setName(ID).setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.vcfMeta.addAttribute(this.attributeFactory.create().setName("REF").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.vcfMeta.addAttribute(this.attributeFactory.create().setName("ALT").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.vcfMeta.addAttribute(this.attributeFactory.create().setName("FILTER").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.vcfMeta.addAttribute(this.attributeFactory.create().setName("QUAL").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.vcfMeta.addAttribute(INFO_ATTR, new EntityType.AttributeRole[0]);
        this.vcfMeta.addAttribute(AC_ATTR, new EntityType.AttributeRole[0]);
        this.vcfMeta.addAttribute(AN_ATTR, new EntityType.AttributeRole[0]);
        this.vcfMeta.addAttribute(GTC_ATTR, new EntityType.AttributeRole[0]);
        this.vcfMeta.addAttribute(this.attributeFactory.create().setName(EFFECT).setDataType(AttributeType.MREF).setRefEntity(this.effectMeta), new EntityType.AttributeRole[0]);
        this.vcfMeta.addAttribute(this.attributeFactory.create().setName(GENES).setDataType(AttributeType.MREF).setRefEntity(this.geneMeta), new EntityType.AttributeRole[0]);
        this.vcfMeta.addAttribute(this.attributeFactory.create().setName("SAMPLES_ENTITIES").setDataType(AttributeType.MREF).setRefEntity(this.sampleEntityType), new EntityType.AttributeRole[0]);
        DynamicEntity sampleEntity1 = new DynamicEntity(this.sampleEntityType);
        sampleEntity1.set("NAME", (Object)"0");
        sampleEntity1.set("GT", (Object)"0/1");
        DynamicEntity sampleEntity2 = new DynamicEntity(this.sampleEntityType);
        sampleEntity2.set("NAME", (Object)"0");
        sampleEntity2.set("GT", (Object)"1/0");
        DynamicEntity vcfEntity1 = new DynamicEntity(this.vcfMeta);
        vcfEntity1.set("#CHROM", (Object)"1");
        vcfEntity1.set("POS", (Object)48554748);
        vcfEntity1.set(ID, (Object)".");
        vcfEntity1.set("REF", (Object)"T");
        vcfEntity1.set("ALT", (Object)"A,G");
        vcfEntity1.set("QUAL", (Object)"100");
        vcfEntity1.set("FILTER", (Object)"PASS");
        vcfEntity1.set(AC, (Object)"0");
        vcfEntity1.set(AN, (Object)"6");
        vcfEntity1.set(GTC, (Object)"0,1,10");
        vcfEntity1.set(EFFECT, this.getEffectEntities(Arrays.asList("A", "G")));
        vcfEntity1.set(GENES, this.getGeneEntities(Arrays.asList("A", "G")));
        vcfEntity1.set("SAMPLES_ENTITIES", Arrays.asList(sampleEntity1));
        DynamicEntity vcfEntity2 = new DynamicEntity(this.vcfMeta);
        vcfEntity2.set("#CHROM", (Object)"7");
        vcfEntity2.set("POS", (Object)50356137);
        vcfEntity2.set(ID, (Object)".");
        vcfEntity2.set("REF", (Object)"T");
        vcfEntity2.set("ALT", (Object)"A,C");
        vcfEntity2.set("QUAL", (Object)"100");
        vcfEntity2.set("FILTER", (Object)"PASS");
        vcfEntity2.set(AC, (Object)"0");
        vcfEntity2.set(AN, (Object)"6");
        vcfEntity2.set(GTC, (Object)"1,0,10");
        vcfEntity2.set(EFFECT, this.getEffectEntities(Arrays.asList("A", "C")));
        vcfEntity2.set(GENES, this.getGeneEntities(Arrays.asList("A", "C")));
        vcfEntity2.set("SAMPLES_ENTITIES", Arrays.asList(sampleEntity2));
        DynamicEntity vcfEntity3 = new DynamicEntity(this.vcfMeta);
        vcfEntity3.set("#CHROM", (Object)"17");
        vcfEntity3.set("POS", (Object)57281092);
        vcfEntity3.set(ID, (Object)".");
        vcfEntity3.set("REF", (Object)"A");
        vcfEntity3.set("ALT", (Object)"G,T");
        vcfEntity3.set("QUAL", (Object)"100");
        vcfEntity3.set("FILTER", (Object)"PASS");
        vcfEntity3.set(AC, (Object)"0");
        vcfEntity3.set(AN, (Object)"6");
        vcfEntity3.set(GTC, (Object)"10,1,0");
        vcfEntity3.set(EFFECT, this.getEffectEntities(Arrays.asList("G", "T")));
        vcfEntity3.set(GENES, this.getGeneEntities(Arrays.asList("G", "T")));
        vcfEntity3.set("SAMPLES_ENTITIES", Arrays.asList(sampleEntity1));
        DynamicEntity vcfEntity4 = new DynamicEntity(this.vcfMeta);
        vcfEntity4.set("#CHROM", (Object)"X");
        vcfEntity4.set("POS", (Object)48536966);
        vcfEntity4.set(ID, (Object)".");
        vcfEntity4.set("REF", (Object)"T");
        vcfEntity4.set("ALT", (Object)"A,C,G");
        vcfEntity4.set("QUAL", (Object)"100");
        vcfEntity4.set("FILTER", (Object)"PASS");
        vcfEntity4.set(AC, (Object)"0");
        vcfEntity4.set(AN, (Object)"6");
        vcfEntity4.set(GTC, (Object)"0,10,1");
        vcfEntity4.set(EFFECT, this.getEffectEntities(Arrays.asList("A", "C", "G")));
        vcfEntity4.set(GENES, this.getGeneEntities(Arrays.asList("A", "C", "G")));
        vcfEntity4.set("SAMPLES_ENTITIES", Arrays.asList(sampleEntity1));
        DynamicEntity vcfEntity5 = new DynamicEntity(this.vcfMeta);
        vcfEntity5.set("#CHROM", (Object)"X");
        vcfEntity5.set("POS", (Object)56032934);
        vcfEntity5.set(ID, (Object)".");
        vcfEntity5.set("REF", (Object)"G");
        vcfEntity5.set("ALT", (Object)"T,C,A");
        vcfEntity5.set("QUAL", (Object)"100");
        vcfEntity5.set("FILTER", (Object)"PASS");
        vcfEntity5.set(AC, (Object)"0");
        vcfEntity5.set(AN, (Object)"3");
        vcfEntity5.set(GTC, (Object)"1,2,3");
        vcfEntity5.set(EFFECT, null);
        vcfEntity5.set(GENES, this.getGeneEntities(Arrays.asList("T", "C", "A")));
        vcfEntity5.set("SAMPLES_ENTITIES", Arrays.asList(sampleEntity1));
        ArrayList vcfEntities = Lists.newArrayList((Object[])new Entity[]{vcfEntity1, vcfEntity2, vcfEntity3, vcfEntity4, vcfEntity5});
        try {
            BufferedWriter actualOutputFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(actualOutputFile), StandardCharsets.UTF_8));
            File inputVcfFile = new File(ResourceUtils.getFile(((Object)((Object)this)).getClass(), (String)"/testMrefVcfWriter_input.vcf").getPath());
            File expectedVcfFile = new File(ResourceUtils.getFile(((Object)((Object)this)).getClass(), (String)"/testMrefVcfWriter_expected_output.vcf").getPath());
            VcfWriterUtils.writeVcfHeader((File)inputVcfFile, (BufferedWriter)actualOutputFileWriter, Arrays.asList(EFFECT_ATTR, GENES_ATTR));
            for (Entity entity : vcfEntities) {
                DynamicEntity mapEntity = new DynamicEntity(this.vcfMeta);
                mapEntity.set(entity);
                VcfWriterUtils.writeToVcf((Entity)mapEntity, Arrays.asList(EFFECT_ATTR, GENES_ATTR), Collections.emptyList(), (BufferedWriter)actualOutputFileWriter);
                actualOutputFileWriter.newLine();
            }
            actualOutputFileWriter.close();
            Assert.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)expectedVcfFile, (File)actualOutputFile, (String)"UTF8"));
            boolean outputVCFFileIsDeleted = actualOutputFile.delete();
            LOG.info("Result test file named: " + actualOutputFile.getName() + " is " + (outputVCFFileIsDeleted ? "" : "not ") + "deleted");
        }
        catch (Throwable throwable) {
            boolean outputVCFFileIsDeleted = actualOutputFile.delete();
            LOG.info("Result test file named: " + actualOutputFile.getName() + " is " + (outputVCFFileIsDeleted ? "" : "not ") + "deleted");
            throw throwable;
        }
    }

    private List<Entity> getGeneEntities(List<String> altAlleles) {
        ArrayList geneEntities = Lists.newArrayList();
        for (String allele : altAlleles) {
            DynamicEntity geneEntity = new DynamicEntity(this.geneMeta);
            geneEntity.set("id", (Object)UUID.randomUUID().toString());
            switch (allele) {
                case "A": {
                    geneEntity.set("Gene", (Object)"BRCA1");
                    break;
                }
                case "T": {
                    geneEntity.set("Gene", (Object)"COL7A1");
                    break;
                }
                case "C": {
                    geneEntity.set("Gene", (Object)"AIP");
                    break;
                }
                case "G": {
                    geneEntity.set("Gene", (Object)"CHD7");
                    break;
                }
                default: {
                    geneEntity.set("Gene", (Object)"NONE");
                }
            }
            geneEntities.add(geneEntity);
        }
        return geneEntities;
    }

    private List<Entity> getEffectEntities(List<String> altAlleles) {
        ArrayList effectEntities = Lists.newArrayList();
        for (int i = 0; i < altAlleles.size(); ++i) {
            String gene = "BRCA" + (i + 1);
            DynamicEntity effectEntity = new DynamicEntity(this.effectMeta);
            String altAllele = altAlleles.get(i);
            effectEntity.set("id", (Object)("eff" + (i + 1)));
            effectEntity.set("ALT", (Object)altAllele);
            effectEntity.set("ALT_GENE", (Object)(altAllele + "_" + gene));
            effectEntity.set("GENE", (Object)gene);
            effectEntity.set(PUTATIVE_IMPACT, (Object)"HIGH");
            effectEntity.set(TYPE, (Object)"STOP_GAIN");
            effectEntities.add(effectEntity);
        }
        return effectEntities;
    }

    @Configuration
    @Import(value={VcfAttributes.class})
    public static class Config {
    }
}

