/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.molgenis.data.AbstractMolgenisSpringTest;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.vcf.VcfRepository;
import org.molgenis.data.vcf.config.VcfTestConfig;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.util.FileCopyUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@ContextConfiguration(classes={Config.class})
public class VcfRepositoryTest
extends AbstractMolgenisSpringTest {
    @Autowired
    private VcfAttributes vcfAttrs;
    @Autowired
    private EntityTypeFactory entityTypeFactory;
    @Autowired
    private AttributeFactory attrMetaFactory;
    private static File testData;
    private static File testNoData;

    @BeforeClass
    public static void beforeClass() throws IOException {
        InputStream in_data = VcfRepositoryTest.class.getResourceAsStream("/testdata.vcf");
        testData = new File(FileUtils.getTempDirectory(), "testdata.vcf");
        FileCopyUtils.copy((InputStream)in_data, (OutputStream)new FileOutputStream(testData));
        InputStream in_no_data = VcfRepositoryTest.class.getResourceAsStream("/testnodata.vcf");
        testNoData = new File(FileUtils.getTempDirectory(), "testnodata.vcf");
        FileCopyUtils.copy((InputStream)in_no_data, (OutputStream)new FileOutputStream(testNoData));
    }

    @Test
    public void metaData() throws IOException {
        try (VcfRepository vcfRepository = new VcfRepository(testData, "testData", this.vcfAttrs, this.entityTypeFactory, this.attrMetaFactory);){
            Assert.assertEquals((String)vcfRepository.getName(), (String)"testData");
            Iterator it = vcfRepository.getEntityType().getAttributes().iterator();
            Assert.assertTrue((boolean)it.hasNext());
            VcfRepositoryTest.testAttribute((Attribute)it.next(), "#CHROM", AttributeType.STRING);
            Assert.assertTrue((boolean)it.hasNext());
            VcfRepositoryTest.testAttribute((Attribute)it.next(), "ALT", AttributeType.TEXT);
            Assert.assertTrue((boolean)it.hasNext());
            VcfRepositoryTest.testAttribute((Attribute)it.next(), "POS", AttributeType.INT);
            Assert.assertTrue((boolean)it.hasNext());
            VcfRepositoryTest.testAttribute((Attribute)it.next(), "REF", AttributeType.TEXT);
            Assert.assertTrue((boolean)it.hasNext());
            VcfRepositoryTest.testAttribute((Attribute)it.next(), "FILTER", AttributeType.STRING);
            Assert.assertTrue((boolean)it.hasNext());
            VcfRepositoryTest.testAttribute((Attribute)it.next(), "QUAL", AttributeType.STRING);
            Assert.assertTrue((boolean)it.hasNext());
            VcfRepositoryTest.testAttribute((Attribute)it.next(), "ID", AttributeType.STRING);
            Assert.assertTrue((boolean)it.hasNext());
            VcfRepositoryTest.testAttribute((Attribute)it.next(), "INTERNAL_ID", AttributeType.STRING);
            Assert.assertTrue((boolean)it.hasNext());
            VcfRepositoryTest.testAttribute((Attribute)it.next(), "INFO", AttributeType.COMPOUND);
            Assert.assertTrue((boolean)it.hasNext());
        }
    }

    private static void testAttribute(Attribute metadata, String name, AttributeType type) {
        Assert.assertEquals((String)metadata.getName(), (String)name);
        Assert.assertEquals((Object)metadata.getDataType(), (Object)type);
    }

    @Test
    public void iterator() throws IOException {
        try (VcfRepository vcfRepository = new VcfRepository(testData, "testData", this.vcfAttrs, this.entityTypeFactory, this.attrMetaFactory);){
            Iterator it = vcfRepository.iterator();
            Assert.assertTrue((boolean)it.hasNext());
            Entity entity = (Entity)it.next();
            Assert.assertEquals((Object)entity.get("#CHROM"), (Object)"1");
            Assert.assertEquals((Object)entity.get("POS"), (Object)565286);
            Assert.assertTrue((boolean)it.hasNext());
            entity = (Entity)it.next();
            Assert.assertEquals((Object)entity.get("#CHROM"), (Object)"1");
            Assert.assertEquals((Object)entity.get("POS"), (Object)0x223C22);
            Assert.assertTrue((boolean)it.hasNext());
            Assert.assertTrue((boolean)it.hasNext());
            entity = (Entity)it.next();
            Assert.assertEquals((Object)entity.get("#CHROM"), (Object)"1");
            Assert.assertEquals((Object)entity.get("POS"), (Object)3171929);
            Assert.assertTrue((boolean)it.hasNext());
            Assert.assertTrue((boolean)it.hasNext());
            entity = (Entity)it.next();
            Assert.assertEquals((Object)entity.get("#CHROM"), (Object)"1");
            Assert.assertEquals((Object)entity.get("POS"), (Object)3172062);
            Assert.assertTrue((boolean)it.hasNext());
            entity = (Entity)it.next();
            Assert.assertEquals((Object)entity.get("#CHROM"), (Object)"1");
            Assert.assertEquals((Object)entity.get("POS"), (Object)3172273);
            Assert.assertTrue((boolean)it.hasNext());
            entity = (Entity)it.next();
            Assert.assertEquals((Object)entity.get("#CHROM"), (Object)"1");
            Assert.assertEquals((Object)entity.get("POS"), (Object)6097450);
            Assert.assertTrue((boolean)it.hasNext());
            entity = (Entity)it.next();
            Assert.assertEquals((Object)entity.get("#CHROM"), (Object)"1");
            Assert.assertEquals((Object)entity.get("POS"), (Object)7569187);
            Assert.assertFalse((boolean)it.hasNext());
        }
    }

    @Test
    public void iterator_noValues() throws IOException {
        try (VcfRepository vcfRepository = new VcfRepository(testNoData, "testNoData", this.vcfAttrs, this.entityTypeFactory, this.attrMetaFactory);){
            Iterator it = vcfRepository.iterator();
            Assert.assertFalse((boolean)it.hasNext());
        }
    }

    @Configuration
    @Import(value={VcfTestConfig.class})
    public static class Config {
    }
}

