/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.format;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.mockito.Mockito;
import org.molgenis.data.AbstractMolgenisSpringTest;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.support.DynamicEntity;
import org.molgenis.data.vcf.config.VcfTestConfig;
import org.molgenis.data.vcf.format.VcfToEntity;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.molgenis.util.EntityUtils;
import org.molgenis.vcf.VcfReader;
import org.molgenis.vcf.VcfRecord;
import org.molgenis.vcf.meta.VcfMeta;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.ContextConfiguration;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@ContextConfiguration(classes={Config.class})
public class VcfToEntityTest
extends AbstractMolgenisSpringTest {
    @Autowired
    private VcfAttributes vcfAttrs;
    @Autowired
    private EntityTypeFactory entityTypeFactory;
    @Autowired
    private AttributeFactory attrMetaFactory;
    private VcfToEntity vcfToEntitySmall;
    private VcfMeta vcfMetaSmall;

    private static VcfMeta parseHeaders(String headers) throws IOException {
        try (VcfReader vcfReader = new VcfReader((Reader)new StringReader(headers));){
            VcfMeta vcfMeta = vcfReader.getVcfMeta();
            return vcfMeta;
        }
    }

    @BeforeMethod
    public void beforeTest() throws IOException {
        String headersSmall = "##fileformat=VCFv4.1\n##fileDate=2012/11/05\n##source=NextGENeV2.2\n##reference=C:\\Program_Files_(x86)\\SoftGenetics\\NextGENe\\References\\Human_v37_2_dna\n##contig=<ID=1,length=249240621>\n##INFO=<ID=NS,Number=1,Type=Integer,Description=\"Number of Samples With Data\">\n##INFO=<ID=DF,Number=0,Type=Flag,Description=\"Flag field\">\n##INFO=<ID=DF2,Number=0,Type=Flag,Description=\"Flag field 2\">\n##INFO=<ID=CHAR,Number=0,Type=Character,Description=\"char field\">\n#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\n";
        this.vcfMetaSmall = VcfToEntityTest.parseHeaders(headersSmall);
        this.vcfToEntitySmall = new VcfToEntity("EntityNameSmall", this.vcfMetaSmall, this.vcfAttrs, this.entityTypeFactory, this.attrMetaFactory);
    }

    @Test
    public void testGetEntityType() {
        EntityType expectedEntityType = (EntityType)this.entityTypeFactory.create((Object)"EntityNameSmall");
        expectedEntityType.addAttribute(this.vcfAttrs.getChromAttribute(), new EntityType.AttributeRole[0]);
        expectedEntityType.addAttribute(this.vcfAttrs.getAltAttribute(), new EntityType.AttributeRole[0]);
        expectedEntityType.addAttribute(this.vcfAttrs.getPosAttribute(), new EntityType.AttributeRole[0]);
        expectedEntityType.addAttribute(this.vcfAttrs.getRefAttribute(), new EntityType.AttributeRole[0]);
        expectedEntityType.addAttribute(this.vcfAttrs.getFilterAttribute(), new EntityType.AttributeRole[0]);
        expectedEntityType.addAttribute(this.vcfAttrs.getQualAttribute(), new EntityType.AttributeRole[0]);
        expectedEntityType.addAttribute(this.vcfAttrs.getIdAttribute(), new EntityType.AttributeRole[0]);
        Attribute internalIdMeta = this.attrMetaFactory.create().setName("INTERNAL_ID").setDataType(AttributeType.STRING).setVisible(false);
        expectedEntityType.addAttribute(internalIdMeta, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID});
        Attribute infoMetaData = this.attrMetaFactory.create().setName("INFO").setDataType(AttributeType.COMPOUND).setNillable(true);
        Attribute infoNS = this.attrMetaFactory.create().setName("NS").setDataType(AttributeType.INT).setDescription("Number of Samples With Data").setAggregatable(true).setParent(infoMetaData);
        Attribute infoDF = this.attrMetaFactory.create().setName("DF").setDataType(AttributeType.BOOL).setDescription("Flag field").setAggregatable(true).setParent(infoMetaData);
        Attribute infoDF2 = this.attrMetaFactory.create().setName("DF2").setDataType(AttributeType.BOOL).setDescription("Flag field 2").setAggregatable(true).setParent(infoMetaData);
        Attribute infoChar2 = this.attrMetaFactory.create().setName("CHAR").setDataType(AttributeType.STRING).setDescription("char field").setAggregatable(true).setParent(infoMetaData);
        expectedEntityType.addAttribute(infoNS, new EntityType.AttributeRole[0]);
        expectedEntityType.addAttribute(infoDF, new EntityType.AttributeRole[0]);
        expectedEntityType.addAttribute(infoDF2, new EntityType.AttributeRole[0]);
        expectedEntityType.addAttribute(infoChar2, new EntityType.AttributeRole[0]);
        expectedEntityType.addAttribute(infoMetaData, new EntityType.AttributeRole[0]);
        EntityType actualEntityType = this.vcfToEntitySmall.getEntityType();
        String backend = "test";
        expectedEntityType.setBackend(backend);
        actualEntityType.setBackend(backend);
        Package package_ = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)package_.getIdValue()).thenReturn((Object)"pck0");
        expectedEntityType.setPackage(package_);
        actualEntityType.setPackage(package_);
        expectedEntityType.setId("dummyId");
        expectedEntityType.setLabel("EntityNameSmall");
        expectedEntityType.getOwnAllAttributes().forEach(attr -> attr.setIdentifier(null));
        actualEntityType.setId("dummyId");
        actualEntityType.getOwnAllAttributes().forEach(attr -> attr.setIdentifier(null));
        Assert.assertTrue((boolean)EntityUtils.equals((EntityType)expectedEntityType, (EntityType)actualEntityType));
    }

    @Test
    public void testToEntity() throws IOException {
        VcfRecord record = new VcfRecord(this.vcfMetaSmall, new String[]{"10", "12345", "id3", "A", "C", "7.9123", "pass", "DF;;CHAR=-"});
        Entity entity = this.vcfToEntitySmall.toEntity(record);
        DynamicEntity expected = new DynamicEntity(this.vcfToEntitySmall.getEntityType());
        expected.set("#CHROM", (Object)"10");
        expected.set("ALT", (Object)"C");
        expected.set("POS", (Object)12345);
        expected.set("REF", (Object)"A");
        expected.set("FILTER", (Object)"pass");
        expected.set("QUAL", (Object)"7.9123");
        expected.set("ID", (Object)"id3");
        expected.set("INTERNAL_ID", entity.get("INTERNAL_ID"));
        expected.set("DF", (Object)true);
        expected.set("DF2", (Object)false);
        expected.set("CHAR", (Object)"-");
        Assert.assertTrue((boolean)EntityUtils.equals((Entity)entity, (Entity)expected));
    }

    @Test
    public void testToEntityAlternativeAlleles() throws IOException {
        VcfRecord record = new VcfRecord(this.vcfMetaSmall, new String[]{"10", "12345", "id3", "A", "A,C,G,T,N,*", "7.9123", "pass", "DF;DF2;CHAR=-"});
        Entity entity = this.vcfToEntitySmall.toEntity(record);
        DynamicEntity expected = new DynamicEntity(this.vcfToEntitySmall.getEntityType());
        expected.set("#CHROM", (Object)"10");
        expected.set("ALT", (Object)"A,C,G,T,N,*");
        expected.set("POS", (Object)12345);
        expected.set("REF", (Object)"A");
        expected.set("FILTER", (Object)"pass");
        expected.set("QUAL", (Object)"7.9123");
        expected.set("ID", (Object)"id3");
        expected.set("INTERNAL_ID", entity.get("INTERNAL_ID"));
        expected.set("DF", (Object)true);
        expected.set("DF2", (Object)true);
        expected.set("CHAR", (Object)"-");
        Assert.assertTrue((boolean)EntityUtils.equals((Entity)entity, (Entity)expected));
    }

    @Test
    public void testToEntityMissingValues() throws IOException {
        String vcfHeaders = "##fileformat=VCFv4.1\n##INFO=<ID=GoNL_AF,Number=.,Type=Float,Description=\"The allele frequency for variants seen in the population used for the GoNL project\">\n#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\n";
        VcfMeta vcfMeta = VcfToEntityTest.parseHeaders(vcfHeaders);
        VcfToEntity vcfToEntity = new VcfToEntity("entityTypeName", vcfMeta, this.vcfAttrs, this.entityTypeFactory, this.attrMetaFactory);
        VcfRecord record = new VcfRecord(vcfMeta, new String[]{"1", "54728", ".", "G", "T,C", ".", ".", "GoNL_AF=0.01,."});
        Entity entity = vcfToEntity.toEntity(record);
        Assert.assertEquals((String)entity.getString("GoNL_AF"), (String)"0.01,.");
    }

    @Configuration
    @Import(value={VcfTestConfig.class})
    public static class Config {
    }
}

