/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.format;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.NameValidator;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.support.DynamicEntity;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.molgenis.data.vcf.utils.VcfUtils;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.util.EntityUtils;
import org.molgenis.vcf.VcfInfo;
import org.molgenis.vcf.VcfRecord;
import org.molgenis.vcf.VcfSample;
import org.molgenis.vcf.meta.VcfMeta;
import org.molgenis.vcf.meta.VcfMetaFormat;
import org.molgenis.vcf.meta.VcfMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcfToEntity {
    private static final Logger LOG = LoggerFactory.getLogger(VcfToEntity.class);
    private static final String[] EMPTY_FORMAT = new String[]{"."};
    private final VcfMeta vcfMeta;
    private final VcfAttributes vcfAttributes;
    private final EntityTypeFactory entityTypeFactory;
    private final AttributeFactory attrMetaFactory;
    private final EntityType sampleEntityType;
    private final EntityType entityType;
    private final Set<String> vcfInfoFlagFieldKeys;
    private final Map<String, String> infoFieldKeyToAttrNameMap;

    public VcfToEntity(String entityTypeId, VcfMeta vcfMeta, VcfAttributes vcfAttributes, EntityTypeFactory entityTypeFactory, AttributeFactory attrMetaFactory) {
        Objects.requireNonNull(entityTypeId);
        this.vcfMeta = Objects.requireNonNull(vcfMeta);
        Objects.requireNonNull(vcfMeta.getFormatMeta());
        this.vcfAttributes = Objects.requireNonNull(vcfAttributes);
        this.entityTypeFactory = Objects.requireNonNull(entityTypeFactory);
        this.attrMetaFactory = Objects.requireNonNull(attrMetaFactory);
        this.vcfInfoFlagFieldKeys = VcfToEntity.determineVcfInfoFlagFields(vcfMeta);
        this.infoFieldKeyToAttrNameMap = VcfToEntity.createInfoFieldKeyToAttrNameMap(vcfMeta, entityTypeId);
        this.sampleEntityType = this.createSampleEntityType(entityTypeId, vcfMeta.getFormatMeta());
        this.entityType = this.createEntityType(entityTypeId, vcfMeta);
    }

    private EntityType createEntityType(String entityTypeId, VcfMeta vcfMeta) {
        Attribute idAttribute = this.attrMetaFactory.create().setName("INTERNAL_ID").setDataType(AttributeType.STRING);
        idAttribute.setVisible(false);
        EntityType entityType = (EntityType)this.entityTypeFactory.create((Object)entityTypeId);
        entityType.setLabel(entityTypeId);
        entityType.addAttribute(this.vcfAttributes.getChromAttribute(), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.vcfAttributes.getAltAttribute(), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.vcfAttributes.getPosAttribute(), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.vcfAttributes.getRefAttribute(), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.vcfAttributes.getFilterAttribute(), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.vcfAttributes.getQualAttribute(), new EntityType.AttributeRole[0]);
        entityType.addAttribute(this.vcfAttributes.getIdAttribute(), new EntityType.AttributeRole[0]);
        entityType.addAttribute(idAttribute, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID});
        Attribute infoMetaData = this.attrMetaFactory.create().setName("INFO").setDataType(AttributeType.COMPOUND).setNillable(true);
        for (VcfMetaInfo info : vcfMeta.getInfoMeta()) {
            String attrName = this.toAttributeName(info.getId());
            AttributeType attrType = VcfToEntity.vcfReaderFormatToMolgenisType(info);
            String attrDescription = StringUtils.isBlank((CharSequence)info.getDescription()) ? "Description not provided" : info.getDescription();
            Attribute attribute = this.attrMetaFactory.create().setName(attrName).setDataType(attrType).setDescription(attrDescription).setAggregatable(true).setParent(infoMetaData);
            entityType.addAttribute(attribute, new EntityType.AttributeRole[0]);
        }
        entityType.addAttribute(infoMetaData, new EntityType.AttributeRole[0]);
        if (this.sampleEntityType != null) {
            Attribute samplesAttributeMeta = this.attrMetaFactory.create().setName("SAMPLES_ENTITIES").setDataType(AttributeType.MREF).setRefEntity(this.sampleEntityType).setLabel("SAMPLES");
            entityType.addAttribute(samplesAttributeMeta, new EntityType.AttributeRole[0]);
        }
        return entityType;
    }

    private EntityType createSampleEntityType(String entityTypeId, Iterable<VcfMetaFormat> formatMetaData) {
        EntityType result = null;
        if (formatMetaData.iterator().hasNext()) {
            String sampleEntityTypeId = entityTypeId + "Sample";
            result = (EntityType)this.entityTypeFactory.create((Object)sampleEntityTypeId);
            result.setLabel(sampleEntityTypeId);
            Attribute idAttr = this.attrMetaFactory.create().setName("ID").setAggregatable(true).setVisible(false);
            Attribute nameAttr = this.attrMetaFactory.create().setName("NAME").setDataType(AttributeType.TEXT).setAggregatable(true).setNillable(false);
            Attribute originalNameAttr = this.attrMetaFactory.create().setName("ORIGINAL_NAME").setDataType(AttributeType.TEXT);
            result.addAttribute(idAttr, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID});
            result.addAttribute(nameAttr, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_LABEL, EntityType.AttributeRole.ROLE_LOOKUP});
            for (VcfMetaFormat meta : formatMetaData) {
                String name = meta.getId();
                if (NameValidator.KEYWORDS.contains(name) || NameValidator.KEYWORDS.contains(name.toUpperCase())) {
                    name = name + "_";
                }
                Attribute attr = this.attrMetaFactory.create().setName(name.replaceAll("[-.*$&%^()#!@?_]", "")).setDataType(VcfToEntity.vcfFieldTypeToMolgenisFieldType(meta)).setAggregatable(true).setLabel(meta.getId());
                result.addAttribute(attr, new EntityType.AttributeRole[0]);
            }
            result.addAttribute(originalNameAttr, new EntityType.AttributeRole[0]);
        }
        return result;
    }

    private static AttributeType vcfReaderFormatToMolgenisType(VcfMetaInfo vcfMetaInfo) {
        boolean isListValue;
        String number = vcfMetaInfo.getNumber();
        try {
            isListValue = number.equals("A") || number.equals("R") || number.equals("G") || number.equals(".") || Integer.parseInt(number) > 1;
        }
        catch (NumberFormatException ex) {
            throw new GenotypeDataException("Error parsing length of vcf info field. " + number + " is not a valid int or expected preset (A, R, G, .)", (Throwable)ex);
        }
        switch (vcfMetaInfo.getType()) {
            case CHARACTER: {
                if (isListValue) {
                    return AttributeType.STRING;
                }
                return AttributeType.STRING;
            }
            case FLAG: {
                return AttributeType.BOOL;
            }
            case FLOAT: {
                if (isListValue) {
                    return AttributeType.STRING;
                }
                return AttributeType.DECIMAL;
            }
            case INTEGER: {
                if (isListValue) {
                    return AttributeType.STRING;
                }
                return AttributeType.INT;
            }
            case STRING: {
                if (isListValue) {
                    return AttributeType.TEXT;
                }
                return AttributeType.TEXT;
            }
        }
        throw new MolgenisDataException(String.format("Unknown vcf info type [%s]", vcfMetaInfo.getType()));
    }

    private static AttributeType vcfFieldTypeToMolgenisFieldType(VcfMetaFormat format) {
        boolean isListValue;
        String number = format.getNumber();
        try {
            isListValue = number.equals("A") || number.equals("R") || number.equals("G") || number.equals(".") || Integer.parseInt(number) > 1;
        }
        catch (NumberFormatException ex) {
            throw new GenotypeDataException("Error parsing length of vcf info field. " + number + " is not a valid int or expected preset (A, R, G, .)", (Throwable)ex);
        }
        switch (format.getType()) {
            case CHARACTER: {
                if (isListValue) {
                    return AttributeType.STRING;
                }
                return AttributeType.STRING;
            }
            case FLOAT: {
                if (isListValue) {
                    return AttributeType.STRING;
                }
                return AttributeType.DECIMAL;
            }
            case INTEGER: {
                if (isListValue) {
                    return AttributeType.STRING;
                }
                return AttributeType.INT;
            }
            case STRING: {
                if (isListValue) {
                    return AttributeType.STRING;
                }
                return AttributeType.STRING;
            }
        }
        throw new MolgenisDataException(String.format("Unknown vcf field type [%s]", format.getType()));
    }

    public Entity toEntity(String[] tokens) {
        return this.toEntity(new VcfRecord(this.vcfMeta, tokens));
    }

    public Entity toEntity(VcfRecord vcfRecord) {
        DynamicEntity entity = new DynamicEntity(this.entityType);
        entity.set("#CHROM", (Object)vcfRecord.getChromosome());
        entity.set("ALT", (Object)StringUtils.join((Iterable)Lists.transform((List)vcfRecord.getAlternateAlleles(), Allele::toString), (char)','));
        entity.set("POS", (Object)vcfRecord.getPosition());
        entity.set("REF", (Object)vcfRecord.getReferenceAllele().toString());
        entity.set("FILTER", (Object)vcfRecord.getFilterStatus());
        entity.set("QUAL", (Object)vcfRecord.getQuality());
        entity.set("ID", (Object)StringUtils.join((Iterable)vcfRecord.getIdentifiers(), (char)','));
        String id = VcfUtils.createId((Entity)entity);
        entity.set("INTERNAL_ID", (Object)id);
        this.writeInfoFieldsToEntity(vcfRecord, (Entity)entity);
        if (this.sampleEntityType != null) {
            List<Entity> samples = this.createSampleEntities(vcfRecord, entity.get("POS") + "_" + entity.get("ALT"), id);
            entity.set("SAMPLES_ENTITIES", samples);
        }
        return entity;
    }

    private List<Entity> createSampleEntities(VcfRecord vcfRecord, String entityPosAlt, String entityId) {
        ArrayList<Entity> samples = new ArrayList<Entity>();
        Iterator sampleIterator = vcfRecord.getSamples().iterator();
        if (vcfRecord.getNrSamples() > 0) {
            Iterator sampleNameIterator = this.vcfMeta.getSampleNames().iterator();
            int j = 0;
            while (sampleIterator.hasNext()) {
                Object[] format = vcfRecord.getFormat();
                VcfSample sample = (VcfSample)sampleIterator.next();
                DynamicEntity sampleEntity = new DynamicEntity(this.sampleEntityType);
                for (int i = 0; i < format.length; ++i) {
                    String strValue = sample.getData(i);
                    Object value = null;
                    EntityType sampleEntityType = sampleEntity.getEntityType();
                    Attribute attr = sampleEntityType.getAttribute(format[i]);
                    if (attr != null) {
                        if (strValue != null) {
                            value = EntityUtils.getTypedValue((String)strValue, (Attribute)attr);
                        }
                    } else if (Arrays.equals(EMPTY_FORMAT, format)) {
                        LOG.debug("Found a dot as format, assuming no samples present");
                    } else {
                        throw new MolgenisDataException("Sample entity contains an attribute [" + (String)format[i] + "] which is not specified in vcf headers");
                    }
                    sampleEntity.set((String)format[i], value);
                }
                sampleEntity.set("ID", (Object)(entityId + j));
                String original_name = (String)sampleNameIterator.next();
                sampleEntity.set("NAME", (Object)(entityPosAlt + "_" + original_name));
                sampleEntity.set("ORIGINAL_NAME", (Object)original_name);
                samples.add((Entity)sampleEntity);
                ++j;
            }
        }
        return samples;
    }

    private void writeInfoFieldsToEntity(VcfRecord vcfRecord, Entity entity) {
        for (String vcfInfoFlagFieldKey : this.vcfInfoFlagFieldKeys) {
            entity.set(this.toAttributeName(vcfInfoFlagFieldKey), (Object)false);
        }
        for (VcfInfo vcfInfo : vcfRecord.getInformation()) {
            Object val;
            if (vcfInfo.getKey().equals(".")) continue;
            if (this.vcfInfoFlagFieldKeys.contains(vcfInfo.getKey())) {
                val = true;
            } else {
                Object vcfInfoVal = vcfInfo.getVal();
                if (vcfInfoVal == null) {
                    val = null;
                } else if (vcfInfoVal instanceof List) {
                    List vcfInfoValTokens = (List)vcfInfoVal;
                    val = vcfInfoValTokens.stream().map(vcfInfoValToken -> vcfInfoValToken != null ? vcfInfoValToken.toString() : ".").collect(Collectors.joining(","));
                } else {
                    val = vcfInfoVal instanceof Float ? (Float.isNaN(((Float)vcfInfoVal).floatValue()) ? null : Double.valueOf(new BigDecimal(String.valueOf(vcfInfoVal)).doubleValue())) : (vcfInfoVal instanceof Character ? vcfInfoVal.toString() : vcfInfoVal);
                }
            }
            entity.set(this.toAttributeName(vcfInfo.getKey()), val);
        }
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    private String toAttributeName(String vcfInfoFieldKey) {
        String attrName = this.infoFieldKeyToAttrNameMap.get(vcfInfoFieldKey);
        if (attrName == null) {
            throw new RuntimeException(String.format("Missing attribute for VCF info field [%s]", vcfInfoFieldKey));
        }
        return attrName;
    }

    private static Set<String> determineVcfInfoFlagFields(VcfMeta vcfMeta) {
        return StreamSupport.stream(vcfMeta.getInfoMeta().spliterator(), false).filter(vcfInfoMeta -> vcfInfoMeta.getType().equals((Object)VcfMetaInfo.Type.FLAG)).map(VcfMetaInfo::getId).collect(Collectors.toSet());
    }

    private static Map<String, String> createInfoFieldKeyToAttrNameMap(VcfMeta vcfMeta, String entityTypeId) {
        HashMap infoFieldIdToAttrNameMap = Maps.newHashMapWithExpectedSize((int)Iterables.size((Iterable)vcfMeta.getInfoMeta()));
        for (VcfMetaInfo info : vcfMeta.getInfoMeta()) {
            String postFix = "";
            switch (info.getId()) {
                case "INTERNAL_ID": 
                case "#CHROM": 
                case "ALT": 
                case "POS": 
                case "REF": 
                case "FILTER": 
                case "QUAL": 
                case "ID": {
                    postFix = '_' + entityTypeId;
                    break;
                }
            }
            String name = info.getId();
            if (NameValidator.KEYWORDS.contains(name) || NameValidator.KEYWORDS.contains(name.toUpperCase())) {
                name = name + '_';
            }
            infoFieldIdToAttrNameMap.put(info.getId(), name + postFix);
        }
        return infoFieldIdToAttrNameMap;
    }
}

