/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.model;

import java.util.Objects;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VcfAttributes {
    public static final String CHROM = "#CHROM";
    public static final String ALT = "ALT";
    public static final String POS = "POS";
    public static final String REF = "REF";
    public static final String FILTER = "FILTER";
    public static final String QUAL = "QUAL";
    public static final String ID = "ID";
    public static final String INTERNAL_ID = "INTERNAL_ID";
    public static final String INFO = "INFO";
    public static final String FORMAT_GT = "GT";
    public static final String SAMPLES = "SAMPLES_ENTITIES";
    private final AttributeFactory attributeFactory;

    @Autowired
    public VcfAttributes(AttributeFactory attributeFactory) {
        this.attributeFactory = Objects.requireNonNull(attributeFactory);
    }

    public Attribute getChromAttribute() {
        return this.attributeFactory.create().setName(CHROM).setDataType(AttributeType.STRING).setAggregatable(true).setNillable(false).setDescription("The chromosome on which the variant is observed");
    }

    public Attribute getAltAttribute() {
        return this.attributeFactory.create().setName(ALT).setDataType(AttributeType.TEXT).setAggregatable(true).setNillable(false).setDescription("The alternative allele observed");
    }

    public Attribute getPosAttribute() {
        return this.attributeFactory.create().setName(POS).setDataType(AttributeType.INT).setAggregatable(true).setNillable(false).setDescription("The position on the chromosome which the variant is observed");
    }

    public Attribute getRefAttribute() {
        return this.attributeFactory.create().setName(REF).setDataType(AttributeType.TEXT).setAggregatable(true).setNillable(false).setDescription("The reference allele");
    }

    public Attribute getFilterAttribute() {
        return this.attributeFactory.create().setName(FILTER).setDataType(AttributeType.STRING).setAggregatable(true).setNillable(true).setDescription("Description not provided");
    }

    public Attribute getQualAttribute() {
        return this.attributeFactory.create().setName(QUAL).setDataType(AttributeType.STRING).setAggregatable(true).setNillable(true).setDescription("Description not provided");
    }

    public Attribute getIdAttribute() {
        return this.attributeFactory.create().setName(ID).setDataType(AttributeType.STRING).setNillable(true).setDescription("Description not provided");
    }
}

