/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.molgenis.data.Entity;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.support.AbstractRepository;
import org.molgenis.data.vcf.VcfReaderFactory;
import org.molgenis.data.vcf.VcfReaderFactoryImpl;
import org.molgenis.data.vcf.format.VcfToEntity;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.molgenis.vcf.VcfReader;
import org.molgenis.vcf.meta.VcfMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcfRepository
extends AbstractRepository {
    private static final Logger LOG = LoggerFactory.getLogger(VcfRepository.class);
    public static final String DEFAULT_ATTRIBUTE_DESCRIPTION = "Description not provided";
    public static final String NAME = "NAME";
    public static final String ORIGINAL_NAME = "ORIGINAL_NAME";
    public static final String PREFIX = "##";
    private final VcfReaderFactory vcfReaderFactory;
    private final String entityTypeId;
    private final VcfAttributes vcfAttributes;
    private final EntityTypeFactory entityTypeFactory;
    private final AttributeFactory attrMetaFactory;
    protected final Supplier<VcfToEntity> vcfToEntitySupplier;

    public VcfRepository(File file, String entityTypeId, VcfAttributes vcfAttributes, EntityTypeFactory entityTypeFactory, AttributeFactory attrMetaFactory) {
        this(new VcfReaderFactoryImpl(file), entityTypeId, vcfAttributes, entityTypeFactory, attrMetaFactory);
    }

    protected VcfRepository(VcfReaderFactory vcfReaderFactory, String entityTypeId, VcfAttributes vcfAttributes, EntityTypeFactory entityTypeFactory, AttributeFactory attrMetaFactory) {
        this.vcfReaderFactory = Objects.requireNonNull(vcfReaderFactory);
        this.entityTypeId = Objects.requireNonNull(entityTypeId);
        this.vcfAttributes = Objects.requireNonNull(vcfAttributes);
        this.entityTypeFactory = Objects.requireNonNull(entityTypeFactory);
        this.attrMetaFactory = Objects.requireNonNull(attrMetaFactory);
        this.vcfToEntitySupplier = Suppliers.memoize(this::parseVcfMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VcfToEntity parseVcfMeta() {
        VcfReader reader = (VcfReader)this.vcfReaderFactory.get();
        try {
            VcfMeta vcfMeta = reader.getVcfMeta();
            VcfToEntity vcfToEntity = new VcfToEntity(this.entityTypeId, vcfMeta, this.vcfAttributes, this.entityTypeFactory, this.attrMetaFactory);
            return vcfToEntity;
        }
        catch (Exception e) {
            LOG.error("Failed to read VCF Metadata from file", (Throwable)e);
            VcfToEntity vcfToEntity = null;
            return vcfToEntity;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOG.info("Failed to close VcfReader", (Throwable)e);
            }
        }
    }

    public Iterator<Entity> iterator() {
        UnmodifiableIterator vcfRecordIterator = Iterators.unmodifiableIterator((Iterator)((VcfReader)this.vcfReaderFactory.get()).iterator());
        VcfToEntity vcfToEntity = (VcfToEntity)this.vcfToEntitySupplier.get();
        return Iterators.transform((Iterator)vcfRecordIterator, vcfToEntity::toEntity);
    }

    public EntityType getEntityType() {
        return ((VcfToEntity)this.vcfToEntitySupplier.get()).getEntityType();
    }

    public void close() throws IOException {
        this.vcfReaderFactory.close();
    }

    public Set<RepositoryCapability> getCapabilities() {
        return Collections.emptySet();
    }

    public long count() {
        return Iterables.size((Iterable)((Object)this));
    }
}

