/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Repository;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.processor.CellProcessor;
import org.molgenis.data.support.FileRepositoryCollection;
import org.molgenis.data.vcf.VcfRepository;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.springframework.beans.factory.annotation.Autowired;

public class VcfRepositoryCollection
extends FileRepositoryCollection {
    public static final String NAME = "VCF";
    private static final String EXTENSION_VCF = "vcf";
    private static final String EXTENSION_VCF_GZ = "vcf.gz";
    private static final String EXTENSION_VCF_ZIP = "vcf.zip";
    static final Set<String> EXTENSIONS = ImmutableSet.of((Object)"vcf", (Object)"vcf.gz", (Object)"vcf.zip");
    @Autowired
    private VcfAttributes vcfAttributes;
    @Autowired
    private EntityTypeFactory entityTypeFactory;
    @Autowired
    private AttributeFactory attrMetaFactory;
    private final File file;
    private final String entityTypeId;

    public VcfRepositoryCollection(File file) {
        super(EXTENSIONS, new CellProcessor[0]);
        this.file = Objects.requireNonNull(file);
        String name = file.getName();
        if (name.toLowerCase().endsWith(EXTENSION_VCF)) {
            this.entityTypeId = name.substring(0, name.toLowerCase().lastIndexOf(".vcf"));
        } else if (name.toLowerCase().endsWith(EXTENSION_VCF_GZ)) {
            this.entityTypeId = name.substring(0, name.toLowerCase().lastIndexOf(".vcf.gz"));
        } else if (name.toLowerCase().endsWith(EXTENSION_VCF_ZIP)) {
            this.entityTypeId = name.substring(0, name.toLowerCase().lastIndexOf(".vcf.zip"));
        } else {
            throw new IllegalArgumentException("Not a VCF file [" + file.getName() + "]");
        }
    }

    public void init() throws IOException {
    }

    public Iterable<String> getEntityTypeIds() {
        return Collections.singleton(this.entityTypeId);
    }

    public Repository<Entity> getRepository(String name) {
        if (!this.entityTypeId.equals(name)) {
            throw new MolgenisDataException("Unknown entity name [" + name + "]");
        }
        return new VcfRepository(this.file, name, this.vcfAttributes, this.entityTypeFactory, this.attrMetaFactory);
    }

    public String getName() {
        return NAME;
    }

    public Iterator<Repository<Entity>> iterator() {
        return new Iterator<Repository<Entity>>(){
            Iterator<String> it;
            {
                this.it = VcfRepositoryCollection.this.getEntityTypeIds().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Repository<Entity> next() {
                return VcfRepositoryCollection.this.getRepository(this.it.next());
            }
        };
    }

    public boolean hasRepository(String name) {
        if (null == name) {
            return false;
        }
        for (String s : this.getEntityTypeIds()) {
            if (!s.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRepository(EntityType entityType) {
        return this.hasRepository(entityType.getId());
    }
}

