/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.MolgenisInvalidFormatException;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.EntityTypeUtils;
import org.molgenis.data.vcf.utils.VcfUtils;

public class VcfWriterUtils {
    public static final String VARIANT = "VARIANT";
    public static final String EFFECT = "EFFECT";
    private static final char ANNOTATION_FIELD_SEPARATOR = ';';
    private static final String SPACE_PIPE_SEPERATOR = " | ";
    private static final LinkedList<String> VCF_ATTRIBUTE_NAMES = new LinkedList<String>(Arrays.asList("#CHROM", "POS", "ID", "REF", "ALT", "QUAL", "FILTER"));
    private static final char PIPE_SEPARATOR = '|';

    public static void writeVcfHeader(File inputVcfFile, BufferedWriter outputVCFWriter, List<Attribute> addedAttributes) throws MolgenisInvalidFormatException, IOException {
        VcfWriterUtils.writeVcfHeader(inputVcfFile, outputVCFWriter, addedAttributes, Collections.emptyList());
    }

    public static void writeVcfHeader(File inputVcfFile, BufferedWriter outputVCFWriter, List<Attribute> addedAttributes, List<String> attributesToInclude) throws MolgenisInvalidFormatException, IOException {
        System.out.println("Detecting VCF column header...");
        Scanner inputVcfFileScanner = VcfWriterUtils.createVcfFileScanner(inputVcfFile);
        String line = inputVcfFileScanner.nextLine();
        LinkedHashMap<String, String> infoHeaderLinesMap = new LinkedHashMap<String, String>();
        if (!line.startsWith("##")) {
            outputVCFWriter.close();
            inputVcfFileScanner.close();
            throw new MolgenisInvalidFormatException("Did not find ## on the first line, are you sure it is a VCF file?");
        }
        line = VcfWriterUtils.processHeaders(outputVCFWriter, inputVcfFileScanner, line, infoHeaderLinesMap);
        System.out.println("\nHeader line found:\n" + line);
        VcfWriterUtils.checkColumnHeaders(outputVCFWriter, inputVcfFileScanner, line);
        VcfWriterUtils.writeInfoHeaders(outputVCFWriter, addedAttributes, attributesToInclude, infoHeaderLinesMap);
        VcfWriterUtils.writeColumnHeaders(outputVCFWriter, line);
        inputVcfFileScanner.close();
    }

    private static Scanner createVcfFileScanner(File vcfFile) throws IOException {
        FileInputStream inputStream = new FileInputStream(vcfFile);
        if (vcfFile.getName().endsWith(".gz")) {
            inputStream = new BlockCompressedInputStream((InputStream)inputStream);
        }
        return new Scanner((InputStream)inputStream, StandardCharsets.UTF_8.name());
    }

    public static void writeToVcf(Entity vcfEntity, BufferedWriter writer) throws IOException {
        VcfWriterUtils.writeToVcf(vcfEntity, new ArrayList<Attribute>(), new ArrayList<String>(), writer);
    }

    public static void writeToVcf(Entity vcfEntity, List<Attribute> addedAttributes, List<String> attributesToInclude, BufferedWriter writer) throws IOException {
        VcfWriterUtils.addStandardFieldsToVcf(vcfEntity, writer);
        VcfWriterUtils.writeInfoData(vcfEntity, writer, addedAttributes, attributesToInclude);
        Iterable sampleEntities = vcfEntity.getEntities("SAMPLES_ENTITIES");
        if (sampleEntities != null) {
            VcfWriterUtils.addSampleEntitiesToVcf(sampleEntities, writer);
        }
    }

    private static String processHeaders(BufferedWriter outputVCFWriter, Scanner inputVcfFileScanner, String line, Map<String, String> infoHeaderLinesMap) throws IOException {
        while (inputVcfFileScanner.hasNextLine()) {
            if (line.startsWith("##INFO")) {
                infoHeaderLinesMap.put(VcfUtils.getIdFromInfoField(line), line);
            } else {
                if (!line.startsWith("##")) break;
                outputVCFWriter.write(line);
                outputVCFWriter.newLine();
            }
            line = inputVcfFileScanner.nextLine();
            System.out.print(".");
        }
        return line;
    }

    private static void checkColumnHeaders(BufferedWriter outputVCFWriter, Scanner inputVcfFileScanner, String line) throws IOException, MolgenisInvalidFormatException {
        if (!line.startsWith("#CHROM")) {
            outputVCFWriter.close();
            inputVcfFileScanner.close();
            throw new MolgenisInvalidFormatException("Header does not start with #CHROM, are you sure it is a VCF file?");
        }
    }

    private static void writeColumnHeaders(BufferedWriter outputVCFWriter, String line) throws IOException {
        outputVCFWriter.write(line);
        outputVCFWriter.newLine();
    }

    private static void writeInfoHeaders(BufferedWriter outputVCFWriter, List<Attribute> annotatorAttributes, List<String> attributesToInclude, Map<String, String> infoHeaderLinesMap) throws IOException {
        Map<String, Attribute> annotatorAttributesMap = VcfUtils.getAttributesMapFromList(annotatorAttributes);
        VcfWriterUtils.writeExistingInfoHeaders(outputVCFWriter, infoHeaderLinesMap, annotatorAttributesMap);
        VcfWriterUtils.writeAddedInfoHeaders(outputVCFWriter, attributesToInclude, annotatorAttributesMap, infoHeaderLinesMap);
    }

    private static void writeAddedInfoHeaders(BufferedWriter outputVCFWriter, List<String> attributesToInclude, Map<String, Attribute> annotatorAttributes, Map<String, String> infoHeaderLinesMap) throws IOException {
        for (Attribute annotatorInfoAttr : annotatorAttributes.values()) {
            if (!attributesToInclude.isEmpty() && !attributesToInclude.contains(annotatorInfoAttr.getName()) && !EntityTypeUtils.isReferenceType((Attribute)annotatorInfoAttr)) continue;
            outputVCFWriter.write(VcfWriterUtils.createInfoStringFromAttribute(annotatorAttributes.get(annotatorInfoAttr.getName()), attributesToInclude, infoHeaderLinesMap.get(annotatorInfoAttr.getName())));
            outputVCFWriter.newLine();
        }
    }

    private static String createInfoStringFromAttribute(Attribute infoAttribute, List<String> attributesToInclude, String currentInfoField) {
        String attributeName = infoAttribute.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("##INFO=<ID=");
        sb.append(attributeName);
        sb.append(",Number=.");
        sb.append(",Type=");
        sb.append(VcfUtils.toVcfDataType(infoAttribute.getDataType()));
        sb.append(",Description=\"");
        if (StringUtils.isBlank((CharSequence)infoAttribute.getDescription())) {
            if (EntityTypeUtils.isReferenceType((Attribute)infoAttribute) && !attributeName.equals("SAMPLES_ENTITIES")) {
                String currentAttributesString = currentInfoField != null ? currentInfoField.substring(currentInfoField.indexOf("'") + 1, currentInfoField.lastIndexOf("'")) : "";
                VcfWriterUtils.writeRefAttributePartsToInfoDescription(infoAttribute, attributesToInclude, attributeName, sb, currentAttributesString);
            } else {
                sb.append("Description not provided");
            }
        } else {
            sb.append(infoAttribute.getDescription().replace("\"", "\\\"").replace("\n", " "));
        }
        sb.append("\">");
        return sb.toString();
    }

    private static void writeRefAttributePartsToInfoDescription(Attribute infoAttribute, List<String> attributesToInclude, String attributeName, StringBuilder sb, String existingAttributes) {
        Iterable atomicAttributes = infoAttribute.getRefEntity().getAtomicAttributes();
        sb.append(attributeName);
        sb.append(" annotations: '");
        if (!existingAttributes.isEmpty()) {
            sb.append(existingAttributes);
            sb.append(SPACE_PIPE_SEPERATOR);
        }
        sb.append(VcfWriterUtils.refAttributesToString(atomicAttributes, attributesToInclude).replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", " "));
        sb.append("'");
    }

    private static String refAttributesToString(Iterable<Attribute> atomicAttributes, List<String> attributesToInclude) {
        Iterable attributes = StreamSupport.stream(atomicAttributes.spliterator(), false).filter(attribute -> attribute.isVisible() && VcfWriterUtils.isOutputAttribute(attribute, Lists.newArrayList((Iterable)atomicAttributes), attributesToInclude)).collect(Collectors.toList());
        return Joiner.on((String)SPACE_PIPE_SEPERATOR).join(Iterables.transform((Iterable)attributes, Attribute::getName));
    }

    private static void writeExistingInfoHeaders(BufferedWriter outputVCFWriter, Map<String, String> infoHeaderLinesMap, Map<String, Attribute> annotatorAttributes) throws IOException {
        for (String infoHeaderFieldKey : infoHeaderLinesMap.keySet()) {
            if (annotatorAttributes.containsKey(infoHeaderFieldKey)) continue;
            outputVCFWriter.write(infoHeaderLinesMap.get(infoHeaderFieldKey));
            outputVCFWriter.newLine();
        }
    }

    private static void addStandardFieldsToVcf(Entity vcfEntity, BufferedWriter writer) throws IOException {
        for (String attribute : VCF_ATTRIBUTE_NAMES) {
            Object value = vcfEntity.get(attribute);
            String stringValue = ".";
            if (value != null) {
                stringValue = value.toString();
            }
            if (stringValue.isEmpty()) {
                stringValue = ".";
            }
            writer.write(stringValue);
            writer.write(9);
        }
    }

    private static void writeInfoData(Entity vcfEntity, BufferedWriter writer, List<Attribute> annotatorAttributes, List<String> attributesToInclude) throws IOException {
        boolean hasInfoFields = false;
        List attributes = StreamSupport.stream(vcfEntity.getEntityType().getAllAttributes().spliterator(), false).filter(attr -> !VCF_ATTRIBUTE_NAMES.contains(attr.getName()) && !attr.getName().equals("INFO")).filter(attr -> VcfWriterUtils.isOutputAttribute(attr, annotatorAttributes, attributesToInclude)).collect(Collectors.toList());
        ArrayList<String> infoFieldStrs = new ArrayList<String>();
        for (Attribute attribute : attributes) {
            String infoFieldStr = VcfWriterUtils.getInfoFieldString(vcfEntity, attribute);
            if (infoFieldStr == null) continue;
            infoFieldStrs.add(infoFieldStr);
        }
        hasInfoFields = !infoFieldStrs.isEmpty();
        writer.append(infoFieldStrs.stream().collect(Collectors.joining(String.valueOf(';'))));
        String refEntityAttributesInfoFields = VcfWriterUtils.parseRefAttributesToDataString(vcfEntity, annotatorAttributes, attributesToInclude);
        if (!Strings.isNullOrEmpty((String)refEntityAttributesInfoFields)) {
            if (hasInfoFields) {
                writer.append(';');
            }
            writer.append(refEntityAttributesInfoFields);
            hasInfoFields = true;
        }
        if (!hasInfoFields) {
            writer.append('.');
        }
    }

    private static String parseRefAttributesToDataString(Entity vcfEntity, List<Attribute> annotatorAttributes, List<String> attributesToInclude) {
        Iterable attributes = vcfEntity.getEntityType().getAllAttributes();
        StringBuilder refEntityInfoFields = new StringBuilder();
        for (Attribute attribute : attributes) {
            String attributeName = attribute.getName();
            if (!EntityTypeUtils.isReferenceType((Attribute)attribute) || attributeName.equals("SAMPLES_ENTITIES") || vcfEntity.get(attributeName) == null || !VcfWriterUtils.isOutputAttribute(attribute, annotatorAttributes, attributesToInclude)) continue;
            VcfWriterUtils.parseRefFieldsToInfoField(vcfEntity.getEntities(attributeName), attribute, refEntityInfoFields, annotatorAttributes, attributesToInclude);
        }
        if (refEntityInfoFields.length() > 0 && refEntityInfoFields.charAt(refEntityInfoFields.length() - 1) == ';') {
            refEntityInfoFields.setLength(refEntityInfoFields.length() - 1);
        }
        return refEntityInfoFields.toString();
    }

    private static String getInfoFieldString(Entity vcfEntity, Attribute attribute) {
        Object infoAttrStringValue;
        String infoFieldValue = null;
        String infoAttrName = attribute.getName();
        if (attribute.getDataType() == AttributeType.BOOL) {
            Boolean infoAttrBoolValue = vcfEntity.getBoolean(infoAttrName);
            if (infoAttrBoolValue != null && infoAttrBoolValue.booleanValue()) {
                infoFieldValue = infoAttrName;
            }
        } else if (!EntityTypeUtils.isReferenceType((Attribute)attribute) && (infoAttrStringValue = vcfEntity.get(infoAttrName)) != null) {
            infoFieldValue = infoAttrName + '=' + infoAttrStringValue.toString();
        }
        return infoFieldValue;
    }

    private static void parseRefFieldsToInfoField(Iterable<Entity> refEntities, Attribute attribute, StringBuilder refEntityInfoFields, List<Attribute> annotatorAttributes, List<String> attributesToInclude) {
        boolean secondValuePresent = false;
        for (Entity refEntity : refEntities) {
            Iterable refAttributes = refEntity.getEntityType().getAttributes();
            if (!secondValuePresent) {
                refEntityInfoFields.append(attribute.getName());
                refEntityInfoFields.append("=");
                VcfWriterUtils.addEntityValuesToRefEntityInfoField(refEntityInfoFields, refEntity, refAttributes, annotatorAttributes, attributesToInclude);
            } else {
                refEntityInfoFields.append(",");
                VcfWriterUtils.addEntityValuesToRefEntityInfoField(refEntityInfoFields, refEntity, refAttributes, annotatorAttributes, attributesToInclude);
            }
            secondValuePresent = true;
        }
        refEntityInfoFields.append(';');
    }

    private static void addEntityValuesToRefEntityInfoField(StringBuilder refEntityInfoFields, Entity refEntity, Iterable<Attribute> refAttributes, List<Attribute> annotatorAttributes, List<String> attributesToInclude) {
        boolean previousValuePresent = false;
        for (Attribute refAttribute : refAttributes) {
            if (!refAttribute.isVisible() || EntityTypeUtils.isReferenceType((Attribute)refAttribute) || !VcfWriterUtils.isOutputAttribute(refAttribute, annotatorAttributes, attributesToInclude)) continue;
            if (previousValuePresent) {
                refEntityInfoFields.append('|');
            }
            String value = refEntity.getString(refAttribute.getName()) == null ? "" : refEntity.getString(refAttribute.getName());
            refEntityInfoFields.append(value);
            previousValuePresent = true;
        }
    }

    private static void addSampleEntitiesToVcf(Iterable<Entity> sampleEntities, BufferedWriter writer) throws IOException {
        boolean first = true;
        for (Entity sample : sampleEntities) {
            writer.append('\t');
            if (first) {
                VcfWriterUtils.writeFormatString(writer, sample);
            }
            VcfWriterUtils.writeSampleData(writer, sample);
            first = false;
        }
    }

    private static void writeSampleData(BufferedWriter writer, Entity sample) throws IOException {
        StringBuilder sampleColumn = new StringBuilder();
        if (sample.getEntityType().getAttribute("GT") != null) {
            String sampleAttrValue = sample.getString("GT");
            if (sampleAttrValue != null) {
                sampleColumn.append(sampleAttrValue);
            } else {
                sampleColumn.append(".");
            }
        }
        EntityType entityType = sample.getEntityType();
        for (Attribute sampleAttribute : entityType.getAttributes()) {
            Object sampleAttrValue;
            String sampleAttributeName = sampleAttribute.getName();
            if (sampleAttributeName.equals("GT") || sampleAttributeName.equals("ORIGINAL_NAME") || sampleAttribute.equals(entityType.getIdAttribute()) || sampleAttribute.equals(entityType.getLabelAttribute())) continue;
            if (sampleColumn.length() != 0) {
                sampleColumn.append(":");
            }
            if ((sampleAttrValue = sample.get(sampleAttributeName)) != null) {
                sampleColumn.append(sampleAttrValue.toString());
                continue;
            }
            sampleColumn.append(".");
        }
        writer.write(sampleColumn.toString());
    }

    private static void writeFormatString(BufferedWriter writer, Entity sample) throws IOException {
        StringBuilder formatColumn = new StringBuilder();
        if (sample.getEntityType().getAttribute("GT") != null) {
            formatColumn.append("GT");
        }
        EntityType entityType = sample.getEntityType();
        for (Attribute sampleAttribute : entityType.getAttributes()) {
            String sampleAttributeName = sampleAttribute.getName();
            if (sampleAttributeName.equals("GT") || sampleAttributeName.equals("ORIGINAL_NAME") || sampleAttribute.equals(entityType.getIdAttribute()) || sampleAttribute.equals(entityType.getLabelAttribute())) continue;
            if (formatColumn.length() != 0) {
                formatColumn.append(':');
            }
            formatColumn.append(sampleAttributeName);
        }
        if (formatColumn.length() <= 0) {
            throw new MolgenisDataException("Missing FORMAT information while trying to print first sample");
        }
        formatColumn.append('\t');
        writer.write(formatColumn.toString());
    }

    private static boolean isOutputAttribute(Attribute attribute, List<Attribute> addedAttributes, List<String> attributesToInclude) {
        ArrayList<Attribute> expandedAddedAttributes = new ArrayList<Attribute>();
        for (Attribute annotatorAttr : addedAttributes) {
            if (EntityTypeUtils.isReferenceType((Attribute)annotatorAttr)) {
                expandedAddedAttributes.addAll(Lists.newArrayList((Iterable)annotatorAttr.getRefEntity().getAtomicAttributes()));
                continue;
            }
            expandedAddedAttributes.add(annotatorAttr);
        }
        List annotatorAttributeNames = expandedAddedAttributes.stream().map(Attribute::getName).collect(Collectors.toList());
        return (!annotatorAttributeNames.contains(attribute.getName()) || attributesToInclude.contains(attribute.getName()) || attributesToInclude.isEmpty()) && attribute.isVisible() && !attribute.getName().equals("SAMPLES_ENTITIES");
    }
}

