/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.importer;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.StreamSupport;
import org.molgenis.data.DataService;
import org.molgenis.data.DatabaseAction;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.importer.EntitiesValidationReport;
import org.molgenis.data.importer.EntitiesValidationReportImpl;
import org.molgenis.data.importer.EntityImportReport;
import org.molgenis.data.importer.ImportService;
import org.molgenis.data.meta.DefaultPackage;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.security.permission.PermissionSystemService;
import org.molgenis.data.vcf.VcfFileExtensions;
import org.molgenis.security.core.runas.RunAsSystemAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VcfImporterService
implements ImportService {
    private static final Logger LOG = LoggerFactory.getLogger(VcfImporterService.class);
    private static final int BATCH_SIZE = 10000;
    private final DataService dataService;
    private final PermissionSystemService permissionSystemService;
    private final MetaDataService metaDataService;
    private final DefaultPackage defaultPackage;

    public VcfImporterService(DataService dataService, PermissionSystemService permissionSystemService, MetaDataService metaDataService, DefaultPackage defaultPackage) {
        this.dataService = Objects.requireNonNull(dataService);
        this.metaDataService = Objects.requireNonNull(metaDataService);
        this.permissionSystemService = Objects.requireNonNull(permissionSystemService);
        this.defaultPackage = Objects.requireNonNull(defaultPackage);
    }

    @Transactional
    public EntityImportReport doImport(RepositoryCollection source, DatabaseAction databaseAction, String packageId) {
        EntityImportReport report;
        block16: {
            if (databaseAction != DatabaseAction.ADD) {
                throw new IllegalArgumentException("Only ADD is supported");
            }
            ArrayList addedEntities = Lists.newArrayList();
            Iterator it = source.getEntityTypeIds().iterator();
            if (it.hasNext()) {
                try (Repository repo = source.getRepository((String)it.next());){
                    report = this.importVcf((Repository<Entity>)repo, addedEntities, packageId);
                    break block16;
                }
                catch (IOException e) {
                    LOG.error("", (Throwable)e);
                    throw new MolgenisDataException((Throwable)e);
                }
            }
            report = new EntityImportReport();
        }
        return report;
    }

    public EntitiesValidationReport validateImport(File file, RepositoryCollection source) {
        EntitiesValidationReportImpl report = new EntitiesValidationReportImpl();
        Iterator it = source.getEntityTypeIds().iterator();
        if (it.hasNext()) {
            String entityTypeId = (String)it.next();
            EntityType emd = source.getRepository(entityTypeId).getEntityType();
            boolean entityExists = (Boolean)RunAsSystemAspect.runAsSystem(() -> this.dataService.hasRepository(entityTypeId));
            report.getSheetsImportable().put(entityTypeId, !entityExists);
            ArrayList availableAttributeNames = Lists.newArrayList();
            for (Attribute attr : emd.getAtomicAttributes()) {
                availableAttributeNames.add(attr.getName());
            }
            report.getFieldsImportable().put(entityTypeId, availableAttributeNames);
            Attribute sampleAttribute = emd.getAttribute("SAMPLES_ENTITIES");
            if (sampleAttribute != null) {
                String sampleEntityName = sampleAttribute.getRefEntity().getId();
                boolean sampleEntityExists = (Boolean)RunAsSystemAspect.runAsSystem(() -> this.dataService.hasRepository(sampleEntityName));
                report.getSheetsImportable().put(sampleEntityName, !sampleEntityExists);
                ArrayList availableSampleAttributeNames = Lists.newArrayList();
                for (Attribute attr : sampleAttribute.getRefEntity().getAtomicAttributes()) {
                    availableSampleAttributeNames.add(attr.getName());
                }
                report.getFieldsImportable().put(sampleEntityName, availableSampleAttributeNames);
            }
        }
        return report;
    }

    public boolean canImport(File file, RepositoryCollection source) {
        for (String extension : this.getSupportedFileExtensions()) {
            if (!file.getName().toLowerCase().endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private EntityImportReport importVcf(Repository<Entity> inRepository, List<EntityType> addedEntities, String packageId) throws IOException {
        EntityImportReport report = new EntityImportReport();
        String entityTypeId = inRepository.getName();
        if (((Boolean)RunAsSystemAspect.runAsSystem(() -> this.dataService.hasRepository(entityTypeId))).booleanValue()) {
            throw new MolgenisDataException("Can't overwrite existing " + entityTypeId);
        }
        EntityType entityType = inRepository.getEntityType();
        entityType.setBackend(this.metaDataService.getDefaultBackend().getName());
        Package targetPackage = this.determineTargetPackage(packageId, entityType);
        Repository<Entity> sampleRepository = this.createSampleRepository(addedEntities, entityType, targetPackage);
        Iterator inIterator = inRepository.iterator();
        try (Repository outRepository = (Repository)RunAsSystemAspect.runAsSystem(() -> this.dataService.getMeta().createRepository(entityType));){
            this.permissionSystemService.giveUserWriteMetaPermissions(entityType);
            addedEntities.add(entityType);
            if (sampleRepository != null) {
                int sampleEntityCount = this.addSampleEntities(sampleRepository, inIterator);
                report.addNewEntity(sampleRepository.getName());
                if (sampleEntityCount > 0) {
                    report.addEntityCount(sampleRepository.getName(), sampleEntityCount);
                }
            }
            AtomicInteger vcfEntityCount = new AtomicInteger();
            RunAsSystemAspect.runAsSystem(() -> outRepository.add(StreamSupport.stream(inRepository.spliterator(), false).filter(entity -> {
                vcfEntityCount.incrementAndGet();
                return true;
            })));
            if (vcfEntityCount.get() > 0) {
                report.addEntityCount(entityTypeId, vcfEntityCount.get());
            }
        }
        report.addNewEntity(entityTypeId);
        return report;
    }

    private int addSampleEntities(Repository<Entity> sampleRepository, Iterator<Entity> inIterator) {
        int sampleEntityCount = 0;
        ArrayList<Entity> batch = new ArrayList<Entity>();
        while (inIterator.hasNext()) {
            Entity entity = inIterator.next();
            Iterable samples = entity.getEntities("SAMPLES_ENTITIES");
            if (samples == null) continue;
            for (Entity sample : samples) {
                batch.add(sample);
                if (batch.size() != 10000) continue;
                sampleRepository.add(batch.stream());
                sampleEntityCount += batch.size();
                batch.clear();
            }
        }
        if (!batch.isEmpty()) {
            RunAsSystemAspect.runAsSystem(() -> sampleRepository.add(batch.stream()));
            sampleEntityCount += batch.size();
        }
        return sampleEntityCount;
    }

    private Repository<Entity> createSampleRepository(List<EntityType> addedEntities, EntityType entityType, Package targetPackage) {
        Repository sampleRepository;
        Attribute sampleAttribute = entityType.getAttribute("SAMPLES_ENTITIES");
        if (sampleAttribute != null) {
            EntityType samplesEntityType = sampleAttribute.getRefEntity();
            samplesEntityType.setBackend(this.metaDataService.getDefaultBackend().getName());
            samplesEntityType.setPackage(targetPackage);
            sampleRepository = (Repository)RunAsSystemAspect.runAsSystem(() -> this.dataService.getMeta().createRepository(samplesEntityType));
            this.permissionSystemService.giveUserWriteMetaPermissions(samplesEntityType);
            addedEntities.add(sampleAttribute.getRefEntity());
        } else {
            sampleRepository = null;
        }
        return sampleRepository;
    }

    private Package determineTargetPackage(String packageId, EntityType entityType) {
        DefaultPackage targetPackage;
        if (packageId != null) {
            targetPackage = this.dataService.getMeta().getPackage(packageId);
            if (targetPackage == null) {
                throw new MolgenisDataException(String.format("Unknown package [%s]", packageId));
            }
            entityType.setPackage((Package)targetPackage);
        } else {
            targetPackage = this.defaultPackage;
        }
        return targetPackage;
    }

    public int getOrder() {
        return 10;
    }

    public List<DatabaseAction> getSupportedDatabaseActions() {
        return Lists.newArrayList((Object[])new DatabaseAction[]{DatabaseAction.ADD});
    }

    public boolean getMustChangeEntityName() {
        return true;
    }

    public Set<String> getSupportedFileExtensions() {
        return VcfFileExtensions.getVCF();
    }

    public Map<String, Boolean> determineImportableEntities(MetaDataService metaDataService, RepositoryCollection repositoryCollection, String defaultPackage) {
        return metaDataService.determineImportableEntities(repositoryCollection);
    }
}

