/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.utils.test;

import java.io.IOException;
import java.util.ArrayList;
import org.molgenis.data.AbstractMolgenisSpringTest;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.support.DynamicEntity;
import org.molgenis.data.vcf.config.VcfTestConfig;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.molgenis.data.vcf.utils.VcfUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.ContextConfiguration;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@ContextConfiguration(classes={Config.class})
public class VcfUtilsTest
extends AbstractMolgenisSpringTest {
    @Autowired
    EntityTypeFactory entityTypeFactory;
    @Autowired
    AttributeFactory attributeFactory;
    @Autowired
    VcfAttributes vcfAttributes;
    @Autowired
    VcfUtils vcfUtils;
    private EntityType annotatedEntityType;
    public EntityType metaDataCanAnnotate;
    public EntityType metaDataCantAnnotate;
    public Attribute attributeChrom;
    public Attribute attributePos;
    public Attribute attributeRef;
    public Attribute attributeAlt;
    public Attribute attributeCantAnnotateChrom;
    public ArrayList<Entity> input = new ArrayList();
    public Entity entity;
    public Entity entity1;
    public Entity entity2;
    public Entity entity3;
    public Entity entity4;
    public ArrayList<Entity> entities;
    private EntityType expectedEffectsEntityType;

    @BeforeClass
    public void beforeClass() {
        this.annotatedEntityType = (EntityType)this.entityTypeFactory.create((Object)"test");
        this.metaDataCanAnnotate = (EntityType)this.entityTypeFactory.create((Object)"test");
        this.metaDataCantAnnotate = (EntityType)this.entityTypeFactory.create((Object)"test");
        this.attributeChrom = this.attributeFactory.create().setName("#CHROM").setDataType(AttributeType.STRING);
        this.attributePos = this.attributeFactory.create().setName("POS").setDataType(AttributeType.INT);
        this.attributeRef = this.attributeFactory.create().setName("REF").setDataType(AttributeType.STRING);
        this.attributeAlt = this.attributeFactory.create().setName("ALT").setDataType(AttributeType.STRING);
        this.attributeCantAnnotateChrom = this.attributeFactory.create().setName("#CHROM").setDataType(AttributeType.LONG);
    }

    @BeforeMethod
    public void beforeMethod() throws IOException {
        this.metaDataCanAnnotate.addAttribute(this.attributeChrom, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID});
        this.metaDataCanAnnotate.addAttribute(this.attributePos, new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(this.attributeRef, new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(this.attributeAlt, new EntityType.AttributeRole[0]);
        this.metaDataCantAnnotate.addAttribute(this.attributeCantAnnotateChrom, new EntityType.AttributeRole[0]);
        this.metaDataCantAnnotate.addAttribute(this.attributePos, new EntityType.AttributeRole[0]);
        this.metaDataCantAnnotate.addAttribute(this.attributeRef, new EntityType.AttributeRole[0]);
        this.metaDataCantAnnotate.addAttribute(this.attributeAlt, new EntityType.AttributeRole[0]);
        this.entity = new DynamicEntity(this.metaDataCanAnnotate);
        this.entity1 = new DynamicEntity(this.metaDataCanAnnotate);
        this.entity2 = new DynamicEntity(this.metaDataCanAnnotate);
        this.entity3 = new DynamicEntity(this.metaDataCanAnnotate);
        this.entity4 = new DynamicEntity(this.metaDataCanAnnotate);
        this.metaDataCanAnnotate.addAttribute(this.attributeFactory.create().setName("ID").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(this.attributeFactory.create().setName("QUAL").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(this.attributeFactory.create().setName("FILTER").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(this.attributeFactory.create().setName("EFFECT").setDataType(AttributeType.STRING).setDescription("EFFECT annotations: 'Alt_Allele | Gene_Name | Annotation | Putative_impact | Gene_ID | Feature_type | Feature_ID | Transcript_biotype | Rank_total | HGVS_c | HGVS_p | cDNA_position | CDS_position | Protein_position | Distance_to_feature | Errors'"), new EntityType.AttributeRole[0]);
        Attribute INFO = this.attributeFactory.create().setName("INFO").setDataType(AttributeType.COMPOUND);
        Attribute AC = this.attributeFactory.create().setName("AC").setDataType(AttributeType.STRING).setParent(INFO);
        Attribute AN = this.attributeFactory.create().setName("AN").setDataType(AttributeType.STRING).setParent(INFO);
        Attribute GTC = this.attributeFactory.create().setName("GTC").setDataType(AttributeType.STRING).setParent(INFO);
        this.metaDataCanAnnotate.addAttribute(INFO, new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(AC, new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(AN, new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(GTC, new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(this.attributeChrom, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID});
        this.annotatedEntityType.addAttribute(this.attributePos, new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(this.attributeRef, new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(this.attributeAlt, new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(this.attributeFactory.create().setName("ID").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(this.attributeFactory.create().setName("QUAL").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(this.attributeFactory.create().setName("FILTER").setDataType(AttributeType.STRING).setDescription("Test that description is not: 'Description not provided'"), new EntityType.AttributeRole[0]);
        Attribute annoAttr = this.attributeFactory.create().setName("ANNO").setDataType(AttributeType.STRING).setParent(INFO);
        this.annotatedEntityType.addAttribute(INFO, new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(AC, new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(AN, new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(GTC, new EntityType.AttributeRole[0]);
        this.annotatedEntityType.addAttribute(annoAttr, new EntityType.AttributeRole[0]);
        this.metaDataCanAnnotate.addAttribute(annoAttr, new EntityType.AttributeRole[0]);
        this.entity1.set("#CHROM", (Object)"1");
        this.entity1.set("POS", (Object)10050000);
        this.entity1.set("ID", (Object)"test21");
        this.entity1.set("REF", (Object)"G");
        this.entity1.set("ALT", (Object)"A");
        this.entity1.set("QUAL", (Object)".");
        this.entity1.set("FILTER", (Object)"PASS");
        this.entity1.set("AC", (Object)"21");
        this.entity1.set("AN", (Object)"22");
        this.entity1.set("GTC", (Object)"0,1,10");
        this.entity1.set("EFFECT", (Object)"A|TUBB8|missense_variant|MODERATE|TUBB8|transcript|NM_177987.2|Coding|4/4|c.1286C>T|p.Thr429Met|1286/1504|1286/1335|429/444||");
        this.entity2.set("#CHROM", (Object)"1");
        this.entity2.set("POS", (Object)10050001);
        this.entity2.set("ID", (Object)"test22");
        this.entity2.set("REF", (Object)"G");
        this.entity2.set("ALT", (Object)"A");
        this.entity2.set("QUAL", (Object)".");
        this.entity2.set("FILTER", (Object)"PASS");
        this.entity2.set("EFFECT", (Object)"A|TUBB8|missense_variant|MODERATE|TUBB8|transcript|NM_177987.2|Coding|4/4|c.1286C>T|p.Thr429Met|1286/1504|1286/1335|429/444||,A|GEN2|missense_variant|MODERATE|GEN2|transcript|NM_177987.2|Coding|4/4|c.1286C>T|p.Thr429Met|1286/1504|1286/1335|429/444||");
        this.entity3.set("#CHROM", (Object)"1");
        this.entity3.set("POS", (Object)10050002);
        this.entity3.set("ID", (Object)"test23");
        this.entity3.set("REF", (Object)"G");
        this.entity3.set("ALT", (Object)"A");
        this.entity3.set("QUAL", (Object)".");
        this.entity3.set("FILTER", (Object)"PASS");
        this.entities = new ArrayList();
        this.entities.add(this.entity1);
        this.entities.add(this.entity2);
        this.entities.add(this.entity3);
        this.expectedEffectsEntityType = (EntityType)this.entityTypeFactory.create((Object)"EFFECTannotations");
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("identifier").setDataType(AttributeType.STRING), new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID});
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("Alt_Allele").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("Gene_Name").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("Annotation").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("Putative_impact").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("Gene_ID").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("Feature_type").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("Feature_ID").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("Transcript_biotype").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("Rank_total").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("HGVS_c").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("HGVS_p").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("cDNA_position").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("CDS_position").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("Protein_position").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("Distance_to_feature").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("Errors").setDataType(AttributeType.STRING), new EntityType.AttributeRole[0]);
        this.expectedEffectsEntityType.addAttribute(this.attributeFactory.create().setName("VARIANT").setDataType(AttributeType.XREF).setRefEntity(this.metaDataCanAnnotate), new EntityType.AttributeRole[0]);
    }

    @Test
    public void createId() {
        Assert.assertEquals((String)VcfUtils.createId((Entity)this.entity1), (String)"VWnsXKOj5B7PBk4dwFLsQw");
    }

    @Configuration
    @Import(value={VcfTestConfig.class})
    public static class Config {
    }
}

