/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.molgenis.data.AbstractMolgenisSpringTest;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.vcf.VcfRepository;
import org.molgenis.data.vcf.config.VcfTestConfig;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ClassPathResource;
import org.springframework.test.context.ContextConfiguration;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@ContextConfiguration(classes={Config.class})
public class VcfRepositoryTest
extends AbstractMolgenisSpringTest {
    @Autowired
    private VcfAttributes vcfAttrs;
    @Autowired
    private EntityTypeFactory entityTypeFactory;
    @Autowired
    private AttributeFactory attrMetaFactory;
    @Mock
    private Consumer<List<Entity>> batchConsumer;
    @Captor
    private ArgumentCaptor<List<Entity>> entityListCaptor;
    private static File testData;
    private static File testNoData;
    private static File testEmptyFile;

    @BeforeClass
    public void beforeClass() throws IOException {
        testData = new ClassPathResource("testdata.vcf").getFile();
        testNoData = new ClassPathResource("testnodata.vcf").getFile();
        testEmptyFile = Files.createTempFile("empty", "vcf", new FileAttribute[0]).toFile();
    }

    @AfterClass
    public void afterClass() {
        testEmptyFile.delete();
    }

    @Test(expectedExceptions={MolgenisDataException.class}, expectedExceptionsMessageRegExp="Failed to read VCF Metadata from file; nested exception is java.io.IOException: missing column headers")
    public void testCreateRepositoryForEmptyFile() {
        new VcfRepository(testEmptyFile, "test", this.vcfAttrs, this.entityTypeFactory, this.attrMetaFactory);
    }

    @Test
    public void metaData() {
        VcfRepository vcfRepository = new VcfRepository(testData, "testData", this.vcfAttrs, this.entityTypeFactory, this.attrMetaFactory);
        Assert.assertEquals((String)vcfRepository.getName(), (String)"testData");
        Iterator it = vcfRepository.getEntityType().getAttributes().iterator();
        Assert.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "#CHROM", AttributeType.STRING);
        Assert.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "ALT", AttributeType.TEXT);
        Assert.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "POS", AttributeType.INT);
        Assert.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "REF", AttributeType.TEXT);
        Assert.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "FILTER", AttributeType.STRING);
        Assert.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "QUAL", AttributeType.STRING);
        Assert.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "ID", AttributeType.STRING);
        Assert.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "INTERNAL_ID", AttributeType.STRING);
        Assert.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "INFO", AttributeType.COMPOUND);
        Assert.assertTrue((boolean)it.hasNext());
    }

    private static void testAttribute(Attribute metadata, String name, AttributeType type) {
        Assert.assertEquals((String)metadata.getName(), (String)name);
        Assert.assertEquals((Object)metadata.getDataType(), (Object)type);
    }

    @Test
    public void testForEachBatched() {
        VcfRepository vcfRepository = new VcfRepository(testData, "testData", this.vcfAttrs, this.entityTypeFactory, this.attrMetaFactory);
        vcfRepository.forEachBatched(this.batchConsumer, 5);
        ((Consumer)Mockito.verify(this.batchConsumer, (VerificationMode)Mockito.times((int)2))).accept(this.entityListCaptor.capture());
        List allValues = this.entityListCaptor.getAllValues();
        List positions = allValues.stream().map(batch -> batch.stream().map(entity -> entity.getInt("POS")).collect(Collectors.toList())).collect(Collectors.toList());
        Assert.assertEquals(positions, (Collection)ImmutableList.of((Object)ImmutableList.of((Object)565286, (Object)0x223C22, (Object)3171929, (Object)3172062, (Object)3172273), (Object)ImmutableList.of((Object)6097450, (Object)7569187)));
        Set chroms = allValues.stream().flatMap(batch -> batch.stream().map(entity -> entity.getString("#CHROM"))).collect(Collectors.toSet());
        Assert.assertEquals(chroms, Collections.singleton("1"));
    }

    @Test
    public void iterator_noValues() {
        VcfRepository vcfRepository = new VcfRepository(testNoData, "testNoData", this.vcfAttrs, this.entityTypeFactory, this.attrMetaFactory);
        vcfRepository.forEachBatched(this.batchConsumer, 1000);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.batchConsumer});
    }

    @Configuration
    @Import(value={VcfTestConfig.class})
    public static class Config {
    }
}

