/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.importer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.molgenis.data.DataAction;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.importer.EntitiesValidationReport;
import org.molgenis.data.importer.EntitiesValidationReportImpl;
import org.molgenis.data.importer.EntityImportReport;
import org.molgenis.data.importer.ImportService;
import org.molgenis.data.importer.MetadataAction;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.security.permission.PermissionSystemService;
import org.molgenis.data.vcf.VcfFileExtensions;
import org.molgenis.security.core.runas.RunAsSystemAspect;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VcfImporterService
implements ImportService {
    private static final int BATCH_SIZE = 10000;
    private final DataService dataService;
    private final PermissionSystemService permissionSystemService;
    private final MetaDataService metaDataService;

    public VcfImporterService(DataService dataService, PermissionSystemService permissionSystemService, MetaDataService metaDataService) {
        this.dataService = Objects.requireNonNull(dataService);
        this.metaDataService = Objects.requireNonNull(metaDataService);
        this.permissionSystemService = Objects.requireNonNull(permissionSystemService);
    }

    @Transactional
    public EntityImportReport doImport(RepositoryCollection source, MetadataAction metadataAction, DataAction dataAction, @Nullable String packageId) {
        EntityImportReport report;
        block17: {
            if (dataAction != DataAction.ADD) {
                throw new IllegalArgumentException("Only ADD is supported");
            }
            Package importPackage = null;
            if (packageId != null) {
                importPackage = (Package)this.metaDataService.getPackage(packageId).orElseThrow(() -> new UnknownEntityException("sys_md_Package", (Object)packageId));
            }
            ArrayList<EntityType> addedEntities = new ArrayList<EntityType>();
            Iterator it = source.getEntityTypeIds().iterator();
            if (it.hasNext()) {
                try (Repository repo = source.getRepository((String)it.next());){
                    report = this.importVcf((Repository<Entity>)repo, addedEntities, importPackage);
                    break block17;
                }
                catch (IOException e) {
                    throw new MolgenisDataException((Throwable)e);
                }
            }
            report = new EntityImportReport();
        }
        return report;
    }

    public EntitiesValidationReport validateImport(File file, RepositoryCollection source) {
        EntitiesValidationReportImpl report = new EntitiesValidationReportImpl();
        Iterator it = source.getEntityTypeIds().iterator();
        if (it.hasNext()) {
            String entityTypeId = (String)it.next();
            EntityType emd = source.getRepository(entityTypeId).getEntityType();
            boolean entityExists = (Boolean)RunAsSystemAspect.runAsSystem(() -> this.dataService.hasRepository(entityTypeId));
            report.getSheetsImportable().put(entityTypeId, !entityExists);
            ArrayList availableAttributeNames = Lists.newArrayList();
            for (Attribute attr : emd.getAtomicAttributes()) {
                availableAttributeNames.add(attr.getName());
            }
            report.getFieldsImportable().put(entityTypeId, availableAttributeNames);
            Attribute sampleAttribute = emd.getAttribute("SAMPLES_ENTITIES");
            if (sampleAttribute != null) {
                String sampleEntityName = sampleAttribute.getRefEntity().getId();
                boolean sampleEntityExists = (Boolean)RunAsSystemAspect.runAsSystem(() -> this.dataService.hasRepository(sampleEntityName));
                report.getSheetsImportable().put(sampleEntityName, !sampleEntityExists);
                ArrayList availableSampleAttributeNames = Lists.newArrayList();
                for (Attribute attr : sampleAttribute.getRefEntity().getAtomicAttributes()) {
                    availableSampleAttributeNames.add(attr.getName());
                }
                report.getFieldsImportable().put(sampleEntityName, availableSampleAttributeNames);
            }
        }
        return report;
    }

    public boolean canImport(File file, RepositoryCollection source) {
        for (String extension : this.getSupportedFileExtensions()) {
            if (!file.getName().toLowerCase().endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private EntityImportReport importVcf(Repository<Entity> inRepository, List<EntityType> addedEntities, Package importPackage) throws IOException {
        EntityImportReport report = new EntityImportReport();
        String entityTypeId = inRepository.getName();
        if (((Boolean)RunAsSystemAspect.runAsSystem(() -> this.dataService.hasRepository(entityTypeId))).booleanValue()) {
            throw new MolgenisDataException("Can't overwrite existing " + entityTypeId);
        }
        EntityType entityType = inRepository.getEntityType();
        entityType.setBackend(this.metaDataService.getDefaultBackend().getName());
        entityType.setPackage(importPackage);
        Repository<Entity> sampleRepository = this.createSampleRepository(addedEntities, entityType, importPackage);
        try (Repository outRepository = this.dataService.getMeta().createRepository(entityType);){
            this.permissionSystemService.giveUserWriteMetaPermissions(entityType);
            addedEntities.add(entityType);
            if (sampleRepository != null) {
                int sampleEntityCount = this.addSampleEntities(sampleRepository, inRepository);
                report.addNewEntity(sampleRepository.getName());
                if (sampleEntityCount > 0) {
                    report.addEntityCount(sampleRepository.getName(), sampleEntityCount);
                }
            }
            AtomicInteger vcfEntityCount = new AtomicInteger();
            inRepository.forEachBatched(rowBatch -> {
                outRepository.add(rowBatch.stream());
                vcfEntityCount.addAndGet(rowBatch.size());
            }, 1000);
            if (vcfEntityCount.get() > 0) {
                report.addEntityCount(entityTypeId, vcfEntityCount.get());
            }
        }
        report.addNewEntity(entityTypeId);
        return report;
    }

    private int addSampleEntities(Repository<Entity> sampleRepository, Repository<Entity> inRepository) {
        AtomicInteger sampleEntityCount = new AtomicInteger(0);
        ArrayList sampleBatch = new ArrayList();
        inRepository.forEachBatched(rowBatch -> {
            for (Entity entity : rowBatch) {
                Iterable samples = entity.getEntities("SAMPLES_ENTITIES");
                if (samples == null) continue;
                for (Entity sample : samples) {
                    sampleBatch.add(sample);
                    if (sampleBatch.size() != 10000) continue;
                    sampleRepository.add(sampleBatch.stream());
                    sampleEntityCount.addAndGet(sampleBatch.size());
                    sampleBatch.clear();
                }
            }
        }, 1000);
        if (!sampleBatch.isEmpty()) {
            sampleRepository.add(sampleBatch.stream());
            sampleEntityCount.addAndGet(sampleBatch.size());
        }
        return sampleEntityCount.get();
    }

    private Repository<Entity> createSampleRepository(List<EntityType> addedEntities, EntityType entityType, Package samplePackage) {
        Repository sampleRepository;
        Attribute sampleAttribute = entityType.getAttribute("SAMPLES_ENTITIES");
        if (sampleAttribute != null) {
            EntityType samplesEntityType = sampleAttribute.getRefEntity();
            samplesEntityType.setBackend(this.metaDataService.getDefaultBackend().getName());
            samplesEntityType.setPackage(samplePackage);
            sampleRepository = this.dataService.getMeta().createRepository(samplesEntityType);
            this.permissionSystemService.giveUserWriteMetaPermissions(samplesEntityType);
            addedEntities.add(sampleAttribute.getRefEntity());
        } else {
            sampleRepository = null;
        }
        return sampleRepository;
    }

    public int getOrder() {
        return 10;
    }

    public List<MetadataAction> getSupportedMetadataActions() {
        return ImmutableList.of((Object)MetadataAction.ADD);
    }

    public List<DataAction> getSupportedDataActions() {
        return Lists.newArrayList((Object[])new DataAction[]{DataAction.ADD});
    }

    public boolean getMustChangeEntityName() {
        return true;
    }

    public Set<String> getSupportedFileExtensions() {
        return VcfFileExtensions.getVCF();
    }

    public Map<String, Boolean> determineImportableEntities(MetaDataService metaDataService, RepositoryCollection repositoryCollection, String defaultPackage) {
        return metaDataService.determineImportableEntities(repositoryCollection);
    }
}

