/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf;

import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.support.AbstractRepository;
import org.molgenis.data.vcf.format.VcfToEntity;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.molgenis.vcf.VcfReader;
import org.molgenis.vcf.meta.VcfMeta;

public class VcfRepository
extends AbstractRepository {
    public static final String DEFAULT_ATTRIBUTE_DESCRIPTION = "Description not provided";
    public static final String NAME = "NAME";
    public static final String ORIGINAL_NAME = "ORIGINAL_NAME";
    public static final String PREFIX = "##";
    public static final int BATCH_SIZE = 1000;
    private final String entityTypeId;
    private final VcfAttributes vcfAttributes;
    private final EntityTypeFactory entityTypeFactory;
    private final AttributeFactory attrMetaFactory;
    private VcfToEntity vcfToEntity;
    private final File file;

    VcfRepository(File file, String entityTypeId, VcfAttributes vcfAttributes, EntityTypeFactory entityTypeFactory, AttributeFactory attrMetaFactory) {
        this.file = Objects.requireNonNull(file);
        this.entityTypeId = Objects.requireNonNull(entityTypeId);
        this.vcfAttributes = Objects.requireNonNull(vcfAttributes);
        this.entityTypeFactory = Objects.requireNonNull(entityTypeFactory);
        this.attrMetaFactory = Objects.requireNonNull(attrMetaFactory);
        this.parseVcfMeta();
    }

    private void parseVcfMeta() {
        this.withReader(reader -> {
            try {
                VcfMeta vcfMeta = reader.getVcfMeta();
                this.vcfToEntity = new VcfToEntity(this.entityTypeId, vcfMeta, this.vcfAttributes, this.entityTypeFactory, this.attrMetaFactory);
            }
            catch (IOException | RuntimeException e) {
                throw new MolgenisDataException("Failed to read VCF Metadata from file", (Throwable)e);
            }
        });
    }

    public Iterator<Entity> iterator() {
        throw new UnsupportedOperationException("Use forEachBatched instead of iterator");
    }

    public EntityType getEntityType() {
        return this.vcfToEntity.getEntityType();
    }

    public Set<RepositoryCapability> getCapabilities() {
        return Collections.emptySet();
    }

    public long count() {
        AtomicInteger counter = new AtomicInteger(0);
        this.forEachBatched(batch -> counter.addAndGet(batch.size()), 1000);
        return counter.get();
    }

    public void forEachBatched(Consumer<List<Entity>> consumer, int batchSize) {
        this.withReader(reader -> Streams.stream((Iterator)Iterators.partition((Iterator)Iterators.transform((Iterator)reader.iterator(), this.vcfToEntity::toEntity), (int)batchSize)).forEach(consumer));
    }

    private void withReader(Consumer<VcfReader> consumer) {
        this.withInputStream(inputStream -> {
            try (VcfReader reader = new VcfReader((Reader)new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));){
                consumer.accept(reader);
            }
            catch (IOException e) {
                throw new MolgenisDataException("Failed to create VCF Reader for file" + this.file.getAbsolutePath(), (Throwable)e);
            }
        });
    }

    private void withInputStream(Consumer<InputStream> consumer) {
        block9: {
            try {
                if (this.file.getName().endsWith(".gz")) {
                    consumer.accept(new GZIPInputStream(new FileInputStream(this.file)));
                    break block9;
                }
                if (this.file.getName().endsWith(".zip")) {
                    try (ZipFile zipFile = new ZipFile(this.file.getPath());){
                        Enumeration<? extends ZipEntry> e = zipFile.entries();
                        ZipEntry entry = e.nextElement();
                        consumer.accept(zipFile.getInputStream(entry));
                        break block9;
                    }
                }
                consumer.accept(new FileInputStream(this.file));
            }
            catch (IOException e) {
                throw new MolgenisDataException("Failed to create InputStream for file" + this.file.getAbsolutePath(), (Throwable)e);
            }
        }
    }
}

