/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.util.UnexpectedEnumException;
import org.molgenis.vcf.meta.VcfMetaInfo;
import org.springframework.stereotype.Component;

@Component
public class VcfUtils {
    public static String createId(Entity vcfEntity) {
        MessageDigest messageDigest;
        String idStr = StringUtils.strip((String)vcfEntity.get("#CHROM").toString()) + "_" + StringUtils.strip((String)vcfEntity.get("POS").toString()) + "_" + StringUtils.strip((String)vcfEntity.get("REF").toString()) + "_" + StringUtils.strip((String)vcfEntity.get("ALT").toString()) + "_" + StringUtils.strip((String)vcfEntity.get("ID").toString()) + "_" + StringUtils.strip((String)(vcfEntity.get("QUAL") != null ? vcfEntity.get("QUAL").toString() : "")) + "_" + StringUtils.strip((String)(vcfEntity.get("FILTER") != null ? vcfEntity.get("FILTER").toString() : ""));
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] md5Hash = messageDigest.digest(idStr.getBytes(StandardCharsets.UTF_8));
        return Base64.getUrlEncoder().withoutPadding().encodeToString(md5Hash);
    }

    public static String getIdFromInfoField(String line) {
        int idStartIndex = line.indexOf("ID=") + 3;
        int idEndIndex = line.indexOf(44);
        return line.substring(idStartIndex, idEndIndex);
    }

    public static List<Attribute> getAtomicAttributesFromList(Iterable<Attribute> outputAttrs) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        for (Attribute attribute : outputAttrs) {
            if (attribute.getDataType() == AttributeType.COMPOUND) {
                result.addAll(VcfUtils.getAtomicAttributesFromList(attribute.getChildren()));
                continue;
            }
            result.add(attribute);
        }
        return result;
    }

    public static Map<String, Attribute> getAttributesMapFromList(Iterable<Attribute> outputAttrs) {
        LinkedHashMap<String, Attribute> attributeMap = new LinkedHashMap<String, Attribute>();
        List<Attribute> attributes = VcfUtils.getAtomicAttributesFromList(outputAttrs);
        for (Attribute attribute : attributes) {
            attributeMap.put(attribute.getName(), attribute);
        }
        return attributeMap;
    }

    protected static String toVcfDataType(AttributeType dataType) {
        switch (dataType) {
            case BOOL: {
                return VcfMetaInfo.Type.FLAG.toString();
            }
            case LONG: 
            case DECIMAL: {
                return VcfMetaInfo.Type.FLOAT.toString();
            }
            case INT: {
                return VcfMetaInfo.Type.INTEGER.toString();
            }
            case EMAIL: 
            case ENUM: 
            case HTML: 
            case HYPERLINK: 
            case STRING: 
            case TEXT: 
            case DATE: 
            case DATE_TIME: 
            case CATEGORICAL: 
            case XREF: 
            case CATEGORICAL_MREF: 
            case MREF: 
            case ONE_TO_MANY: {
                return VcfMetaInfo.Type.STRING.toString();
            }
            case COMPOUND: 
            case FILE: {
                throw new RuntimeException("invalid vcf data type " + dataType);
            }
        }
        throw new UnexpectedEnumException((Enum)dataType);
    }
}

