/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.molgenis.data.AbstractMolgenisSpringTest;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.vcf.VcfRepository;
import org.molgenis.data.vcf.config.VcfTestConfig;
import org.molgenis.data.vcf.model.VcfAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ClassPathResource;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(classes={Config.class})
class VcfRepositoryTest
extends AbstractMolgenisSpringTest {
    @Autowired
    private VcfAttributes vcfAttrs;
    @Autowired
    private EntityTypeFactory entityTypeFactory;
    @Autowired
    private AttributeFactory attrMetaFactory;
    @Mock
    private Consumer<List<Entity>> batchConsumer;
    @Captor
    private ArgumentCaptor<List<Entity>> entityListCaptor;
    private static File testData;
    private static File testNoData;
    private static File testEmptyFile;

    VcfRepositoryTest() {
    }

    @BeforeAll
    static void beforeClass() throws IOException {
        testData = new ClassPathResource("testdata.vcf").getFile();
        testNoData = new ClassPathResource("testnodata.vcf").getFile();
        testEmptyFile = Files.createTempFile("empty", "vcf", new FileAttribute[0]).toFile();
    }

    @AfterAll
    static void afterClass() {
        testEmptyFile.delete();
    }

    @Test
    void testCreateRepositoryForEmptyFile() {
        Exception exception = (Exception)org.junit.jupiter.api.Assertions.assertThrows(MolgenisDataException.class, () -> new VcfRepository(testEmptyFile, "test", this.vcfAttrs, this.entityTypeFactory, this.attrMetaFactory));
        Assertions.assertThat((String)exception.getMessage()).containsPattern((CharSequence)"Failed to read VCF Metadata from file; nested exception is java.io.IOException: missing column headers");
    }

    @Test
    void metaData() {
        VcfRepository vcfRepository = new VcfRepository(testData, "testData", this.vcfAttrs, this.entityTypeFactory, this.attrMetaFactory);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"testData", (Object)vcfRepository.getName());
        Iterator it = vcfRepository.getEntityType().getAttributes().iterator();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "#CHROM", AttributeType.STRING);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "ALT", AttributeType.TEXT);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "POS", AttributeType.INT);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "REF", AttributeType.TEXT);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "FILTER", AttributeType.STRING);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "QUAL", AttributeType.STRING);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "ID", AttributeType.STRING);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "INTERNAL_ID", AttributeType.STRING);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)it.hasNext());
        VcfRepositoryTest.testAttribute((Attribute)it.next(), "INFO", AttributeType.COMPOUND);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)it.hasNext());
    }

    private static void testAttribute(Attribute metadata, String name, AttributeType type) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)name, (Object)metadata.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)type, (Object)metadata.getDataType());
    }

    @Test
    void testForEachBatched() {
        VcfRepository vcfRepository = new VcfRepository(testData, "testData", this.vcfAttrs, this.entityTypeFactory, this.attrMetaFactory);
        vcfRepository.forEachBatched(this.batchConsumer, 5);
        ((Consumer)Mockito.verify(this.batchConsumer, (VerificationMode)Mockito.times((int)2))).accept((List)this.entityListCaptor.capture());
        List allValues = this.entityListCaptor.getAllValues();
        List positions = allValues.stream().map(batch -> batch.stream().map(entity -> entity.getInt("POS")).collect(Collectors.toList())).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)565286, (Object)0x223C22, (Object)3171929, (Object)3172062, (Object)3172273), (Object)ImmutableList.of((Object)6097450, (Object)7569187)), positions);
        Set chroms = allValues.stream().flatMap(batch -> batch.stream().map(entity -> entity.getString("#CHROM"))).collect(Collectors.toSet());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singleton("1"), chroms);
    }

    @Test
    void iterator_noValues() {
        VcfRepository vcfRepository = new VcfRepository(testNoData, "testNoData", this.vcfAttrs, this.entityTypeFactory, this.attrMetaFactory);
        vcfRepository.forEachBatched(this.batchConsumer, 1000);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.batchConsumer});
    }

    @Configuration
    @Import(value={VcfTestConfig.class})
    static class Config {
        Config() {
        }
    }
}

