/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.importer;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.molgenis.data.DataAction;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.importer.EntitiesValidationReport;
import org.molgenis.data.importer.EntityImportReport;
import org.molgenis.data.importer.MetadataAction;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.security.permission.PermissionSystemService;
import org.molgenis.data.support.AbstractRepository;
import org.molgenis.data.vcf.importer.VcfImporterService;
import org.molgenis.test.AbstractMockitoTest;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

class VcfImporterServiceTest
extends AbstractMockitoTest {
    private VcfImporterService vcfImporterService;
    @Mock
    private DataService dataService;
    @Mock
    private PermissionSystemService permissionSystemService;
    @Mock
    private MetaDataService metaDataService;
    @Mock
    private SecurityContext securityContext;
    @Mock
    private RepositoryCollection repositoryCollection;

    VcfImporterServiceTest() {
    }

    @BeforeEach
    void setUpBeforeMethod() {
        this.vcfImporterService = new VcfImporterService(this.dataService, this.permissionSystemService, this.metaDataService);
        SecurityContextHolder.setContext((SecurityContext)this.securityContext);
    }

    @Test
    void doImportVcfWithoutSamples() {
        Mockito.when((Object)this.dataService.getMeta()).thenReturn((Object)this.metaDataService);
        Mockito.when((Object)this.metaDataService.getDefaultBackend()).thenReturn((Object)this.repositoryCollection);
        Mockito.when((Object)this.repositoryCollection.getName()).thenReturn((Object)"default");
        final String entityTypeId0 = "entity0";
        List<String> entityTypeIds = Collections.singletonList(entityTypeId0);
        final EntityType entityType0 = (EntityType)Mockito.mock(EntityType.class);
        Mockito.when((Object)entityType0.getId()).thenReturn((Object)entityTypeId0);
        Entity entity0 = (Entity)Mockito.mock(Entity.class);
        Entity entity1 = (Entity)Mockito.mock(Entity.class);
        final List<Entity> entities = Arrays.asList(entity0, entity1);
        Repository repo0 = (Repository)Mockito.spy((Object)new AbstractRepository(){

            public Set<RepositoryCapability> getCapabilities() {
                return null;
            }

            public EntityType getEntityType() {
                return entityType0;
            }

            public Iterator<Entity> iterator() {
                return entities.iterator();
            }

            public Spliterator<Entity> spliterator() {
                return entities.spliterator();
            }

            public String getName() {
                return entityTypeId0;
            }

            public void forEachBatched(Consumer<List<Entity>> consumer, int batchSize) {
                this.forEachBatched(null, consumer, batchSize);
            }
        });
        Mockito.when((Object)this.dataService.hasRepository(entityTypeId0)).thenReturn((Object)false);
        Repository outRepo0 = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)this.metaDataService.createRepository((EntityType)Mockito.argThat(VcfImporterServiceTest.eqName(entityType0)))).thenReturn((Object)outRepo0);
        Mockito.when((Object)outRepo0.add((Stream)Mockito.any(Stream.class))).thenAnswer(invocation -> {
            Stream entities1 = (Stream)invocation.getArguments()[0];
            List entityList = entities1.collect(Collectors.toList());
            return entityList.size();
        });
        RepositoryCollection source = (RepositoryCollection)Mockito.mock(RepositoryCollection.class);
        Mockito.when((Object)source.getEntityTypeIds()).thenReturn(entityTypeIds);
        Mockito.when((Object)source.getRepository(entityTypeId0)).thenReturn((Object)repo0);
        String importPackageId = "package";
        Package importPackage = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)this.metaDataService.getPackage(importPackageId)).thenReturn(Optional.of(importPackage));
        EntityImportReport entityImportReport = this.vcfImporterService.doImport(source, MetadataAction.ADD, DataAction.ADD, importPackageId);
        EntityImportReport expectedEntityImportReport = new EntityImportReport();
        expectedEntityImportReport.addEntityCount(entityTypeId0, entities.size());
        expectedEntityImportReport.addNewEntity(entityTypeId0);
        Assertions.assertEquals((Object)expectedEntityImportReport, (Object)entityImportReport);
        ((MetaDataService)Mockito.verify((Object)this.metaDataService, (VerificationMode)Mockito.times((int)1))).createRepository((EntityType)Mockito.argThat(VcfImporterServiceTest.eqName(entityType0)));
        ((PermissionSystemService)Mockito.verify((Object)this.permissionSystemService, (VerificationMode)Mockito.times((int)1))).giveUserWriteMetaPermissions(entityType0);
    }

    @Test
    void doImportVcfWithSamples() {
        Mockito.when((Object)this.dataService.getMeta()).thenReturn((Object)this.metaDataService);
        Mockito.when((Object)this.metaDataService.getDefaultBackend()).thenReturn((Object)this.repositoryCollection);
        Mockito.when((Object)this.repositoryCollection.getName()).thenReturn((Object)"default");
        final String entityTypeId0 = "entity0";
        List<String> entityTypeIds = Collections.singletonList(entityTypeId0);
        String sampleEntityName0 = "entity0sample";
        EntityType sampleEntityType0 = (EntityType)Mockito.mock(EntityType.class);
        Mockito.when((Object)sampleEntityType0.getId()).thenReturn((Object)sampleEntityName0);
        Repository outSampleRepo0 = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)outSampleRepo0.getName()).thenReturn((Object)sampleEntityName0);
        ((MetaDataService)Mockito.doReturn((Object)outSampleRepo0).when((Object)this.metaDataService)).createRepository((EntityType)Mockito.argThat(VcfImporterServiceTest.eqName(sampleEntityType0)));
        Attribute sampleAttr = (Attribute)Mockito.mock(Attribute.class);
        Mockito.when((Object)sampleAttr.getRefEntity()).thenReturn((Object)sampleEntityType0);
        final EntityType entityType0 = (EntityType)Mockito.mock(EntityType.class);
        Mockito.when((Object)entityType0.getId()).thenReturn((Object)entityTypeId0);
        Mockito.when((Object)entityType0.getAttribute("SAMPLES_ENTITIES")).thenReturn((Object)sampleAttr);
        Entity entity0Sample0 = (Entity)Mockito.mock(Entity.class);
        Entity entity0Sample1 = (Entity)Mockito.mock(Entity.class);
        Entity entity1Sample0 = (Entity)Mockito.mock(Entity.class);
        Entity entity1Sample1 = (Entity)Mockito.mock(Entity.class);
        Entity entity0 = (Entity)Mockito.mock(Entity.class);
        Mockito.when((Object)entity0.getEntities("SAMPLES_ENTITIES")).thenReturn(Arrays.asList(entity0Sample0, entity0Sample1));
        Entity entity1 = (Entity)Mockito.mock(Entity.class);
        Mockito.when((Object)entity1.getEntities("SAMPLES_ENTITIES")).thenReturn(Arrays.asList(entity1Sample0, entity1Sample1));
        final List<Entity> entities = Arrays.asList(entity0, entity1);
        Repository repo0 = (Repository)Mockito.spy((Object)new AbstractRepository(){

            public Set<RepositoryCapability> getCapabilities() {
                return null;
            }

            public EntityType getEntityType() {
                return entityType0;
            }

            public Iterator<Entity> iterator() {
                return entities.iterator();
            }

            public Spliterator<Entity> spliterator() {
                return entities.spliterator();
            }

            public String getName() {
                return entityTypeId0;
            }

            public void forEachBatched(Consumer<List<Entity>> consumer, int batchSize) {
                this.forEachBatched(null, consumer, batchSize);
            }
        });
        Mockito.when((Object)this.dataService.hasRepository(entityTypeId0)).thenReturn((Object)false);
        Repository outRepo0 = (Repository)Mockito.mock(Repository.class);
        ((MetaDataService)Mockito.doReturn((Object)outRepo0).when((Object)this.metaDataService)).createRepository((EntityType)Mockito.argThat(VcfImporterServiceTest.eqName(entityType0)));
        Mockito.when((Object)outRepo0.add((Stream)Mockito.any(Stream.class))).thenAnswer(invocation -> {
            Stream entities1 = (Stream)invocation.getArguments()[0];
            List entityList = entities1.collect(Collectors.toList());
            return entityList.size();
        });
        RepositoryCollection source = (RepositoryCollection)Mockito.mock(RepositoryCollection.class);
        Mockito.when((Object)source.getEntityTypeIds()).thenReturn(entityTypeIds);
        Mockito.when((Object)source.getRepository(entityTypeId0)).thenReturn((Object)repo0);
        String importPackageId = "package";
        Package importPackage = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)this.metaDataService.getPackage(importPackageId)).thenReturn(Optional.of(importPackage));
        EntityImportReport entityImportReport = this.vcfImporterService.doImport(source, MetadataAction.ADD, DataAction.ADD, importPackageId);
        EntityImportReport expectedEntityImportReport = new EntityImportReport();
        expectedEntityImportReport.addNewEntity(sampleEntityName0);
        expectedEntityImportReport.addEntityCount(sampleEntityName0, 4);
        expectedEntityImportReport.addNewEntity(entityTypeId0);
        expectedEntityImportReport.addEntityCount(entityTypeId0, entities.size());
        Assertions.assertEquals((Object)expectedEntityImportReport, (Object)entityImportReport);
        ((MetaDataService)Mockito.verify((Object)this.metaDataService)).createRepository((EntityType)Mockito.argThat(VcfImporterServiceTest.eqName(sampleEntityType0)));
        ((MetaDataService)Mockito.verify((Object)this.metaDataService)).createRepository((EntityType)Mockito.argThat(VcfImporterServiceTest.eqName(entityType0)));
        ((PermissionSystemService)Mockito.verify((Object)this.permissionSystemService)).giveUserWriteMetaPermissions(entityType0);
        ((PermissionSystemService)Mockito.verify((Object)this.permissionSystemService)).giveUserWriteMetaPermissions(sampleEntityType0);
    }

    @Test
    void doImportAlreadyExists() {
        String entityTypeId0 = "entity0";
        List<String> entityTypeIds = Collections.singletonList(entityTypeId0);
        Repository repo0 = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)repo0.getName()).thenReturn((Object)entityTypeId0);
        RepositoryCollection source = (RepositoryCollection)Mockito.mock(RepositoryCollection.class);
        Mockito.when((Object)source.getEntityTypeIds()).thenReturn(entityTypeIds);
        Mockito.when((Object)source.getRepository(entityTypeId0)).thenReturn((Object)repo0);
        Mockito.when((Object)this.dataService.hasRepository(entityTypeId0)).thenReturn((Object)true);
        String importPackageId = "package";
        Package importPackage = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)this.metaDataService.getPackage(importPackageId)).thenReturn(Optional.of(importPackage));
        Assertions.assertThrows(MolgenisDataException.class, () -> this.vcfImporterService.doImport(source, MetadataAction.ADD, DataAction.ADD, importPackageId));
    }

    @Test
    void doImportAddIgnoreExisting() {
        RepositoryCollection source = (RepositoryCollection)Mockito.mock(RepositoryCollection.class);
        String defaultPackage = "package";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.vcfImporterService.doImport(source, MetadataAction.ADD, DataAction.ADD_IGNORE_EXISTING, defaultPackage));
    }

    @Test
    void doImportAddUpdateExisting() {
        RepositoryCollection source = (RepositoryCollection)Mockito.mock(RepositoryCollection.class);
        String defaultPackage = "package";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.vcfImporterService.doImport(source, MetadataAction.ADD, DataAction.ADD_UPDATE_EXISTING, defaultPackage));
    }

    @Test
    void doImportUpdate() {
        RepositoryCollection source = (RepositoryCollection)Mockito.mock(RepositoryCollection.class);
        String defaultPackage = "package";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.vcfImporterService.doImport(source, MetadataAction.ADD, DataAction.UPDATE, defaultPackage));
    }

    @Test
    void validateImportWithoutSamples() {
        String entityTypeId0 = "entity0";
        List<String> entityTypeIds = Collections.singletonList(entityTypeId0);
        String attrName0 = "attr0";
        Attribute attr0 = (Attribute)Mockito.mock(Attribute.class);
        Mockito.when((Object)attr0.getName()).thenReturn((Object)attrName0);
        EntityType entityType0 = (EntityType)Mockito.mock(EntityType.class);
        Mockito.when((Object)entityType0.getAtomicAttributes()).thenReturn(Collections.singletonList(attr0));
        Repository repo0 = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)repo0.getEntityType()).thenReturn((Object)entityType0);
        RepositoryCollection source = (RepositoryCollection)Mockito.mock(RepositoryCollection.class);
        Mockito.when((Object)source.getEntityTypeIds()).thenReturn(entityTypeIds);
        Mockito.when((Object)source.getRepository(entityTypeId0)).thenReturn((Object)repo0);
        EntitiesValidationReport entitiesValidationReport = this.vcfImporterService.validateImport(source);
        Assertions.assertTrue((boolean)entitiesValidationReport.valid());
        Assertions.assertEquals(Collections.emptyMap(), (Object)entitiesValidationReport.getFieldsAvailable());
        Assertions.assertEquals(Collections.singletonMap(entityTypeId0, Collections.singletonList(attrName0)), (Object)entitiesValidationReport.getFieldsImportable());
        Assertions.assertEquals(Collections.emptyMap(), (Object)entitiesValidationReport.getFieldsRequired());
        Assertions.assertEquals(Collections.emptyMap(), (Object)entitiesValidationReport.getFieldsUnknown());
        Assertions.assertEquals(Collections.emptyList(), (Object)entitiesValidationReport.getImportOrder());
        Assertions.assertEquals(Collections.emptyList(), (Object)entitiesValidationReport.getPackages());
        Assertions.assertEquals(Collections.singletonMap(entityTypeId0, Boolean.TRUE), (Object)entitiesValidationReport.getSheetsImportable());
    }

    @Test
    void validateImportWithoutSamplesAlreadyExists() {
        String entityTypeId0 = "entity0";
        List<String> entityTypeIds = Collections.singletonList(entityTypeId0);
        String attrName0 = "attr0";
        Attribute attr0 = (Attribute)Mockito.mock(Attribute.class);
        Mockito.when((Object)attr0.getName()).thenReturn((Object)attrName0);
        EntityType entityType0 = (EntityType)Mockito.mock(EntityType.class);
        Mockito.when((Object)entityType0.getAtomicAttributes()).thenReturn(Collections.singletonList(attr0));
        Repository repo0 = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)repo0.getEntityType()).thenReturn((Object)entityType0);
        RepositoryCollection source = (RepositoryCollection)Mockito.mock(RepositoryCollection.class);
        Mockito.when((Object)source.getEntityTypeIds()).thenReturn(entityTypeIds);
        Mockito.when((Object)source.getRepository(entityTypeId0)).thenReturn((Object)repo0);
        Mockito.when((Object)this.dataService.hasRepository(entityTypeId0)).thenReturn((Object)true);
        EntitiesValidationReport entitiesValidationReport = this.vcfImporterService.validateImport(source);
        Assertions.assertFalse((boolean)entitiesValidationReport.valid());
        Assertions.assertEquals(Collections.emptyMap(), (Object)entitiesValidationReport.getFieldsAvailable());
        Assertions.assertEquals(Collections.singletonMap(entityTypeId0, Collections.singletonList(attrName0)), (Object)entitiesValidationReport.getFieldsImportable());
        Assertions.assertEquals(Collections.emptyMap(), (Object)entitiesValidationReport.getFieldsRequired());
        Assertions.assertEquals(Collections.emptyMap(), (Object)entitiesValidationReport.getFieldsUnknown());
        Assertions.assertEquals(Collections.emptyList(), (Object)entitiesValidationReport.getImportOrder());
        Assertions.assertEquals(Collections.emptyList(), (Object)entitiesValidationReport.getPackages());
        Assertions.assertEquals(Collections.singletonMap(entityTypeId0, Boolean.FALSE), (Object)entitiesValidationReport.getSheetsImportable());
    }

    @Test
    void validateImportWithSamples() {
        String entityTypeId0 = "entity0";
        List<String> entityTypeIds = Collections.singletonList(entityTypeId0);
        String sampleAttrName0 = "sampleAttr0";
        Attribute sampleAttr0 = (Attribute)Mockito.mock(Attribute.class);
        Mockito.when((Object)sampleAttr0.getName()).thenReturn((Object)sampleAttrName0);
        String sampleEntityName0 = "entity0sample";
        EntityType sampleEntityType0 = (EntityType)Mockito.mock(EntityType.class);
        Mockito.when((Object)sampleEntityType0.getId()).thenReturn((Object)sampleEntityName0);
        Mockito.when((Object)sampleEntityType0.getAtomicAttributes()).thenReturn(Collections.singleton(sampleAttr0));
        Attribute sampleAttr = (Attribute)Mockito.mock(Attribute.class);
        Mockito.when((Object)sampleAttr.getName()).thenReturn((Object)"SAMPLES_ENTITIES");
        Mockito.when((Object)sampleAttr.getRefEntity()).thenReturn((Object)sampleEntityType0);
        EntityType entityType0 = (EntityType)Mockito.mock(EntityType.class);
        Mockito.when((Object)entityType0.getAttribute("SAMPLES_ENTITIES")).thenReturn((Object)sampleAttr);
        Mockito.when((Object)entityType0.getAtomicAttributes()).thenReturn(Collections.singletonList(sampleAttr));
        Repository repo0 = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)repo0.getEntityType()).thenReturn((Object)entityType0);
        RepositoryCollection source = (RepositoryCollection)Mockito.mock(RepositoryCollection.class);
        Mockito.when((Object)source.getEntityTypeIds()).thenReturn(entityTypeIds);
        Mockito.when((Object)source.getRepository(entityTypeId0)).thenReturn((Object)repo0);
        EntitiesValidationReport entitiesValidationReport = this.vcfImporterService.validateImport(source);
        Assertions.assertTrue((boolean)entitiesValidationReport.valid());
        Assertions.assertEquals(Collections.emptyMap(), (Object)entitiesValidationReport.getFieldsAvailable());
        HashMap<String, List<String>> importableFields = new HashMap<String, List<String>>();
        importableFields.put(entityTypeId0, Collections.singletonList("SAMPLES_ENTITIES"));
        importableFields.put(sampleEntityName0, Collections.singletonList(sampleAttrName0));
        Assertions.assertEquals(importableFields, (Object)entitiesValidationReport.getFieldsImportable());
        Assertions.assertEquals(Collections.emptyMap(), (Object)entitiesValidationReport.getFieldsRequired());
        Assertions.assertEquals(Collections.emptyMap(), (Object)entitiesValidationReport.getFieldsUnknown());
        Assertions.assertEquals(Collections.emptyList(), (Object)entitiesValidationReport.getImportOrder());
        Assertions.assertEquals(Collections.emptyList(), (Object)entitiesValidationReport.getPackages());
        HashMap<String, Boolean> sheetsImportable = new HashMap<String, Boolean>();
        sheetsImportable.put(entityTypeId0, Boolean.TRUE);
        sheetsImportable.put(sampleEntityName0, Boolean.TRUE);
        Assertions.assertEquals(sheetsImportable, (Object)entitiesValidationReport.getSheetsImportable());
    }

    @Test
    void validateImportWithSamplesAlreadyExists() {
        String entityTypeId0 = "entity0";
        List<String> entityTypeIds = Collections.singletonList(entityTypeId0);
        String sampleAttrName0 = "sampleAttr0";
        Attribute sampleAttr0 = (Attribute)Mockito.mock(Attribute.class);
        Mockito.when((Object)sampleAttr0.getName()).thenReturn((Object)sampleAttrName0);
        String sampleEntityName0 = "entity0sample";
        EntityType sampleEntityType0 = (EntityType)Mockito.mock(EntityType.class);
        Mockito.when((Object)sampleEntityType0.getId()).thenReturn((Object)sampleEntityName0);
        Mockito.when((Object)sampleEntityType0.getAtomicAttributes()).thenReturn(Collections.singleton(sampleAttr0));
        Attribute sampleAttr = (Attribute)Mockito.mock(Attribute.class);
        Mockito.when((Object)sampleAttr.getName()).thenReturn((Object)"SAMPLES_ENTITIES");
        Mockito.when((Object)sampleAttr.getRefEntity()).thenReturn((Object)sampleEntityType0);
        EntityType entityType0 = (EntityType)Mockito.mock(EntityType.class);
        Mockito.when((Object)entityType0.getAttribute("SAMPLES_ENTITIES")).thenReturn((Object)sampleAttr);
        Mockito.when((Object)entityType0.getAtomicAttributes()).thenReturn(Collections.singletonList(sampleAttr));
        Repository repo0 = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)repo0.getEntityType()).thenReturn((Object)entityType0);
        RepositoryCollection source = (RepositoryCollection)Mockito.mock(RepositoryCollection.class);
        Mockito.when((Object)source.getEntityTypeIds()).thenReturn(entityTypeIds);
        Mockito.when((Object)source.getRepository(entityTypeId0)).thenReturn((Object)repo0);
        ((DataService)Mockito.doReturn((Object)true).when((Object)this.dataService)).hasRepository(entityTypeId0);
        ((DataService)Mockito.doReturn((Object)true).when((Object)this.dataService)).hasRepository(sampleEntityName0);
        EntitiesValidationReport entitiesValidationReport = this.vcfImporterService.validateImport(source);
        Assertions.assertFalse((boolean)entitiesValidationReport.valid());
        Assertions.assertEquals(Collections.emptyMap(), (Object)entitiesValidationReport.getFieldsAvailable());
        HashMap<String, List<String>> importableFields = new HashMap<String, List<String>>();
        importableFields.put(entityTypeId0, Collections.singletonList("SAMPLES_ENTITIES"));
        importableFields.put(sampleEntityName0, Collections.singletonList(sampleAttrName0));
        Assertions.assertEquals(importableFields, (Object)entitiesValidationReport.getFieldsImportable());
        Assertions.assertEquals(Collections.emptyMap(), (Object)entitiesValidationReport.getFieldsRequired());
        Assertions.assertEquals(Collections.emptyMap(), (Object)entitiesValidationReport.getFieldsUnknown());
        Assertions.assertEquals(Collections.emptyList(), (Object)entitiesValidationReport.getImportOrder());
        Assertions.assertEquals(Collections.emptyList(), (Object)entitiesValidationReport.getPackages());
        HashMap<String, Boolean> sheetsImportable = new HashMap<String, Boolean>();
        sheetsImportable.put(entityTypeId0, Boolean.FALSE);
        sheetsImportable.put(sampleEntityName0, Boolean.FALSE);
        Assertions.assertEquals(sheetsImportable, (Object)entitiesValidationReport.getSheetsImportable());
    }

    @Test
    void canImportVcf() {
        RepositoryCollection source = (RepositoryCollection)Mockito.mock(RepositoryCollection.class);
        Assertions.assertTrue((boolean)this.vcfImporterService.canImport(new File("file.vcf"), source));
    }

    @Test
    void canImportVcfGz() {
        RepositoryCollection source = (RepositoryCollection)Mockito.mock(RepositoryCollection.class);
        Assertions.assertTrue((boolean)this.vcfImporterService.canImport(new File("file.vcf.gz"), source));
    }

    @Test
    void canImportXls() {
        RepositoryCollection source = (RepositoryCollection)Mockito.mock(RepositoryCollection.class);
        Assertions.assertFalse((boolean)this.vcfImporterService.canImport(new File("file.xls"), source));
    }

    @Test
    void getMetadataAction() {
        RepositoryCollection source = (RepositoryCollection)Mockito.mock(RepositoryCollection.class);
        Assertions.assertEquals((Object)MetadataAction.ADD, (Object)this.vcfImporterService.getMetadataAction(source));
    }

    private static ArgumentMatcher<EntityType> eqName(EntityType expectedEntityType) {
        return item -> item != null && item.getId().equals(expectedEntityType.getId());
    }
}

