/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.controller;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Repository;
import org.molgenis.data.annotation.AnnotationService;
import org.molgenis.data.annotation.CrudRepositoryAnnotator;
import org.molgenis.data.annotation.RepositoryAnnotator;
import org.molgenis.data.elasticsearch.SearchService;
import org.molgenis.data.validation.EntityValidator;
import org.molgenis.file.FileStore;
import org.molgenis.security.core.MolgenisPermissionService;
import org.molgenis.security.core.Permission;
import org.molgenis.security.permission.PermissionSystemService;
import org.molgenis.security.user.UserAccountService;
import org.molgenis.util.ErrorMessageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/annotators"})
public class AnnotatorController {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotatorController.class);
    public static final String URI = "/annotators";
    @Autowired
    DataService dataService;
    @Autowired
    FileStore fileStore;
    @Autowired
    SearchService searchService;
    @Autowired
    AnnotationService annotationService;
    @Autowired
    EntityValidator entityValidator;
    @Autowired
    PermissionSystemService permissionSystemService;
    @Autowired
    UserAccountService userAccountService;
    @Autowired
    MolgenisPermissionService molgenisPermissionService;

    @RequestMapping(value={"/get-available-annotators"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Map<String, Object>> getMapOfAvailableAnnotators(@RequestBody String dataSetName) {
        Map<String, Map<String, Object>> annotatorMap = this.setMapOfAnnotators(dataSetName);
        return annotatorMap;
    }

    @RequestMapping(value={"/annotate-data"}, method={RequestMethod.POST})
    @ResponseBody
    @Transactional
    public String annotateData(@RequestParam(value="annotatorNames", required=false) String[] annotatorNames, @RequestParam(value="dataset-identifier") String entityName, @RequestParam(value="createCopy", required=false) boolean createCopy) {
        Repository repository = this.dataService.getRepository(entityName);
        if (annotatorNames != null && repository != null) {
            CrudRepositoryAnnotator crudRepositoryAnnotator = new CrudRepositoryAnnotator(this.dataService, this.getNewRepositoryName(annotatorNames, repository.getEntityMetaData().getSimpleName()), this.permissionSystemService, this.userAccountService, this.molgenisPermissionService);
            for (String annotatorName : annotatorNames) {
                RepositoryAnnotator annotator = this.annotationService.getAnnotatorByName(annotatorName);
                if (annotator == null) continue;
                try {
                    repository = crudRepositoryAnnotator.annotate(annotator, repository, createCopy);
                    entityName = repository.getName();
                    createCopy = false;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
        return entityName;
    }

    private String getNewRepositoryName(String[] annotatorNames, String repositoryName) {
        String newRepositoryName = repositoryName;
        for (String annotatorName : annotatorNames) {
            newRepositoryName = newRepositoryName + "_" + annotatorName;
        }
        return newRepositoryName;
    }

    private Map<String, Map<String, Object>> setMapOfAnnotators(String dataSetName) {
        HashMap<String, Map<String, Object>> mapOfAnnotators = new HashMap<String, Map<String, Object>>();
        if (dataSetName != null) {
            EntityMetaData entityMetaData = this.dataService.getEntityMetaData(dataSetName);
            for (RepositoryAnnotator annotator : this.annotationService.getAllAnnotators()) {
                List<AttributeMetaData> outputAttrs = annotator.getOutputMetaData();
                outputAttrs = this.getAtomicAttributesFromList(outputAttrs);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("description", annotator.getDescription());
                map.put("canAnnotate", annotator.canAnnotate(entityMetaData));
                map.put("inputAttributes", annotator.getInputMetaData());
                map.put("inputAttributeTypes", this.toMap(annotator.getInputMetaData()));
                map.put("outputAttributes", outputAttrs);
                map.put("outputAttributeTypes", this.toMap(annotator.getOutputMetaData()));
                String settingsEntityName = "settings_" + annotator.getInfo().getCode();
                map.put("showSettingsButton", this.molgenisPermissionService.hasPermissionOnEntity(settingsEntityName, Permission.WRITE));
                mapOfAnnotators.put(annotator.getSimpleName(), map);
            }
        }
        return mapOfAnnotators;
    }

    private List<AttributeMetaData> getAtomicAttributesFromList(List<AttributeMetaData> outputAttrs) {
        if (outputAttrs.size() == 1 && outputAttrs.get(0).getDataType().getEnumType().equals((Object)MolgenisFieldTypes.FieldTypeEnum.COMPOUND)) {
            return this.getAtomicAttributesFromList(Lists.newArrayList((Iterable)outputAttrs.get(0).getAttributeParts()));
        }
        return outputAttrs;
    }

    private Map<String, String> toMap(Iterable<AttributeMetaData> attrs) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (AttributeMetaData attr : attrs) {
            result.put(attr.getName(), attr.getDataType().toString());
        }
        return result;
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorMessageResponse handleRuntimeException(RuntimeException e) {
        LOG.error(e.getMessage(), (Throwable)e);
        return new ErrorMessageResponse(new ErrorMessageResponse.ErrorMessage("An error occurred. Please contact the administrator.<br />Message:" + e.getMessage()));
    }
}

