/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.controller;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import freemarker.core.ParseException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.MolgenisDataAccessException;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.i18n.LanguageService;
import org.molgenis.data.settings.AppSettings;
import org.molgenis.data.support.GenomicDataSettings;
import org.molgenis.dataexplorer.controller.DataRequest;
import org.molgenis.dataexplorer.controller.ModuleConfig;
import org.molgenis.dataexplorer.controller.ModulesConfigResponse;
import org.molgenis.dataexplorer.download.DataExplorerDownloadHandler;
import org.molgenis.dataexplorer.galaxy.GalaxyDataExportException;
import org.molgenis.dataexplorer.galaxy.GalaxyDataExportRequest;
import org.molgenis.dataexplorer.galaxy.GalaxyDataExporter;
import org.molgenis.dataexplorer.settings.DataExplorerSettings;
import org.molgenis.security.core.MolgenisPermissionService;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.ui.MolgenisPluginController;
import org.molgenis.ui.menumanager.MenuManagerService;
import org.molgenis.util.ErrorMessageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Controller
@RequestMapping(value={"/plugin/dataexplorer"})
@SessionAttributes(value={"galaxyUrl", "galaxyApiKey"})
public class DataExplorerController
extends MolgenisPluginController {
    private static final Logger LOG = LoggerFactory.getLogger(DataExplorerController.class);
    public static final String ID = "dataexplorer";
    public static final String URI = "/plugin/dataexplorer";
    static final String ATTR_GALAXY_URL = "galaxyUrl";
    static final String ATTR_GALAXY_API_KEY = "galaxyApiKey";
    @Autowired
    private AppSettings appSettings;
    @Autowired
    private DataExplorerSettings dataExplorerSettings;
    @Autowired
    private GenomicDataSettings genomicDataSettings;
    @Autowired
    private DataService dataService;
    @Autowired
    private MolgenisPermissionService molgenisPermissionService;
    @Autowired
    private FreeMarkerConfigurer freemarkerConfigurer;
    @Autowired
    MenuManagerService menuManager;
    @Autowired
    private Gson gson;
    @Autowired
    private LanguageService languageService;

    public DataExplorerController() {
        super(URI);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(@RequestParam(value="entity", required=false) String selectedEntityName, Model model) throws Exception {
        boolean entityExists = false;
        boolean hasEntityPermission = false;
        Iterable entitiesMeta = Iterables.transform((Iterable)this.dataService.getEntityNames(), (Function)new Function<String, EntityMetaData>(){

            public EntityMetaData apply(String entityName) {
                return DataExplorerController.this.dataService.getEntityMetaData(entityName);
            }
        });
        model.addAttribute("entitiesMeta", (Object)entitiesMeta);
        if (selectedEntityName != null) {
            entityExists = this.dataService.hasRepository(selectedEntityName);
            hasEntityPermission = this.molgenisPermissionService.hasPermissionOnEntity(selectedEntityName, Permission.COUNT);
        }
        if (!(entityExists && hasEntityPermission || selectedEntityName == null)) {
            StringBuilder message = new StringBuilder("Entity does not exist or you do not have permission on this entity");
            if (!SecurityUtils.currentUserIsAuthenticated()) {
                message.append(", log in to view more entities");
            } else {
                message.append(", please specify the fully qualified entity name");
            }
            model.addAttribute("warningMessage", (Object)message.toString());
        }
        model.addAttribute("selectedEntityName", (Object)selectedEntityName);
        model.addAttribute("isAdmin", (Object)SecurityUtils.currentUserIsSu());
        return "view-dataexplorer";
    }

    @RequestMapping(value={"/module/{moduleId}"}, method={RequestMethod.GET})
    public String getModule(@PathVariable(value="moduleId") String moduleId, @RequestParam(value="entity") String entityName, Model model) {
        if (moduleId.equals("data")) {
            model.addAttribute("genomicDataSettings", (Object)this.genomicDataSettings);
            model.addAttribute("genomeEntities", this.getGenomeBrowserEntities());
        } else if (moduleId.equals("entitiesreport")) {
            model.addAttribute("datasetRepository", (Object)this.dataService.getRepository(entityName));
            model.addAttribute("viewName", (Object)this.dataExplorerSettings.getEntityReport(entityName));
        }
        return "view-dataexplorer-mod-" + moduleId;
    }

    @RequestMapping(value={"/modules"}, method={RequestMethod.GET})
    @ResponseBody
    public ModulesConfigResponse getModules(@RequestParam(value="entity") String entityName) {
        boolean modAggregates = this.dataExplorerSettings.getModAggregates();
        boolean modAnnotators = this.dataExplorerSettings.getModAnnotators();
        boolean modCharts = this.dataExplorerSettings.getModCharts();
        boolean modData = this.dataExplorerSettings.getModData();
        boolean modReports = this.dataExplorerSettings.getModReports();
        if (modAggregates) {
            modAggregates = this.dataService.getCapabilities(entityName).contains(RepositoryCapability.AGGREGATEABLE);
        }
        Permission pluginPermission = null;
        if (this.molgenisPermissionService.hasPermissionOnEntity(entityName, Permission.WRITE)) {
            pluginPermission = Permission.WRITE;
        } else if (this.molgenisPermissionService.hasPermissionOnEntity(entityName, Permission.READ)) {
            pluginPermission = Permission.READ;
        } else if (this.molgenisPermissionService.hasPermissionOnEntity(entityName, Permission.COUNT)) {
            pluginPermission = Permission.COUNT;
        }
        ModulesConfigResponse modulesConfig = new ModulesConfigResponse();
        ResourceBundle i18n = this.languageService.getBundle();
        String aggregatesTitle = i18n.getString("dataexplorer_aggregates_title");
        if (pluginPermission != null) {
            switch (pluginPermission) {
                case COUNT: {
                    if (!modAggregates) break;
                    modulesConfig.add(new ModuleConfig("aggregates", aggregatesTitle, "grid-icon.png"));
                    break;
                }
                case READ: 
                case WRITE: {
                    String modEntitiesReportName;
                    if (modData) {
                        modulesConfig.add(new ModuleConfig("data", "Data", "grid-icon.png"));
                    }
                    if (modAggregates) {
                        modulesConfig.add(new ModuleConfig("aggregates", aggregatesTitle, "aggregate-icon.png"));
                    }
                    if (modCharts) {
                        modulesConfig.add(new ModuleConfig("charts", "Charts", "chart-icon.png"));
                    }
                    if (modAnnotators && pluginPermission == Permission.WRITE) {
                        modulesConfig.add(new ModuleConfig("annotators", "Annotators", "annotator-icon.png"));
                    }
                    if (!modReports || (modEntitiesReportName = this.dataExplorerSettings.getEntityReport(entityName)) == null) break;
                    modulesConfig.add(new ModuleConfig("entitiesreport", modEntitiesReportName, "report-icon.png"));
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new RuntimeException("unknown plugin permission: " + pluginPermission);
                }
            }
        }
        return modulesConfig;
    }

    private Map<String, String> getGenomeBrowserEntities() {
        HashMap<String, String> genomeEntities = new HashMap<String, String>();
        for (String entityName : this.dataService.getEntityNames()) {
            EntityMetaData entityMetaData = this.dataService.getEntityMetaData(entityName);
            if (!this.isGenomeBrowserEntity(entityMetaData)) continue;
            boolean canRead = this.molgenisPermissionService.hasPermissionOnEntity(entityName, Permission.READ);
            boolean canWrite = this.molgenisPermissionService.hasPermissionOnEntity(entityName, Permission.WRITE);
            if (!canRead && !canWrite) continue;
            genomeEntities.put(entityMetaData.getName(), entityMetaData.getLabel());
        }
        return genomeEntities;
    }

    private boolean isGenomeBrowserEntity(EntityMetaData entityMetaData) {
        AttributeMetaData attributeStartPosition = this.genomicDataSettings.getAttributeMetadataForAttributeNameArray("start", entityMetaData);
        AttributeMetaData attributeChromosome = this.genomicDataSettings.getAttributeMetadataForAttributeNameArray("chromosome", entityMetaData);
        return attributeStartPosition != null && attributeChromosome != null;
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    public void download(@RequestParam(value="dataRequest") String dataRequestStr, HttpServletResponse response) throws IOException {
        DataExplorerDownloadHandler download = new DataExplorerDownloadHandler(this.dataService);
        dataRequestStr = URLDecoder.decode(dataRequestStr, "UTF-8");
        LOG.info("Download request: [" + dataRequestStr + "]");
        DataRequest dataRequest = (DataRequest)this.gson.fromJson(dataRequestStr, DataRequest.class);
        String fileName = "";
        ServletOutputStream outputStream = null;
        switch (dataRequest.getDownloadType()) {
            case DOWNLOAD_TYPE_CSV: {
                response.setContentType("text/csv");
                fileName = dataRequest.getEntityName() + '_' + new SimpleDateFormat("yyyy-MM-dd_hh:mm:ss").format(new Date()) + ".csv";
                response.addHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                outputStream = response.getOutputStream();
                download.writeToCsv(dataRequest, (OutputStream)outputStream, ',');
                break;
            }
            case DOWNLOAD_TYPE_XLSX: {
                response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                fileName = dataRequest.getEntityName() + '_' + new SimpleDateFormat("yyyy-MM-dd_hh:mm:ss").format(new Date()) + ".xlsx";
                response.addHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                outputStream = response.getOutputStream();
                download.writeToExcel(dataRequest, (OutputStream)outputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/galaxy/export"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void exportToGalaxy(@Valid @RequestBody GalaxyDataExportRequest galaxyDataExportRequest, Model model) throws IOException {
        boolean galaxyEnabled = this.dataExplorerSettings.getGalaxyExport();
        if (!galaxyEnabled) {
            throw new MolgenisDataAccessException("Galaxy export disabled");
        }
        DataExplorerDownloadHandler download = new DataExplorerDownloadHandler(this.dataService);
        String galaxyUrl = galaxyDataExportRequest.getGalaxyUrl();
        String galaxyApiKey = galaxyDataExportRequest.getGalaxyApiKey();
        GalaxyDataExporter galaxyDataSetExporter = new GalaxyDataExporter(galaxyUrl, galaxyApiKey);
        DataRequest dataRequest = galaxyDataExportRequest.getDataRequest();
        File csvFile = File.createTempFile("galaxydata_" + System.currentTimeMillis(), ".tsv");
        try {
            download.writeToCsv(dataRequest, new FileOutputStream(csvFile), '\t', true);
            galaxyDataSetExporter.export(dataRequest.getEntityName(), csvFile);
        }
        finally {
            csvFile.delete();
        }
        model.addAttribute(ATTR_GALAXY_URL, (Object)galaxyUrl);
        model.addAttribute(ATTR_GALAXY_API_KEY, (Object)galaxyApiKey);
    }

    @RequestMapping(value={"/details"}, method={RequestMethod.POST})
    public String viewEntityDetails(@RequestParam(value="entityName") String entityName, @RequestParam(value="entityId") String entityId, Model model) throws Exception {
        model.addAttribute("entity", (Object)this.dataService.getRepository(entityName).findOne((Object)entityId));
        model.addAttribute("entityMetadata", (Object)this.dataService.getEntityMetaData(entityName));
        model.addAttribute("viewName", (Object)this.getViewName(entityName));
        return "view-entityreport";
    }

    private String getViewName(String entityName) {
        String specificViewname;
        String reportTemplate = this.dataExplorerSettings.getEntityReport(entityName);
        if (reportTemplate != null && this.viewExists(specificViewname = "view-entityreport-specific-" + reportTemplate)) {
            return specificViewname;
        }
        specificViewname = "view-entityreport-specific-" + entityName;
        if (this.viewExists(specificViewname)) {
            return specificViewname;
        }
        if (this.viewExists("view-entityreport-generic")) {
            return "view-entityreport-generic";
        }
        return "view-entityreport-generic-default";
    }

    private boolean viewExists(String viewName) {
        try {
            return this.freemarkerConfigurer.getConfiguration().getTemplate(viewName + ".ftl") != null;
        }
        catch (ParseException e) {
            LOG.info("error parsing template: ", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    @ExceptionHandler(value={GalaxyDataExportException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ErrorMessageResponse handleGalaxyDataExportException(GalaxyDataExportException e) {
        LOG.debug("", (Throwable)e);
        return new ErrorMessageResponse(Collections.singletonList(new ErrorMessageResponse.ErrorMessage(e.getMessage())));
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorMessageResponse handleRuntimeException(RuntimeException e) {
        LOG.error(e.getMessage(), (Throwable)e);
        return new ErrorMessageResponse(new ErrorMessageResponse.ErrorMessage("An error occurred. Please contact the administrator.<br />Message:" + e.getMessage()));
    }
}

