/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.controller;

import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.RandomStringUtils;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Repository;
import org.molgenis.data.annotation.AnnotationJob;
import org.molgenis.data.annotation.AnnotationService;
import org.molgenis.data.annotation.RepositoryAnnotator;
import org.molgenis.security.core.MolgenisPermissionService;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.security.permission.PermissionSystemService;
import org.molgenis.security.user.UserAccountService;
import org.molgenis.util.ErrorMessageResponse;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/annotators"})
public class AnnotatorController {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotatorController.class);
    public static final String URI = "/annotators";
    private static final String TRIGGER_GROUP = "annotators";
    private static final String JOB_GROUP = "annotators";
    private static final String INDEX_REBUILD_JOB_KEY = "annotate";
    private final String triggerNameSalt;
    private final DataService dataService;
    private final AnnotationService annotationService;
    private final MolgenisPermissionService molgenisPermissionService;
    private final Scheduler scheduler;
    private final PermissionSystemService permissionSystemService;
    private final UserAccountService userAccountService;

    @Autowired
    public AnnotatorController(DataService dataService, AnnotationService annotationService, MolgenisPermissionService molgenisPermissionService, Scheduler scheduler, PermissionSystemService permissionSystemService, UserAccountService userAccountService) {
        this.dataService = dataService;
        this.annotationService = annotationService;
        this.molgenisPermissionService = molgenisPermissionService;
        this.scheduler = Objects.requireNonNull(scheduler);
        this.triggerNameSalt = UUID.randomUUID().toString();
        this.permissionSystemService = permissionSystemService;
        this.userAccountService = userAccountService;
    }

    @RequestMapping(value={"/get-available-annotators"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Map<String, Object>> getMapOfAvailableAnnotators(@RequestBody String dataSetName) {
        Map<String, Map<String, Object>> annotatorMap = this.setMapOfAnnotators(dataSetName);
        return annotatorMap;
    }

    @RequestMapping(value={"/annotate-data"}, method={RequestMethod.POST})
    @ResponseBody
    public String annotateData(HttpServletRequest request, @RequestParam(value="annotatorNames", required=false) String[] annotatorNames, @RequestParam(value="dataset-identifier") String entityName, @RequestParam(value="createCopy", required=false) boolean createCopy) {
        Repository repository = this.dataService.getRepository(entityName);
        if (createCopy) {
            String newRepositoryLabel = this.getNewRepositoryLabel(annotatorNames, entityName);
            repository = this.dataService.copyRepository(repository, RandomStringUtils.randomAlphabetic((int)30), newRepositoryLabel);
            this.permissionSystemService.giveUserEntityPermissions(SecurityContextHolder.getContext(), Collections.singletonList(repository.getName()));
            entityName = repository.getEntityMetaData().getSimpleName();
        }
        if (annotatorNames != null && repository != null) {
            ArrayList<RepositoryAnnotator> annotators = new ArrayList<RepositoryAnnotator>();
            Arrays.asList(annotatorNames).stream().forEach(a -> annotators.add(this.annotationService.getAnnotatorByName(a)));
            try {
                this.scheduleAnnotatorRun(repository.getEntityMetaData().getSimpleName(), annotators);
            }
            catch (SchedulerException e) {
                e.printStackTrace();
            }
        }
        return entityName;
    }

    private String getNewRepositoryLabel(@RequestParam(value="annotatorNames", required=false) String[] annotatorNames, @RequestParam(value="dataset-identifier") String entityName) {
        StringJoiner joiner = new StringJoiner("_");
        Arrays.asList(annotatorNames).forEach(a -> joiner.add((CharSequence)a));
        String joinedString = joiner.toString();
        return entityName + "_" + joinedString;
    }

    public TriggerKey scheduleAnnotatorRun(String entityName, List<RepositoryAnnotator> annotators) throws SchedulerException {
        TriggerKey triggerKey = this.getIndexRebuildTriggerKeyCurrentUser();
        if (this.scheduler.checkExists(triggerKey)) {
            throw new RuntimeException("Index rebuild already scheduled");
        }
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("REPOSITORY_NAME", entityName);
        jobDataMap.put("ANNOTATORS", annotators);
        jobDataMap.put("USERNAME", this.userAccountService.getCurrentUser().getUsername());
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(triggerKey).usingJobData(jobDataMap).startNow();
        this.scheduleAnnotatorRunJob(triggerBuilder);
        return triggerKey;
    }

    private JobKey scheduleAnnotatorRunJob(TriggerBuilder<?> triggerBuilder) throws SchedulerException {
        JobKey jobKey = this.getIndexRebuildJobKey();
        JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
        if (jobDetail == null) {
            jobDetail = JobBuilder.newJob(AnnotationJob.class).withIdentity(jobKey).build();
            this.scheduler.scheduleJob(jobDetail, triggerBuilder.build());
        } else {
            this.scheduler.scheduleJob(triggerBuilder.forJob(jobDetail).build());
        }
        return jobKey;
    }

    private TriggerKey getIndexRebuildTriggerKeyCurrentUser() {
        MessageDigest messageDigest;
        String rawTriggerName = this.triggerNameSalt + SecurityUtils.getCurrentUsername();
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] md5Hash = messageDigest.digest(rawTriggerName.getBytes(StandardCharsets.UTF_8));
        String triggerName = BaseEncoding.base64Url().omitPadding().encode(md5Hash);
        return new TriggerKey(triggerName, "annotators");
    }

    private Map<String, Map<String, Object>> setMapOfAnnotators(String dataSetName) {
        HashMap<String, Map<String, Object>> mapOfAnnotators = new HashMap<String, Map<String, Object>>();
        if (dataSetName != null) {
            EntityMetaData entityMetaData = this.dataService.getEntityMetaData(dataSetName);
            for (RepositoryAnnotator annotator : this.annotationService.getAllAnnotators()) {
                List<AttributeMetaData> outputAttrs = annotator.getOutputMetaData();
                outputAttrs = this.getAtomicAttributesFromList(outputAttrs);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("description", annotator.getDescription());
                map.put("canAnnotate", annotator.canAnnotate(entityMetaData));
                map.put("inputAttributes", this.createAttrsResponse(annotator.getRequiredAttributes()));
                map.put("inputAttributeTypes", this.toMap(annotator.getRequiredAttributes()));
                map.put("outputAttributes", this.createAttrsResponse(outputAttrs));
                map.put("outputAttributeTypes", this.toMap(annotator.getOutputMetaData()));
                String settingsEntityName = "settings_" + annotator.getInfo().getCode();
                map.put("showSettingsButton", this.molgenisPermissionService.hasPermissionOnEntity(settingsEntityName, Permission.WRITE));
                mapOfAnnotators.put(annotator.getSimpleName(), map);
            }
        }
        return mapOfAnnotators;
    }

    private JobKey getIndexRebuildJobKey() {
        return new JobKey(INDEX_REBUILD_JOB_KEY, "annotators");
    }

    private List<Map<String, Object>> createAttrsResponse(List<AttributeMetaData> inputMetaData) {
        return inputMetaData.stream().map(attr -> {
            HashMap<String, String> attrMap = new HashMap<String, String>();
            attrMap.put("name", attr.getName());
            attrMap.put("description", attr.getDescription());
            return attrMap;
        }).collect(Collectors.toList());
    }

    private List<AttributeMetaData> getAtomicAttributesFromList(List<AttributeMetaData> outputAttrs) {
        if (outputAttrs.size() == 1 && outputAttrs.get(0).getDataType().getEnumType().equals((Object)MolgenisFieldTypes.FieldTypeEnum.COMPOUND)) {
            return this.getAtomicAttributesFromList(Lists.newArrayList((Iterable)outputAttrs.get(0).getAttributeParts()));
        }
        return outputAttrs;
    }

    private Map<String, String> toMap(Iterable<AttributeMetaData> attrs) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (AttributeMetaData attr : attrs) {
            result.put(attr.getName(), attr.getDataType().toString());
        }
        return result;
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorMessageResponse handleRuntimeException(RuntimeException e) {
        LOG.error(e.getMessage(), (Throwable)e);
        return new ErrorMessageResponse(new ErrorMessageResponse.ErrorMessage("An error occurred. Please contact the administrator.<br />Message:" + e.getMessage()));
    }
}

