/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.controller;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.AggregateQuery;
import org.molgenis.data.AggregateResult;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.MolgenisDataAccessException;
import org.molgenis.data.Query;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.support.AggregateQueryImpl;
import org.molgenis.data.support.GenomeConfig;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.dataexplorer.controller.AggregateRequest;
import org.molgenis.dataexplorer.controller.DataRequest;
import org.molgenis.dataexplorer.controller.InputValidationException;
import org.molgenis.dataexplorer.controller.ModuleConfig;
import org.molgenis.dataexplorer.controller.ModulesConfigResponse;
import org.molgenis.dataexplorer.download.DataExplorerDownloadHandler;
import org.molgenis.dataexplorer.galaxy.GalaxyDataExportException;
import org.molgenis.dataexplorer.galaxy.GalaxyDataExportRequest;
import org.molgenis.dataexplorer.galaxy.GalaxyDataExporter;
import org.molgenis.framework.server.MolgenisSettings;
import org.molgenis.framework.ui.MolgenisPluginController;
import org.molgenis.security.core.MolgenisPermissionService;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.runas.RunAsSystemProxy;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.ui.menumanager.MenuManagerService;
import org.molgenis.util.ErrorMessageResponse;
import org.molgenis.util.GsonHttpMessageConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Controller
@RequestMapping(value={"/plugin/dataexplorer"})
@SessionAttributes(value={"galaxyUrl", "galaxyApiKey"})
public class DataExplorerController
extends MolgenisPluginController {
    private static final Logger LOG = LoggerFactory.getLogger(DataExplorerController.class);
    public static final String ID = "dataexplorer";
    public static final String URI = "/plugin/dataexplorer";
    public static final String KEY_MOD_AGGREGATES = "plugin.dataexplorer.mod.aggregates";
    public static final String KEY_MOD_ANNOTATORS = "plugin.dataexplorer.mod.annotators";
    public static final String KEY_MOD_CHARTS = "plugin.dataexplorer.mod.charts";
    public static final String KEY_MOD_DATA = "plugin.dataexplorer.mod.data";
    public static final String KEY_MOD_DISEASEMATCHER = "plugin.dataexplorer.mod.diseasematcher";
    public static final String KEY_GALAXY_ENABLED = "plugin.dataexplorer.galaxy.enabled";
    public static final String KEY_GALAXY_URL = "plugin.dataexplorer.galaxy.url";
    public static final String KEY_SHOW_WIZARD_ONINIT = "plugin.dataexplorer.wizard.oninit";
    public static final String KEY_HEADER_ABBREVIATE = "plugin.dataexplorer.header.abbreviate";
    public static final String KEY_HIDE_SEARCH_BOX = "plugin.dataexplorer.hide.searchbox";
    public static final String KEY_HIDE_ITEM_SELECTION = "plugin.dataexplorer.hide.itemselection";
    public static final String KEY_MOD_AGGREGATES_DISTINCT_HIDE = "plugin.dataexplorer.mod.aggregates.distinct.hide";
    public static final String KEY_MOD_AGGREGATES_DISTINCT_OVERRIDE = "plugin.dataexplorer.mod.aggregates.distinct.override";
    public static final String KEY_MOD_ENTITIESREPORT = "plugin.dataexplorer.mod.entitiesreport";
    public static final String KEY_DATATABLE = "plugin.dataexplorer.table.javascript";
    private static final boolean DEFAULT_VAL_MOD_AGGREGATES = true;
    private static final boolean DEFAULT_VAL_MOD_ANNOTATORS = false;
    private static final boolean DEFAULT_VAL_MOD_CHARTS = true;
    private static final boolean DEFAULT_VAL_MOD_DATA = true;
    private static final boolean DEFAULT_VAL_MOD_DISEASEMATCHER = false;
    private static final boolean DEFAULT_VAL_GALAXY_ENABLED = false;
    public static final boolean DEFAULT_VAL_SHOW_WIZARD_ONINIT = false;
    public static final boolean DEFAULT_VAL_AGGREGATES_DISTINCT_HIDE = false;
    public static final String DEFAULT_VAL_HEADER_ABBREVIATE = "180";
    public static final String DEFAULT_AGGREGATES_NORESULTS_MESSAGE = "No results found";
    static final String ATTR_GALAXY_URL = "galaxyUrl";
    static final String ATTR_GALAXY_API_KEY = "galaxyApiKey";
    public static final String INITLOCATION = "genomebrowser.init.initLocation";
    public static final String COORDSYSTEM = "genomebrowser.init.coordSystem";
    public static final String CHAINS = "genomebrowser.init.chains";
    public static final String SOURCES = "genomebrowser.init.sources";
    public static final String BROWSERLINKS = "genomebrowser.init.browserLinks";
    public static final String AGGREGATES_NORESULTS_MESSAGE = "plugin.dataexplorer.mod.aggregates.noresults";
    public static final String HIGHLIGHTREGION = "genomebrowser.init.highlightRegion";
    public static final String KEY_DATAEXPLORER_EDITABLE = "plugin.dataexplorer.editable";
    public static final String KEY_DATAEXPLORER_ROW_CLICKABLE = "plugin.dataexplorer.rowClickable";
    private static final boolean DEFAULT_VAL_DATAEXPLORER_EDITABLE = false;
    private static final boolean DEFAULT_VAL_DATAEXPLORER_ROW_CLICKABLE = false;
    private static final boolean DEFAULT_VAL_KEY_HIGLIGHTREGION = false;
    @Autowired
    private DataService dataService;
    @Autowired
    private MolgenisPermissionService molgenisPermissionService;
    @Autowired
    private MolgenisSettings molgenisSettings;
    @Autowired
    private GenomeConfig genomeConfig;
    @Autowired
    private FreeMarkerConfigurer freemarkerConfigurer;
    @Autowired
    MenuManagerService menuManager;

    public DataExplorerController() {
        super(URI);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(@RequestParam(value="entity", required=false) String selectedEntityName, Model model) throws Exception {
        boolean entityExists = false;
        boolean hasEntityPermission = false;
        Iterable entitiesMeta = Iterables.transform((Iterable)this.dataService.getEntityNames(), (Function)new Function<String, EntityMetaData>(){

            public EntityMetaData apply(String entityName) {
                return DataExplorerController.this.dataService.getEntityMetaData(entityName);
            }
        });
        model.addAttribute("entitiesMeta", (Object)entitiesMeta);
        if (selectedEntityName != null) {
            entityExists = this.dataService.hasRepository(selectedEntityName);
            hasEntityPermission = this.molgenisPermissionService.hasPermissionOnEntity(selectedEntityName, Permission.COUNT);
        }
        if (!(entityExists && hasEntityPermission || selectedEntityName == null)) {
            StringBuilder message = new StringBuilder("Entity does not exist or you do not have permission on this entity");
            if (!SecurityUtils.currentUserIsAuthenticated()) {
                message.append(", log in to view more entities");
            } else {
                message.append(", please specify the fully qualified entity name");
            }
            model.addAttribute("warningMessage", (Object)message.toString());
        }
        model.addAttribute("selectedEntityName", (Object)selectedEntityName);
        model.addAttribute("hideSearchBox", (Object)this.molgenisSettings.getBooleanProperty(KEY_HIDE_SEARCH_BOX, false));
        model.addAttribute("hideDataItemSelect", (Object)this.molgenisSettings.getBooleanProperty(KEY_HIDE_ITEM_SELECTION, false));
        model.addAttribute("isAdmin", (Object)SecurityUtils.currentUserIsSu());
        return "view-dataexplorer";
    }

    @RequestMapping(value={"/module/{moduleId}"}, method={RequestMethod.GET})
    public String getModule(@PathVariable(value="moduleId") String moduleId, @RequestParam(value="entity") String entityName, Model model) {
        if (moduleId.equals("data")) {
            model.addAttribute("genomeEntities", this.getGenomeBrowserEntities());
            model.addAttribute("initLocation", (Object)this.molgenisSettings.getProperty(INITLOCATION));
            model.addAttribute("coordSystem", (Object)this.molgenisSettings.getProperty(COORDSYSTEM));
            model.addAttribute("chains", (Object)this.molgenisSettings.getProperty(CHAINS));
            model.addAttribute("sources", (Object)this.molgenisSettings.getProperty(SOURCES));
            model.addAttribute("browserLinks", (Object)this.molgenisSettings.getProperty(BROWSERLINKS));
            model.addAttribute("showHighlight", (Object)String.valueOf(this.molgenisSettings.getBooleanProperty(HIGHLIGHTREGION, false)));
            model.addAttribute("genomebrowser_start_list", (Object)this.molgenisSettings.getProperty("genomebrowser.data.start", "POS"));
            model.addAttribute("genomebrowser_chrom_list", (Object)this.molgenisSettings.getProperty("genomebrowser.data.chromosome", "CHROM"));
            model.addAttribute("genomebrowser_id_list", (Object)this.molgenisSettings.getProperty("genomebrowser.data.id", "ID"));
            model.addAttribute("genomebrowser_desc_list", (Object)this.molgenisSettings.getProperty("genomebrowser.data.desc", "INFO"));
            model.addAttribute("genomebrowser_patient_list", (Object)this.molgenisSettings.getProperty("genomebrowser.data.patient", "patient_id"));
            model.addAttribute("galaxyEnabled", (Object)this.molgenisSettings.getBooleanProperty(KEY_GALAXY_ENABLED, false));
            String galaxyUrl = this.molgenisSettings.getProperty(KEY_GALAXY_URL);
            if (galaxyUrl != null) {
                model.addAttribute(ATTR_GALAXY_URL, (Object)galaxyUrl);
            }
            model.addAttribute("rowClickable", (Object)this.isRowClickable());
            model.addAttribute("tableEditable", (Object)this.isTableEditable());
        } else if (moduleId.equals("diseasematcher")) {
            model.addAttribute("tableEditable", (Object)this.isTableEditable());
            model.addAttribute("rowClickable", (Object)this.isRowClickable());
        } else if (moduleId.equals("entitiesreport")) {
            model.addAttribute("datasetRepository", (Object)this.dataService.getRepository(entityName));
            model.addAttribute("viewName", (Object)this.parseEntitySpecificRuntimeProperty(entityName, KEY_MOD_ENTITIESREPORT, null));
        }
        return "view-dataexplorer-mod-" + moduleId;
    }

    @RequestMapping(value={"/modules"}, method={RequestMethod.GET})
    @ResponseBody
    public ModulesConfigResponse getModules(@RequestParam(value="entity") String entityName) {
        boolean modCharts = this.molgenisSettings.getBooleanProperty(KEY_MOD_CHARTS, true);
        boolean modData = this.molgenisSettings.getBooleanProperty(KEY_MOD_DATA, true);
        boolean modAggregates = this.molgenisSettings.getBooleanProperty(KEY_MOD_AGGREGATES, true);
        boolean modAnnotators = this.molgenisSettings.getBooleanProperty(KEY_MOD_ANNOTATORS, false);
        boolean modDiseasematcher = this.molgenisSettings.getBooleanProperty(KEY_MOD_DISEASEMATCHER, false);
        if (modAggregates) {
            modAggregates = this.dataService.getCapabilities(entityName).contains(RepositoryCapability.AGGREGATEABLE);
        }
        String modEntitiesReportName = this.parseEntitySpecificRuntimeProperty(entityName, KEY_MOD_ENTITIESREPORT, null);
        Permission pluginPermission = null;
        if (this.molgenisPermissionService.hasPermissionOnEntity(entityName, Permission.WRITE)) {
            pluginPermission = Permission.WRITE;
        } else if (this.molgenisPermissionService.hasPermissionOnEntity(entityName, Permission.READ)) {
            pluginPermission = Permission.READ;
        } else if (this.molgenisPermissionService.hasPermissionOnEntity(entityName, Permission.COUNT)) {
            pluginPermission = Permission.COUNT;
        }
        ModulesConfigResponse modulesConfig = new ModulesConfigResponse();
        String i18nLocale = this.molgenisSettings.getProperty("i18nLocale", "en");
        Locale locale = new Locale(i18nLocale, i18nLocale);
        ResourceBundle i18n = ResourceBundle.getBundle("i18n", locale);
        String aggregatesTitle = i18n.getString("dataexplorer_aggregates_title");
        if (pluginPermission != null) {
            switch (pluginPermission) {
                case COUNT: {
                    if (!modAggregates) break;
                    modulesConfig.add(new ModuleConfig("aggregates", aggregatesTitle, "grid-icon.png"));
                    break;
                }
                case READ: {
                    if (modData) {
                        modulesConfig.add(new ModuleConfig("data", "Data", "grid-icon.png"));
                    }
                    if (modAggregates) {
                        modulesConfig.add(new ModuleConfig("aggregates", aggregatesTitle, "aggregate-icon.png"));
                    }
                    if (modCharts) {
                        modulesConfig.add(new ModuleConfig("charts", "Charts", "chart-icon.png"));
                    }
                    if (modDiseasematcher) {
                        modulesConfig.add(new ModuleConfig("diseasematcher", "Disease Matcher", "diseasematcher-icon.png"));
                    }
                    if (modEntitiesReportName == null) break;
                    modulesConfig.add(new ModuleConfig("entitiesreport", modEntitiesReportName, "report-icon.png"));
                    break;
                }
                case WRITE: {
                    if (modData) {
                        modulesConfig.add(new ModuleConfig("data", "Data", "grid-icon.png"));
                    }
                    if (modAggregates) {
                        modulesConfig.add(new ModuleConfig("aggregates", aggregatesTitle, "aggregate-icon.png"));
                    }
                    if (modCharts) {
                        modulesConfig.add(new ModuleConfig("charts", "Charts", "chart-icon.png"));
                    }
                    if (modAnnotators) {
                        modulesConfig.add(new ModuleConfig("annotators", "Annotators", "annotator-icon.png"));
                    }
                    if (modDiseasematcher) {
                        modulesConfig.add(new ModuleConfig("diseasematcher", "Disease Matcher", "diseasematcher-icon.png"));
                    }
                    if (modEntitiesReportName == null) break;
                    modulesConfig.add(new ModuleConfig("entitiesreport", modEntitiesReportName, "report-icon.png"));
                    break;
                }
                default: {
                    throw new RuntimeException("unknown plugin permission: " + pluginPermission);
                }
            }
        }
        return modulesConfig;
    }

    private Map<String, String> getGenomeBrowserEntities() {
        HashMap<String, String> genomeEntities = new HashMap<String, String>();
        for (String entityName : this.dataService.getEntityNames()) {
            EntityMetaData entityMetaData = this.dataService.getEntityMetaData(entityName);
            if (!this.isGenomeBrowserEntity(entityMetaData)) continue;
            boolean canRead = this.molgenisPermissionService.hasPermissionOnEntity(entityName, Permission.READ);
            boolean canWrite = this.molgenisPermissionService.hasPermissionOnEntity(entityName, Permission.WRITE);
            if (!canRead && !canWrite) continue;
            genomeEntities.put(entityMetaData.getName(), entityMetaData.getLabel());
        }
        return genomeEntities;
    }

    private boolean isGenomeBrowserEntity(EntityMetaData entityMetaData) {
        AttributeMetaData attributeStartPosition = this.genomeConfig.getAttributeMetadataForAttributeNameArray("genomebrowser.data.start", entityMetaData);
        AttributeMetaData attributeChromosome = this.genomeConfig.getAttributeMetadataForAttributeNameArray("genomebrowser.data.chromosome", entityMetaData);
        return attributeStartPosition != null && attributeChromosome != null;
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    public void download(@RequestParam(value="dataRequest") String dataRequestStr, HttpServletResponse response) throws IOException {
        DataExplorerDownloadHandler download = new DataExplorerDownloadHandler(this.dataService);
        dataRequestStr = URLDecoder.decode(dataRequestStr, "UTF-8");
        LOG.info("Download request: [" + dataRequestStr + "]");
        DataRequest dataRequest = (DataRequest)new GsonHttpMessageConverter().getGson().fromJson(dataRequestStr, DataRequest.class);
        String fileName = "";
        ServletOutputStream outputStream = null;
        switch (dataRequest.getDownloadType()) {
            case DOWNLOAD_TYPE_CSV: {
                response.setContentType("text/csv");
                fileName = dataRequest.getEntityName() + '_' + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date()) + ".csv";
                response.addHeader("Content-Disposition", "attachment; filename=" + fileName);
                outputStream = response.getOutputStream();
                download.writeToCsv(dataRequest, (OutputStream)outputStream, ',');
                break;
            }
            case DOWNLOAD_TYPE_XLSX: {
                response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                fileName = dataRequest.getEntityName() + '_' + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date()) + ".xlsx";
                response.addHeader("Content-Disposition", "attachment; filename=" + fileName);
                outputStream = response.getOutputStream();
                download.writeToExcel(dataRequest, (OutputStream)outputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/galaxy/export"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void exportToGalaxy(@Valid @RequestBody GalaxyDataExportRequest galaxyDataExportRequest, Model model) throws IOException {
        DataExplorerDownloadHandler download = new DataExplorerDownloadHandler(this.dataService);
        boolean galaxyEnabled = this.molgenisSettings.getBooleanProperty(KEY_GALAXY_ENABLED, false);
        if (!galaxyEnabled) {
            throw new MolgenisDataAccessException("Galaxy export disabled");
        }
        String galaxyUrl = galaxyDataExportRequest.getGalaxyUrl();
        String galaxyApiKey = galaxyDataExportRequest.getGalaxyApiKey();
        GalaxyDataExporter galaxyDataSetExporter = new GalaxyDataExporter(galaxyUrl, galaxyApiKey);
        DataRequest dataRequest = galaxyDataExportRequest.getDataRequest();
        File csvFile = File.createTempFile("galaxydata_" + System.currentTimeMillis(), ".tsv");
        try {
            download.writeToCsv(dataRequest, new FileOutputStream(csvFile), '\t', true);
            galaxyDataSetExporter.export(dataRequest.getEntityName(), csvFile);
        }
        finally {
            csvFile.delete();
        }
        model.addAttribute(ATTR_GALAXY_URL, (Object)galaxyUrl);
        model.addAttribute(ATTR_GALAXY_API_KEY, (Object)galaxyApiKey);
    }

    @RequestMapping(value={"/aggregate"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    @ResponseBody
    public AggregateResult aggregate(@Valid @RequestBody AggregateRequest request) {
        String entityName = request.getEntityName();
        String xAttributeName = request.getXAxisAttributeName();
        String yAttributeName = request.getYAxisAttributeName();
        String distinctAttributeName = this.getDistinctAttributeName(request);
        if (StringUtils.isBlank((CharSequence)xAttributeName) && StringUtils.isBlank((CharSequence)yAttributeName)) {
            throw new InputValidationException("Missing aggregate attribute");
        }
        EntityMetaData entityMeta = this.dataService.getEntityMetaData(entityName);
        AttributeMetaData xAttributeMeta = null;
        if (StringUtils.isNotBlank((CharSequence)xAttributeName)) {
            xAttributeMeta = entityMeta.getAttribute(xAttributeName);
            if (xAttributeMeta == null) {
                throw new InputValidationException("Unknown attribute '" + xAttributeName + "'");
            }
            if (!xAttributeMeta.isAggregateable()) {
                throw new InputValidationException("Attribute '" + xAttributeName + "' is not aggregateable");
            }
        }
        AttributeMetaData yAttributeMeta = null;
        if (StringUtils.isNotBlank((CharSequence)yAttributeName)) {
            yAttributeMeta = entityMeta.getAttribute(yAttributeName);
            if (yAttributeMeta == null) {
                throw new InputValidationException("Unknow attribute '" + yAttributeName + "'");
            }
            if (!yAttributeMeta.isAggregateable()) {
                throw new InputValidationException("Attribute '" + yAttributeName + "' is not aggregateable");
            }
        }
        AttributeMetaData distinctAttributeMeta = null;
        if (StringUtils.isNotBlank((CharSequence)distinctAttributeName)) {
            distinctAttributeMeta = entityMeta.getAttribute(distinctAttributeName);
            if (distinctAttributeName == null) {
                throw new InputValidationException("Unknow attribute '" + distinctAttributeName + "'");
            }
        }
        AggregateQueryImpl aggregateQuery = new AggregateQueryImpl().attrX(xAttributeMeta).attrY(yAttributeMeta).attrDistinct(distinctAttributeMeta).query((Query)new QueryImpl(request.getQ()));
        return this.dataService.aggregate(entityName, (AggregateQuery)aggregateQuery);
    }

    private String getDistinctAttributeName(AggregateRequest request) {
        String rtpKey = "plugin.dataexplorer.mod.aggregates.distinct.override." + request.getEntityName();
        String overrideDistinctAttributeName = this.molgenisSettings.getProperty(rtpKey);
        String distinctAttributeName = request.getDistinctAttributeName();
        if (overrideDistinctAttributeName != null) {
            if (distinctAttributeName != null) {
                LOG.info("[mod-aggregate] Overriding distinct attribute from request! Request specifies " + distinctAttributeName + ", runtime property " + rtpKey + " specifies " + overrideDistinctAttributeName);
            } else {
                LOG.debug("[mod-aggregate] Using distinct attribute " + overrideDistinctAttributeName + " from runtime property " + rtpKey);
            }
            return overrideDistinctAttributeName;
        }
        return distinctAttributeName;
    }

    @RequestMapping(value={"/details"}, method={RequestMethod.POST})
    public String viewEntityDetails(@RequestParam(value="entityName") String entityName, @RequestParam(value="entityId") String entityId, Model model) throws Exception {
        model.addAttribute("entity", (Object)this.dataService.getRepository(entityName).findOne((Object)entityId));
        model.addAttribute("entityMetadata", (Object)this.dataService.getEntityMetaData(entityName));
        RunAsSystemProxy.runAsSystem(() -> model.addAttribute("viewName", (Object)this.getViewName(entityName)));
        return "view-entityreport";
    }

    private String getViewName(String entityName) {
        String specificViewname;
        String rtName = KEY_MOD_ENTITIESREPORT;
        Entity rt = this.dataService.getRepository("RuntimeProperty").findOne(new QueryImpl().eq("Name", (Object)rtName));
        if (rt != null) {
            String[] mappingSplit;
            String entityMapping = rt.get("Value").toString();
            for (String mapping : mappingSplit = entityMapping.split(",", -1)) {
                String[] valSplit = mapping.split(":", -1);
                if (valSplit.length == 2) {
                    String specificViewname2;
                    String entity = valSplit[0];
                    String reportTemplate = valSplit[1];
                    if (!entity.equals(entityName) || !this.viewExists(specificViewname2 = "view-entityreport-specific-" + reportTemplate)) continue;
                    return specificViewname2;
                }
                LOG.error("Bad runtime entity " + rtName + " mapping: " + mapping);
            }
        }
        if (this.viewExists(specificViewname = "view-entityreport-specific-" + entityName)) {
            return specificViewname;
        }
        if (this.viewExists("view-entityreport-generic")) {
            return "view-entityreport-generic";
        }
        return "view-entityreport-generic-default";
    }

    private boolean viewExists(String viewName) {
        try {
            return this.freemarkerConfigurer.getConfiguration().getTemplate(viewName + ".ftl") != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    @RequestMapping(value={"/settings"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getSettings(@RequestParam(required=false) String keyStartsWith) {
        if (keyStartsWith == null) {
            keyStartsWith = "";
        }
        return this.molgenisSettings.getProperties("plugin.dataexplorer" + keyStartsWith);
    }

    @ExceptionHandler(value={GalaxyDataExportException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ErrorMessageResponse handleGalaxyDataExportException(GalaxyDataExportException e) {
        LOG.debug("", (Throwable)e);
        return new ErrorMessageResponse(Collections.singletonList(new ErrorMessageResponse.ErrorMessage(e.getMessage())));
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorMessageResponse handleRuntimeException(RuntimeException e) {
        LOG.error(e.getMessage(), (Throwable)e);
        return new ErrorMessageResponse(new ErrorMessageResponse.ErrorMessage("An error occurred. Please contact the administrator.<br />Message:" + e.getMessage()));
    }

    private boolean isTableEditable() {
        return this.molgenisSettings.getBooleanProperty(KEY_DATAEXPLORER_EDITABLE, false) && this.molgenisPermissionService.hasPermissionOnPlugin(ID, Permission.READ);
    }

    private boolean isRowClickable() {
        return this.molgenisSettings.getBooleanProperty(KEY_DATAEXPLORER_ROW_CLICKABLE, false);
    }

    private String parseEntitySpecificRuntimeProperty(String entityName, String property, String defaultValue) {
        String modEntitiesReportRTP = this.molgenisSettings.getProperty(property, null);
        if (modEntitiesReportRTP != null) {
            String[] entitiesReports;
            for (String entitiesReport : entitiesReports = modEntitiesReportRTP.split(",")) {
                String[] entitiesReportParts = entitiesReport.split(":");
                if (entitiesReportParts.length != 2 || !entitiesReportParts[0].equals(entityName)) continue;
                return entitiesReportParts[1];
            }
        }
        return defaultValue;
    }
}

