/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.controller;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.annotation.core.RepositoryAnnotator;
import org.molgenis.data.annotation.web.CrudRepositoryAnnotator;
import org.molgenis.data.jobs.Job;
import org.molgenis.data.jobs.Progress;
import org.springframework.security.core.Authentication;
import org.springframework.transaction.support.TransactionTemplate;

public class AnnotationJob
extends Job<Void> {
    private final CrudRepositoryAnnotator crudRepositoryAnnotator;
    private final String username;
    private final List<RepositoryAnnotator> annotators;
    private final Repository<Entity> repository;
    List<String> successfulAnnotators = Lists.newArrayList();
    List<String> failedAnnotators = Lists.newArrayList();
    Exception firstException = null;

    public AnnotationJob(CrudRepositoryAnnotator crudRepositoryAnnotator, String username, List<RepositoryAnnotator> annotators, Repository<Entity> repository, Progress progress, Authentication userAuthentication, TransactionTemplate transactionTemplate) {
        super(progress, transactionTemplate, userAuthentication);
        this.crudRepositoryAnnotator = Objects.requireNonNull(crudRepositoryAnnotator);
        this.username = Objects.requireNonNull(username);
        this.annotators = Objects.requireNonNull(annotators);
        this.repository = Objects.requireNonNull(repository);
    }

    public Void call(Progress progress) throws Exception {
        progress.setProgressMax(this.annotators.size());
        int i = 0;
        for (RepositoryAnnotator annotator : this.annotators) {
            progress.progress(i, this.getMessage(i, annotator));
            try {
                this.crudRepositoryAnnotator.annotate(annotator, this.repository);
                this.successfulAnnotators.add(annotator.getSimpleName());
            }
            catch (Exception ex) {
                if (this.firstException == null) {
                    this.firstException = ex;
                }
                this.failedAnnotators.add(annotator.getSimpleName());
            }
            ++i;
        }
        progress.progress(this.annotators.size(), this.getMessage());
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.firstException != null) {
            progress.status("Failed annotators: " + StringUtils.join(this.failedAnnotators, (String)",") + ". Successful annotators: " + StringUtils.join(this.successfulAnnotators, (String)","));
            throw this.firstException;
        }
        return null;
    }

    private String getMessage() {
        return String.format("Annotated \"%s\" with %s (started by \"%s\")", this.repository.getEntityType().getLabel(), StringUtils.join(this.successfulAnnotators, (String)","), this.username);
    }

    private String getMessage(int i, RepositoryAnnotator annotator) {
        return String.format("Annotating \"%s\" with %s (annotator %d of %d, started by \"%s\")", this.repository.getEntityType().getLabel(), annotator.getSimpleName(), i + 1, this.annotators.size(), this.username);
    }
}

